/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include <string.h>
#include <stdio.h>
#include "main.h"

/* Private Macros ----------------------------------------------------------- */

/* Private Variables--------------------------------------------------------- */
static char s_src1_buf[] = "task1:hello world!\r\n";
static char s_src2_buf[] = "task2:hello world!\r\n";
static char s_src3_buf[] = "task3:hello world!\r\n";
static char s_src4_buf[] = "task4:hello world!\r\n";
static char s_src5_buf[] = "task5:hello world!\r\n";

static dma_descriptor_t s_scatter_gather_ctrl[5];
static uint8_t s_complete = 0U;

/* Public Variables -------------------------------------------------------- */
dma_handle_t g_dma_init;
uart_handle_t g_uart_init;

/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

/* Private Function---------------------------------------------------------- */
/**
  * @brief  DMA send complete.
  * @param  arg: Pointer.
  * @retval None.
  */
void dma_complete(void *arg)
{
    s_complete++;

    return;
}

void init_uart_pin(void)
{
    gpio_init_t gpio_init;

    /* Initialize tx pin */
    gpio_init.mode = GPIO_MODE_OUTPUT;
    gpio_init.odos = GPIO_PUSH_PULL;
    gpio_init.pupd = GPIO_PUSH_UP;
    gpio_init.podrv = GPIO_OUT_DRIVE_1;
    gpio_init.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_init.flt  = GPIO_FILTER_DISABLE;
    gpio_init.type = GPIO_TYPE_TTL;
    gpio_init.func = GPIO_FUNC_3;
    ald_gpio_init(UART_TX_PORT, UART_TX_PIN, &gpio_init);

    /* Initialize rx pin */
    gpio_init.mode = GPIO_MODE_INPUT;
    gpio_init.odos = GPIO_PUSH_PULL;
    gpio_init.pupd = GPIO_PUSH_UP;
    gpio_init.podrv = GPIO_OUT_DRIVE_1;
    gpio_init.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_init.flt  = GPIO_FILTER_DISABLE;
    gpio_init.type = GPIO_TYPE_TTL;
    gpio_init.func = GPIO_FUNC_3;
    ald_gpio_init(UART_RX_PORT, UART_RX_PIN, &gpio_init);

    return;
}

void init_uart(void)
{
    init_uart_pin();

    g_uart_init.perh             = UART2;
    g_uart_init.init.baud        = 115200;
    g_uart_init.init.word_length = UART_WORD_LENGTH_8B;
    g_uart_init.init.stop_bits   = UART_STOP_BITS_1;
    g_uart_init.init.parity      = UART_PARITY_NONE;
    g_uart_init.init.mode        = UART_MODE_UART;
    g_uart_init.init.fctl        = UART_HW_FLOW_CTL_DISABLE;
    g_uart_init.tx_cplt_cbk      = NULL;
    g_uart_init.rx_cplt_cbk      = NULL;
    g_uart_init.error_cbk        = NULL;
    ald_uart_init(&g_uart_init);
}

void init_dma(void)
{
    dma_config_t dma_config;

    dma_config.channel = 0;
    dma_config.primary = ENABLE;
    dma_config.R_power = DMA_R_POWER_1;
    dma_config.data_width = DMA_DATA_SIZE_BYTE;
    dma_config.dst     = (void *)(&UART2->TXBUF);
    dma_config.dst_inc = DMA_DATA_INC_NONE;
    dma_config.src     = s_src1_buf;
    dma_config.src_inc = DMA_DATA_INC_BYTE;
    dma_config.size    = strlen(s_src1_buf);
    dma_config.msel    = DMA_MSEL_UART2;
    dma_config.msigsel = DMA_MSIGSEL_UART_TXEMPTY;
    dma_config.burst   = ENABLE;
    dma_config.interrupt = ENABLE;
    ald_dma_config_sg_alt_desc(&s_scatter_gather_ctrl[0], &dma_config, 0);

    dma_config.src     = s_src2_buf;
    dma_config.size    = strlen(s_src2_buf);
    ald_dma_config_sg_alt_desc(&s_scatter_gather_ctrl[1], &dma_config, 0);

    dma_config.src     = s_src3_buf;
    dma_config.size    = strlen(s_src3_buf);
    ald_dma_config_sg_alt_desc(&s_scatter_gather_ctrl[2], &dma_config, 0);

    dma_config.src     = s_src4_buf;
    dma_config.size    = strlen(s_src4_buf);
    ald_dma_config_sg_alt_desc(&s_scatter_gather_ctrl[3], &dma_config, 0);

    dma_config.src     = s_src5_buf;
    dma_config.size    = strlen(s_src5_buf);
    ald_dma_config_sg_alt_desc(&s_scatter_gather_ctrl[4], &dma_config, 0);

    ald_dma_config_sg_per(DMA0, s_scatter_gather_ctrl, 5, 1,
                          DMA_MSEL_UART2, DMA_MSIGSEL_UART_TXEMPTY,
                          0, dma_complete);

    ald_uart_dma_req_config(&g_uart_init, UART_DMA_REQ_TX, ENABLE);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    init_uart();
    init_dma();

    while (1)
    {
        if (s_complete)
        {
            s_complete = 0;

            init_dma();
        }
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
