/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include <string.h>
#include <stdio.h>
#include "main.h"

/* Private Macros ----------------------------------------------------------- */

/* Private Variables--------------------------------------------------------- */
static uint8_t s_complete_flag = 0U;

/* Public Variables -------------------------------------------------------- */
uint8_t g_send_buf[] = "hello world!\r\n";
dma_handle_t g_dma_init;
uart_handle_t g_uart_init;

/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

/* Private Function---------------------------------------------------------- */
/**
  * @brief  DMA send complete.
  * @param  arg: Pointer.
  * @retval None.
  */
void dma_complete(void *arg)
{
    uint16_t cnt = 4000U;

    while (ald_uart_get_status(&g_uart_init, UART_STATUS_TSBUSY) && (--cnt))
    {

    }

    s_complete_flag = 1;

    return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer.
  * @retval None.
  */
void dma_error(void *arg)
{
    return;
}

void uart_send_complete(uart_handle_t *arg)
{
    return;
}

void uart_recv_complete(uart_handle_t *arg)
{
    return;
}

void uart_error(uart_handle_t *arg)
{
    return;
}

/**
  * @brief  UART pin initialization function
  * @retval Status.
  */
void init_uart_pin(void)
{
    gpio_init_t gpio_init;

    /* Initialize tx pin */
    gpio_init.mode = GPIO_MODE_OUTPUT;
    gpio_init.odos = GPIO_PUSH_PULL;
    gpio_init.pupd = GPIO_PUSH_UP;
    gpio_init.podrv = GPIO_OUT_DRIVE_1;
    gpio_init.nodrv = GPIO_OUT_DRIVE_1;
    gpio_init.flt  = GPIO_FILTER_DISABLE;
    gpio_init.type = GPIO_TYPE_CMOS;
    gpio_init.func = GPIO_FUNC_3;
    ald_gpio_init(UART_TX_PORT, UART_TX_PIN, &gpio_init);

    /* Initialize rx pin */
    gpio_init.mode = GPIO_MODE_INPUT;
    gpio_init.odos = GPIO_PUSH_PULL;
    gpio_init.pupd = GPIO_PUSH_UP;
    gpio_init.podrv = GPIO_OUT_DRIVE_1;
    gpio_init.nodrv = GPIO_OUT_DRIVE_1;
    gpio_init.flt  = GPIO_FILTER_DISABLE;
    gpio_init.type = GPIO_TYPE_CMOS;
    gpio_init.func = GPIO_FUNC_3;
    ald_gpio_init(UART_RX_PORT, UART_RX_PIN, &gpio_init);

    return;
}

/**
  * @brief  UART initialization function
  * @retval Status.
  */
void init_uart(void)
{
    init_uart_pin();

    g_uart_init.perh             = UART2;
    g_uart_init.init.baud        = 115200;
    g_uart_init.init.word_length = UART_WORD_LENGTH_8B;
    g_uart_init.init.stop_bits   = UART_STOP_BITS_1;
    g_uart_init.init.parity      = UART_PARITY_NONE;
    g_uart_init.init.mode        = UART_MODE_UART;
    g_uart_init.init.fctl        = UART_HW_FLOW_CTL_DISABLE;
    g_uart_init.tx_cplt_cbk      = uart_send_complete;
    g_uart_init.rx_cplt_cbk      = uart_recv_complete;
    g_uart_init.error_cbk        = uart_error;
    ald_uart_init(&g_uart_init);

    return;
}

/**
  * @brief  DMA initialization function
  * @retval Status.
  */
void init_dma(void)
{
    g_dma_init.perh = DMA0;
    ald_dma_config_struct(&g_dma_init.config);
    g_dma_init.config.channel = 0;
    g_dma_init.config.primary = ENABLE;
    g_dma_init.config.R_power = DMA_R_POWER_1;
    g_dma_init.config.data_width = DMA_DATA_SIZE_BYTE;
    g_dma_init.config.dst     = (void *)(&UART2->TXBUF);
    g_dma_init.config.dst_inc = DMA_DATA_INC_NONE;
    g_dma_init.config.src     = g_send_buf;
    g_dma_init.config.src_inc = DMA_DATA_INC_BYTE;
    g_dma_init.config.size    = sizeof(g_send_buf);
    g_dma_init.config.msel    = DMA_MSEL_UART2;
    g_dma_init.config.msigsel = DMA_MSIGSEL_UART_TXEMPTY;
    g_dma_init.config.burst   = ENABLE;
    g_dma_init.config.interrupt = ENABLE;
    g_dma_init.cplt_cbk       = dma_complete;
    g_dma_init.cplt_arg       = NULL;
    g_dma_init.err_cbk        = dma_error;
    g_dma_init.err_arg        = NULL;
    ald_dma_config_basic(&g_dma_init);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    init_uart();
    ald_uart_dma_req_config(&g_uart_init, UART_DMA_REQ_TX, ENABLE);
    init_dma();

    while (1)
    {
        if (s_complete_flag)
        {
            s_complete_flag = 0;
            ald_uart_dma_req_config(&g_uart_init, UART_DMA_REQ_TX, DISABLE);
            ald_uart_dma_req_config(&g_uart_init, UART_DMA_REQ_TX, ENABLE);
            init_dma();
        }
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
