/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include <string.h>
#include <stdio.h>
#include "main.h"

/* Private Macros ----------------------------------------------------------- */

/* Private Variables--------------------------------------------------------- */

/* Public Variables -------------------------------------------------------- */

dma_handle_t g_dma_init;
uart_handle_t g_uart_init;

char g_src_buf[] = "hello world!\r\n";
char g_dst_buf[64] = {0};

/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

/* Private Function---------------------------------------------------------- */


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */


/**
  * @brief  DMA send complete.
  * @param  arg: Pointer.
  * @retval None.
  */
void dma_complete(void *arg)
{

    return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer.
  * @retval None.
  */
void dma_error(void *arg)
{
    return;
}

void uart_send_complete(uart_handle_t *arg)
{
    return;
}

void uart_recv_complete(uart_handle_t *arg)
{
    return;
}

void uart_error(uart_handle_t *arg)
{
    return;
}


/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    g_dma_init.perh = DMA0;
    ald_dma_config_struct(&g_dma_init.config);
    g_dma_init.config.channel = 0;
    g_dma_init.config.primary = ENABLE;
    g_dma_init.config.R_power = DMA_R_POWER_1;
    g_dma_init.config.data_width = DMA_DATA_SIZE_BYTE;
    g_dma_init.config.dst     = g_dst_buf;
    g_dma_init.config.dst_inc = DMA_DATA_INC_BYTE;
    g_dma_init.config.src     = g_src_buf;
    g_dma_init.config.src_inc = DMA_DATA_INC_BYTE;
    g_dma_init.config.size    = strlen(g_src_buf);
    g_dma_init.config.msel    = DMA_MSEL_NONE;
    g_dma_init.config.msigsel = DMA_MSIGSEL_NONE;
    g_dma_init.config.burst   = ENABLE;
    g_dma_init.config.interrupt = ENABLE;

    g_dma_init.cplt_cbk       = dma_complete;
    g_dma_init.cplt_arg       = NULL;
    g_dma_init.err_cbk        = dma_error;
    g_dma_init.err_arg        = NULL;
    ald_dma_config_auto(&g_dma_init);

    while (1)
    {
        ald_delay_ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
