/**********************************************************************************
 *
 * @file    main.c
 * @brief   crc_calculate C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include <stdio.h>
#include "main.h"
/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private Variables --------------------------------------------------------- */
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */


/* Public Variables ---------------------------------------------------------- */
md_crc_init_t g_crc_init;

/* Private function prototypes ----------------------------------------------- */
void uart_init(void);

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Init CRC
  * @retval None.
  */
void crc_init_crc32(void)
{
    md_crc_init_struct(&g_crc_init);

    g_crc_init.mode = MD_CRC_MODE_32;
    g_crc_init.len = MD_CRC_DATASIZE_8;
    g_crc_init.order = MD_CRC_BYTORD_LOW;
    g_crc_init.seed = 0xFFFFFFFF;
    g_crc_init.chs_inv = ENABLE;
    g_crc_init.chs_rev = ENABLE;
    g_crc_init.data_inv = DISABLE;
    g_crc_init.data_rev = ENABLE;
    md_crc_init(&g_crc_init);
}

void crc_init_crc32_mpeg_2(void)
{
    md_crc_init_struct(&g_crc_init);

    g_crc_init.mode = MD_CRC_MODE_32;
    g_crc_init.len = MD_CRC_DATASIZE_8;
    g_crc_init.order = MD_CRC_BYTORD_LOW;
    g_crc_init.seed = 0xFFFFFFFF;
    g_crc_init.chs_inv = DISABLE;
    g_crc_init.chs_rev = DISABLE;
    g_crc_init.data_inv = DISABLE;
    g_crc_init.data_rev = DISABLE;
    md_crc_init(&g_crc_init);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    volatile uint32_t result = 0;
    uint8_t i = 0U;
    uint8_t crc_buf[8] = {1U, 2U, 3U, 4U, 5U, 6U, 7U, 8U};

    /* Configure system clock */
    md_cmu_clock_config_default();
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* 2bits preempt-priority(0-3)
       2bits sub-priority(0-3). */
    NVIC_SetPriorityGrouping(5);

    uart_init();
    printf("CRC demo\r\n");

    /* Init CRC-32 */
    crc_init_crc32();

    for (i = 0; i < 8; i++)
        md_crc_write_data(CRC, crc_buf[i]);

    result = md_crc_get_check_result(CRC);
    printf("CRC-32 result: 0x%08X\r\n", result);/* Init CRC */

    /* Init CRC-32/MPEG-2 */
    crc_init_crc32_mpeg_2();

    for (i = 0; i < 8; i++)
        md_crc_write_data(CRC, crc_buf[i]);

    result = md_crc_get_check_result(CRC);
    printf("CRC-32/MPEG-2 result: 0x%08X\r\n", result);
    printf("\r\n");

    while (1)
    {
        md_delay_1ms(1000);
    }
}

void uart_gpio_init(void)
{
    md_gpio_init_t g_gpio_init_s;

    md_gpio_init_struct(&g_gpio_init_s);

    g_gpio_init_s.mode = MD_GPIO_MODE_OUTPUT;
    g_gpio_init_s.func = MD_GPIO_FUNC_3;

    md_gpio_init(UART_PORT, UART_TX_PIN, &g_gpio_init_s);

    g_gpio_init_s.mode = MD_GPIO_MODE_INPUT;
    md_gpio_init(UART_PORT, UART_RX_PIN, &g_gpio_init_s);
}

void uart_init(void)
{
    md_uart_init_t g_uart_init_s;

    md_cmu_enable_perh_uart0();

    uart_gpio_init();

    md_uart_init_struct(&g_uart_init_s);

    md_uart_init(UART0, &g_uart_init_s);
}

#ifdef __GNUC__     /* GCC Compiler */
int _write(int file, const void *ptr, int len)
{
    uint16_t cnt; 
    (void)file;
    uint8_t *ptr_char = (uint8_t *)ptr;

    int i = 0;

    for (i = 0 ; i < len ; i++)
    {
        if (*ptr_char == '\n')
        {
            cnt = 4000;
            while (!md_uart_is_active_flag_tfempty(UART0) && (--cnt));

            md_uart_set_send_data8(UART0, '\r');
        }

        cnt = 4000;
        while (!md_uart_is_active_flag_tfempty(UART0) && (--cnt));

        md_uart_set_send_data8(UART0, *ptr_char++);
    }

    return len;
}

void *_sbrk(intptr_t increment)
{
    extern char end asm("end");
    /* Defined by the linker. */
    static char *heap_end;
    char* prev_heap_end;
    heap_end += increment;

    return (void *)prev_heap_end;
}

void _read()
{

}

void _lseek()
{

}

void _close()
{

}

void _fstat()
{

}

void _isatty()
{

}

void _getpid()
{

}

void _kill()
{

}

void _exit()
{

}

#else
int fputc(int c, FILE *f)
{
    uint16_t cnt = 4000U;

    while (!md_uart_is_active_flag_tfempty(UART0) && (--cnt))
    {

    }

    md_uart_set_send_data8(UART0, c);

    return c;
}

#endif /* __GNUC__ */

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
