/**********************************************************************************
 *
 * @file    main.c
 * @brief   crc_calculate C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"
#include "stdio.h"
#include "stdlib.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private Variables --------------------------------------------------------- */
/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Public Variables ---------------------------------------------------------- */
crc_handle_t g_h_crc;
uint32_t g_result = 0U;
ald_status_t g_state = ERROR;

/* Private function prototypes ----------------------------------------------- */

void uart_init(void);

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  calculate completed callback.
  * @param  arg: Pointer to crc_handle_t structure.
  * @retval None.
  */
void calculate_complete(crc_handle_t *arg)
{
    return;
}

/**
  * @brief  calculate error callback.
  * @param  arg: Pointer to crc_handle_t structure.
  * @retval None.
  */
void error_complete(crc_handle_t *arg)
{
    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    uint8_t crc_buf[8] = {1U, 2U, 3U, 4U, 5U, 6U, 7U, 8U};

    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    /* Enable CRC mode clock */
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    uart_init();
    printf("CRC demo\r\n");

    /* Clear crc_handle_t structure */
    memset(&g_h_crc, 0x0, sizeof(crc_handle_t));

    /* Initialize CRC */
    g_h_crc.perh = CRC;
    g_h_crc.init.mode = CRC_MODE_32;
    g_h_crc.init.seed = 0xFFFFFFFF;
    g_h_crc.init.data_rev = ENABLE;
    g_h_crc.init.data_inv = DISABLE;
    g_h_crc.init.chs_rev = ENABLE;
    g_h_crc.init.chs_inv = ENABLE;

    g_h_crc.cal_cplt_cbk = calculate_complete;
    g_h_crc.err_cplt_cbk = error_complete;
    ald_crc_init(&g_h_crc);

    /* start calculate and g_result is 0x3FCA88C5*/
    g_result = ald_crc_calculate(&g_h_crc, crc_buf, sizeof(crc_buf));
    printf("CRC-32 g_result: 0x%08X\r\n", g_result);/* Init CRC */

    /* Initialize CRC */
    g_h_crc.perh = CRC;
    g_h_crc.init.mode = CRC_MODE_32;
    g_h_crc.init.seed = 0xFFFFFFFF;
    g_h_crc.init.data_rev = DISABLE;
    g_h_crc.init.data_inv = DISABLE;
    g_h_crc.init.chs_rev = DISABLE;
    g_h_crc.init.chs_inv = DISABLE;

    g_h_crc.cal_cplt_cbk = calculate_complete;
    g_h_crc.err_cplt_cbk = error_complete;
    ald_crc_init(&g_h_crc);

    /* start calculate and g_result is 0x140B8DD8*/
    g_result = ald_crc_calculate(&g_h_crc, crc_buf, sizeof(crc_buf));
    printf("CRC-32/MPEG-2 g_result: 0x%08X\r\n", g_result);
    printf("\r\n");

    while (1)
    {
        ald_delay_ms(1000);
    }
}

void uart_gpio_init(void)
{
    gpio_init_t g_gpio_init_s;

    memset(&g_gpio_init_s, 0, sizeof(g_gpio_init_s));

    g_gpio_init_s.mode = GPIO_MODE_OUTPUT;
    g_gpio_init_s.func = GPIO_FUNC_3;
    ald_gpio_init(UART_PORT, UART_TX_PIN, &g_gpio_init_s);

    g_gpio_init_s.mode = GPIO_MODE_INPUT;
    ald_gpio_init(UART_PORT, UART_RX_PIN, &g_gpio_init_s);
}

uart_handle_t g_h_uart = {0};
void uart_init(void)
{
    uart_gpio_init();

    g_h_uart.perh             = UART0;
    g_h_uart.init.baud        = 115200;
    g_h_uart.init.word_length = UART_WORD_LENGTH_8B;
    g_h_uart.init.stop_bits   = UART_STOP_BITS_1;
    g_h_uart.init.parity      = UART_PARITY_NONE;
    g_h_uart.init.mode        = UART_MODE_UART;
    g_h_uart.init.fctl        = UART_HW_FLOW_CTL_DISABLE;
    ald_uart_init(&g_h_uart);
}

#ifdef __GNUC__     /* GCC Compiler */
int _write(int file, const void *ptr, int len)
{
    uint16_t cnt;
    (void)file;
    uint8_t *ptr_char = (uint8_t *)ptr;

    int i = 0;

    for (i = 0 ; i < len ; i++)
    {
        if (*ptr_char == '\n')
        {
            cnt = 4000;

            while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

            g_h_uart.perh->TXBUF = '\r';
        }

        cnt = 4000;

        while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

        g_h_uart.perh->TXBUF = *ptr_char++;
    }

    return len;
}

void *_sbrk(intptr_t increment)
{
    extern char end asm("end");
    /* Defined by the linker. */
    static char *heap_end;
    char *prev_heap_end;

    heap_end += increment;

    return (void *)prev_heap_end;
}

void _read()
{

}

void _lseek()
{

}

void _close()
{

}

void _fstat()
{

}

void _isatty()
{

}

void _getpid()
{

}

void _kill()
{

}

void _exit()
{

}

#else
int fputc(int c, FILE *f)
{
    uint16_t cnt = 4000U;

    while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt))
    {

    }

    g_h_uart.perh->TXBUF = c;

    return c;
}

#endif /* __GNUC__ */

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
