/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

uint32_t g_sysclk;
uint32_t g_hclk1;
uint32_t g_hclk2;
uint32_t g_pclk1;
uint32_t g_pclk2;

/* Private Constants --------------------------------------------------------- */

uint8_t g_clk_err_flag = 0U;

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Init clock out pin(HSCO PA15)
  * @retval None
  */
void init_hsco_pin(void)
{
    md_gpio_init_t gpio_config;
    /* Initialize tx pin */
    gpio_config.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_config.odos  = MD_GPIO_PUSH_PULL;
    gpio_config.pupd  = MD_GPIO_FLOATING;
    gpio_config.podrv = MD_GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = MD_GPIO_OUT_DRIVE_1;
    gpio_config.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_config.type  = MD_GPIO_TYPE_CMOS;
    gpio_config.func  = MD_GPIO_FUNC_6;
    md_gpio_init(HSCO_PORT, HSCO_PIN, &gpio_config);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Configure system clock */

    md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HOSC_3, MD_CMU_PLL1_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 72000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    SYSCFG_UNLOCK();
    md_cmu_set_hosc_region(3);  /* 3: 8-16MHz */
    md_cmu_enable_hosc_safe();
    md_cmu_enable_pll_safe();

    md_cmu_enable_perh_all(); /* Enable ALL peripheral */
    md_cmu_set_hsco_div(7);   /* 7: HSC / 128 */
    md_cmu_set_hsco_type(7);  /* 7: SYSCLK */
    md_cmu_enable_hsco();     /* Enable HSC output */

    /* Enable interrupt */
    md_cmu_enable_pll_ulk_interrupt();
    md_cmu_enable_pll_nmi();
    md_cmu_enable_hosc_stp_interrupt();
    md_cmu_enable_hosc_nmi_interrupt();

    /* get current clock */
    g_sysclk = md_cmu_get_sys_clock();
    g_hclk1 = md_cmu_get_hclk1_clock();
    g_hclk2 = md_cmu_get_hclk2_clock();
    g_pclk1 = md_cmu_get_pclk1_clock();
    g_pclk2 = md_cmu_get_pclk2_clock();

    /* set the clock divider */
    md_cmu_set_sysclk_div(6);  /* 0x6: Fclk / 64 */
    md_cmu_set_hclk1_div(1);   /* 0x1: sysclk / 2 */
    md_cmu_set_hclk2_div(1);   /* 0x1: sysclk / 2 */
    md_cmu_set_pclk1_div(1);   /* 0x1: sysclk / 2 */
    md_cmu_set_pclk2_div(1);   /* 0x1: sysclk / 2 */

    /* get current clock */
    g_sysclk = md_cmu_get_sys_clock();
    g_hclk1 = md_cmu_get_hclk1_clock();
    g_hclk2 = md_cmu_get_hclk2_clock();
    g_pclk1 = md_cmu_get_pclk1_clock();
    g_pclk2 = md_cmu_get_pclk2_clock();

    SYSCFG_LOCK();
    /* 2bits preempt-priority(0-3)
       2bits sub-priority(0-3). */
    NVIC_SetPriorityGrouping(5);

    /* Initialize high speed clock output gpio (HSCO PA15) */
    init_hsco_pin();

    md_mcu_irq_config(CMU_IRQn, 0, 0, ENABLE);  /* enable CMU IRQ */

    while (1)
    {
        /* if pll have unlocked and resumed */
        if ((md_cmu_get_current_clock_source() == 0) && (g_clk_err_flag == 1))
            g_clk_err_flag = 0;
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
