/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

uint32_t g_sysclk;
uint32_t g_hclk1;
uint32_t g_hclk2;
uint32_t g_pclk1;
uint32_t g_pclk2;
uint8_t g_clk_err_flag = 0U;

/* Private Constants --------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Configure PA15
  * @retval None
  */
void init_cmu_pin(void)
{
    gpio_init_t gpio_config;

    /* Initialize HSCO pin */
    gpio_config.mode  = GPIO_MODE_OUTPUT;
    gpio_config.odos  = GPIO_PUSH_PULL;
    gpio_config.pupd  = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_0_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_config.flt   = GPIO_FILTER_DISABLE;
    gpio_config.type  = GPIO_TYPE_TTL;
    gpio_config.func  = GPIO_FUNC_6;
    ald_gpio_init(HSCO_PORT, HSCO_PIN, &gpio_config);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();

    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);

    /* Enable all peripherals */
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* get current clock */
    g_sysclk = ald_cmu_get_sys_clock();
    g_hclk1 = ald_cmu_get_hclk1_clock();
    g_hclk2 = ald_cmu_get_hclk2_clock();
    g_pclk1 = ald_cmu_get_pclk1_clock();
    g_pclk2 = ald_cmu_get_pclk2_clock();

    /* set the clock divider */
    ald_cmu_div_config(CMU_SYS, CMU_DIV_64);    /* Fclk / 64 */
    ald_cmu_div_config(CMU_HCLK_1, CMU_DIV_2);  /* sysclk / 2 */
    ald_cmu_div_config(CMU_HCLK_2, CMU_DIV_2);  /* sysclk / 2 */
    ald_cmu_div_config(CMU_PCLK_1, CMU_DIV_2);  /* sysclk / 2 */
    ald_cmu_div_config(CMU_PCLK_2, CMU_DIV_2);  /* sysclk / 2 */

    /* get current clock */
    g_sysclk = ald_cmu_get_sys_clock();
    g_hclk1 = ald_cmu_get_hclk1_clock();
    g_hclk2 = ald_cmu_get_hclk2_clock();
    g_pclk1 = ald_cmu_get_pclk1_clock();
    g_pclk2 = ald_cmu_get_pclk2_clock();

    /* Configure high-speed clock output */
    ald_cmu_output_high_clock_config(CMU_OUTPUT_HIGH_SEL_SYSCLK, CMU_OUTPUT_DIV_128, ENABLE);
    init_cmu_pin();    /* Initialize clock output pin */
    ald_cmu_pll_safe_config(ENABLE);  /* enalbe pll clock safe cecurity management */
    ald_cmu_hosc_safe_config(CMU_HOSC_16M, ENABLE);  /* enalbe hosc clock safe cecurity management */

    while (1)
    {
        /* if pll have unlocked and resumed */
        if ((ald_cmu_current_clock_source_get(CMU_SAFE_CLK_PLL) == 0)
                && (g_clk_err_flag == 1))
            g_clk_err_flag = 0;
    }
}

/**
  * @brief  Interrupt callback function.
  * @retval None
  */
void ald_cmu_irq_cbk(cmu_security_t se)
{
    if (se == CMU_HOSC_STOP)
    {
        /* system rescue code in hosc fault  */

    }

    if (se == CMU_LOSC_STOP)
    {
        /* system rescue code in losc fault  */
    }

    if (se == CMU_PLL1_UNLOCK)
    {
        g_clk_err_flag = 1;
        /* system rescue code in pll fault  */
    }

}
/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
