/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    zhuxf          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include "main.h"


/* Private Macros ----------------------------------------------------------- */

#define TIMEOUT     1000    /*宏定义超时时间*/

/* Private Variables--------------------------------------------------------- */

static can_tx_msg_t s_tx_msg;     /*CAN TX消息对象*/
static can_rx_msg_t s_rx0_msg;    /*CAN RX消息对象*/

/* Public Variables -------------------------------------------------------- */

/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

/* Private Function---------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    ald_cmu_init();     /*初始化滴答时钟*/

    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);    /*使能倍频，由晶振三分频倍频至48MHz*/
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);     /*选择倍频时钟为系统时钟*/
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);    /*使能所有外设时钟*/

    can_init();     /*初始化CAN模块*/

    while (1)
    {
        ald_can_recv_by_it(&g_can, CAN_RX_FIFO0, &s_rx0_msg);     /*使能中断接收*/

        while (g_flag != RX_COMPLEPED)      /*等待数据接收*/
            ;

        g_flag = ~RX_COMPLEPED;  /*重置接收标志*/

        s_tx_msg.rtr  = s_rx0_msg.rtr;      /*发送数据帧*/
        s_tx_msg.type = s_rx0_msg.type;     /*标准格式*/
        s_tx_msg.std  = s_rx0_msg.std;      /*标准消息标识符*/
        s_tx_msg.ext  = s_rx0_msg.ext;      /*扩展消息标识符*/
        s_tx_msg.len  = s_rx0_msg.len;      /*发送的数据长度*/
        s_tx_msg.data[0] = s_rx0_msg.data[0];   /*发送数据赋值*/
        s_tx_msg.data[1] = s_rx0_msg.data[1];
        s_tx_msg.data[2] = s_rx0_msg.data[2];
        s_tx_msg.data[3] = s_rx0_msg.data[3];
        s_tx_msg.data[4] = s_rx0_msg.data[4];
        s_tx_msg.data[5] = s_rx0_msg.data[5];
        s_tx_msg.data[6] = s_rx0_msg.data[6];
        s_tx_msg.data[7] = s_rx0_msg.data[7];

        if (ald_can_send(&g_can, &s_tx_msg, TIMEOUT) != OK)   /*数据回传*/
        {
            while (1)
                ;
        }
    }
}
/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
