/**********************************************************************************
 *
 * @file    bxcan.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    zhuxf          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include "bxcan.h"


/* Private Macros ----------------------------------------------------------- */

#define MASKID      0x5A1

/* Private Variables--------------------------------------------------------- */

can_handle_t g_can;
can_filter_t g_filter;
uint32_t g_flag = ~RX_COMPLEPED;

/* Public Variables -------------------------------------------------------- */

/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

/* Private Function---------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to can_handle_t structure.
  * @retval None.
  */
void can_send_complete(can_handle_t *arg)
{
    return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to can_handle_t structure.
  * @param  num: Index of the RxFIFO.
  * @retval None.
  */
void can_recv_complete(can_handle_t *arg, can_rx_fifo_t num)
{
    g_flag = RX_COMPLEPED;     /*中断接收完成后调用此函数，置标志位*/
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to can_handle_t structure.
  * @retval None.
  */
void can_error(can_handle_t *arg)
{
    return;
}

/**
  * @brief  Initializing can function.
  * @retval None.
  */
void can_init(void)
{
    can_pin_init();     /*初始化CAN管脚*/

    g_can.perh        = CAN0;
    g_can.init.mode   = CAN_MODE_NORMAL;    /*正常模式*/
    g_can.init.psc    = 8;              /*|--------|*/
    g_can.init.sjw    = CAN_SJW_1;      /*|通讯速率|*/
    g_can.init.seg1   = CAN_SEG1_7;     /*| 500Kbps|*/
    g_can.init.seg2   = CAN_SEG2_4;     /*|--------|*/
    g_can.init.ttcm   = DISABLE;
    g_can.init.abom   = DISABLE;
    g_can.init.awk    = DISABLE;
    g_can.init.artx   = ENABLE;
    g_can.init.rfom   = DISABLE;
    g_can.init.txmp   = DISABLE;
    g_can.tx_cplt_cbk = can_send_complete;
    g_can.rx_cplt_cbk = can_recv_complete;
    g_can.error_cbk   = can_error;
    ald_can_init(&g_can);   /*初始化CAN模块*/

    g_filter.fifo         = CAN_FILTER_FIFO0;
    g_filter.mode         = CAN_FILTER_MODE_MASK;
    g_filter.scale        = CAN_FILTER_SCALE_32;
    g_filter.number       = 0;
    g_filter.id_high      = MASKID << 5;   /*标识符高位寄存器*/
    g_filter.id_low       = 0;
    g_filter.mask_id_high = 0xFF00;     /*屏蔽高位寄存器,仅接收标识符为0x5A0~0x5A7的消息*/
    g_filter.mask_id_low  = 0x0000;
    g_filter.active       = ENABLE;
    ald_can_filter_config(&g_can, &g_filter);   /*配置并使能CAN过滤器*/

    ald_mcu_irq_config(CAN0_RX0_IRQn, 3, 3, ENABLE);    /*配置优先级，使能内核中断*/
}

/**
  * @brief  Initializate pin of can module.
  * @retval None
  */
static void can_pin_init(void)
{
    gpio_init_t l_gpio;

    l_gpio.odos  = GPIO_PUSH_PULL;
    l_gpio.pupd  = GPIO_PUSH_UP;
    l_gpio.nodrv = GPIO_OUT_DRIVE_6;
    l_gpio.podrv = GPIO_OUT_DRIVE_6;
    l_gpio.flt   = GPIO_FILTER_DISABLE;
    l_gpio.type  = GPIO_TYPE_TTL;

    l_gpio.func  = GPIO_FUNC_3;
    l_gpio.mode  = GPIO_MODE_OUTPUT;
    ald_gpio_init(GPIOB, GPIO_PIN_9, &l_gpio);  /*配置CAN_TX管脚*/

    l_gpio.func  = GPIO_FUNC_3;
    l_gpio.mode  = GPIO_MODE_INPUT;
    ald_gpio_init(GPIOB, GPIO_PIN_8, &l_gpio);  /*配置CAN_RX管脚，除管脚输入方向外其它与CAN_TX一致*/
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
