/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Variables --------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/* Public Variables ---------------------------------------------------------- */
md_adc_init_t g_adc_config;
uint32_t g_adc_result;
uint8_t g_warning = 0U;

/** @addtogroup Public_Function
  * @{
  */

/**
  * @brief  Configure the ADC Pins.
  * @param  None
  * @retval None
  */

/* Private Function ---------------------------------------------------------- */

void init_adc_pin(void)
{
    md_gpio_init_t gpio_config;
    md_gpio_init_struct(&gpio_config);

    /* Initialize adc gpio pin: PC0, PC1 */
    gpio_config.mode  = MD_GPIO_MODE_CLOSE;
    gpio_config.pupd  = MD_GPIO_FLOATING;
    gpio_config.odos  = MD_GPIO_PUSH_PULL;
    gpio_config.podrv = MD_GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = MD_GPIO_OUT_DRIVE_1;
    gpio_config.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_config.type  = MD_GPIO_TYPE_CMOS;
    gpio_config.func  = MD_GPIO_FUNC_0;

    md_gpio_init(ADC_CHANNEL0_GPIO_PORT, ADC_CHANNEL0_PIN, &gpio_config);

    return;
}

/**
  * @brief  Configure the TIM Pins.
  * @param  None
  * @retval None
  */
void config_adc_base(void)
{
    md_adc_struct_init(&g_adc_config);
    /* Set ADC Base Configuration:  */
    g_adc_config.align    = MD_ADC_DATAALIGN_RIGHT;     /* Specifies ADC data alignment */
    g_adc_config.data_bit = MD_ADC_CONV_BIT_12;
    g_adc_config.div      = MD_ADC_CKDIV_16;            /* ADCCLK divider */
    g_adc_config.n_ref    = MD_ADC_NEG_REF_VSS;
    g_adc_config.p_ref    = MD_ADC_POS_REF_VDD;         /* The positive reference voltage*/
    md_adc_init(ADC0, &g_adc_config);

    /* enable ADC reg analog watchdog */
    md_adc_wdt_normal_channel_enable_nchwden(ADC0);
    /* Enable ADC singal analog watchdog */
    md_adc_wdt_single_channel_scan_mode_enable_awdsgl(ADC0);
    /* Set ADC analog watchdog monitored channel*/
    md_adc_set_channel_awdch(ADC0, MD_ADC_CHANNEL_0);
    /* Set ADC analog watchdog threshold value of threshold high*/
    md_adc_set_higher_threshold_ht(ADC0, 0x800);
    /* Set ADC analog watchdog threshold value of threshold low*/
    md_adc_set_lower_threshold_lt(ADC0, 0x300);

    /*Enable ADC sequencers scan mode*/
    md_adc_scan_mode_enable_scanen(ADC0);
    /* Set ADC group REG sequencer length and scan direction,ADC conversion 1 channel */
    md_adc_set_normal_channel_length_nsl(ADC0, MD_ADC_NCH_NR_1);
    /* Set ADC continuous conversion mode on ADC group REG.*/
    md_adc_continuous_conversion_enable_cm(ADC0);
    /*Set ADC group REG sequence: channel on the selected scan sequence rank.*/
    md_adc_set_normal_1st_conv_ns1(ADC0, MD_ADC_CHANNEL_0);
    md_adc_set_smpt1_cht(ADC0, MD_ADC_CHANNEL_0, MD_ADC_SAMPLETIME_15);

    /* Set priority for ADC_IRQn and Enable ADC_IRQn*/
    md_mcu_irq_config(ADC0_IRQn, 0, 0, ENABLE);
    /*Enable interruption ADC analog watchdog*/
    md_adc_analog_wdt_interrupt_enable_awdie(ADC0);
    md_adc_conv_end_interrupt_enable_ncheie(ADC0);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Configure system clock */
    md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HOSC_3, MD_CMU_PLL1_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 72000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* 2bits preempt-priority(0-3)
       2bits sub-priority(0-3). */
    NVIC_SetPriorityGrouping(5);

    /* Enable the selected ADC instance.*/
    md_adc_converter_enable_adcen(ADC0);
    /* Disable the selected ADC instance.*/
    md_adc_converter_disable_adcen(ADC0);

    /* Initialize ADC Pins  */
    init_adc_pin();
    /* ADC Base Feature Configuration */
    config_adc_base();

    /*Enable the selected ADC instance.*/
    md_adc_converter_enable_adcen(ADC0);

    /* Enable ADC group REG conversion trigger source internal (SW start)*/
    md_adc_set_normal_channel_conv_start_nchtrg(ADC0);

    while (1)
    {

    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
