/**********************************************************************************
 *
 * @file    main.c
 * @brief   ADC_SingleConversion C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Variables --------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Public Variables ---------------------------------------------------------- */
adc_handle_t g_adc_config;
adc_nch_conf_t g_nch_config;
adc_ich_conf_t g_ich_config;
uint32_t g_adc_result;

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Adc normal convert complete.
  * @param  arg: Pointer to adc_handle_t structure.
  * @retval None.
  */
void normal_convert_complete(adc_handle_t *arg)
{
    g_adc_result = ald_adc_normal_get_value(&g_adc_config) * 3320 / 4096;
    return;
}

/**
  * @brief  Adc insert convert complete.
  * @param  arg: Pointer to adc_handle_t structure.
  * @retval None.
  */
void insert_convert_complete(adc_handle_t *arg)
{
    return;
}

/**
  * @brief  Adc level out of window complete.
  * @param  arg: Pointer to adc_handle_t structure.
  * @retval None.
  */
void out_window_complete(adc_handle_t *arg)
{
    return;
}

/**
  * @brief  Adc error complete.
  * @param  arg: Pointer to adc_handle_t structure.
  * @retval None.
  */
void error_complete(adc_handle_t *arg)
{
    return;
}

/**
  * @brief  Adc over complete.
  * @param  arg: Pointer to adc_handle_t structure.
  * @retval None.
  */
void ovr_complete(adc_handle_t *arg)
{
    return;
}

/**
  * @brief  Initialize the ADC Pins.
  * @param  None
  * @retval None
  */
void init_adc_pin(void)
{
    /* Initialize adc gpio pin: PC0 */
    gpio_init_t gpio_config;
    memset(&gpio_config, 0x0, sizeof(gpio_init_t));

    gpio_config.mode = GPIO_MODE_CLOSE;
    gpio_config.pupd = GPIO_FLOATING;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_0;
    ald_gpio_init(ADC_IN_PORT, ADC_IN0_PIN, &gpio_config);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Enable interrupt */
    ald_mcu_irq_config(ADC0_IRQn, 1, 1, ENABLE);
    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);

    /* Enable mode clock */
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Initialize ADC gpio */
    init_adc_pin();

    memset(&g_adc_config, 0x0, sizeof(adc_handle_t));
    memset(&g_nch_config, 0x0, sizeof(adc_nch_conf_t));

    /* Initialize adc */
    g_adc_config.perh = ADC0;
    g_adc_config.init.align    = ADC_DATAALIGN_RIGHT;
    g_adc_config.init.scan     = ENABLE;
    g_adc_config.init.cont     = DISABLE;
    g_adc_config.init.disc     = ADC_ALL_DISABLE;
    g_adc_config.init.disc_nr  = ADC_DISC_NR_1;
    g_adc_config.init.data_bit = ADC_CONV_BIT_12;
    g_adc_config.init.div      = ADC_CKDIV_16;
    g_adc_config.init.nche_sel = ADC_NCHESEL_MODE_ALL;
    g_adc_config.init.nch_nr   = ADC_NCH_NR_1;
    g_adc_config.init.n_ref    = ADC_NEG_REF_VSS;
    g_adc_config.init.p_ref    = ADC_POS_REF_VDD;
    g_adc_config.normal_cplt_cbk = normal_convert_complete;
    ADC_ENABLE(&g_adc_config);
    ADC_DISABLE(&g_adc_config);
    ald_adc_init(&g_adc_config);

    /* Initialize nromal convert channel */
    g_nch_config.ch   = ADC_CHANNEL_0;
    g_nch_config.idx  = ADC_NCH_IDX_1;
    g_nch_config.samp = ADC_SAMPLETIME_15;
    ald_adc_normal_channel_config(&g_adc_config, &g_nch_config);

    while (1)
    {
        /* Start nromal convert, enable interrupt */
        ald_adc_normal_start_by_it(&g_adc_config);

        ald_delay_ms(500);
    }
}
/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
