#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 20 px
 * Bpp: 4
 * Opts:
 ******************************************************************************/

#ifndef ARIAL_20
#define ARIAL_20 1
#endif

#if ARIAL_20

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x3f, 0xd3, 0xfd, 0x0, 0x0, 0x63, 0xd, 0x70,
    0xe8, 0xf, 0x90, 0xfa, 0x1f, 0xb2, 0xfc, 0x3f,
    0xd4, 0xfe, 0x4f, 0xe4, 0xfe, 0x14, 0x30,

    /* U+22 "\"" */
    0x7, 0x60, 0x59, 0x0, 0xda, 0x9, 0xe0, 0xf,
    0xd0, 0xcf, 0x11, 0xfe, 0xd, 0xf2, 0x1f, 0xe0,
    0xdf, 0x20, 0x43, 0x3, 0x40,

    /* U+23 "#" */
    0x3, 0x10, 0x1, 0x40, 0x0, 0x0, 0xd9, 0x0,
    0x4f, 0x20, 0x0, 0xa, 0xd0, 0x1, 0xf5, 0x0,
    0x0, 0x7f, 0x0, 0xe, 0x80, 0x0, 0x4, 0xf3,
    0x0, 0xbc, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x34, 0xdc, 0x44, 0x6f, 0x64, 0x30, 0x9,
    0xd0, 0x1, 0xf6, 0x0, 0x0, 0x6f, 0x0, 0xe,
    0x90, 0x0, 0x3, 0xf3, 0x0, 0xbc, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xd3, 0x44, 0xdc, 0x44,
    0x6f, 0x73, 0x0, 0x9, 0xe0, 0x0, 0xf6, 0x0,
    0x0, 0x6f, 0x0, 0xd, 0xa0, 0x0, 0x3, 0xf4,
    0x0, 0xad, 0x0, 0x0, 0x8, 0x30, 0x4, 0x70,

    /* U+24 "$" */
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xf3, 0x0, 0x0, 0x0, 0x8e, 0xff, 0xff, 0x60,
    0x0, 0x6f, 0xe6, 0xf6, 0xdf, 0x50, 0xe, 0xf1,
    0xf, 0x0, 0xee, 0x3, 0xfa, 0x0, 0xf0, 0xb,
    0xf1, 0x1, 0x10, 0xf, 0x0, 0xbf, 0x20, 0x0,
    0x0, 0xf0, 0x3f, 0xe0, 0x0, 0x0, 0x2f, 0xbf,
    0xf5, 0x0, 0x5, 0xdf, 0xff, 0xd3, 0x0, 0x3,
    0xff, 0xbf, 0x20, 0x0, 0x0, 0xbf, 0x60, 0xf0,
    0x0, 0x0, 0xf, 0xd0, 0xf, 0x0, 0x0, 0x0,
    0xde, 0x0, 0xf0, 0x1f, 0x90, 0x9, 0xf7, 0xf,
    0xa, 0xf6, 0x0, 0xc, 0xfe, 0xfe, 0xfc, 0x0,
    0x0, 0x7, 0xaf, 0xa6, 0x0, 0x0, 0x0, 0x0,
    0xc0, 0x0, 0x0,

    /* U+25 "%" */
    0x0, 0x5, 0x60, 0x0, 0x0, 0x4, 0x73, 0x0,
    0x0, 0x3, 0xf2, 0x0, 0x0, 0x9f, 0xdf, 0x80,
    0x0, 0x0, 0xbb, 0x0, 0x3, 0xf5, 0x5, 0xf2,
    0x0, 0x0, 0x3f, 0x30, 0x7, 0xf0, 0x0, 0xf6,
    0x0, 0x0, 0xa, 0xc0, 0x8, 0xf0, 0x0, 0xf8,
    0x0, 0x0, 0x2, 0xf4, 0x6, 0xf1, 0x2, 0xf6,
    0x0, 0x0, 0x0, 0xad, 0x1, 0xfa, 0x4a, 0xe1,
    0x0, 0x0, 0x0, 0x2f, 0x50, 0x3c, 0xfc, 0x20,
    0x5, 0xde, 0xa0, 0x9, 0xd0, 0x0, 0x0, 0x0,
    0x3f, 0x96, 0xea, 0x1, 0xf5, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x6f, 0x10, 0x8d, 0x0, 0x0, 0x0,
    0xcb, 0x0, 0x4f, 0x30, 0x1f, 0x60, 0x0, 0x0,
    0xcc, 0x0, 0x5f, 0x20, 0x8, 0xe0, 0x0, 0x0,
    0x9f, 0x10, 0x9f, 0x0, 0x0, 0xf7, 0x0, 0x0,
    0x1e, 0xdc, 0xf5, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x1, 0x56, 0x20, 0x0, 0x0, 0x7, 0x20, 0x0,

    /* U+26 "&" */
    0x0, 0x0, 0x23, 0x0, 0x0, 0x1, 0x0, 0x3,
    0xef, 0xff, 0xc4, 0x5, 0xf6, 0x4, 0xff, 0x75,
    0x9f, 0xf8, 0xff, 0x40, 0xdf, 0x50, 0x0, 0x1e,
    0xff, 0x40, 0xf, 0xd0, 0x0, 0x1, 0xef, 0xc0,
    0x0, 0xfd, 0x0, 0x0, 0xcf, 0xff, 0x30, 0xc,
    0xf4, 0x0, 0xaf, 0xc5, 0xfa, 0x0, 0x2e, 0xf6,
    0x7f, 0xe1, 0xa, 0x50, 0x0, 0x1b, 0xff, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0x80, 0x0,
    0x0, 0x0, 0xb, 0xfa, 0xbf, 0xb0, 0x0, 0x0,
    0x2, 0xfc, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x4f,
    0x70, 0x4, 0xf7, 0x0, 0x0, 0x1, 0xfd, 0x0,
    0x9f, 0x50, 0x0, 0x0, 0x4, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x1, 0x57, 0x60, 0x0, 0x0,

    /* U+27 "'" */
    0x96, 0xea, 0xfc, 0xff, 0xff, 0x44,

    /* U+28 "(" */
    0x0, 0x1, 0x30, 0x0, 0xd9, 0x0, 0x7f, 0x10,
    0x1f, 0xa0, 0x8, 0xf2, 0x0, 0xfd, 0x0, 0x3f,
    0xa0, 0x8, 0xf8, 0x0, 0xbf, 0x50, 0xc, 0xf2,
    0x0, 0xcf, 0x0, 0xa, 0xf1, 0x0, 0x9f, 0x30,
    0x6, 0xf6, 0x0, 0x1f, 0xa0, 0x0, 0xbe, 0x0,
    0x3, 0xf4, 0x0, 0xb, 0xb0, 0x0, 0x1e, 0x40,
    0x0, 0x46,

    /* U+29 ")" */
    0x22, 0x0, 0x7, 0xe0, 0x0, 0xe, 0xa0, 0x0,
    0x8f, 0x20, 0x1, 0xfa, 0x0, 0xb, 0xf1, 0x0,
    0x8f, 0x60, 0x5, 0xfa, 0x0, 0x3f, 0xd0, 0x0,
    0xfe, 0x0, 0xe, 0xe0, 0x0, 0xfd, 0x0, 0x1f,
    0xb0, 0x4, 0xf8, 0x0, 0x7f, 0x30, 0xc, 0xd0,
    0x2, 0xf6, 0x0, 0x9d, 0x0, 0x2f, 0x20, 0x5,
    0x50, 0x0,

    /* U+2A "*" */
    0x0, 0x40, 0x4, 0x0, 0x5, 0xf2, 0x7f, 0x10,
    0x0, 0xad, 0xf5, 0x0, 0x17, 0xaf, 0xe9, 0x50,
    0x1e, 0xac, 0x9c, 0xc0, 0x0, 0xc, 0x70, 0x0,
    0x0, 0x6, 0x40, 0x0,

    /* U+2B "+" */
    0x0, 0x0, 0xb8, 0x0, 0x0, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0xfa, 0x0, 0x0, 0xac, 0xcc, 0xfe, 0xcc,
    0xc6, 0xef, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x0, 0x0, 0xb8,
    0x0, 0x0,

    /* U+2C "," */
    0x17, 0x0, 0xb7, 0x4, 0xb3, 0xfc, 0x3f, 0xc0,

    /* U+2D "-" */
    0x4b, 0xbb, 0xbb, 0x5, 0xff, 0xff, 0xf0, 0x1,
    0x11, 0x11, 0x0,

    /* U+2E "." */
    0x2f, 0xd2, 0xfd,

    /* U+2F "/" */
    0x42, 0x0, 0x0, 0xda, 0x0, 0x0, 0x8d, 0x0,
    0x0, 0x4f, 0x30, 0x0, 0xf, 0x70, 0x0, 0xb,
    0xc0, 0x0, 0x6, 0xf0, 0x0, 0x2, 0xf5, 0x0,
    0x0, 0xd9, 0x0, 0x0, 0x9d, 0x0, 0x0, 0x5f,
    0x20, 0x0, 0xf, 0x70, 0x0, 0xb, 0xb0, 0x0,
    0x7, 0xe0, 0x0, 0x2, 0xf4, 0x0, 0x0, 0x84,

    /* U+30 "0" */
    0x0, 0x0, 0x13, 0x10, 0x0, 0x0, 0x1, 0xdf,
    0xff, 0xc2, 0x0, 0x0, 0xdf, 0x84, 0x8f, 0xe0,
    0x0, 0x5f, 0x60, 0x0, 0x6f, 0x60, 0xc, 0xf0,
    0x0, 0x0, 0xfc, 0x0, 0xfc, 0x0, 0x0, 0xd,
    0xf0, 0x1f, 0xb0, 0x0, 0x0, 0xbf, 0x12, 0xfa,
    0x0, 0x0, 0xa, 0xf2, 0x2f, 0xa0, 0x0, 0x0,
    0xaf, 0x21, 0xfb, 0x0, 0x0, 0xc, 0xf1, 0xf,
    0xd0, 0x0, 0x0, 0xdf, 0x0, 0xcf, 0x0, 0x0,
    0xf, 0xd0, 0x8, 0xf5, 0x0, 0x6, 0xf8, 0x0,
    0x1e, 0xe4, 0x17, 0xfd, 0x0, 0x0, 0x2d, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x5, 0x74, 0x0, 0x0,

    /* U+31 "1" */
    0x0, 0x4, 0xf7, 0x0, 0x4, 0xf7, 0x0, 0x4,
    0xf7, 0x0, 0x4, 0xf7, 0x0, 0x4, 0xf7, 0x0,
    0x4, 0xf7, 0x0, 0x4, 0xf7, 0x0, 0x4, 0xf7,
    0x0, 0x4, 0xf7, 0xa4, 0x4, 0xf7, 0xcf, 0xb6,
    0xf7, 0x8, 0xff, 0xf7, 0x0, 0x4f, 0xf7, 0x0,
    0x5, 0xf7, 0x0, 0x0, 0x63,

    /* U+32 "2" */
    0x5f, 0xff, 0xff, 0xff, 0xff, 0x11, 0xff, 0xcc,
    0xcc, 0xcc, 0xc0, 0x8, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x7, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x5, 0xfd, 0x10, 0x0, 0x0,
    0x0, 0x4, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0xe, 0xe0, 0xc,
    0xc0, 0x0, 0x0, 0xcf, 0x0, 0xcf, 0x10, 0x0,
    0x1f, 0xd0, 0x3, 0xfc, 0x40, 0x3c, 0xf6, 0x0,
    0x4, 0xdf, 0xff, 0xe6, 0x0, 0x0, 0x0, 0x36,
    0x40, 0x0, 0x0,

    /* U+33 "3" */
    0x0, 0x0, 0x13, 0x10, 0x0, 0x0, 0x5, 0xef,
    0xff, 0xd3, 0x0, 0x5, 0xfd, 0x74, 0x8f, 0xf2,
    0x0, 0xdf, 0x10, 0x0, 0x3f, 0xc0, 0xd, 0xb0,
    0x0, 0x0, 0xcf, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xf2, 0x0, 0x0, 0x0, 0x1, 0xff, 0x0, 0x0,
    0x1, 0x3, 0xcf, 0x60, 0x0, 0x0, 0x9f, 0xfe,
    0x40, 0x0, 0x0, 0x2, 0x6d, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xf4, 0x0, 0x59, 0x0, 0x0,
    0x5f, 0x70, 0xb, 0xf2, 0x0, 0x7, 0xf6, 0x0,
    0x4f, 0xd4, 0x16, 0xfe, 0x0, 0x0, 0x6f, 0xff,
    0xfb, 0x20, 0x0, 0x0, 0x15, 0x73, 0x0, 0x0,

    /* U+34 "4" */
    0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x0,
    0x8, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x30,
    0x5, 0x88, 0x88, 0x8c, 0xf9, 0x81, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0x26, 0xf4, 0x0, 0x8, 0xf3,
    0x0, 0xb, 0xe1, 0x0, 0x8f, 0x30, 0x0, 0x1e,
    0xb0, 0x8, 0xf3, 0x0, 0x0, 0x4f, 0x60, 0x8f,
    0x30, 0x0, 0x0, 0x9f, 0x18, 0xf3, 0x0, 0x0,
    0x0, 0xdc, 0x8f, 0x30, 0x0, 0x0, 0x2, 0xfe,
    0xf3, 0x0, 0x0, 0x0, 0x7, 0xff, 0x30, 0x0,
    0x0, 0x0, 0xc, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x14, 0x0, 0x0,

    /* U+35 "5" */
    0x0, 0x0, 0x13, 0x0, 0x0, 0x0, 0x5, 0xef,
    0xff, 0xb1, 0x0, 0x5, 0xff, 0x84, 0x8f, 0xe2,
    0x0, 0xdf, 0x30, 0x0, 0x4f, 0xb0, 0xd, 0xc0,
    0x0, 0x0, 0xbf, 0x10, 0x0, 0x0, 0x0, 0x9,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x20, 0x47,
    0x0, 0x0, 0x1f, 0xe0, 0xb, 0xfc, 0x40, 0x4d,
    0xf7, 0x0, 0x8f, 0xcf, 0xff, 0xf9, 0x0, 0x5,
    0xf5, 0x37, 0x63, 0x0, 0x0, 0x2f, 0x80, 0x0,
    0x0, 0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf8, 0x88, 0x88, 0x50, 0x0, 0x9f, 0xff,
    0xff, 0xfa, 0x0,

    /* U+36 "6" */
    0x0, 0x0, 0x2, 0x10, 0x0, 0x0, 0x1, 0x9e,
    0xff, 0xd5, 0x0, 0x0, 0xef, 0xa5, 0x7e, 0xf3,
    0x0, 0x7f, 0x70, 0x0, 0x1f, 0xb0, 0xc, 0xf0,
    0x0, 0x0, 0xbf, 0x0, 0xfc, 0x0, 0x0, 0xa,
    0xf2, 0x1f, 0xe0, 0x0, 0x0, 0xcf, 0x13, 0xff,
    0x40, 0x0, 0x2f, 0xd0, 0x2f, 0xef, 0x54, 0x4d,
    0xf4, 0x1, 0xf9, 0x6d, 0xff, 0xf5, 0x0, 0xf,
    0xa0, 0x2, 0x20, 0x0, 0x0, 0xbe, 0x0, 0x0,
    0x3, 0x30, 0x4, 0xf6, 0x0, 0x0, 0xfb, 0x0,
    0xd, 0xf7, 0x13, 0xcf, 0x50, 0x0, 0xb, 0xff,
    0xff, 0x80, 0x0, 0x0, 0x2, 0x66, 0x20, 0x0,

    /* U+37 "7" */
    0x0, 0xf, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xee,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x50, 0x0, 0x0, 0x0, 0x3,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0xe, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x40, 0x0, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x30, 0x8, 0x88, 0x88, 0x89, 0xfe, 0x10,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x4, 0x44, 0x44,
    0x44, 0x44, 0x0,

    /* U+38 "8" */
    0x0, 0x0, 0x13, 0x10, 0x0, 0x0, 0x4, 0xef,
    0xff, 0xe4, 0x0, 0x3, 0xfd, 0x64, 0x7e, 0xf3,
    0x0, 0xcf, 0x20, 0x0, 0x1f, 0xd0, 0xf, 0xb0,
    0x0, 0x0, 0xaf, 0x22, 0xfa, 0x0, 0x0, 0xa,
    0xf2, 0xf, 0xe0, 0x0, 0x0, 0xef, 0x0, 0x6f,
    0xb3, 0x3, 0xbf, 0x70, 0x0, 0x4d, 0xff, 0xfe,
    0x40, 0x0, 0x9, 0xfc, 0x8c, 0xfa, 0x0, 0x5,
    0xf8, 0x0, 0x7, 0xf6, 0x0, 0x9f, 0x30, 0x0,
    0x3f, 0x90, 0x7, 0xf6, 0x0, 0x4, 0xf8, 0x0,
    0x2f, 0xe5, 0x5, 0xef, 0x20, 0x0, 0x3d, 0xff,
    0xfd, 0x30, 0x0, 0x0, 0x3, 0x63, 0x0, 0x0,

    /* U+39 "9" */
    0x0, 0x0, 0x23, 0x0, 0x0, 0x0, 0x4, 0xef,
    0xff, 0xa1, 0x0, 0x4, 0xfd, 0x74, 0x8f, 0xd0,
    0x0, 0xbf, 0x20, 0x0, 0x7f, 0x60, 0x4, 0x60,
    0x0, 0x0, 0xfc, 0x0, 0x0, 0x2, 0x20, 0xb,
    0xf0, 0x0, 0x3e, 0xff, 0xc3, 0x9f, 0x10, 0x2f,
    0xfb, 0x8b, 0xfc, 0xf2, 0xb, 0xf5, 0x0, 0x6,
    0xff, 0x30, 0xfc, 0x0, 0x0, 0xe, 0xf2, 0x2f,
    0xa0, 0x0, 0x0, 0xcf, 0x10, 0xfc, 0x0, 0x0,
    0xd, 0xe0, 0xc, 0xf2, 0x0, 0x3, 0xf9, 0x0,
    0x3f, 0xe4, 0x4, 0xee, 0x10, 0x0, 0x4e, 0xff,
    0xfa, 0x10, 0x0, 0x0, 0x4, 0x61, 0x0, 0x0,

    /* U+3A ":" */
    0x3f, 0xc3, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2c, 0x93, 0xfc, 0x4,
    0x30,

    /* U+3B ";" */
    0x17, 0x0, 0xb7, 0x4, 0xb3, 0xfc, 0x3f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xc9, 0x3f, 0xc0, 0x43,

    /* U+3C "<" */
    0x0, 0x0, 0x0, 0x0, 0x45, 0x0, 0x0, 0x1,
    0x7e, 0xf9, 0x0, 0x2, 0x9f, 0xfd, 0x60, 0x5,
    0xcf, 0xfa, 0x30, 0x0, 0xdf, 0xd6, 0x0, 0x0,
    0x0, 0xef, 0xc6, 0x0, 0x0, 0x0, 0x29, 0xff,
    0xe8, 0x10, 0x0, 0x0, 0x7, 0xdf, 0xfa, 0x30,
    0x0, 0x0, 0x4, 0xbf, 0xf7, 0x0, 0x0, 0x0,
    0x2, 0x88,

    /* U+3D "=" */
    0xef, 0xff, 0xff, 0xff, 0xf9, 0xac, 0xcc, 0xcc,
    0xcc, 0xc6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x78, 0x88, 0x88, 0x88,
    0x84, 0xef, 0xff, 0xff, 0xff, 0xf9,

    /* U+3E ">" */
    0x82, 0x0, 0x0, 0x0, 0x0, 0xef, 0xb4, 0x0,
    0x0, 0x0, 0x28, 0xff, 0xe7, 0x10, 0x0, 0x0,
    0x5, 0xcf, 0xf9, 0x30, 0x0, 0x0, 0x2, 0x8f,
    0xf7, 0x0, 0x0, 0x1, 0x8e, 0xf9, 0x0, 0x3,
    0xaf, 0xfd, 0x71, 0x5, 0xcf, 0xfb, 0x40, 0x0,
    0xdf, 0xf9, 0x20, 0x0, 0x0, 0xb6, 0x0, 0x0,
    0x0, 0x0,

    /* U+3F "?" */
    0x0, 0x0, 0x8f, 0x80, 0x0, 0x0, 0x0, 0x8,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0x82, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x50, 0x0, 0x0, 0x0, 0x2, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x1d, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x1d,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xe0, 0x9,
    0x90, 0x0, 0x0, 0xbf, 0x10, 0xdf, 0x10, 0x0,
    0xe, 0xf0, 0x6, 0xfb, 0x10, 0x3c, 0xf9, 0x0,
    0x8, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x2, 0x57,
    0x52, 0x0, 0x0,

    /* U+40 "@" */
    0x0, 0x0, 0x0, 0x0, 0x13, 0x31, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x8d, 0xff, 0xff, 0xfe,
    0x94, 0x0, 0x0, 0x0, 0x7, 0xff, 0xc8, 0x64,
    0x46, 0x8d, 0xfc, 0x30, 0x0, 0x9, 0xf9, 0x10,
    0x0, 0x0, 0x0, 0x2, 0xdf, 0x50, 0x7, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x21,
    0xf9, 0x0, 0x5c, 0xe9, 0x23, 0xde, 0xa4, 0x1,
    0x42, 0x6f, 0x20, 0x4f, 0xf9, 0xaf, 0xdf, 0xbc,
    0xf7, 0x0, 0xb, 0xd0, 0xe, 0xf2, 0x0, 0x4f,
    0xf3, 0x8, 0xf6, 0x0, 0xda, 0x1, 0xfb, 0x0,
    0x0, 0x8f, 0x70, 0x9, 0xf1, 0xe, 0x80, 0x2f,
    0xa0, 0x0, 0x0, 0xfa, 0x0, 0xe, 0x70, 0xd9,
    0x0, 0xfc, 0x0, 0x0, 0xc, 0xd0, 0x0, 0x8b,
    0xb, 0xb0, 0xb, 0xf1, 0x0, 0x0, 0xcf, 0x10,
    0x6, 0xf0, 0x7f, 0x0, 0x5f, 0x90, 0x0, 0xe,
    0xf4, 0x0, 0x6f, 0x1, 0xf5, 0x0, 0xbf, 0x80,
    0x8, 0xff, 0x80, 0x9, 0xe0, 0xa, 0xe0, 0x0,
    0xaf, 0xee, 0xf4, 0xfb, 0x0, 0xfa, 0x0, 0x1e,
    0xa0, 0x0, 0x26, 0x73, 0x3, 0x30, 0x9f, 0x30,
    0x0, 0x4f, 0xb1, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x90, 0x0, 0x0, 0x4f, 0xf9, 0x40, 0x0, 0x6,
    0xdf, 0xa0, 0x0, 0x0, 0x0, 0x3a, 0xff, 0xfc,
    0xdf, 0xfb, 0x40, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x46, 0x76, 0x41, 0x0, 0x0, 0x0,

    /* U+41 "A" */
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xf, 0xf2, 0x7f,
    0x80, 0x0, 0x0, 0x0, 0x6f, 0xc0, 0x1f, 0xe0,
    0x0, 0x0, 0x0, 0xcf, 0x50, 0xa, 0xf4, 0x0,
    0x0, 0x2, 0xfe, 0x0, 0x4, 0xfe, 0xcc, 0xcc,
    0xcd, 0xf8, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x0, 0x8f, 0x40, 0x0, 0x3f, 0xb0,
    0x0, 0x0, 0x2f, 0xb0, 0x0, 0xaf, 0x40, 0x0,
    0x0, 0xc, 0xf1, 0x0, 0xfe, 0x0, 0x0, 0x0,
    0x5, 0xf7, 0x7, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xfd, 0xc, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x4f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xdf,
    0x30, 0x0, 0x0, 0x0, 0x0, 0xd, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x42, 0x0, 0x0,
    0x0,

    /* U+42 "B" */
    0x8f, 0xff, 0xff, 0xed, 0xa3, 0x0, 0x8f, 0xdc,
    0xcc, 0xcd, 0xff, 0x50, 0x8f, 0x50, 0x0, 0x0,
    0x6f, 0xe0, 0x8f, 0x50, 0x0, 0x0, 0xc, 0xf2,
    0x8f, 0x50, 0x0, 0x0, 0xb, 0xf3, 0x8f, 0x50,
    0x0, 0x0, 0x2f, 0xf1, 0x8f, 0xa8, 0x88, 0x8b,
    0xff, 0x40, 0x8f, 0xff, 0xff, 0xff, 0xe2, 0x0,
    0x8f, 0x84, 0x44, 0x69, 0xfc, 0x0, 0x8f, 0x50,
    0x0, 0x0, 0x8f, 0x50, 0x8f, 0x50, 0x0, 0x0,
    0x5f, 0x80, 0x8f, 0x50, 0x0, 0x0, 0x8f, 0x70,
    0x8f, 0x84, 0x44, 0x48, 0xfe, 0x10, 0x8f, 0xff,
    0xff, 0xff, 0xe2, 0x0, 0x24, 0x44, 0x44, 0x43,
    0x0, 0x0,

    /* U+43 "C" */
    0x0, 0x0, 0x1, 0x32, 0x0, 0x0, 0x0, 0x0,
    0x7e, 0xff, 0xff, 0x91, 0x0, 0x0, 0xcf, 0xeb,
    0x8a, 0xef, 0xd1, 0x0, 0xaf, 0x80, 0x0, 0x0,
    0x9f, 0xc0, 0x3f, 0xc0, 0x0, 0x0, 0x0, 0xdf,
    0x39, 0xf5, 0x0, 0x0, 0x0, 0x6, 0xc5, 0xdf,
    0x10, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x40, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xfa, 0x0, 0x0, 0x0, 0xa, 0xb2, 0xe, 0xf4,
    0x0, 0x0, 0x4, 0xfe, 0x0, 0x4f, 0xf8, 0x30,
    0x27, 0xff, 0x50, 0x0, 0x3d, 0xff, 0xff, 0xfe,
    0x50, 0x0, 0x0, 0x5, 0x87, 0x64, 0x0, 0x0,

    /* U+44 "D" */
    0x7f, 0xff, 0xff, 0xec, 0x92, 0x0, 0x7, 0xfd,
    0xcc, 0xcd, 0xff, 0xf5, 0x0, 0x7f, 0x70, 0x0,
    0x0, 0x5f, 0xf2, 0x7, 0xf7, 0x0, 0x0, 0x0,
    0x7f, 0xa0, 0x7f, 0x70, 0x0, 0x0, 0x0, 0xff,
    0x7, 0xf7, 0x0, 0x0, 0x0, 0xb, 0xf4, 0x7f,
    0x70, 0x0, 0x0, 0x0, 0x9f, 0x57, 0xf7, 0x0,
    0x0, 0x0, 0x9, 0xf5, 0x7f, 0x70, 0x0, 0x0,
    0x0, 0xbf, 0x47, 0xf7, 0x0, 0x0, 0x0, 0xd,
    0xf1, 0x7f, 0x70, 0x0, 0x0, 0x3, 0xfd, 0x7,
    0xf7, 0x0, 0x0, 0x1, 0xdf, 0x60, 0x7f, 0x94,
    0x44, 0x7a, 0xff, 0x90, 0x7, 0xff, 0xff, 0xff,
    0xfe, 0x70, 0x0, 0x14, 0x44, 0x44, 0x31, 0x0,
    0x0, 0x0,

    /* U+45 "E" */
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x6f, 0xdc,
    0xcc, 0xcc, 0xcc, 0xc3, 0x6f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xb8, 0x88, 0x88,
    0x88, 0x30, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x6f, 0x94, 0x44, 0x44, 0x44, 0x10, 0x6f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x94, 0x44, 0x44, 0x44, 0x30, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x14, 0x44, 0x44, 0x44,
    0x44, 0x30,

    /* U+46 "F" */
    0x5f, 0x80, 0x0, 0x0, 0x0, 0x5, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0x80, 0x0, 0x0, 0x0,
    0x5, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x80,
    0x0, 0x0, 0x0, 0x5, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xc8, 0x88, 0x88, 0x82, 0x5, 0xff,
    0xff, 0xff, 0xff, 0x40, 0x5f, 0xa4, 0x44, 0x44,
    0x41, 0x5, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x80, 0x0, 0x0, 0x0, 0x5, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xa4, 0x44, 0x44, 0x44, 0x15,
    0xff, 0xff, 0xff, 0xff, 0xf4, 0x14, 0x44, 0x44,
    0x44, 0x44, 0x10,

    /* U+47 "G" */
    0x0, 0x0, 0x0, 0x23, 0x10, 0x0, 0x0, 0x0,
    0x3, 0xaf, 0xff, 0xfe, 0xa3, 0x0, 0x0, 0x8f,
    0xfd, 0xa8, 0xcf, 0xff, 0x90, 0x8, 0xfc, 0x10,
    0x0, 0x0, 0x6f, 0xf4, 0x2f, 0xe1, 0x0, 0x0,
    0x0, 0x8, 0xf4, 0x8f, 0x80, 0x0, 0x0, 0x0,
    0x8, 0xf4, 0xcf, 0x30, 0x0, 0x6, 0x88, 0x8c,
    0xf4, 0xef, 0x10, 0x0, 0xc, 0xff, 0xff, 0xf4,
    0xef, 0x0, 0x0, 0x3, 0x44, 0x44, 0x41, 0xcf,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x60,
    0x0, 0x0, 0x0, 0x1, 0x0, 0x3f, 0xc0, 0x0,
    0x0, 0x0, 0xe, 0xd0, 0xb, 0xf8, 0x0, 0x0,
    0x0, 0x8f, 0x90, 0x1, 0xdf, 0xc6, 0x21, 0x4b,
    0xff, 0x20, 0x0, 0x1b, 0xff, 0xff, 0xff, 0xc3,
    0x0, 0x0, 0x0, 0x27, 0x88, 0x73, 0x0, 0x0,

    /* U+48 "H" */
    0x6f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x6f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x6f, 0x70, 0x0, 0x0,
    0x1, 0xfd, 0x6f, 0x70, 0x0, 0x0, 0x1, 0xfd,
    0x6f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x6f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x6f, 0x94, 0x44, 0x44,
    0x44, 0xfd, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x6f, 0xb8, 0x88, 0x88, 0x88, 0xfd, 0x6f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x6f, 0x70, 0x0, 0x0,
    0x1, 0xfd, 0x6f, 0x70, 0x0, 0x0, 0x1, 0xfd,
    0x6f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x6f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x14, 0x10, 0x0, 0x0,
    0x0, 0x43,

    /* U+49 "I" */
    0x2f, 0xc2, 0xfc, 0x2f, 0xc2, 0xfc, 0x2f, 0xc2,
    0xfc, 0x2f, 0xc2, 0xfc, 0x2f, 0xc2, 0xfc, 0x2f,
    0xc2, 0xfc, 0x2f, 0xc2, 0xfc, 0x5, 0x30,

    /* U+4A "J" */
    0x0, 0x1, 0x30, 0x0, 0x0, 0x3d, 0xff, 0xfb,
    0x10, 0xe, 0xfc, 0x8c, 0xfc, 0x4, 0xf9, 0x0,
    0xc, 0xf3, 0x6f, 0x60, 0x0, 0x8f, 0x50, 0x21,
    0x0, 0x7, 0xf6, 0x0, 0x0, 0x0, 0x7f, 0x70,
    0x0, 0x0, 0x7, 0xf7, 0x0, 0x0, 0x0, 0x7f,
    0x70, 0x0, 0x0, 0x7, 0xf7, 0x0, 0x0, 0x0,
    0x7f, 0x70, 0x0, 0x0, 0x7, 0xf7, 0x0, 0x0,
    0x0, 0x7f, 0x70, 0x0, 0x0, 0x7, 0xf7, 0x0,
    0x0, 0x0, 0x7f, 0x70, 0x0, 0x0, 0x1, 0x41,

    /* U+4B "K" */
    0x8f, 0x50, 0x0, 0x0, 0x8, 0xfd, 0x8, 0xf5,
    0x0, 0x0, 0x3, 0xff, 0x30, 0x8f, 0x50, 0x0,
    0x1, 0xef, 0x70, 0x8, 0xf5, 0x0, 0x0, 0xbf,
    0xb0, 0x0, 0x8f, 0x50, 0x0, 0x5f, 0xe1, 0x0,
    0x8, 0xfd, 0x10, 0x1f, 0xf3, 0x0, 0x0, 0x8f,
    0xfd, 0x1c, 0xf7, 0x0, 0x0, 0x8, 0xfb, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0x8f, 0x55, 0xff, 0x40,
    0x0, 0x0, 0x8, 0xf5, 0x5, 0xfe, 0x20, 0x0,
    0x0, 0x8f, 0x50, 0x5, 0xfe, 0x20, 0x0, 0x8,
    0xf5, 0x0, 0x5, 0xff, 0x30, 0x0, 0x8f, 0x50,
    0x0, 0x5, 0xff, 0x30, 0x8, 0xf5, 0x0, 0x0,
    0x4, 0xff, 0x40, 0x24, 0x10, 0x0, 0x0, 0x2,
    0x43, 0x0,

    /* U+4C "L" */
    0x8f, 0xff, 0xff, 0xff, 0xf8, 0x8f, 0xdc, 0xcc,
    0xcc, 0xc6, 0x8f, 0x40, 0x0, 0x0, 0x0, 0x8f,
    0x40, 0x0, 0x0, 0x0, 0x8f, 0x40, 0x0, 0x0,
    0x0, 0x8f, 0x40, 0x0, 0x0, 0x0, 0x8f, 0x40,
    0x0, 0x0, 0x0, 0x8f, 0x40, 0x0, 0x0, 0x0,
    0x8f, 0x40, 0x0, 0x0, 0x0, 0x8f, 0x40, 0x0,
    0x0, 0x0, 0x8f, 0x40, 0x0, 0x0, 0x0, 0x8f,
    0x40, 0x0, 0x0, 0x0, 0x8f, 0x40, 0x0, 0x0,
    0x0, 0x8f, 0x40, 0x0, 0x0, 0x0, 0x24, 0x10,
    0x0, 0x0, 0x0,

    /* U+4D "M" */
    0x8f, 0x40, 0x0, 0xbf, 0x50, 0x0, 0xaf, 0x28,
    0xf4, 0x0, 0x1f, 0xfa, 0x0, 0xa, 0xf2, 0x8f,
    0x40, 0x6, 0xfb, 0xf0, 0x0, 0xaf, 0x28, 0xf4,
    0x0, 0xbf, 0x1f, 0x50, 0xa, 0xf2, 0x8f, 0x40,
    0x1f, 0xa0, 0xbb, 0x0, 0xaf, 0x28, 0xf4, 0x6,
    0xf4, 0x6, 0xf1, 0xa, 0xf2, 0x8f, 0x40, 0xbf,
    0x0, 0x1f, 0x60, 0xaf, 0x28, 0xf4, 0x1f, 0x90,
    0x0, 0xbc, 0xa, 0xf2, 0x8f, 0x46, 0xf4, 0x0,
    0x6, 0xf1, 0xaf, 0x28, 0xf4, 0xce, 0x0, 0x0,
    0xf, 0x7a, 0xf2, 0x8f, 0x6f, 0x90, 0x0, 0x0,
    0xbc, 0xaf, 0x28, 0xfb, 0xf4, 0x0, 0x0, 0x5,
    0xfd, 0xf2, 0x8f, 0xfe, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x28, 0xff, 0x90, 0x0, 0x0, 0x0, 0xaf,
    0xf2, 0x24, 0x41, 0x0, 0x0, 0x0, 0x1, 0x44,
    0x0,

    /* U+4E "N" */
    0x7f, 0x50, 0x0, 0x0, 0x7, 0xfc, 0x7f, 0x50,
    0x0, 0x0, 0x2f, 0xfc, 0x7f, 0x50, 0x0, 0x0,
    0xdf, 0xfc, 0x7f, 0x50, 0x0, 0x7, 0xfa, 0xfc,
    0x7f, 0x50, 0x0, 0x2f, 0xe1, 0xfc, 0x7f, 0x50,
    0x0, 0xdf, 0x40, 0xfc, 0x7f, 0x50, 0x7, 0xfa,
    0x0, 0xfc, 0x7f, 0x50, 0x2f, 0xe0, 0x0, 0xfc,
    0x7f, 0x50, 0xdf, 0x40, 0x0, 0xfc, 0x7f, 0x57,
    0xfa, 0x0, 0x0, 0xfc, 0x7f, 0x8f, 0xe0, 0x0,
    0x0, 0xfc, 0x7f, 0xff, 0x40, 0x0, 0x0, 0xfc,
    0x7f, 0xfa, 0x0, 0x0, 0x0, 0xfc, 0x7f, 0xe0,
    0x0, 0x0, 0x0, 0xfc, 0x14, 0x20, 0x0, 0x0,
    0x0, 0x43,

    /* U+4F "O" */
    0x0, 0x0, 0x0, 0x13, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xdf, 0xff, 0xf9, 0x20, 0x0, 0x0,
    0xa, 0xfe, 0xa8, 0xae, 0xff, 0x50, 0x0, 0x8,
    0xfa, 0x10, 0x0, 0x7, 0xff, 0x30, 0x2, 0xfd,
    0x0, 0x0, 0x0, 0x6, 0xfd, 0x0, 0x9f, 0x50,
    0x0, 0x0, 0x0, 0xc, 0xf3, 0xd, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x70, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf9, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x90, 0xdf, 0x10, 0x0, 0x0,
    0x0, 0x6, 0xf8, 0xa, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x40, 0x4f, 0xa0, 0x0, 0x0, 0x0,
    0x1f, 0xf0, 0x0, 0xbf, 0x70, 0x0, 0x0, 0xa,
    0xf7, 0x0, 0x2, 0xef, 0xc5, 0x11, 0x6d, 0xfb,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xe6, 0x0,
    0x0, 0x0, 0x0, 0x14, 0x76, 0x40, 0x0, 0x0,

    /* U+50 "P" */
    0x7f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x94,
    0x44, 0x31, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x7f, 0xb8, 0x88, 0x8b, 0xff, 0x90,
    0x7f, 0x70, 0x0, 0x0, 0x2f, 0xf2, 0x7f, 0x70,
    0x0, 0x0, 0x9, 0xf5, 0x7f, 0x70, 0x0, 0x0,
    0x9, 0xf6, 0x7f, 0x70, 0x0, 0x0, 0xd, 0xf4,
    0x7f, 0x94, 0x44, 0x47, 0xcf, 0xd0, 0x7f, 0xff,
    0xff, 0xff, 0xfb, 0x10, 0x14, 0x44, 0x44, 0x44,
    0x20, 0x0,

    /* U+51 "Q" */
    0x0, 0x0, 0x0, 0x13, 0x20, 0x0, 0x2a, 0x70,
    0x0, 0x6, 0xdf, 0xff, 0xf8, 0x7f, 0xd5, 0x0,
    0xb, 0xfe, 0xa8, 0x9d, 0xff, 0xb0, 0x0, 0xb,
    0xf9, 0x0, 0x1b, 0xfc, 0xff, 0x20, 0x5, 0xfc,
    0x0, 0x0, 0xc5, 0x7, 0xfc, 0x0, 0xbf, 0x30,
    0x0, 0x0, 0x0, 0xd, 0xf2, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x61, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xf7, 0x1f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x80, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xf6, 0xc, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x30, 0x7f, 0x80, 0x0, 0x0, 0x0,
    0x2f, 0xe0, 0x0, 0xef, 0x50, 0x0, 0x0, 0xc,
    0xf5, 0x0, 0x3, 0xff, 0xa5, 0x12, 0x6e, 0xfa,
    0x0, 0x0, 0x3, 0xef, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x58, 0x88, 0x71, 0x0, 0x0,

    /* U+52 "R" */
    0x6f, 0x70, 0x0, 0x0, 0x0, 0x8f, 0xd0, 0x6f,
    0x70, 0x0, 0x0, 0x2, 0xff, 0x40, 0x6f, 0x70,
    0x0, 0x0, 0xc, 0xfa, 0x0, 0x6f, 0x70, 0x0,
    0x0, 0x6f, 0xe1, 0x0, 0x6f, 0x70, 0x0, 0x2,
    0xef, 0x40, 0x0, 0x6f, 0x70, 0x0, 0x1d, 0xf6,
    0x0, 0x0, 0x6f, 0xdc, 0xcc, 0xef, 0x71, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x6f, 0x70, 0x0, 0x1, 0x4c, 0xf7, 0x0, 0x6f,
    0x70, 0x0, 0x0, 0x3, 0xfd, 0x0, 0x6f, 0x70,
    0x0, 0x0, 0x0, 0xff, 0x0, 0x6f, 0x70, 0x0,
    0x0, 0x3, 0xfe, 0x0, 0x6f, 0x94, 0x44, 0x45,
    0x9f, 0xf5, 0x0, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x14, 0x44, 0x44, 0x44, 0x30, 0x0,
    0x0,

    /* U+53 "S" */
    0x0, 0x0, 0x0, 0x32, 0x0, 0x0, 0x0, 0x0,
    0x9e, 0xff, 0xff, 0xc3, 0x0, 0x0, 0xdf, 0xfd,
    0x99, 0xbf, 0xf3, 0x0, 0x8f, 0xc2, 0x0, 0x0,
    0x4f, 0xe0, 0xe, 0xf0, 0x0, 0x0, 0x0, 0x9f,
    0x30, 0x98, 0x0, 0x0, 0x0, 0xa, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xfe, 0x0, 0x0, 0x0,
    0x48, 0xbe, 0xff, 0x30, 0x0, 0x8, 0xff, 0xff,
    0xfa, 0x10, 0x0, 0xd, 0xff, 0xd8, 0x40, 0x0,
    0x0, 0x6, 0xfc, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x50, 0x0, 0x0, 0xb, 0x90, 0x6, 0xf8,
    0x0, 0x0, 0x5, 0xf9, 0x0, 0x1f, 0xf8, 0x20,
    0x27, 0xff, 0x20, 0x0, 0x3d, 0xff, 0xff, 0xfe,
    0x40, 0x0, 0x0, 0x2, 0x47, 0x74, 0x0, 0x0,

    /* U+54 "T" */
    0x0, 0x0, 0xd, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xf1, 0x0, 0x0,
    0x24, 0x44, 0x4d, 0xf4, 0x44, 0x43, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x24, 0x44, 0x44, 0x44,
    0x44, 0x43,

    /* U+55 "U" */
    0x0, 0x0, 0x2, 0x31, 0x0, 0x0, 0x0, 0x3b,
    0xff, 0xff, 0xe7, 0x0, 0x4, 0xff, 0xea, 0x8b,
    0xff, 0x90, 0xd, 0xf6, 0x0, 0x0, 0x2e, 0xf4,
    0x2f, 0xc0, 0x0, 0x0, 0x8, 0xf9, 0x5f, 0x90,
    0x0, 0x0, 0x3, 0xfb, 0x6f, 0x70, 0x0, 0x0,
    0x1, 0xfc, 0x6f, 0x70, 0x0, 0x0, 0x1, 0xfd,
    0x6f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x6f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x6f, 0x70, 0x0, 0x0,
    0x1, 0xfd, 0x6f, 0x70, 0x0, 0x0, 0x1, 0xfd,
    0x6f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x6f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x6f, 0x70, 0x0, 0x0,
    0x1, 0xfd, 0x14, 0x10, 0x0, 0x0, 0x0, 0x43,

    /* U+56 "V" */
    0x0, 0x0, 0x8, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xef, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x7f, 0x80, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xc, 0xf0, 0x0, 0x0, 0x0, 0x2, 0xfa, 0x6,
    0xf5, 0x0, 0x0, 0x0, 0x8, 0xf5, 0x1, 0xfb,
    0x0, 0x0, 0x0, 0xe, 0xe0, 0x0, 0xaf, 0x10,
    0x0, 0x0, 0x4f, 0x90, 0x0, 0x4f, 0x80, 0x0,
    0x0, 0xaf, 0x30, 0x0, 0xe, 0xe0, 0x0, 0x1,
    0xfd, 0x0, 0x0, 0x8, 0xf4, 0x0, 0x7, 0xf7,
    0x0, 0x0, 0x2, 0xfb, 0x0, 0xd, 0xf1, 0x0,
    0x0, 0x0, 0xcf, 0x10, 0x3f, 0xc0, 0x0, 0x0,
    0x0, 0x6f, 0x70, 0x9f, 0x60, 0x0, 0x0, 0x0,
    0x1f, 0xe0, 0x34, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x40,

    /* U+57 "W" */
    0x0, 0x1, 0xff, 0x10, 0x0, 0x0, 0x3f, 0xe0,
    0x0, 0x0, 0x0, 0x5f, 0xf6, 0x0, 0x0, 0x8,
    0xff, 0x20, 0x0, 0x0, 0xa, 0xee, 0xa0, 0x0,
    0x0, 0xcc, 0xf6, 0x0, 0x0, 0x0, 0xea, 0xae,
    0x0, 0x0, 0x1f, 0x8e, 0xb0, 0x0, 0x0, 0x2f,
    0x77, 0xf3, 0x0, 0x5, 0xf4, 0xaf, 0x0, 0x0,
    0x6, 0xf3, 0x2f, 0x70, 0x0, 0x9f, 0x6, 0xf3,
    0x0, 0x0, 0xbf, 0x0, 0xec, 0x0, 0xe, 0xc0,
    0x2f, 0x80, 0x0, 0xf, 0xc0, 0x9, 0xf0, 0x2,
    0xf8, 0x0, 0xec, 0x0, 0x3, 0xf8, 0x0, 0x5f,
    0x50, 0x6f, 0x30, 0xa, 0xf1, 0x0, 0x7f, 0x40,
    0x0, 0xf9, 0xb, 0xf0, 0x0, 0x6f, 0x50, 0xc,
    0xf0, 0x0, 0xb, 0xe0, 0xfa, 0x0, 0x2, 0xf9,
    0x0, 0xfd, 0x0, 0x0, 0x7f, 0x6f, 0x60, 0x0,
    0xe, 0xe0, 0x4f, 0x90, 0x0, 0x2, 0xfe, 0xf1,
    0x0, 0x0, 0xbf, 0x29, 0xf5, 0x0, 0x0, 0xe,
    0xfd, 0x0, 0x0, 0x7, 0xf7, 0x24, 0x0, 0x0,
    0x0, 0x24, 0x20, 0x0, 0x0, 0x14, 0x20,

    /* U+58 "X" */
    0x8f, 0xb0, 0x0, 0x0, 0x0, 0x7f, 0xd0, 0xc,
    0xf7, 0x0, 0x0, 0x3, 0xff, 0x20, 0x2, 0xff,
    0x20, 0x0, 0xe, 0xf6, 0x0, 0x0, 0x5f, 0xd0,
    0x0, 0xaf, 0xb0, 0x0, 0x0, 0x9, 0xf9, 0x6,
    0xfe, 0x10, 0x0, 0x0, 0x0, 0xdf, 0x5f, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0x7d, 0xf4, 0x0, 0x0, 0x0, 0x8,
    0xfc, 0x2, 0xfe, 0x10, 0x0, 0x0, 0x4f, 0xe1,
    0x0, 0x5f, 0xc0, 0x0, 0x1, 0xef, 0x40, 0x0,
    0x9, 0xf8, 0x0, 0xb, 0xf8, 0x0, 0x0, 0x0,
    0xdf, 0x30, 0x4, 0x40, 0x0, 0x0, 0x0, 0x14,
    0x20,

    /* U+59 "Y" */
    0x0, 0x0, 0x6, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xdf, 0x80, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x1c, 0xf3, 0x0, 0x0, 0x0,
    0xc, 0xf7, 0x2, 0xfd, 0x0, 0x0, 0x0, 0x6f,
    0xd0, 0x0, 0x7f, 0x90, 0x0, 0x1, 0xff, 0x30,
    0x0, 0xc, 0xf4, 0x0, 0xc, 0xf8, 0x0, 0x0,
    0x2, 0xfe, 0x0, 0x7f, 0xd0, 0x0, 0x0, 0x0,
    0x8f, 0xa0, 0x34, 0x10, 0x0, 0x0, 0x0, 0x4,
    0x40,

    /* U+5A "Z" */
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x9f, 0xec,
    0xcc, 0xcc, 0xcc, 0xc8, 0x1e, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x70,
    0x3, 0x44, 0x44, 0x44, 0x6f, 0xf4, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0x3, 0x44, 0x44, 0x44,
    0x44, 0x41,

    /* U+5B "[" */
    0xaf, 0xff, 0x3a, 0xf8, 0x81, 0xaf, 0x10, 0xa,
    0xf1, 0x0, 0xaf, 0x10, 0xa, 0xf1, 0x0, 0xaf,
    0x10, 0xa, 0xf1, 0x0, 0xaf, 0x10, 0xa, 0xf1,
    0x0, 0xaf, 0x10, 0xa, 0xf1, 0x0, 0xaf, 0x10,
    0xa, 0xf1, 0x0, 0xaf, 0x10, 0xa, 0xf1, 0x0,
    0xaf, 0x54, 0xa, 0xff, 0xf3, 0x24, 0x44, 0x0,

    /* U+5C "\\" */
    0x0, 0x0, 0x42, 0x0, 0x1, 0xf6, 0x0, 0x6,
    0xf1, 0x0, 0xa, 0xd0, 0x0, 0xe, 0x80, 0x0,
    0x3f, 0x30, 0x0, 0x7f, 0x0, 0x0, 0xcb, 0x0,
    0x1, 0xf6, 0x0, 0x5, 0xf2, 0x0, 0x9, 0xd0,
    0x0, 0xe, 0x90, 0x0, 0x2f, 0x40, 0x0, 0x7f,
    0x0, 0x0, 0xbb, 0x0, 0x0, 0x84, 0x0, 0x0,

    /* U+5D "]" */
    0x9f, 0xff, 0x44, 0x8c, 0xf4, 0x0, 0x8f, 0x40,
    0x8, 0xf4, 0x0, 0x8f, 0x40, 0x8, 0xf4, 0x0,
    0x8f, 0x40, 0x8, 0xf4, 0x0, 0x8f, 0x40, 0x8,
    0xf4, 0x0, 0x8f, 0x40, 0x8, 0xf4, 0x0, 0x8f,
    0x40, 0x8, 0xf4, 0x0, 0x8f, 0x40, 0x8, 0xf4,
    0x24, 0xaf, 0x49, 0xff, 0xf4, 0x24, 0x44, 0x10,

    /* U+5E "^" */
    0x14, 0x10, 0x0, 0x3, 0x32, 0xfa, 0x0, 0x3,
    0xf8, 0xb, 0xf0, 0x0, 0xaf, 0x10, 0x4f, 0x70,
    0x1f, 0x90, 0x0, 0xde, 0x7, 0xf2, 0x0, 0x5,
    0xf4, 0xeb, 0x0, 0x0, 0xe, 0xef, 0x40, 0x0,
    0x0, 0x7f, 0xd0, 0x0, 0x0, 0x1, 0x84, 0x0,
    0x0,

    /* U+5F "_" */
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x51, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x41,

    /* U+60 "`" */
    0x0, 0x42, 0xa, 0xf2, 0x6f, 0xa0, 0x88, 0x20,

    /* U+61 "a" */
    0x0, 0x1, 0x31, 0x0, 0x0, 0x0, 0x4e, 0xff,
    0xfd, 0x3c, 0xf0, 0xf, 0xf7, 0x45, 0x9f, 0xfc,
    0x3, 0xfa, 0x0, 0x0, 0x8f, 0xb0, 0x2f, 0xd1,
    0x0, 0x2, 0xfb, 0x0, 0xbf, 0xd8, 0x74, 0x1f,
    0xb0, 0x0, 0x7d, 0xff, 0xfe, 0xfb, 0x0, 0x0,
    0x0, 0x13, 0x7f, 0xb0, 0x8, 0xa0, 0x0, 0x1,
    0xfb, 0x0, 0xaf, 0x60, 0x0, 0xaf, 0x80, 0x1,
    0xcf, 0xfc, 0xff, 0xe1, 0x0, 0x0, 0x47, 0x87,
    0x50, 0x0,

    /* U+62 "b" */
    0x0, 0x0, 0x22, 0x0, 0x0, 0xbf, 0x3d, 0xff,
    0xe3, 0x0, 0xbf, 0xf8, 0x47, 0xff, 0x20, 0xbf,
    0x70, 0x0, 0x3f, 0xa0, 0xbf, 0x10, 0x0, 0xc,
    0xf0, 0xbf, 0x0, 0x0, 0x9, 0xf3, 0xbf, 0x0,
    0x0, 0x8, 0xf4, 0xbf, 0x10, 0x0, 0xa, 0xf2,
    0xbf, 0x60, 0x0, 0xe, 0xf0, 0xbf, 0xe2, 0x0,
    0x9f, 0x90, 0xbf, 0x9f, 0xde, 0xfb, 0x0, 0xbf,
    0x13, 0x77, 0x40, 0x0, 0xbf, 0x10, 0x0, 0x0,
    0x0, 0xbf, 0x10, 0x0, 0x0, 0x0, 0xbf, 0x10,
    0x0, 0x0, 0x0, 0x24, 0x0, 0x0, 0x0, 0x0,

    /* U+63 "c" */
    0x0, 0x0, 0x13, 0x10, 0x0, 0x0, 0x2d, 0xff,
    0xfc, 0x20, 0x1, 0xff, 0x74, 0x8e, 0xd0, 0xa,
    0xf4, 0x0, 0x4, 0xf7, 0xf, 0xd0, 0x0, 0x0,
    0xb6, 0x1f, 0xa0, 0x0, 0x0, 0x0, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x0,
    0xd, 0xf1, 0x0, 0x3, 0xe6, 0x4, 0xfb, 0x0,
    0xb, 0xf3, 0x0, 0x7f, 0xfc, 0xdf, 0x70, 0x0,
    0x3, 0x78, 0x83, 0x0,

    /* U+64 "d" */
    0x0, 0x0, 0x12, 0x0, 0x0, 0x0, 0x3c, 0xff,
    0xd3, 0xfa, 0x3, 0xff, 0x74, 0xaf, 0xfa, 0xd,
    0xf3, 0x0, 0xa, 0xfa, 0x2f, 0xb0, 0x0, 0x2,
    0xfa, 0x4f, 0x90, 0x0, 0x0, 0xfa, 0x4f, 0x80,
    0x0, 0x0, 0xfa, 0x3f, 0x90, 0x0, 0x1, 0xfa,
    0xf, 0xe0, 0x0, 0x7, 0xfa, 0x7, 0xf9, 0x0,
    0x2e, 0xfa, 0x0, 0xbf, 0xed, 0xfb, 0xfa, 0x0,
    0x5, 0x87, 0x41, 0xfa, 0x0, 0x0, 0x0, 0x1,
    0xfa, 0x0, 0x0, 0x0, 0x1, 0xfa, 0x0, 0x0,
    0x0, 0x1, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x42,

    /* U+65 "e" */
    0x0, 0x0, 0x13, 0x10, 0x0, 0x0, 0x2, 0xdf,
    0xff, 0xe4, 0x0, 0x1, 0xff, 0x84, 0x7e, 0xf5,
    0x0, 0xaf, 0x20, 0x0, 0x2f, 0xe0, 0xf, 0xc0,
    0x0, 0x0, 0x21, 0x3, 0xfb, 0x44, 0x44, 0x44,
    0x41, 0x3f, 0xff, 0xff, 0xff, 0xff, 0x40, 0xfc,
    0x44, 0x44, 0x4b, 0xf1, 0xb, 0xe1, 0x0, 0x0,
    0xdf, 0x0, 0x4f, 0xc3, 0x0, 0x9f, 0x80, 0x0,
    0x8f, 0xfd, 0xff, 0x80, 0x0, 0x0, 0x25, 0x76,
    0x20, 0x0,

    /* U+66 "f" */
    0x4, 0xf7, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x4,
    0xf7, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x4, 0xf7,
    0x0, 0x0, 0x4f, 0x70, 0x0, 0x4, 0xf7, 0x0,
    0x0, 0x4f, 0x70, 0x0, 0x4, 0xf7, 0x0, 0xd,
    0xff, 0xff, 0x80, 0x37, 0xf9, 0x42, 0x0, 0x4f,
    0x80, 0x0, 0x3, 0xfd, 0x22, 0x0, 0xb, 0xff,
    0xf1, 0x0, 0x17, 0x88, 0x10,

    /* U+67 "g" */
    0x0, 0x0, 0x23, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xf9, 0x0, 0x8, 0xfb, 0x65, 0xaf, 0xc0, 0xe,
    0xd0, 0x0, 0x6, 0xf6, 0x2, 0x0, 0x0, 0x1,
    0xfa, 0x0, 0x19, 0xdf, 0xc2, 0xfb, 0x2, 0xef,
    0xa8, 0xdf, 0xfc, 0xb, 0xf5, 0x0, 0xb, 0xfc,
    0x1f, 0xc0, 0x0, 0x3, 0xfc, 0x3f, 0x80, 0x0,
    0x0, 0xfc, 0x5f, 0x70, 0x0, 0x0, 0xec, 0x3f,
    0x90, 0x0, 0x0, 0xfc, 0xf, 0xe0, 0x0, 0x5,
    0xfc, 0x7, 0xf9, 0x0, 0x2e, 0xfc, 0x0, 0xbf,
    0xed, 0xf7, 0xdc, 0x0, 0x5, 0x86, 0x10, 0x33,

    /* U+68 "h" */
    0xaf, 0x10, 0x0, 0xf, 0xca, 0xf1, 0x0, 0x0,
    0xfc, 0xaf, 0x10, 0x0, 0xf, 0xca, 0xf1, 0x0,
    0x0, 0xfc, 0xaf, 0x10, 0x0, 0xf, 0xca, 0xf1,
    0x0, 0x0, 0xfc, 0xaf, 0x20, 0x0, 0xf, 0xca,
    0xf6, 0x0, 0x2, 0xfb, 0xaf, 0xf3, 0x0, 0xaf,
    0x8a, 0xf9, 0xff, 0xff, 0xe1, 0xaf, 0x13, 0x67,
    0x61, 0xa, 0xf1, 0x0, 0x0, 0x0, 0xaf, 0x10,
    0x0, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x0, 0x24,
    0x0, 0x0, 0x0, 0x0,

    /* U+69 "i" */
    0xaf, 0x1a, 0xf1, 0xaf, 0x1a, 0xf1, 0xaf, 0x1a,
    0xf1, 0xaf, 0x1a, 0xf1, 0xaf, 0x1a, 0xf1, 0x24,
    0x0, 0x0, 0x8c, 0x1a, 0xf1, 0x24, 0x0,

    /* U+6A "j" */
    0x13, 0x0, 0xc, 0xff, 0x40, 0x46, 0xfd, 0x0,
    0xc, 0xf0, 0x0, 0xbf, 0x0, 0xb, 0xf1, 0x0,
    0xbf, 0x10, 0xb, 0xf1, 0x0, 0xbf, 0x10, 0xb,
    0xf1, 0x0, 0xbf, 0x10, 0xb, 0xf1, 0x0, 0xbf,
    0x10, 0xb, 0xf1, 0x0, 0xbf, 0x10, 0x2, 0x40,
    0x0, 0x0, 0x0, 0x8, 0xc0, 0x0, 0xbf, 0x10,
    0x2, 0x40,

    /* U+6B "k" */
    0xaf, 0x10, 0x0, 0x9f, 0x9a, 0xf1, 0x0, 0x3f,
    0xe0, 0xaf, 0x10, 0xd, 0xf3, 0xa, 0xf1, 0x8,
    0xf9, 0x0, 0xaf, 0x93, 0xfd, 0x0, 0xa, 0xff,
    0xff, 0x30, 0x0, 0xaf, 0xbf, 0xc0, 0x0, 0xa,
    0xf1, 0xaf, 0x90, 0x0, 0xaf, 0x10, 0x9f, 0xa0,
    0xa, 0xf1, 0x0, 0x8f, 0xb0, 0xaf, 0x10, 0x0,
    0x34, 0x1a, 0xf1, 0x0, 0x0, 0x0, 0xaf, 0x10,
    0x0, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x0, 0x24,
    0x0, 0x0, 0x0, 0x0,

    /* U+6C "l" */
    0xbf, 0xb, 0xf0, 0xbf, 0xb, 0xf0, 0xbf, 0xb,
    0xf0, 0xbf, 0xb, 0xf0, 0xbf, 0xb, 0xf0, 0xbf,
    0xb, 0xf0, 0xbf, 0xb, 0xf0, 0x35, 0x0,

    /* U+6D "m" */
    0xaf, 0x10, 0x0, 0x8f, 0x30, 0x0, 0x6f, 0x5a,
    0xf1, 0x0, 0x8, 0xf3, 0x0, 0x6, 0xf5, 0xaf,
    0x10, 0x0, 0x8f, 0x30, 0x0, 0x6f, 0x5a, 0xf1,
    0x0, 0x8, 0xf3, 0x0, 0x6, 0xf5, 0xaf, 0x10,
    0x0, 0x8f, 0x30, 0x0, 0x6f, 0x5a, 0xf1, 0x0,
    0x8, 0xf3, 0x0, 0x6, 0xf5, 0xaf, 0x20, 0x0,
    0x8f, 0x40, 0x0, 0x6f, 0x5a, 0xf6, 0x0, 0x9,
    0xf7, 0x0, 0x7, 0xf4, 0xaf, 0xe2, 0x1, 0xef,
    0xf6, 0x11, 0xdf, 0x1a, 0xeb, 0xff, 0xff, 0x83,
    0xff, 0xff, 0xa0, 0x23, 0x5, 0x78, 0x50, 0x0,
    0x47, 0x60, 0x0,

    /* U+6E "n" */
    0xaf, 0x10, 0x0, 0xf, 0xba, 0xf1, 0x0, 0x0,
    0xfb, 0xaf, 0x10, 0x0, 0xf, 0xba, 0xf1, 0x0,
    0x0, 0xfb, 0xaf, 0x10, 0x0, 0xf, 0xba, 0xf1,
    0x0, 0x0, 0xfb, 0xaf, 0x20, 0x0, 0xf, 0xba,
    0xf5, 0x0, 0x1, 0xfb, 0xaf, 0xf6, 0x10, 0x9f,
    0x7a, 0xe8, 0xff, 0xff, 0xe1, 0x23, 0x3, 0x67,
    0x60, 0x0,

    /* U+6F "o" */
    0x0, 0x0, 0x13, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xb2, 0x0, 0x2, 0xff, 0x74, 0x7f, 0xf3,
    0x0, 0xbf, 0x30, 0x0, 0x3f, 0xd0, 0x1f, 0xb0,
    0x0, 0x0, 0xbf, 0x33, 0xf8, 0x0, 0x0, 0x8,
    0xf4, 0x4f, 0x80, 0x0, 0x0, 0x7f, 0x52, 0xf9,
    0x0, 0x0, 0x9, 0xf2, 0xf, 0xe0, 0x0, 0x0,
    0xed, 0x0, 0x8f, 0xa0, 0x0, 0xaf, 0x60, 0x0,
    0x9f, 0xfc, 0xff, 0x90, 0x0, 0x0, 0x25, 0x76,
    0x20, 0x0,

    /* U+70 "p" */
    0xaf, 0x10, 0x0, 0x0, 0x0, 0xaf, 0x10, 0x0,
    0x0, 0x0, 0xaf, 0x10, 0x0, 0x0, 0x0, 0xaf,
    0x10, 0x21, 0x0, 0x0, 0xaf, 0x4d, 0xff, 0xc3,
    0x0, 0xaf, 0xfa, 0x47, 0xff, 0x30, 0xaf, 0x90,
    0x0, 0x3f, 0xb0, 0xaf, 0x20, 0x0, 0xb, 0xf1,
    0xaf, 0x0, 0x0, 0x9, 0xf3, 0xaf, 0x0, 0x0,
    0x8, 0xf4, 0xaf, 0x0, 0x0, 0xa, 0xf3, 0xaf,
    0x60, 0x0, 0xe, 0xf0, 0xaf, 0xe3, 0x0, 0x9f,
    0x70, 0xae, 0xaf, 0xce, 0xfb, 0x0, 0x23, 0x5,
    0x88, 0x50, 0x0,

    /* U+71 "q" */
    0x0, 0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x0, 0x1, 0xfb, 0x0,
    0x0, 0x22, 0x1, 0xfb, 0x0, 0x2e, 0xff, 0xd4,
    0xfb, 0x1, 0xff, 0x74, 0xaf, 0xfb, 0xa, 0xf3,
    0x0, 0x9, 0xfb, 0xf, 0xc0, 0x0, 0x2, 0xfb,
    0x3f, 0x90, 0x0, 0x0, 0xfb, 0x4f, 0x80, 0x0,
    0x0, 0xfb, 0x2f, 0xa0, 0x0, 0x1, 0xfb, 0xe,
    0xe0, 0x0, 0x6, 0xfb, 0x6, 0xf9, 0x0, 0x2e,
    0xfb, 0x0, 0xaf, 0xed, 0xf9, 0xeb, 0x0, 0x5,
    0x87, 0x40, 0x32,

    /* U+72 "r" */
    0xbf, 0x0, 0x0, 0xbf, 0x0, 0x0, 0xbf, 0x0,
    0x0, 0xbf, 0x0, 0x0, 0xbf, 0x0, 0x0, 0xbf,
    0x10, 0x0, 0xbf, 0x20, 0x0, 0xbf, 0x60, 0x0,
    0xbf, 0xe4, 0x43, 0xbe, 0xaf, 0xfb, 0x23, 0x7,
    0x83,

    /* U+73 "s" */
    0x0, 0x0, 0x22, 0x0, 0x0, 0x2, 0xbf, 0xff,
    0xe9, 0x0, 0xd, 0xfa, 0x65, 0xaf, 0xa0, 0x3f,
    0xa0, 0x0, 0xb, 0xf2, 0x2, 0x10, 0x0, 0x1d,
    0xf2, 0x0, 0x0, 0x5a, 0xff, 0xb0, 0x1, 0xbf,
    0xff, 0xc8, 0x0, 0xc, 0xfc, 0x61, 0x0, 0x0,
    0xf, 0xb0, 0x0, 0x7, 0x30, 0xe, 0xe1, 0x0,
    0x6f, 0xa0, 0x5, 0xff, 0xde, 0xfd, 0x10, 0x0,
    0x37, 0x87, 0x50, 0x0,

    /* U+74 "t" */
    0x0, 0x1, 0x20, 0x0, 0xaf, 0xf5, 0x4, 0xfe,
    0x81, 0x5, 0xf6, 0x0, 0x5, 0xf6, 0x0, 0x5,
    0xf6, 0x0, 0x5, 0xf6, 0x0, 0x5, 0xf6, 0x0,
    0x5, 0xf6, 0x0, 0x5, 0xf6, 0x0, 0xaf, 0xff,
    0xf2, 0x28, 0xf8, 0x40, 0x5, 0xf6, 0x0, 0x5,
    0xf6, 0x0, 0x0, 0x75, 0x0,

    /* U+75 "u" */
    0x0, 0x3, 0x10, 0x0, 0x0, 0x8f, 0xff, 0xc1,
    0xeb, 0x5f, 0xe8, 0x5b, 0xef, 0xba, 0xf4, 0x0,
    0x9, 0xfb, 0xbf, 0x10, 0x0, 0x2f, 0xbb, 0xf0,
    0x0, 0x1, 0xfb, 0xbf, 0x0, 0x0, 0x1f, 0xbb,
    0xf0, 0x0, 0x1, 0xfb, 0xbf, 0x0, 0x0, 0x1f,
    0xbb, 0xf0, 0x0, 0x1, 0xfb, 0xbf, 0x0, 0x0,
    0x1f, 0xb2, 0x40, 0x0, 0x0, 0x42,

    /* U+76 "v" */
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x6, 0xff,
    0x60, 0x0, 0x0, 0xc, 0xdd, 0xc0, 0x0, 0x0,
    0x2f, 0x88, 0xf2, 0x0, 0x0, 0x8f, 0x32, 0xf8,
    0x0, 0x0, 0xed, 0x0, 0xcf, 0x0, 0x4, 0xf7,
    0x0, 0x6f, 0x50, 0xb, 0xf1, 0x0, 0x1f, 0xb0,
    0x1f, 0xc0, 0x0, 0xb, 0xf1, 0x7f, 0x60, 0x0,
    0x5, 0xf7, 0x24, 0x0, 0x0, 0x0, 0x42,

    /* U+77 "w" */
    0x0, 0xe, 0xf3, 0x0, 0xe, 0xf3, 0x0, 0x0,
    0x3, 0xff, 0x70, 0x2, 0xff, 0x80, 0x0, 0x0,
    0x8f, 0xdb, 0x0, 0x7f, 0xdd, 0x0, 0x0, 0xd,
    0xc8, 0xf0, 0xb, 0xe7, 0xf1, 0x0, 0x2, 0xf8,
    0x4f, 0x30, 0xf9, 0x3f, 0x70, 0x0, 0x7f, 0x30,
    0xf8, 0x3f, 0x50, 0xec, 0x0, 0xc, 0xf0, 0xb,
    0xc7, 0xf1, 0x9, 0xf1, 0x1, 0xfa, 0x0, 0x6f,
    0xcd, 0x0, 0x4f, 0x60, 0x6f, 0x50, 0x2, 0xff,
    0x90, 0x0, 0xfb, 0xb, 0xf1, 0x0, 0xe, 0xf5,
    0x0, 0xa, 0xf0, 0x33, 0x0, 0x0, 0x24, 0x0,
    0x0, 0x14, 0x0,

    /* U+78 "x" */
    0x8f, 0x90, 0x0, 0xa, 0xf8, 0xd, 0xf4, 0x0,
    0x4f, 0xc0, 0x2, 0xfe, 0x10, 0xef, 0x20, 0x0,
    0x7f, 0xaa, 0xf6, 0x0, 0x0, 0xc, 0xff, 0xb0,
    0x0, 0x0, 0x3, 0xff, 0x20, 0x0, 0x0, 0xc,
    0xff, 0xb0, 0x0, 0x0, 0x8f, 0x78, 0xf8, 0x0,
    0x4, 0xfd, 0x0, 0xdf, 0x40, 0x1e, 0xf2, 0x0,
    0x2f, 0xe1, 0x14, 0x20, 0x0, 0x2, 0x41,

    /* U+79 "y" */
    0x0, 0x20, 0x0, 0x0, 0x0, 0xd, 0xfd, 0x20,
    0x0, 0x0, 0x9, 0x9f, 0xd0, 0x0, 0x0, 0x0,
    0x5, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xec, 0x0,
    0x0, 0x0, 0x0, 0xef, 0x20, 0x0, 0x0, 0x5,
    0xff, 0x80, 0x0, 0x0, 0xb, 0xfc, 0xe0, 0x0,
    0x0, 0x1f, 0xa7, 0xf4, 0x0, 0x0, 0x7f, 0x41,
    0xfa, 0x0, 0x0, 0xde, 0x0, 0xbf, 0x10, 0x3,
    0xf8, 0x0, 0x5f, 0x60, 0x9, 0xf3, 0x0, 0xe,
    0xc0, 0xf, 0xd0, 0x0, 0x9, 0xf2, 0x6f, 0x70,
    0x0, 0x3, 0xf8, 0x24, 0x10, 0x0, 0x0, 0x33,

    /* U+7A "z" */
    0x9f, 0xff, 0xff, 0xff, 0xf9, 0x7f, 0xe8, 0x88,
    0x88, 0x84, 0xb, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x40, 0x0, 0x0, 0x0, 0x1e, 0xf2, 0x0,
    0x0, 0x0, 0x2, 0xee, 0x10, 0x0, 0x0, 0x0,
    0x3f, 0xd0, 0x0, 0x0, 0x0, 0x5, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x90, 0x3f, 0xff, 0xff,
    0xff, 0xf3, 0x4, 0x44, 0x44, 0x44, 0x41,

    /* U+7B "{" */
    0x0, 0x0, 0x3, 0x0, 0x0, 0x7f, 0xf3, 0x0,
    0x2f, 0xb5, 0x0, 0x5, 0xf4, 0x0, 0x0, 0x6f,
    0x30, 0x0, 0x6, 0xf3, 0x0, 0x0, 0x7f, 0x20,
    0x0, 0x8, 0xf1, 0x0, 0x0, 0xdc, 0x0, 0x4,
    0xde, 0x20, 0x0, 0x7f, 0x90, 0x0, 0x0, 0x6f,
    0x90, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x7, 0xf2,
    0x0, 0x0, 0x6f, 0x30, 0x0, 0x6, 0xf3, 0x0,
    0x0, 0x6f, 0x40, 0x0, 0x4, 0xf8, 0x0, 0x0,
    0xd, 0xff, 0x30, 0x0, 0x17, 0x81,

    /* U+7C "|" */
    0x3, 0x12, 0xf5, 0x2f, 0x52, 0xf5, 0x2f, 0x52,
    0xf5, 0x2f, 0x52, 0xf5, 0x2f, 0x52, 0xf5, 0x2f,
    0x52, 0xf5, 0x2f, 0x52, 0xf5, 0x2f, 0x52, 0xf5,
    0x2f, 0x52, 0xf5, 0x2f, 0x51, 0x83,

    /* U+7D "}" */
    0x22, 0x0, 0x0, 0x8, 0xfd, 0x50, 0x0, 0x28,
    0xfc, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x8f,
    0x10, 0x0, 0x8, 0xf1, 0x0, 0x0, 0x8f, 0x10,
    0x0, 0x7, 0xf3, 0x0, 0x0, 0x3f, 0x80, 0x0,
    0x0, 0x8f, 0xb0, 0x0, 0x3, 0xdf, 0x10, 0x1,
    0xfd, 0x30, 0x0, 0x5f, 0x40, 0x0, 0x7, 0xf2,
    0x0, 0x0, 0x8f, 0x10, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0xd, 0xe0, 0x0, 0x8f,
    0xf9, 0x0, 0x4, 0x86, 0x0, 0x0,

    /* U+7E "~" */
    0x10, 0x0, 0x0, 0x48, 0x73, 0x2, 0xd6, 0x45,
    0xdf, 0xff, 0xfa, 0x1e, 0xff, 0xff, 0xd9, 0x5b,
    0xd0, 0x17, 0x87, 0x40, 0x0, 0x5,

    /* U+401 "Ё" */
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x6f, 0xdc,
    0xcc, 0xcc, 0xcc, 0xc3, 0x6f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xb8, 0x88, 0x88,
    0x88, 0x30, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x6f, 0x94, 0x44, 0x44, 0x44, 0x10, 0x6f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x94, 0x44, 0x44, 0x44, 0x30, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x14, 0x44, 0x44, 0x44,
    0x44, 0x30, 0x0, 0xb, 0xa0, 0x4c, 0x50, 0x0,
    0x0, 0xf, 0xd0, 0x5f, 0x70, 0x0, 0x0, 0x3,
    0x30, 0x14, 0x10, 0x0,

    /* U+402 "Ђ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x13, 0x30, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x20, 0x3f, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0xb, 0xf2, 0x0, 0x95, 0x7e,
    0xf7, 0x0, 0x0, 0x0, 0xbf, 0x20, 0x0, 0x0,
    0x1f, 0xf1, 0x0, 0x0, 0xb, 0xf2, 0x0, 0x0,
    0x0, 0x9f, 0x50, 0x0, 0x0, 0xbf, 0x20, 0x0,
    0x0, 0x7, 0xf7, 0x0, 0x0, 0xb, 0xf2, 0x0,
    0x0, 0x0, 0xbf, 0x40, 0x0, 0x0, 0xbf, 0x30,
    0x0, 0x0, 0x3f, 0xe0, 0x0, 0x0, 0xb, 0xff,
    0xc8, 0x88, 0x9f, 0xf4, 0x0, 0x0, 0x0, 0xbf,
    0x7b, 0xff, 0xff, 0xb2, 0x0, 0x0, 0x0, 0xb,
    0xf2, 0x0, 0x23, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x2, 0x44,
    0x44, 0xcf, 0x54, 0x44, 0x30, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x2,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x30, 0x0, 0x0,

    /* U+403 "Ѓ" */
    0x6f, 0x70, 0x0, 0x0, 0x0, 0x6f, 0x70, 0x0,
    0x0, 0x0, 0x6f, 0x70, 0x0, 0x0, 0x0, 0x6f,
    0x70, 0x0, 0x0, 0x0, 0x6f, 0x70, 0x0, 0x0,
    0x0, 0x6f, 0x70, 0x0, 0x0, 0x0, 0x6f, 0x70,
    0x0, 0x0, 0x0, 0x6f, 0x70, 0x0, 0x0, 0x0,
    0x6f, 0x70, 0x0, 0x0, 0x0, 0x6f, 0x70, 0x0,
    0x0, 0x0, 0x6f, 0x70, 0x0, 0x0, 0x0, 0x6f,
    0x70, 0x0, 0x0, 0x0, 0x6f, 0x94, 0x44, 0x44,
    0x43, 0x6f, 0xff, 0xff, 0xff, 0xfd, 0x14, 0x44,
    0x44, 0x44, 0x43, 0x0, 0x2, 0xc4, 0x0, 0x0,
    0x0, 0x0, 0xce, 0x10, 0x0, 0x0, 0x0, 0x5f,
    0xc0, 0x0,

    /* U+404 "Є" */
    0x0, 0x0, 0x0, 0x32, 0x0, 0x0, 0x0, 0x0,
    0x8e, 0xff, 0xff, 0x91, 0x0, 0x0, 0xbf, 0xc6,
    0x46, 0xcf, 0xe1, 0x0, 0x9f, 0xa0, 0x0, 0x0,
    0x7f, 0xc0, 0x2f, 0xe0, 0x0, 0x0, 0x0, 0xbf,
    0x37, 0xf7, 0x0, 0x0, 0x0, 0x5, 0xd5, 0x9f,
    0x30, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf8, 0x88,
    0x88, 0x20, 0x0, 0x0, 0xef, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0xc, 0xf6, 0x44, 0x44, 0x10, 0x0,
    0x0, 0x9f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xfa, 0x0, 0x0, 0x0, 0x9, 0xc3, 0xd, 0xf4,
    0x0, 0x0, 0x2, 0xff, 0x0, 0x3f, 0xf7, 0x20,
    0x26, 0xef, 0x60, 0x0, 0x1a, 0xff, 0xff, 0xfe,
    0x60, 0x0, 0x0, 0x2, 0x57, 0x64, 0x0, 0x0,

    /* U+405 "Ѕ" */
    0x0, 0x0, 0x0, 0x32, 0x0, 0x0, 0x0, 0x0,
    0x9e, 0xff, 0xff, 0xc3, 0x0, 0x0, 0xdf, 0xfd,
    0x99, 0xbf, 0xf3, 0x0, 0x8f, 0xc2, 0x0, 0x0,
    0x4f, 0xe0, 0xe, 0xf0, 0x0, 0x0, 0x0, 0x9f,
    0x30, 0x98, 0x0, 0x0, 0x0, 0xa, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xfe, 0x0, 0x0, 0x0,
    0x48, 0xbe, 0xff, 0x30, 0x0, 0x8, 0xff, 0xff,
    0xfa, 0x10, 0x0, 0xd, 0xff, 0xd8, 0x40, 0x0,
    0x0, 0x6, 0xfc, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x50, 0x0, 0x0, 0xb, 0x90, 0x6, 0xf8,
    0x0, 0x0, 0x5, 0xf9, 0x0, 0x1f, 0xf8, 0x20,
    0x27, 0xff, 0x20, 0x0, 0x3d, 0xff, 0xff, 0xfe,
    0x40, 0x0, 0x0, 0x2, 0x47, 0x74, 0x0, 0x0,

    /* U+406 "І" */
    0x2f, 0xc2, 0xfc, 0x2f, 0xc2, 0xfc, 0x2f, 0xc2,
    0xfc, 0x2f, 0xc2, 0xfc, 0x2f, 0xc2, 0xfc, 0x2f,
    0xc2, 0xfc, 0x2f, 0xc2, 0xfc, 0x5, 0x30,

    /* U+407 "Ї" */
    0x2, 0xfc, 0x0, 0x2, 0xfc, 0x0, 0x2, 0xfc,
    0x0, 0x2, 0xfc, 0x0, 0x2, 0xfc, 0x0, 0x2,
    0xfc, 0x0, 0x2, 0xfc, 0x0, 0x2, 0xfc, 0x0,
    0x2, 0xfc, 0x0, 0x2, 0xfc, 0x0, 0x2, 0xfc,
    0x0, 0x2, 0xfc, 0x0, 0x2, 0xfc, 0x0, 0x2,
    0xfc, 0x0, 0x0, 0x43, 0x0, 0xba, 0x3, 0xc6,
    0xfe, 0x5, 0xf8, 0x33, 0x1, 0x42,

    /* U+408 "Ј" */
    0x0, 0x1, 0x30, 0x0, 0x0, 0x3d, 0xff, 0xfb,
    0x10, 0xe, 0xfc, 0x8c, 0xfc, 0x4, 0xf9, 0x0,
    0xc, 0xf3, 0x6f, 0x60, 0x0, 0x8f, 0x50, 0x21,
    0x0, 0x7, 0xf6, 0x0, 0x0, 0x0, 0x7f, 0x70,
    0x0, 0x0, 0x7, 0xf7, 0x0, 0x0, 0x0, 0x7f,
    0x70, 0x0, 0x0, 0x7, 0xf7, 0x0, 0x0, 0x0,
    0x7f, 0x70, 0x0, 0x0, 0x7, 0xf7, 0x0, 0x0,
    0x0, 0x7f, 0x70, 0x0, 0x0, 0x7, 0xf7, 0x0,
    0x0, 0x0, 0x7f, 0x70, 0x0, 0x0, 0x1, 0x41,

    /* U+409 "Љ" */
    0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0x70, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0xfc, 0x93, 0x0, 0x6a, 0xff, 0x0,
    0x0, 0x6, 0xfc, 0x88, 0x88, 0xbf, 0xf6, 0x0,
    0xa, 0xf4, 0x0, 0x0, 0x6f, 0x80, 0x0, 0x0,
    0x2f, 0xf1, 0x0, 0x8f, 0x60, 0x0, 0x6, 0xf8,
    0x0, 0x0, 0x0, 0xbf, 0x50, 0x7, 0xf6, 0x0,
    0x0, 0x6f, 0x80, 0x0, 0x0, 0xb, 0xf5, 0x0,
    0x7f, 0x60, 0x0, 0x6, 0xf8, 0x0, 0x0, 0x2,
    0xff, 0x20, 0x7, 0xf6, 0x0, 0x0, 0x6f, 0xc8,
    0x88, 0x88, 0xff, 0xb0, 0x0, 0x7f, 0x60, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x7,
    0xf6, 0x0, 0x0, 0x6f, 0xa4, 0x44, 0x43, 0x10,
    0x0, 0x0, 0x7f, 0x60, 0x0, 0x6, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xf6, 0x0, 0x0,
    0x6f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x60, 0x0, 0x6, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xf9, 0x44, 0x44, 0x8f, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x44,
    0x44, 0x44, 0x44, 0x20, 0x0, 0x0, 0x0, 0x0,

    /* U+40A "Њ" */
    0x6f, 0x70, 0x0, 0x5, 0xff, 0xff, 0xff, 0xec,
    0x70, 0x6, 0xf7, 0x0, 0x0, 0x5f, 0xc8, 0x88,
    0x8b, 0xff, 0x80, 0x6f, 0x70, 0x0, 0x5, 0xf9,
    0x0, 0x0, 0x2, 0xff, 0x16, 0xf7, 0x0, 0x0,
    0x5f, 0x90, 0x0, 0x0, 0xa, 0xf5, 0x6f, 0x70,
    0x0, 0x5, 0xf9, 0x0, 0x0, 0x0, 0xaf, 0x66,
    0xf7, 0x0, 0x0, 0x5f, 0x90, 0x0, 0x0, 0x1e,
    0xf3, 0x6f, 0xb8, 0x88, 0x8a, 0xfc, 0x88, 0x88,
    0xbf, 0xfb, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xd7, 0x0, 0x6f, 0x94, 0x44, 0x47,
    0xfa, 0x44, 0x32, 0x0, 0x0, 0x6, 0xf7, 0x0,
    0x0, 0x5f, 0x90, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x70, 0x0, 0x5, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xf7, 0x0, 0x0, 0x5f, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x70, 0x0, 0x5, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xf7, 0x0, 0x0, 0x5f,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x14, 0x10, 0x0,
    0x1, 0x42, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+40B "Ћ" */
    0x0, 0x0, 0xb, 0xf2, 0x0, 0x0, 0x0, 0xbf,
    0x20, 0x0, 0x0, 0xbf, 0x20, 0x0, 0x0, 0xb,
    0xf2, 0x0, 0x0, 0xb, 0xf2, 0x0, 0x0, 0x0,
    0xbf, 0x20, 0x0, 0x0, 0xbf, 0x20, 0x0, 0x0,
    0xb, 0xf2, 0x0, 0x0, 0xb, 0xf2, 0x0, 0x0,
    0x0, 0xcf, 0x10, 0x0, 0x0, 0xbf, 0x20, 0x0,
    0x0, 0xe, 0xf0, 0x0, 0x0, 0xb, 0xf4, 0x0,
    0x0, 0x4, 0xfc, 0x0, 0x0, 0x0, 0xbf, 0xfd,
    0x88, 0x8d, 0xff, 0x40, 0x0, 0x0, 0xb, 0xf7,
    0xaf, 0xff, 0xfb, 0x30, 0x0, 0x0, 0x0, 0xbf,
    0x20, 0x2, 0x30, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x24, 0x44,
    0x4c, 0xf5, 0x44, 0x43, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x24,
    0x44, 0x44, 0x44, 0x44, 0x43, 0x0, 0x0, 0x0,

    /* U+40C "Ќ" */
    0x6f, 0x70, 0x0, 0x1, 0xff, 0x46, 0xf7, 0x0,
    0x0, 0xaf, 0xa0, 0x6f, 0x70, 0x0, 0x4f, 0xe1,
    0x6, 0xf7, 0x0, 0xd, 0xf6, 0x0, 0x6f, 0x70,
    0x8, 0xfc, 0x0, 0x6, 0xf7, 0x5, 0xff, 0x10,
    0x0, 0x6f, 0xa9, 0xfe, 0x40, 0x0, 0x6, 0xff,
    0xff, 0x70, 0x0, 0x0, 0x6f, 0x73, 0xbf, 0x70,
    0x0, 0x6, 0xf7, 0x1, 0xff, 0x0, 0x0, 0x6f,
    0x70, 0x9, 0xf6, 0x0, 0x6, 0xf7, 0x0, 0x2f,
    0xd0, 0x0, 0x6f, 0x70, 0x0, 0xaf, 0xb5, 0x16,
    0xf7, 0x0, 0x1, 0xcf, 0xf7, 0x14, 0x10, 0x0,
    0x0, 0x34, 0x10, 0x0, 0x8, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x50, 0x0,

    /* U+40E "Ў" */
    0x0, 0x2, 0x10, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x95, 0xaf,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xef, 0x50, 0x0, 0x0, 0x0, 0x9,
    0xf2, 0xdd, 0x0, 0x0, 0x0, 0x2, 0xf9, 0x6,
    0xf5, 0x0, 0x0, 0x0, 0xbf, 0x10, 0xe, 0xd0,
    0x0, 0x0, 0x4f, 0x80, 0x0, 0x7f, 0x50, 0x0,
    0xd, 0xf0, 0x0, 0x0, 0xfc, 0x0, 0x6, 0xf7,
    0x0, 0x0, 0x8, 0xf4, 0x0, 0xee, 0x0, 0x0,
    0x0, 0x1f, 0xc0, 0x7f, 0x60, 0x0, 0x0, 0x0,
    0x9f, 0x43, 0x40, 0x0, 0x0, 0x0, 0x1, 0x42,
    0x0, 0x0, 0x17, 0xa9, 0x40, 0x0, 0x0, 0x0,
    0xb, 0xe9, 0xaf, 0x50, 0x0, 0x0, 0x0, 0xb3,
    0x0, 0x87, 0x0, 0x0,

    /* U+40F "Џ" */
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x7f, 0xdc,
    0xcc, 0xcc, 0xcc, 0xfd, 0x7f, 0x70, 0x0, 0x0,
    0x1, 0xfd, 0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd,
    0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x7f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x7f, 0x70, 0x0, 0x0,
    0x1, 0xfd, 0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd,
    0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x7f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x7f, 0x70, 0x0, 0x0,
    0x1, 0xfd, 0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd,
    0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x7f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x14, 0x10, 0x0, 0x0,
    0x0, 0x43,

    /* U+410 "А" */
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xf, 0xf2, 0x7f,
    0x80, 0x0, 0x0, 0x0, 0x6f, 0xc0, 0x1f, 0xe0,
    0x0, 0x0, 0x0, 0xcf, 0x50, 0xa, 0xf4, 0x0,
    0x0, 0x2, 0xfe, 0x0, 0x4, 0xfe, 0xcc, 0xcc,
    0xcd, 0xf8, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x0, 0x8f, 0x40, 0x0, 0x3f, 0xb0,
    0x0, 0x0, 0x2f, 0xb0, 0x0, 0xaf, 0x40, 0x0,
    0x0, 0xc, 0xf1, 0x0, 0xfe, 0x0, 0x0, 0x0,
    0x5, 0xf7, 0x7, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xfd, 0xc, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x4f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xdf,
    0x30, 0x0, 0x0, 0x0, 0x0, 0xd, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x42, 0x0, 0x0,
    0x0,

    /* U+411 "Б" */
    0x5f, 0xff, 0xff, 0xfd, 0xb6, 0x0, 0x5f, 0xc8,
    0x88, 0x8b, 0xff, 0x70, 0x5f, 0x80, 0x0, 0x0,
    0x4f, 0xf0, 0x5f, 0x80, 0x0, 0x0, 0xb, 0xf5,
    0x5f, 0x80, 0x0, 0x0, 0xb, 0xf6, 0x5f, 0x80,
    0x0, 0x0, 0x2f, 0xf3, 0x5f, 0xc8, 0x88, 0x88,
    0xff, 0xa0, 0x5f, 0xff, 0xff, 0xff, 0xd7, 0x0,
    0x5f, 0xa4, 0x43, 0x20, 0x0, 0x0, 0x5f, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xa4, 0x44, 0x44, 0x43, 0x0, 0x5f, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x14, 0x44, 0x44, 0x44,
    0x43, 0x0,

    /* U+412 "В" */
    0x8f, 0xff, 0xff, 0xed, 0xa3, 0x0, 0x8f, 0xdc,
    0xcc, 0xcd, 0xff, 0x50, 0x8f, 0x50, 0x0, 0x0,
    0x6f, 0xe0, 0x8f, 0x50, 0x0, 0x0, 0xc, 0xf2,
    0x8f, 0x50, 0x0, 0x0, 0xb, 0xf3, 0x8f, 0x50,
    0x0, 0x0, 0x2f, 0xf1, 0x8f, 0xa8, 0x88, 0x8b,
    0xff, 0x40, 0x8f, 0xff, 0xff, 0xff, 0xe2, 0x0,
    0x8f, 0x84, 0x44, 0x69, 0xfc, 0x0, 0x8f, 0x50,
    0x0, 0x0, 0x8f, 0x50, 0x8f, 0x50, 0x0, 0x0,
    0x5f, 0x80, 0x8f, 0x50, 0x0, 0x0, 0x8f, 0x70,
    0x8f, 0x84, 0x44, 0x48, 0xfe, 0x10, 0x8f, 0xff,
    0xff, 0xff, 0xe2, 0x0, 0x24, 0x44, 0x44, 0x43,
    0x0, 0x0,

    /* U+413 "Г" */
    0x8f, 0x80, 0x0, 0x0, 0x0, 0x8f, 0x80, 0x0,
    0x0, 0x0, 0x8f, 0x80, 0x0, 0x0, 0x0, 0x8f,
    0x80, 0x0, 0x0, 0x0, 0x8f, 0x80, 0x0, 0x0,
    0x0, 0x8f, 0x80, 0x0, 0x0, 0x0, 0x8f, 0x80,
    0x0, 0x0, 0x0, 0x8f, 0x80, 0x0, 0x0, 0x0,
    0x8f, 0x80, 0x0, 0x0, 0x0, 0x8f, 0x80, 0x0,
    0x0, 0x0, 0x8f, 0x80, 0x0, 0x0, 0x0, 0x8f,
    0x80, 0x0, 0x0, 0x0, 0x8f, 0x93, 0x33, 0x33,
    0x33, 0x8f, 0xff, 0xff, 0xff, 0xfc, 0x24, 0x44,
    0x44, 0x44, 0x43,

    /* U+414 "Д" */
    0x42, 0x0, 0x0, 0x0, 0x0, 0x3, 0x3f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0xdd, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xdf, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0xdd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdc, 0xff, 0xcc, 0xcc, 0xcc, 0xdf, 0xea, 0x9,
    0xf5, 0x0, 0x0, 0x5, 0xf8, 0x0, 0x2f, 0xa0,
    0x0, 0x0, 0x5f, 0x80, 0x0, 0xee, 0x0, 0x0,
    0x5, 0xf8, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x5f,
    0x80, 0x0, 0x7f, 0x30, 0x0, 0x5, 0xf8, 0x0,
    0x6, 0xf6, 0x0, 0x0, 0x5f, 0x80, 0x0, 0x4f,
    0x70, 0x0, 0x5, 0xf8, 0x0, 0x3, 0xf8, 0x0,
    0x0, 0x5f, 0x80, 0x0, 0x3f, 0x90, 0x0, 0x5,
    0xf8, 0x0, 0x3, 0xfa, 0x0, 0x0, 0x5f, 0x80,
    0x0, 0x2f, 0xc4, 0x44, 0x48, 0xf8, 0x0, 0x2,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x4, 0x44,
    0x44, 0x44, 0x42, 0x0,

    /* U+415 "Е" */
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x6f, 0xdc,
    0xcc, 0xcc, 0xcc, 0xc3, 0x6f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xb8, 0x88, 0x88,
    0x88, 0x30, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x6f, 0x94, 0x44, 0x44, 0x44, 0x10, 0x6f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x94, 0x44, 0x44, 0x44, 0x30, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x14, 0x44, 0x44, 0x44,
    0x44, 0x30,

    /* U+416 "Ж" */
    0x9f, 0xb0, 0x0, 0x0, 0xbf, 0x30, 0x0, 0x3,
    0xff, 0x11, 0xef, 0x50, 0x0, 0xb, 0xf3, 0x0,
    0x0, 0xdf, 0x70, 0x6, 0xfe, 0x0, 0x0, 0xbf,
    0x30, 0x0, 0x7f, 0xd0, 0x0, 0xc, 0xf8, 0x0,
    0xb, 0xf3, 0x0, 0x1f, 0xf3, 0x0, 0x0, 0x2f,
    0xf4, 0x0, 0xbf, 0x30, 0xb, 0xf9, 0x0, 0x0,
    0x0, 0x6f, 0xe1, 0xb, 0xf3, 0x7, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xd7, 0xdf, 0x7a, 0xfd,
    0x20, 0x0, 0x0, 0x0, 0x1, 0xcf, 0xff, 0xff,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x72,
    0xbf, 0x44, 0xdf, 0x30, 0x0, 0x0, 0x0, 0x4f,
    0xa0, 0xb, 0xf3, 0x3, 0xfc, 0x0, 0x0, 0x0,
    0xc, 0xf3, 0x0, 0xbf, 0x30, 0xc, 0xf3, 0x0,
    0x0, 0x4, 0xfc, 0x0, 0xb, 0xf3, 0x0, 0x5f,
    0xb0, 0x0, 0x36, 0xef, 0x40, 0x0, 0xbf, 0x30,
    0x0, 0xdf, 0x94, 0x1c, 0xff, 0x80, 0x0, 0xb,
    0xf3, 0x0, 0x2, 0xef, 0xf4, 0x34, 0x20, 0x0,
    0x0, 0x24, 0x0, 0x0, 0x0, 0x34, 0x10,

    /* U+417 "З" */
    0x0, 0x0, 0x2, 0x31, 0x0, 0x0, 0x0, 0x1a,
    0xff, 0xff, 0xc3, 0x0, 0x0, 0xdf, 0xd9, 0x9d,
    0xff, 0x30, 0x8, 0xfb, 0x0, 0x0, 0x6f, 0xd0,
    0xf, 0xe0, 0x0, 0x0, 0xd, 0xf2, 0x3, 0x40,
    0x0, 0x0, 0xd, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xe0, 0x0, 0x0, 0x8, 0x89, 0xff, 0x40,
    0x0, 0x0, 0xf, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x5, 0x7b, 0xfc, 0x0, 0x2, 0x50, 0x0, 0x0,
    0xbf, 0x40, 0xe, 0xf0, 0x0, 0x0, 0x5f, 0x80,
    0x9, 0xf6, 0x0, 0x0, 0x8f, 0x60, 0x1, 0xff,
    0x92, 0x17, 0xff, 0x20, 0x0, 0x5e, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x46, 0x87, 0x20, 0x0,

    /* U+418 "И" */
    0x6f, 0xc0, 0x0, 0x0, 0x0, 0xed, 0x6f, 0xf7,
    0x0, 0x0, 0x0, 0xed, 0x6f, 0xff, 0x20, 0x0,
    0x0, 0xed, 0x6f, 0xaf, 0xd0, 0x0, 0x0, 0xed,
    0x6f, 0x4b, 0xf8, 0x0, 0x0, 0xed, 0x6f, 0x41,
    0xef, 0x20, 0x0, 0xed, 0x6f, 0x40, 0x5f, 0xd0,
    0x0, 0xed, 0x6f, 0x40, 0xa, 0xf8, 0x0, 0xed,
    0x6f, 0x40, 0x1, 0xef, 0x30, 0xed, 0x6f, 0x40,
    0x0, 0x4f, 0xe0, 0xed, 0x6f, 0x40, 0x0, 0xa,
    0xf9, 0xed, 0x6f, 0x40, 0x0, 0x0, 0xef, 0xfd,
    0x6f, 0x40, 0x0, 0x0, 0x4f, 0xfd, 0x6f, 0x40,
    0x0, 0x0, 0x9, 0xfd, 0x14, 0x10, 0x0, 0x0,
    0x0, 0x43,

    /* U+419 "Й" */
    0x6f, 0xc0, 0x0, 0x0, 0x0, 0xed, 0x6f, 0xf7,
    0x0, 0x0, 0x0, 0xed, 0x6f, 0xff, 0x20, 0x0,
    0x0, 0xed, 0x6f, 0xaf, 0xd0, 0x0, 0x0, 0xed,
    0x6f, 0x4b, 0xf8, 0x0, 0x0, 0xed, 0x6f, 0x41,
    0xef, 0x20, 0x0, 0xed, 0x6f, 0x40, 0x5f, 0xd0,
    0x0, 0xed, 0x6f, 0x40, 0xa, 0xf8, 0x0, 0xed,
    0x6f, 0x40, 0x1, 0xef, 0x30, 0xed, 0x6f, 0x40,
    0x0, 0x4f, 0xe0, 0xed, 0x6f, 0x40, 0x0, 0xa,
    0xf9, 0xed, 0x6f, 0x40, 0x0, 0x0, 0xef, 0xfd,
    0x6f, 0x40, 0x0, 0x0, 0x4f, 0xfd, 0x6f, 0x40,
    0x0, 0x0, 0x9, 0xfd, 0x14, 0x10, 0x0, 0x0,
    0x0, 0x43, 0x0, 0x0, 0x6a, 0xa6, 0x0, 0x0,
    0x0, 0x8, 0xf9, 0x9f, 0x80, 0x0, 0x0, 0x9,
    0x50, 0x5, 0x90, 0x0,

    /* U+41A "К" */
    0x6f, 0x70, 0x0, 0x1, 0xff, 0x46, 0xf7, 0x0,
    0x0, 0xaf, 0xa0, 0x6f, 0x70, 0x0, 0x4f, 0xe1,
    0x6, 0xf7, 0x0, 0xd, 0xf6, 0x0, 0x6f, 0x70,
    0x8, 0xfc, 0x0, 0x6, 0xf7, 0x5, 0xff, 0x10,
    0x0, 0x6f, 0xa9, 0xfe, 0x40, 0x0, 0x6, 0xff,
    0xff, 0x70, 0x0, 0x0, 0x6f, 0x73, 0xbf, 0x70,
    0x0, 0x6, 0xf7, 0x1, 0xff, 0x0, 0x0, 0x6f,
    0x70, 0x9, 0xf6, 0x0, 0x6, 0xf7, 0x0, 0x2f,
    0xd0, 0x0, 0x6f, 0x70, 0x0, 0xaf, 0xb5, 0x16,
    0xf7, 0x0, 0x1, 0xcf, 0xf7, 0x14, 0x10, 0x0,
    0x0, 0x34, 0x10,

    /* U+41B "Л" */
    0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf8,
    0x0, 0x0, 0x5, 0xf8, 0x6a, 0xff, 0x10, 0x0,
    0x5, 0xf8, 0x0, 0x9f, 0x50, 0x0, 0x5, 0xf8,
    0x0, 0x7f, 0x60, 0x0, 0x5, 0xf8, 0x0, 0x6f,
    0x70, 0x0, 0x5, 0xf8, 0x0, 0x6f, 0x70, 0x0,
    0x5, 0xf8, 0x0, 0x6f, 0x70, 0x0, 0x5, 0xf8,
    0x0, 0x6f, 0x70, 0x0, 0x5, 0xf8, 0x0, 0x6f,
    0x70, 0x0, 0x5, 0xf8, 0x0, 0x6f, 0x70, 0x0,
    0x5, 0xf8, 0x0, 0x6f, 0x70, 0x0, 0x5, 0xf8,
    0x0, 0x6f, 0x70, 0x0, 0x5, 0xf8, 0x0, 0x6f,
    0x94, 0x44, 0x48, 0xf8, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x14, 0x44, 0x44, 0x44, 0x42,

    /* U+41C "М" */
    0x8f, 0x40, 0x0, 0xbf, 0x50, 0x0, 0xaf, 0x28,
    0xf4, 0x0, 0x1f, 0xfa, 0x0, 0xa, 0xf2, 0x8f,
    0x40, 0x6, 0xfb, 0xf0, 0x0, 0xaf, 0x28, 0xf4,
    0x0, 0xbf, 0x1f, 0x50, 0xa, 0xf2, 0x8f, 0x40,
    0x1f, 0xa0, 0xbb, 0x0, 0xaf, 0x28, 0xf4, 0x6,
    0xf4, 0x6, 0xf1, 0xa, 0xf2, 0x8f, 0x40, 0xbf,
    0x0, 0x1f, 0x60, 0xaf, 0x28, 0xf4, 0x1f, 0x90,
    0x0, 0xbc, 0xa, 0xf2, 0x8f, 0x46, 0xf4, 0x0,
    0x6, 0xf1, 0xaf, 0x28, 0xf4, 0xce, 0x0, 0x0,
    0xf, 0x7a, 0xf2, 0x8f, 0x6f, 0x90, 0x0, 0x0,
    0xbc, 0xaf, 0x28, 0xfb, 0xf4, 0x0, 0x0, 0x5,
    0xfd, 0xf2, 0x8f, 0xfe, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x28, 0xff, 0x90, 0x0, 0x0, 0x0, 0xaf,
    0xf2, 0x24, 0x41, 0x0, 0x0, 0x0, 0x1, 0x44,
    0x0,

    /* U+41D "Н" */
    0x6f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x6f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x6f, 0x70, 0x0, 0x0,
    0x1, 0xfd, 0x6f, 0x70, 0x0, 0x0, 0x1, 0xfd,
    0x6f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x6f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x6f, 0x94, 0x44, 0x44,
    0x44, 0xfd, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x6f, 0xb8, 0x88, 0x88, 0x88, 0xfd, 0x6f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x6f, 0x70, 0x0, 0x0,
    0x1, 0xfd, 0x6f, 0x70, 0x0, 0x0, 0x1, 0xfd,
    0x6f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x6f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x14, 0x10, 0x0, 0x0,
    0x0, 0x43,

    /* U+41E "О" */
    0x0, 0x0, 0x0, 0x13, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xdf, 0xff, 0xf9, 0x20, 0x0, 0x0,
    0xa, 0xfe, 0xa8, 0xae, 0xff, 0x50, 0x0, 0x8,
    0xfa, 0x10, 0x0, 0x7, 0xff, 0x30, 0x2, 0xfd,
    0x0, 0x0, 0x0, 0x6, 0xfd, 0x0, 0x9f, 0x50,
    0x0, 0x0, 0x0, 0xc, 0xf3, 0xd, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x70, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf9, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x90, 0xdf, 0x10, 0x0, 0x0,
    0x0, 0x6, 0xf8, 0xa, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x40, 0x4f, 0xa0, 0x0, 0x0, 0x0,
    0x1f, 0xf0, 0x0, 0xbf, 0x70, 0x0, 0x0, 0xa,
    0xf7, 0x0, 0x2, 0xef, 0xc5, 0x11, 0x6d, 0xfb,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xe6, 0x0,
    0x0, 0x0, 0x0, 0x14, 0x76, 0x40, 0x0, 0x0,

    /* U+41F "П" */
    0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x7f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x7f, 0x70, 0x0, 0x0,
    0x1, 0xfd, 0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd,
    0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x7f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x7f, 0x70, 0x0, 0x0,
    0x1, 0xfd, 0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd,
    0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x7f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x7f, 0x70, 0x0, 0x0,
    0x1, 0xfd, 0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd,
    0x7f, 0x94, 0x44, 0x44, 0x44, 0xfd, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x14, 0x44, 0x44, 0x44,
    0x44, 0x43,

    /* U+420 "Р" */
    0x7f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x94,
    0x44, 0x31, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x7f, 0xb8, 0x88, 0x8b, 0xff, 0x90,
    0x7f, 0x70, 0x0, 0x0, 0x2f, 0xf2, 0x7f, 0x70,
    0x0, 0x0, 0x9, 0xf5, 0x7f, 0x70, 0x0, 0x0,
    0x9, 0xf6, 0x7f, 0x70, 0x0, 0x0, 0xd, 0xf4,
    0x7f, 0x94, 0x44, 0x47, 0xcf, 0xd0, 0x7f, 0xff,
    0xff, 0xff, 0xfb, 0x10, 0x14, 0x44, 0x44, 0x44,
    0x20, 0x0,

    /* U+421 "С" */
    0x0, 0x0, 0x1, 0x32, 0x0, 0x0, 0x0, 0x0,
    0x7e, 0xff, 0xff, 0x91, 0x0, 0x0, 0xcf, 0xeb,
    0x8a, 0xef, 0xd1, 0x0, 0xaf, 0x80, 0x0, 0x0,
    0x9f, 0xc0, 0x3f, 0xc0, 0x0, 0x0, 0x0, 0xdf,
    0x39, 0xf5, 0x0, 0x0, 0x0, 0x6, 0xc5, 0xdf,
    0x10, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x40, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xfa, 0x0, 0x0, 0x0, 0xa, 0xb2, 0xe, 0xf4,
    0x0, 0x0, 0x4, 0xfe, 0x0, 0x4f, 0xf8, 0x30,
    0x27, 0xff, 0x50, 0x0, 0x3d, 0xff, 0xff, 0xfe,
    0x50, 0x0, 0x0, 0x5, 0x87, 0x64, 0x0, 0x0,

    /* U+422 "Т" */
    0x0, 0x0, 0xd, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xf1, 0x0, 0x0,
    0x24, 0x44, 0x4d, 0xf4, 0x44, 0x43, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x24, 0x44, 0x44, 0x44,
    0x44, 0x43,

    /* U+423 "У" */
    0x0, 0x2, 0x10, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x95, 0xaf,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xef, 0x50, 0x0, 0x0, 0x0, 0x9,
    0xf2, 0xdd, 0x0, 0x0, 0x0, 0x2, 0xf9, 0x6,
    0xf5, 0x0, 0x0, 0x0, 0xbf, 0x10, 0xe, 0xd0,
    0x0, 0x0, 0x4f, 0x80, 0x0, 0x7f, 0x50, 0x0,
    0xd, 0xf0, 0x0, 0x0, 0xfc, 0x0, 0x6, 0xf7,
    0x0, 0x0, 0x8, 0xf4, 0x0, 0xee, 0x0, 0x0,
    0x0, 0x1f, 0xc0, 0x7f, 0x60, 0x0, 0x0, 0x0,
    0x9f, 0x43, 0x40, 0x0, 0x0, 0x0, 0x1, 0x42,

    /* U+424 "Ф" */
    0x0, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xbf, 0xff, 0xff, 0xd7, 0x0, 0x0, 0x6,
    0xff, 0xba, 0xfc, 0xae, 0xfb, 0x0, 0x3, 0xfd,
    0x10, 0x4f, 0x70, 0xa, 0xf8, 0x0, 0xdf, 0x30,
    0x4, 0xf7, 0x0, 0x1e, 0xf0, 0xf, 0xe0, 0x0,
    0x4f, 0x70, 0x0, 0xbf, 0x32, 0xfd, 0x0, 0x4,
    0xf7, 0x0, 0x9, 0xf5, 0xf, 0xf0, 0x0, 0x4f,
    0x70, 0x0, 0xcf, 0x20, 0x8f, 0x80, 0x4, 0xf7,
    0x0, 0x4f, 0xb0, 0x0, 0xdf, 0x93, 0x5f, 0x82,
    0x7f, 0xf2, 0x0, 0x1, 0x8f, 0xff, 0xff, 0xff,
    0xd3, 0x0, 0x0, 0x0, 0x3, 0x9f, 0xb6, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x28, 0x30, 0x0, 0x0,
    0x0,

    /* U+425 "Х" */
    0x8f, 0xb0, 0x0, 0x0, 0x0, 0x7f, 0xd0, 0xc,
    0xf7, 0x0, 0x0, 0x3, 0xff, 0x20, 0x2, 0xff,
    0x20, 0x0, 0xe, 0xf6, 0x0, 0x0, 0x5f, 0xd0,
    0x0, 0xaf, 0xb0, 0x0, 0x0, 0x9, 0xf9, 0x6,
    0xfe, 0x10, 0x0, 0x0, 0x0, 0xdf, 0x5f, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0x7d, 0xf4, 0x0, 0x0, 0x0, 0x8,
    0xfc, 0x2, 0xfe, 0x10, 0x0, 0x0, 0x4f, 0xe1,
    0x0, 0x5f, 0xc0, 0x0, 0x1, 0xef, 0x40, 0x0,
    0x9, 0xf8, 0x0, 0xb, 0xf8, 0x0, 0x0, 0x0,
    0xdf, 0x30, 0x4, 0x40, 0x0, 0x0, 0x0, 0x14,
    0x20,

    /* U+426 "Ц" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xf1, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x7f, 0xdc, 0xcc, 0xcc, 0xcc,
    0xff, 0xc1, 0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd,
    0x0, 0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x0,
    0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x0, 0x7f,
    0x70, 0x0, 0x0, 0x1, 0xfd, 0x0, 0x7f, 0x70,
    0x0, 0x0, 0x1, 0xfd, 0x0, 0x7f, 0x70, 0x0,
    0x0, 0x1, 0xfd, 0x0, 0x7f, 0x70, 0x0, 0x0,
    0x1, 0xfd, 0x0, 0x7f, 0x70, 0x0, 0x0, 0x1,
    0xfd, 0x0, 0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd,
    0x0, 0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x0,
    0x7f, 0x70, 0x0, 0x0, 0x1, 0xfd, 0x0, 0x7f,
    0x70, 0x0, 0x0, 0x1, 0xfd, 0x0, 0x14, 0x10,
    0x0, 0x0, 0x0, 0x43, 0x0,

    /* U+427 "Ч" */
    0x0, 0x0, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x2, 0xfc,
    0x0, 0x0, 0x13, 0x10, 0x2, 0xfc, 0x0, 0x4d,
    0xff, 0xff, 0xa7, 0xfc, 0x5, 0xff, 0xc8, 0x9b,
    0xef, 0xfc, 0xd, 0xf8, 0x0, 0x0, 0x4, 0xfc,
    0xf, 0xf0, 0x0, 0x0, 0x2, 0xfc, 0x2f, 0xd0,
    0x0, 0x0, 0x2, 0xfc, 0x2f, 0xb0, 0x0, 0x0,
    0x2, 0xfc, 0x2f, 0xb0, 0x0, 0x0, 0x2, 0xfc,
    0x2f, 0xb0, 0x0, 0x0, 0x2, 0xfc, 0x2f, 0xb0,
    0x0, 0x0, 0x2, 0xfc, 0x4, 0x20, 0x0, 0x0,
    0x0, 0x43,

    /* U+428 "Ш" */
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x6f, 0xdc, 0xcc, 0xcf, 0xfc, 0xcc, 0xcc, 0xfc,
    0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc,
    0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc,
    0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc,
    0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc,
    0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc,
    0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc,
    0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc,
    0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc,
    0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc,
    0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc,
    0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc,
    0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc,
    0x14, 0x10, 0x0, 0x3, 0x40, 0x0, 0x0, 0x43,

    /* U+429 "Щ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf1, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x6f, 0xdc, 0xcc,
    0xcf, 0xfc, 0xcc, 0xcc, 0xff, 0xc0, 0x6f, 0x70,
    0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc, 0x0, 0x6f,
    0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc, 0x0,
    0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc,
    0x0, 0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2,
    0xfc, 0x0, 0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0,
    0x2, 0xfc, 0x0, 0x6f, 0x70, 0x0, 0xc, 0xf1,
    0x0, 0x2, 0xfc, 0x0, 0x6f, 0x70, 0x0, 0xc,
    0xf1, 0x0, 0x2, 0xfc, 0x0, 0x6f, 0x70, 0x0,
    0xc, 0xf1, 0x0, 0x2, 0xfc, 0x0, 0x6f, 0x70,
    0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc, 0x0, 0x6f,
    0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc, 0x0,
    0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2, 0xfc,
    0x0, 0x6f, 0x70, 0x0, 0xc, 0xf1, 0x0, 0x2,
    0xfc, 0x0, 0x14, 0x10, 0x0, 0x3, 0x40, 0x0,
    0x0, 0x43, 0x0,

    /* U+42A "Ъ" */
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xed, 0x91, 0x0,
    0x0, 0x0, 0xaf, 0xa8, 0x88, 0xad, 0xfe, 0x20,
    0x0, 0x0, 0xaf, 0x40, 0x0, 0x0, 0x8f, 0xc0,
    0x0, 0x0, 0xaf, 0x40, 0x0, 0x0, 0xf, 0xf0,
    0x0, 0x0, 0xaf, 0x40, 0x0, 0x0, 0xf, 0xf1,
    0x0, 0x0, 0xaf, 0x40, 0x0, 0x0, 0x7f, 0xe0,
    0x0, 0x0, 0xaf, 0xa8, 0x88, 0x8a, 0xff, 0x60,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xe5, 0x0,
    0x0, 0x0, 0xaf, 0x74, 0x43, 0x21, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x44, 0x44, 0xbf, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x44, 0x44, 0x44, 0x10, 0x0, 0x0, 0x0, 0x0,

    /* U+42B "Ы" */
    0x5f, 0xff, 0xff, 0xfd, 0xb3, 0x0, 0xd, 0xf0,
    0x5f, 0xc8, 0x88, 0x9c, 0xff, 0x60, 0xd, 0xf0,
    0x5f, 0x80, 0x0, 0x0, 0x4f, 0xf1, 0xd, 0xf0,
    0x5f, 0x80, 0x0, 0x0, 0xb, 0xf4, 0xd, 0xf0,
    0x5f, 0x80, 0x0, 0x0, 0xa, 0xf6, 0xd, 0xf0,
    0x5f, 0x80, 0x0, 0x0, 0x1f, 0xf3, 0xd, 0xf0,
    0x5f, 0xc8, 0x88, 0x88, 0xdf, 0xb0, 0xd, 0xf0,
    0x5f, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xd, 0xf0,
    0x5f, 0xa4, 0x43, 0x31, 0x0, 0x0, 0xd, 0xf0,
    0x5f, 0x80, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf0,
    0x5f, 0x80, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf0,
    0x5f, 0x80, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf0,
    0x5f, 0x80, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf0,
    0x5f, 0x80, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf0,
    0x14, 0x20, 0x0, 0x0, 0x0, 0x0, 0x3, 0x40,

    /* U+42C "Ь" */
    0x6f, 0xff, 0xff, 0xfd, 0xb3, 0x0, 0x6f, 0xc8,
    0x88, 0x9b, 0xff, 0x60, 0x6f, 0x80, 0x0, 0x0,
    0x3f, 0xf1, 0x6f, 0x80, 0x0, 0x0, 0xb, 0xf4,
    0x6f, 0x80, 0x0, 0x0, 0xb, 0xf5, 0x6f, 0x80,
    0x0, 0x0, 0x3f, 0xf3, 0x6f, 0xc8, 0x88, 0x88,
    0xff, 0xb0, 0x6f, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x6f, 0xa4, 0x44, 0x44, 0x10, 0x0, 0x6f, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x14, 0x20, 0x0, 0x0,
    0x0, 0x0,

    /* U+42D "Э" */
    0x0, 0x0, 0x1, 0x31, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xef, 0xff, 0xfb, 0x10, 0x0, 0x0, 0x9f,
    0xe7, 0x45, 0x8f, 0xe3, 0x0, 0x6, 0xfc, 0x10,
    0x0, 0x5, 0xfe, 0x0, 0xd, 0xf1, 0x0, 0x0,
    0x0, 0x9f, 0x70, 0x1b, 0xa0, 0x0, 0x0, 0x0,
    0x1f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xf0, 0x0, 0x0, 0x0, 0x78, 0x88, 0x8d, 0xf2,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x34, 0x44, 0x4d, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xf0, 0xa, 0xd0, 0x0,
    0x0, 0x0, 0x4f, 0xa0, 0xa, 0xf8, 0x0, 0x0,
    0x0, 0xef, 0x30, 0x2, 0xef, 0x93, 0x1, 0x4e,
    0xf8, 0x0, 0x0, 0x2c, 0xff, 0xff, 0xfd, 0x50,
    0x0, 0x0, 0x0, 0x25, 0x76, 0x30, 0x0, 0x0,

    /* U+42E "Ю" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x10, 0x0,
    0x0, 0x6, 0xf7, 0x0, 0x0, 0x3, 0xcf, 0xff,
    0xe9, 0x0, 0x0, 0x6f, 0x70, 0x0, 0x9, 0xff,
    0xd9, 0xbf, 0xfd, 0x20, 0x6, 0xf7, 0x0, 0x5,
    0xfe, 0x30, 0x0, 0x1a, 0xfc, 0x0, 0x6f, 0x70,
    0x1, 0xff, 0x20, 0x0, 0x0, 0xb, 0xf5, 0x6,
    0xf7, 0x0, 0x7f, 0x90, 0x0, 0x0, 0x0, 0x3f,
    0xb0, 0x6f, 0x70, 0x9, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0xfe, 0x6, 0xfd, 0xcc, 0xef, 0x30, 0x0,
    0x0, 0x0, 0xd, 0xf0, 0x6f, 0xff, 0xff, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x26, 0xf7, 0x0,
    0xaf, 0x50, 0x0, 0x0, 0x0, 0xe, 0xf0, 0x6f,
    0x70, 0x6, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xfd,
    0x6, 0xf7, 0x0, 0x3f, 0xf0, 0x0, 0x0, 0x0,
    0x6f, 0x70, 0x6f, 0x70, 0x0, 0xbf, 0x70, 0x0,
    0x0, 0x1e, 0xe0, 0x6, 0xf7, 0x0, 0x1, 0xdf,
    0x82, 0x1, 0x4e, 0xf4, 0x0, 0x6f, 0x70, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xd2, 0x0, 0x1, 0x41,
    0x0, 0x0, 0x0, 0x4, 0x75, 0x20, 0x0, 0x0,

    /* U+42F "Я" */
    0x6f, 0xe0, 0x0, 0x0, 0x0, 0xf, 0xd0, 0xdf,
    0x90, 0x0, 0x0, 0x0, 0xfd, 0x3, 0xff, 0x30,
    0x0, 0x0, 0xf, 0xd0, 0x9, 0xfd, 0x0, 0x0,
    0x0, 0xfd, 0x0, 0xd, 0xf7, 0x0, 0x0, 0xf,
    0xd0, 0x0, 0x1d, 0xf6, 0x0, 0x0, 0xfd, 0x0,
    0x0, 0x3e, 0xfc, 0xcc, 0xcf, 0xd0, 0x4, 0xef,
    0xff, 0xff, 0xff, 0xfd, 0x1, 0xff, 0x62, 0x0,
    0x0, 0xf, 0xd0, 0x6f, 0xa0, 0x0, 0x0, 0x0,
    0xfd, 0x8, 0xf6, 0x0, 0x0, 0x0, 0xf, 0xd0,
    0x7f, 0xa0, 0x0, 0x0, 0x0, 0xfd, 0x0, 0xef,
    0xc6, 0x44, 0x44, 0x4f, 0xd0, 0x2, 0xdf, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0x34, 0x44, 0x44,
    0x44, 0x30,

    /* U+430 "а" */
    0x0, 0x1, 0x31, 0x0, 0x0, 0x0, 0x4e, 0xff,
    0xfd, 0x3c, 0xf0, 0xf, 0xf7, 0x45, 0x9f, 0xfc,
    0x3, 0xfa, 0x0, 0x0, 0x8f, 0xb0, 0x2f, 0xd1,
    0x0, 0x2, 0xfb, 0x0, 0xbf, 0xd8, 0x74, 0x1f,
    0xb0, 0x0, 0x7d, 0xff, 0xfe, 0xfb, 0x0, 0x0,
    0x0, 0x13, 0x7f, 0xb0, 0x8, 0xa0, 0x0, 0x1,
    0xfb, 0x0, 0xaf, 0x60, 0x0, 0xaf, 0x80, 0x1,
    0xcf, 0xfc, 0xff, 0xe1, 0x0, 0x0, 0x47, 0x87,
    0x50, 0x0,

    /* U+431 "б" */
    0x0, 0x0, 0x3, 0x20, 0x0, 0x0, 0x1, 0xaf,
    0xff, 0xe5, 0x0, 0x0, 0xdf, 0xa5, 0x6c, 0xf6,
    0x0, 0x6f, 0xa0, 0x0, 0xd, 0xf1, 0xb, 0xf2,
    0x0, 0x0, 0x6f, 0x70, 0xff, 0x0, 0x0, 0x4,
    0xf9, 0xf, 0xe0, 0x0, 0x0, 0x3f, 0x91, 0xff,
    0x0, 0x0, 0x5, 0xf7, 0x1f, 0xf8, 0x0, 0x0,
    0xbf, 0x20, 0xfe, 0xf9, 0x21, 0x8f, 0x90, 0xe,
    0x79, 0xff, 0xff, 0x80, 0x0, 0xcb, 0x2, 0x32,
    0x0, 0x0, 0x7, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xfd, 0xb8, 0x65, 0x10, 0x0, 0x2b, 0xff,
    0xff, 0xff, 0x20, 0x0, 0x0, 0x23, 0x58, 0xc4,

    /* U+432 "в" */
    0xaf, 0xff, 0xff, 0xb5, 0xa, 0xf8, 0x88, 0xad,
    0xf4, 0xaf, 0x10, 0x0, 0x1f, 0xba, 0xf1, 0x0,
    0x1, 0xfc, 0xaf, 0x88, 0x88, 0xdf, 0x4a, 0xff,
    0xff, 0xff, 0x70, 0xaf, 0x10, 0x1, 0xcf, 0x2a,
    0xf1, 0x0, 0x7, 0xf5, 0xaf, 0x10, 0x15, 0xdf,
    0x1a, 0xff, 0xff, 0xff, 0x80, 0x24, 0x44, 0x43,
    0x0, 0x0,

    /* U+433 "г" */
    0xcf, 0x0, 0x0, 0xc, 0xf0, 0x0, 0x0, 0xcf,
    0x0, 0x0, 0xc, 0xf0, 0x0, 0x0, 0xcf, 0x0,
    0x0, 0xc, 0xf0, 0x0, 0x0, 0xcf, 0x0, 0x0,
    0xc, 0xf0, 0x0, 0x0, 0xcf, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xf4, 0x34, 0x44, 0x44, 0x10,

    /* U+434 "д" */
    0xf7, 0x0, 0x0, 0x0, 0x6, 0xf0, 0xf7, 0x0,
    0x0, 0x0, 0x6, 0xf0, 0xf7, 0x0, 0x0, 0x0,
    0x6, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x8f, 0xd8, 0x88, 0x88, 0xef, 0x80, 0x8, 0xe0,
    0x0, 0x0, 0xde, 0x0, 0x1, 0xf4, 0x0, 0x0,
    0xde, 0x0, 0x0, 0xda, 0x0, 0x0, 0xde, 0x0,
    0x0, 0xad, 0x0, 0x0, 0xde, 0x0, 0x0, 0x8f,
    0x0, 0x0, 0xde, 0x0, 0x0, 0x6f, 0x0, 0x0,
    0xde, 0x0, 0x0, 0x5f, 0x10, 0x0, 0xde, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x14,
    0x44, 0x44, 0x43, 0x0,

    /* U+435 "е" */
    0x0, 0x0, 0x13, 0x10, 0x0, 0x0, 0x2, 0xdf,
    0xff, 0xe4, 0x0, 0x1, 0xff, 0x84, 0x7e, 0xf5,
    0x0, 0xaf, 0x20, 0x0, 0x2f, 0xe0, 0xf, 0xc0,
    0x0, 0x0, 0x21, 0x3, 0xfb, 0x44, 0x44, 0x44,
    0x41, 0x3f, 0xff, 0xff, 0xff, 0xff, 0x40, 0xfc,
    0x44, 0x44, 0x4b, 0xf1, 0xb, 0xe1, 0x0, 0x0,
    0xdf, 0x0, 0x4f, 0xc3, 0x0, 0x9f, 0x80, 0x0,
    0x8f, 0xfd, 0xff, 0x80, 0x0, 0x0, 0x25, 0x76,
    0x20, 0x0,

    /* U+436 "ж" */
    0xcf, 0x20, 0x3, 0xf9, 0x0, 0xc, 0xf2, 0x2f,
    0xc0, 0x3, 0xf9, 0x0, 0x5f, 0x80, 0x9, 0xf5,
    0x3, 0xf9, 0x0, 0xee, 0x0, 0x0, 0xee, 0x3,
    0xf9, 0x9, 0xf4, 0x0, 0x0, 0x3f, 0xc6, 0xfb,
    0x7f, 0x80, 0x0, 0x0, 0x5, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x3f, 0x84, 0xf9, 0x3f, 0x90,
    0x0, 0x0, 0xae, 0x3, 0xf9, 0x8, 0xf1, 0x0,
    0x3, 0xf6, 0x3, 0xf9, 0x0, 0xf8, 0x0, 0xaf,
    0xd0, 0x3, 0xf9, 0x0, 0x7f, 0xf0, 0x24, 0x0,
    0x0, 0x42, 0x0, 0x3, 0x40,

    /* U+437 "з" */
    0x0, 0x1, 0x31, 0x0, 0x0, 0x3c, 0xff, 0xfd,
    0x30, 0xe, 0xf9, 0x58, 0xfe, 0x15, 0xf8, 0x0,
    0x6, 0xf5, 0x2, 0x0, 0x0, 0x7f, 0x60, 0x0,
    0x15, 0x8f, 0xe1, 0x0, 0x6, 0xff, 0xf2, 0x0,
    0x0, 0x2, 0x6f, 0xb0, 0x5, 0x40, 0x0, 0xcf,
    0x0, 0xef, 0x30, 0x2f, 0xe0, 0x4, 0xff, 0xdf,
    0xf5, 0x0, 0x2, 0x78, 0x83, 0x0,

    /* U+438 "и" */
    0xaf, 0x80, 0x0, 0xe, 0xda, 0xff, 0x20, 0x0,
    0xed, 0xaf, 0xec, 0x0, 0xe, 0xda, 0xf5, 0xf6,
    0x0, 0xed, 0xaf, 0x1a, 0xf1, 0xe, 0xda, 0xf1,
    0x1f, 0xa0, 0xed, 0xaf, 0x10, 0x6f, 0x4e, 0xda,
    0xf1, 0x0, 0xce, 0xfd, 0xaf, 0x10, 0x2, 0xff,
    0xda, 0xf1, 0x0, 0x8, 0xfd, 0x24, 0x0, 0x0,
    0x4, 0x30,

    /* U+439 "й" */
    0xaf, 0x80, 0x0, 0xe, 0xda, 0xff, 0x20, 0x0,
    0xed, 0xaf, 0xec, 0x0, 0xe, 0xda, 0xf5, 0xf6,
    0x0, 0xed, 0xaf, 0x1a, 0xf1, 0xe, 0xda, 0xf1,
    0x1f, 0xa0, 0xed, 0xaf, 0x10, 0x6f, 0x4e, 0xda,
    0xf1, 0x0, 0xce, 0xfd, 0xaf, 0x10, 0x2, 0xff,
    0xda, 0xf1, 0x0, 0x8, 0xfd, 0x24, 0x0, 0x0,
    0x4, 0x30, 0x0, 0x2, 0x10, 0x0, 0x0, 0x3e,
    0xff, 0x90, 0x0, 0xe, 0x70, 0x3e, 0x60, 0x0,
    0x40, 0x0, 0x22, 0x0,

    /* U+43A "к" */
    0xbf, 0x10, 0x5, 0xf9, 0xbf, 0x10, 0xe, 0xe1,
    0xbf, 0x10, 0x7f, 0x60, 0xbf, 0x12, 0xfc, 0x0,
    0xbf, 0x5d, 0xe1, 0x0, 0xbf, 0xff, 0x50, 0x0,
    0xbf, 0x2a, 0xf1, 0x0, 0xbf, 0x11, 0xf8, 0x0,
    0xbf, 0x10, 0x8f, 0x10, 0xbf, 0x10, 0x1e, 0xf8,
    0x24, 0x0, 0x1, 0x42,

    /* U+43B "л" */
    0xcf, 0xd5, 0x0, 0x0, 0x6f, 0x56, 0x8f, 0xd0,
    0x0, 0x6, 0xf5, 0x0, 0xde, 0x0, 0x0, 0x6f,
    0x50, 0xd, 0xe0, 0x0, 0x6, 0xf5, 0x0, 0xde,
    0x0, 0x0, 0x6f, 0x50, 0xd, 0xe0, 0x0, 0x6,
    0xf5, 0x0, 0xde, 0x0, 0x0, 0x6f, 0x50, 0xd,
    0xe0, 0x0, 0x6, 0xf5, 0x0, 0xde, 0x0, 0x0,
    0x6f, 0x50, 0xd, 0xff, 0xff, 0xff, 0xf5, 0x0,
    0x34, 0x44, 0x44, 0x44, 0x10,

    /* U+43C "м" */
    0xaf, 0x10, 0x2f, 0xb0, 0x6, 0xf6, 0xaf, 0x10,
    0x8f, 0xf1, 0x6, 0xf6, 0xaf, 0x10, 0xdb, 0xf7,
    0x6, 0xf6, 0xaf, 0x12, 0xf5, 0xad, 0x6, 0xf6,
    0xaf, 0x18, 0xf0, 0x4f, 0x36, 0xf6, 0xaf, 0x1d,
    0xa0, 0xe, 0x96, 0xf6, 0xaf, 0x4f, 0x50, 0x8,
    0xf6, 0xf6, 0xaf, 0x9f, 0x0, 0x2, 0xfb, 0xf6,
    0xaf, 0xea, 0x0, 0x0, 0xcf, 0xf6, 0xaf, 0xf5,
    0x0, 0x0, 0x6f, 0xf6, 0x24, 0x40, 0x0, 0x0,
    0x4, 0x41,

    /* U+43D "н" */
    0xaf, 0x10, 0x0, 0xf, 0xba, 0xf1, 0x0, 0x0,
    0xfb, 0xaf, 0x10, 0x0, 0xf, 0xba, 0xf1, 0x0,
    0x0, 0xfb, 0xaf, 0x88, 0x88, 0x8f, 0xba, 0xff,
    0xff, 0xff, 0xfb, 0xaf, 0x10, 0x0, 0xf, 0xba,
    0xf1, 0x0, 0x0, 0xfb, 0xaf, 0x10, 0x0, 0xf,
    0xba, 0xf1, 0x0, 0x0, 0xfb, 0x24, 0x0, 0x0,
    0x4, 0x20,

    /* U+43E "о" */
    0x0, 0x0, 0x13, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xb2, 0x0, 0x2, 0xff, 0x74, 0x7f, 0xf3,
    0x0, 0xbf, 0x30, 0x0, 0x3f, 0xd0, 0x1f, 0xb0,
    0x0, 0x0, 0xbf, 0x33, 0xf8, 0x0, 0x0, 0x8,
    0xf4, 0x4f, 0x80, 0x0, 0x0, 0x7f, 0x52, 0xf9,
    0x0, 0x0, 0x9, 0xf2, 0xf, 0xe0, 0x0, 0x0,
    0xed, 0x0, 0x8f, 0xa0, 0x0, 0xaf, 0x60, 0x0,
    0x9f, 0xfc, 0xff, 0x90, 0x0, 0x0, 0x25, 0x76,
    0x20, 0x0,

    /* U+43F "п" */
    0xaf, 0x10, 0x0, 0x3f, 0x8a, 0xf1, 0x0, 0x3,
    0xf8, 0xaf, 0x10, 0x0, 0x3f, 0x8a, 0xf1, 0x0,
    0x3, 0xf8, 0xaf, 0x10, 0x0, 0x3f, 0x8a, 0xf1,
    0x0, 0x3, 0xf8, 0xaf, 0x10, 0x0, 0x3f, 0x8a,
    0xf1, 0x0, 0x3, 0xf8, 0xaf, 0x10, 0x0, 0x3f,
    0x8a, 0xff, 0xff, 0xff, 0xf8, 0x24, 0x44, 0x44,
    0x44, 0x20,

    /* U+440 "р" */
    0xaf, 0x10, 0x0, 0x0, 0x0, 0xaf, 0x10, 0x0,
    0x0, 0x0, 0xaf, 0x10, 0x0, 0x0, 0x0, 0xaf,
    0x10, 0x21, 0x0, 0x0, 0xaf, 0x4d, 0xff, 0xc3,
    0x0, 0xaf, 0xfa, 0x47, 0xff, 0x30, 0xaf, 0x90,
    0x0, 0x3f, 0xb0, 0xaf, 0x20, 0x0, 0xb, 0xf1,
    0xaf, 0x0, 0x0, 0x9, 0xf3, 0xaf, 0x0, 0x0,
    0x8, 0xf4, 0xaf, 0x0, 0x0, 0xa, 0xf3, 0xaf,
    0x60, 0x0, 0xe, 0xf0, 0xaf, 0xe3, 0x0, 0x9f,
    0x70, 0xae, 0xaf, 0xce, 0xfb, 0x0, 0x23, 0x5,
    0x88, 0x50, 0x0,

    /* U+441 "с" */
    0x0, 0x0, 0x13, 0x10, 0x0, 0x0, 0x2d, 0xff,
    0xfc, 0x20, 0x1, 0xff, 0x74, 0x8e, 0xd0, 0xa,
    0xf4, 0x0, 0x4, 0xf7, 0xf, 0xd0, 0x0, 0x0,
    0xb6, 0x1f, 0xa0, 0x0, 0x0, 0x0, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x0,
    0xd, 0xf1, 0x0, 0x3, 0xe6, 0x4, 0xfb, 0x0,
    0xb, 0xf3, 0x0, 0x7f, 0xfc, 0xdf, 0x70, 0x0,
    0x3, 0x78, 0x83, 0x0,

    /* U+442 "т" */
    0x0, 0x4, 0xf7, 0x0, 0x0, 0x0, 0x4f, 0x70,
    0x0, 0x0, 0x4, 0xf7, 0x0, 0x0, 0x0, 0x4f,
    0x70, 0x0, 0x0, 0x4, 0xf7, 0x0, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x0, 0x4, 0xf7, 0x0, 0x0,
    0x0, 0x4f, 0x70, 0x0, 0x0, 0x4, 0xf7, 0x0,
    0xa, 0xff, 0xff, 0xff, 0xfc, 0x24, 0x44, 0x44,
    0x44, 0x30,

    /* U+443 "у" */
    0x0, 0x20, 0x0, 0x0, 0x0, 0xd, 0xfd, 0x20,
    0x0, 0x0, 0x9, 0x9f, 0xd0, 0x0, 0x0, 0x0,
    0x5, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xec, 0x0,
    0x0, 0x0, 0x0, 0xef, 0x20, 0x0, 0x0, 0x5,
    0xff, 0x80, 0x0, 0x0, 0xb, 0xfc, 0xe0, 0x0,
    0x0, 0x1f, 0xa7, 0xf4, 0x0, 0x0, 0x7f, 0x41,
    0xfa, 0x0, 0x0, 0xde, 0x0, 0xbf, 0x10, 0x3,
    0xf8, 0x0, 0x5f, 0x60, 0x9, 0xf3, 0x0, 0xe,
    0xc0, 0xf, 0xd0, 0x0, 0x9, 0xf2, 0x6f, 0x70,
    0x0, 0x3, 0xf8, 0x24, 0x10, 0x0, 0x0, 0x33,

    /* U+444 "ф" */
    0x0, 0x0, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x31, 0xa, 0xf1, 0x3, 0x10, 0x0,
    0x0, 0x4f, 0xff, 0xdb, 0xf7, 0xff, 0xfb, 0x0,
    0x2, 0xfe, 0x65, 0xdf, 0xff, 0x85, 0xaf, 0xa0,
    0xb, 0xf2, 0x0, 0x2f, 0xf8, 0x0, 0xb, 0xf2,
    0xf, 0xb0, 0x0, 0xc, 0xf4, 0x0, 0x4, 0xf7,
    0x2f, 0x90, 0x0, 0xa, 0xf2, 0x0, 0x2, 0xf9,
    0x3f, 0x80, 0x0, 0xa, 0xf2, 0x0, 0x1, 0xfa,
    0x1f, 0xa0, 0x0, 0xc, 0xf3, 0x0, 0x3, 0xf8,
    0xd, 0xe0, 0x0, 0xf, 0xf6, 0x0, 0x7, 0xf4,
    0x6, 0xf7, 0x0, 0x8f, 0xfd, 0x10, 0x2e, 0xd0,
    0x0, 0xaf, 0xde, 0xec, 0xfa, 0xfc, 0xfe, 0x30,
    0x0, 0x4, 0x77, 0x1a, 0xf1, 0x47, 0x62, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x40, 0x0, 0x0, 0x0,

    /* U+445 "х" */
    0x8f, 0x90, 0x0, 0xa, 0xf8, 0xd, 0xf4, 0x0,
    0x4f, 0xc0, 0x2, 0xfe, 0x10, 0xef, 0x20, 0x0,
    0x7f, 0xaa, 0xf6, 0x0, 0x0, 0xc, 0xff, 0xb0,
    0x0, 0x0, 0x3, 0xff, 0x20, 0x0, 0x0, 0xc,
    0xff, 0xb0, 0x0, 0x0, 0x8f, 0x78, 0xf8, 0x0,
    0x4, 0xfd, 0x0, 0xdf, 0x40, 0x1e, 0xf2, 0x0,
    0x2f, 0xe1, 0x14, 0x20, 0x0, 0x2, 0x41,

    /* U+446 "ц" */
    0x0, 0x0, 0x0, 0x0, 0x9d, 0x0, 0x0, 0x0,
    0x0, 0x9d, 0x0, 0x0, 0x0, 0x0, 0x9d, 0xaf,
    0xff, 0xff, 0xff, 0xfd, 0xaf, 0x88, 0x88, 0x8f,
    0xd6, 0xaf, 0x10, 0x0, 0xf, 0xb0, 0xaf, 0x10,
    0x0, 0xf, 0xb0, 0xaf, 0x10, 0x0, 0xf, 0xb0,
    0xaf, 0x10, 0x0, 0xf, 0xb0, 0xaf, 0x10, 0x0,
    0xf, 0xb0, 0xaf, 0x10, 0x0, 0xf, 0xb0, 0xaf,
    0x10, 0x0, 0xf, 0xb0, 0xaf, 0x10, 0x0, 0xf,
    0xb0, 0x24, 0x0, 0x0, 0x4, 0x20,

    /* U+447 "ч" */
    0x0, 0x0, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x0,
    0xa, 0xf1, 0x0, 0x0, 0x0, 0xa, 0xf1, 0x0,
    0x1, 0x30, 0xa, 0xf1, 0x2, 0xcf, 0xff, 0xee,
    0xf1, 0xd, 0xf8, 0x46, 0x9e, 0xf1, 0x2f, 0xa0,
    0x0, 0xa, 0xf1, 0x4f, 0x70, 0x0, 0xa, 0xf1,
    0x5f, 0x60, 0x0, 0xa, 0xf1, 0x5f, 0x60, 0x0,
    0xa, 0xf1, 0x14, 0x10, 0x0, 0x2, 0x40,

    /* U+448 "ш" */
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xaf,
    0x98, 0x88, 0xef, 0x88, 0x88, 0xfa, 0xaf, 0x20,
    0x0, 0xde, 0x0, 0x1, 0xfa, 0xaf, 0x20, 0x0,
    0xde, 0x0, 0x1, 0xfa, 0xaf, 0x20, 0x0, 0xde,
    0x0, 0x1, 0xfa, 0xaf, 0x20, 0x0, 0xde, 0x0,
    0x1, 0xfa, 0xaf, 0x20, 0x0, 0xde, 0x0, 0x1,
    0xfa, 0xaf, 0x20, 0x0, 0xde, 0x0, 0x1, 0xfa,
    0xaf, 0x20, 0x0, 0xde, 0x0, 0x1, 0xfa, 0xaf,
    0x20, 0x0, 0xde, 0x0, 0x1, 0xfa, 0x24, 0x0,
    0x0, 0x33, 0x0, 0x0, 0x42,

    /* U+449 "щ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xad, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xda, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xaf, 0x98,
    0x88, 0xef, 0x88, 0x88, 0xfd, 0x6a, 0xf2, 0x0,
    0xd, 0xe0, 0x0, 0x1f, 0xa0, 0xaf, 0x20, 0x0,
    0xde, 0x0, 0x1, 0xfa, 0xa, 0xf2, 0x0, 0xd,
    0xe0, 0x0, 0x1f, 0xa0, 0xaf, 0x20, 0x0, 0xde,
    0x0, 0x1, 0xfa, 0xa, 0xf2, 0x0, 0xd, 0xe0,
    0x0, 0x1f, 0xa0, 0xaf, 0x20, 0x0, 0xde, 0x0,
    0x1, 0xfa, 0xa, 0xf2, 0x0, 0xd, 0xe0, 0x0,
    0x1f, 0xa0, 0xaf, 0x20, 0x0, 0xde, 0x0, 0x1,
    0xfa, 0x2, 0x40, 0x0, 0x3, 0x30, 0x0, 0x4,
    0x20,

    /* U+44A "ъ" */
    0x0, 0xb, 0xff, 0xff, 0xeb, 0x40, 0x0, 0xb,
    0xf8, 0x89, 0xae, 0xf4, 0x0, 0xb, 0xf0, 0x0,
    0x3, 0xfa, 0x0, 0xb, 0xf0, 0x0, 0x1, 0xfb,
    0x0, 0xb, 0xf4, 0x44, 0x4b, 0xf7, 0x0, 0xb,
    0xff, 0xff, 0xff, 0x90, 0x0, 0xb, 0xf4, 0x44,
    0x42, 0x0, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xf0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x24, 0x44, 0x40, 0x0,
    0x0, 0x0,

    /* U+44B "ы" */
    0xaf, 0xff, 0xfe, 0xb3, 0x0, 0xcf, 0xaf, 0x88,
    0x8a, 0xef, 0x40, 0xcf, 0xaf, 0x10, 0x0, 0x1f,
    0xb0, 0xcf, 0xaf, 0x10, 0x0, 0xf, 0xc0, 0xcf,
    0xaf, 0x54, 0x44, 0xbf, 0x70, 0xcf, 0xaf, 0xff,
    0xff, 0xf9, 0x0, 0xcf, 0xaf, 0x54, 0x44, 0x20,
    0x0, 0xcf, 0xaf, 0x10, 0x0, 0x0, 0x0, 0xcf,
    0xaf, 0x10, 0x0, 0x0, 0x0, 0xcf, 0xaf, 0x10,
    0x0, 0x0, 0x0, 0xcf, 0x24, 0x0, 0x0, 0x0,
    0x0, 0x33,

    /* U+44C "ь" */
    0xbf, 0xff, 0xfe, 0xb2, 0xb, 0xf8, 0x89, 0xae,
    0xf3, 0xbf, 0x0, 0x0, 0x2f, 0xab, 0xf0, 0x0,
    0x1, 0xfb, 0xbf, 0x44, 0x44, 0xcf, 0x6b, 0xff,
    0xff, 0xff, 0x80, 0xbf, 0x44, 0x44, 0x10, 0xb,
    0xf0, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0xb, 0xf0, 0x0, 0x0, 0x0, 0x24, 0x0, 0x0,
    0x0, 0x0,

    /* U+44D "э" */
    0x0, 0x0, 0x33, 0x0, 0x0, 0x1, 0x9f, 0xff,
    0xf7, 0x0, 0xb, 0xfc, 0x56, 0xdf, 0x50, 0x4f,
    0xb0, 0x0, 0xe, 0xe0, 0x4a, 0x30, 0x0, 0x9,
    0xf3, 0x0, 0x0, 0x88, 0x8b, 0xf5, 0x0, 0x0,
    0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x8, 0xf3,
    0x3e, 0x90, 0x0, 0xd, 0xf1, 0xe, 0xf5, 0x0,
    0x9f, 0xb0, 0x4, 0xff, 0xee, 0xfb, 0x10, 0x0,
    0x27, 0x76, 0x30, 0x0,

    /* U+44E "ю" */
    0x0, 0x0, 0x0, 0x1, 0x32, 0x0, 0x0, 0xaf,
    0x10, 0x1, 0xbf, 0xff, 0xe3, 0x0, 0xaf, 0x10,
    0xc, 0xf9, 0x47, 0xff, 0x10, 0xaf, 0x10, 0x5f,
    0x90, 0x0, 0x4f, 0x90, 0xaf, 0x10, 0x9f, 0x30,
    0x0, 0xd, 0xf0, 0xaf, 0x88, 0xdf, 0x10, 0x0,
    0xa, 0xf1, 0xaf, 0xff, 0xff, 0x0, 0x0, 0xa,
    0xf2, 0xaf, 0x10, 0xaf, 0x20, 0x0, 0xc, 0xf1,
    0xaf, 0x10, 0x7f, 0x70, 0x0, 0x1f, 0xd0, 0xaf,
    0x10, 0x1e, 0xf5, 0x2, 0xcf, 0x60, 0xaf, 0x10,
    0x5, 0xff, 0xff, 0xfa, 0x0, 0x24, 0x0, 0x0,
    0x38, 0x88, 0x40, 0x0,

    /* U+44F "я" */
    0x5f, 0xd0, 0x0, 0x4, 0xf7, 0xb, 0xf8, 0x0,
    0x4, 0xf7, 0x1, 0xef, 0x30, 0x4, 0xf7, 0x0,
    0x2e, 0xe3, 0x4, 0xf7, 0x0, 0x6b, 0xff, 0xff,
    0xf7, 0x6, 0xff, 0xc8, 0x8a, 0xf7, 0xe, 0xe1,
    0x0, 0x4, 0xf7, 0xf, 0xd0, 0x0, 0x4, 0xf7,
    0xb, 0xf6, 0x20, 0x4, 0xf7, 0x2, 0xdf, 0xff,
    0xff, 0xf7, 0x0, 0x3, 0x44, 0x44, 0x41,

    /* U+451 "ё" */
    0x0, 0x0, 0x13, 0x10, 0x0, 0x0, 0x2, 0xdf,
    0xff, 0xe4, 0x0, 0x1, 0xff, 0x84, 0x7e, 0xf5,
    0x0, 0xaf, 0x20, 0x0, 0x2f, 0xe0, 0xf, 0xc0,
    0x0, 0x0, 0x21, 0x3, 0xfb, 0x44, 0x44, 0x44,
    0x41, 0x3f, 0xff, 0xff, 0xff, 0xff, 0x40, 0xfc,
    0x44, 0x44, 0x4b, 0xf1, 0xb, 0xe1, 0x0, 0x0,
    0xdf, 0x0, 0x4f, 0xc3, 0x0, 0x9f, 0x80, 0x0,
    0x8f, 0xfd, 0xff, 0x80, 0x0, 0x0, 0x25, 0x76,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x84, 0x4, 0x82, 0x0, 0x0, 0x3f, 0x90,
    0x9f, 0x40, 0x0, 0x1, 0x84, 0x4, 0x82, 0x0,

    /* U+452 "ђ" */
    0x0, 0x0, 0x0, 0x22, 0x0, 0x0, 0x0, 0x1,
    0xff, 0xd1, 0x0, 0x0, 0x0, 0x5a, 0xf8, 0x0,
    0x0, 0x0, 0x1, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0xfb, 0xa, 0xf1, 0x0, 0x0, 0xfc, 0xa, 0xf1,
    0x0, 0x0, 0xfc, 0xa, 0xf1, 0x0, 0x0, 0xfc,
    0xa, 0xf1, 0x0, 0x0, 0xfc, 0xa, 0xf1, 0x0,
    0x0, 0xfc, 0xa, 0xf1, 0x0, 0x0, 0xfc, 0xa,
    0xf2, 0x0, 0x0, 0xfc, 0xa, 0xf5, 0x0, 0x2,
    0xfa, 0xa, 0xfe, 0x20, 0xa, 0xf7, 0xa, 0xfc,
    0xff, 0xff, 0xe0, 0xa, 0xf1, 0x47, 0x87, 0x10,
    0xa, 0xf1, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0x60, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x0, 0x2,
    0x40, 0x0, 0x0, 0x0,

    /* U+453 "ѓ" */
    0xaf, 0x10, 0x0, 0xa, 0xf1, 0x0, 0x0, 0xaf,
    0x10, 0x0, 0xa, 0xf1, 0x0, 0x0, 0xaf, 0x10,
    0x0, 0xa, 0xf1, 0x0, 0x0, 0xaf, 0x10, 0x0,
    0xa, 0xf1, 0x0, 0x0, 0xaf, 0x10, 0x0, 0xa,
    0xff, 0xff, 0xf4, 0x24, 0x44, 0x44, 0x10, 0x2,
    0x30, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0xdf,
    0x20, 0x0, 0x3, 0x85, 0x0,

    /* U+454 "є" */
    0x0, 0x0, 0x23, 0x10, 0x0, 0x0, 0x4f, 0xff,
    0xfc, 0x20, 0x3, 0xfe, 0x75, 0xbf, 0xd0, 0xb,
    0xf3, 0x0, 0x8, 0xf7, 0xf, 0xc0, 0x0, 0x1,
    0xb6, 0x2f, 0xd8, 0x88, 0x20, 0x0, 0x2f, 0xff,
    0xff, 0x40, 0x0, 0xf, 0xb0, 0x0, 0x0, 0x0,
    0xe, 0xf1, 0x0, 0x6, 0xe6, 0x7, 0xfc, 0x0,
    0x3e, 0xf2, 0x0, 0x8f, 0xfd, 0xff, 0x70, 0x0,
    0x2, 0x57, 0x83, 0x0,

    /* U+455 "ѕ" */
    0x0, 0x0, 0x22, 0x0, 0x0, 0x2, 0xbf, 0xff,
    0xe9, 0x0, 0xd, 0xfa, 0x65, 0xaf, 0xa0, 0x3f,
    0xa0, 0x0, 0xb, 0xf2, 0x2, 0x10, 0x0, 0x1d,
    0xf2, 0x0, 0x0, 0x5a, 0xff, 0xb0, 0x1, 0xbf,
    0xff, 0xc8, 0x0, 0xc, 0xfc, 0x61, 0x0, 0x0,
    0xf, 0xb0, 0x0, 0x7, 0x30, 0xe, 0xe1, 0x0,
    0x6f, 0xa0, 0x5, 0xff, 0xde, 0xfd, 0x10, 0x0,
    0x37, 0x87, 0x50, 0x0,

    /* U+456 "і" */
    0xaf, 0x1a, 0xf1, 0xaf, 0x1a, 0xf1, 0xaf, 0x1a,
    0xf1, 0xaf, 0x1a, 0xf1, 0xaf, 0x1a, 0xf1, 0x24,
    0x0, 0x0, 0x8c, 0x1a, 0xf1, 0x24, 0x0,

    /* U+457 "ї" */
    0x1, 0xfb, 0x0, 0x1, 0xfb, 0x0, 0x1, 0xfb,
    0x0, 0x1, 0xfb, 0x0, 0x1, 0xfb, 0x0, 0x1,
    0xfb, 0x0, 0x1, 0xfb, 0x0, 0x1, 0xfb, 0x0,
    0x1, 0xfb, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x42,
    0x0, 0x0, 0x0, 0x0, 0x77, 0x2, 0x84, 0xee,
    0x4, 0xf9, 0x77, 0x2, 0x84,

    /* U+458 "ј" */
    0x13, 0x0, 0xc, 0xff, 0x40, 0x46, 0xfd, 0x0,
    0xc, 0xf0, 0x0, 0xbf, 0x0, 0xb, 0xf1, 0x0,
    0xbf, 0x10, 0xb, 0xf1, 0x0, 0xbf, 0x10, 0xb,
    0xf1, 0x0, 0xbf, 0x10, 0xb, 0xf1, 0x0, 0xbf,
    0x10, 0xb, 0xf1, 0x0, 0xbf, 0x10, 0x2, 0x40,
    0x0, 0x0, 0x0, 0x8, 0xc0, 0x0, 0xbf, 0x10,
    0x2, 0x40,

    /* U+459 "љ" */
    0xdf, 0xd5, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xd9,
    0x0, 0x56, 0xfd, 0x0, 0x0, 0x1f, 0xd8, 0x89,
    0xbf, 0xc0, 0x0, 0xcf, 0x0, 0x0, 0x1f, 0xa0,
    0x0, 0x8, 0xf4, 0x0, 0xbf, 0x0, 0x0, 0x1f,
    0xa0, 0x0, 0x7, 0xf5, 0x0, 0xbf, 0x0, 0x0,
    0x1f, 0xb4, 0x44, 0x6e, 0xf1, 0x0, 0xbf, 0x0,
    0x0, 0x1f, 0xff, 0xff, 0xfd, 0x30, 0x0, 0xbf,
    0x0, 0x0, 0x1f, 0xb4, 0x44, 0x30, 0x0, 0x0,
    0xbf, 0x0, 0x0, 0x1f, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x0, 0x0, 0x1f, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x24, 0x44, 0x44, 0x44, 0x20,
    0x0, 0x0, 0x0,

    /* U+45A "њ" */
    0xbf, 0x0, 0x0, 0xff, 0xff, 0xfd, 0x91, 0xb,
    0xf0, 0x0, 0xf, 0xe8, 0x89, 0xbf, 0xe0, 0xbf,
    0x0, 0x0, 0xfc, 0x0, 0x0, 0x6f, 0x6b, 0xf0,
    0x0, 0xf, 0xc0, 0x0, 0x7, 0xf6, 0xbf, 0x88,
    0x88, 0xfe, 0x88, 0x9c, 0xfe, 0x1b, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xc8, 0x20, 0xbf, 0x0, 0x0,
    0xfc, 0x0, 0x0, 0x0, 0xb, 0xf0, 0x0, 0xf,
    0xc0, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0x0, 0xb, 0xf0, 0x0, 0xf, 0xc0,
    0x0, 0x0, 0x0, 0x24, 0x0, 0x0, 0x33, 0x0,
    0x0, 0x0, 0x0,

    /* U+45B "ћ" */
    0xa, 0xf1, 0x0, 0x0, 0xfc, 0xa, 0xf1, 0x0,
    0x0, 0xfc, 0xa, 0xf1, 0x0, 0x0, 0xfc, 0xa,
    0xf1, 0x0, 0x0, 0xfc, 0xa, 0xf1, 0x0, 0x0,
    0xfc, 0xa, 0xf1, 0x0, 0x0, 0xfc, 0xa, 0xf2,
    0x0, 0x0, 0xfc, 0xa, 0xf5, 0x0, 0x2, 0xfa,
    0xa, 0xfe, 0x20, 0xa, 0xf7, 0xa, 0xfc, 0xff,
    0xff, 0xe0, 0xa, 0xf1, 0x47, 0x87, 0x10, 0xa,
    0xf1, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x60,
    0x0, 0xa, 0xf1, 0x0, 0x0, 0x0, 0x2, 0x40,
    0x0, 0x0, 0x0,

    /* U+45C "ќ" */
    0xbf, 0x10, 0x5, 0xf9, 0xbf, 0x10, 0xe, 0xe1,
    0xbf, 0x10, 0x7f, 0x60, 0xbf, 0x12, 0xfc, 0x0,
    0xbf, 0x5d, 0xe1, 0x0, 0xbf, 0xff, 0x50, 0x0,
    0xbf, 0x2a, 0xf1, 0x0, 0xbf, 0x11, 0xf8, 0x0,
    0xbf, 0x10, 0x8f, 0x10, 0xbf, 0x10, 0x1e, 0xf8,
    0x24, 0x0, 0x1, 0x42, 0x0, 0x23, 0x0, 0x0,
    0x0, 0x4f, 0x50, 0x0, 0x0, 0xd, 0xf2, 0x0,
    0x0, 0x3, 0x85, 0x0,

    /* U+45E "ў" */
    0x0, 0x20, 0x0, 0x0, 0x0, 0xd, 0xfd, 0x20,
    0x0, 0x0, 0x9, 0x9f, 0xd0, 0x0, 0x0, 0x0,
    0x5, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xec, 0x0,
    0x0, 0x0, 0x0, 0xef, 0x20, 0x0, 0x0, 0x5,
    0xff, 0x80, 0x0, 0x0, 0xb, 0xfc, 0xe0, 0x0,
    0x0, 0x1f, 0xa7, 0xf4, 0x0, 0x0, 0x7f, 0x41,
    0xfa, 0x0, 0x0, 0xde, 0x0, 0xbf, 0x10, 0x3,
    0xf8, 0x0, 0x5f, 0x60, 0x9, 0xf3, 0x0, 0xe,
    0xc0, 0xf, 0xd0, 0x0, 0x9, 0xf2, 0x6f, 0x70,
    0x0, 0x3, 0xf8, 0x24, 0x10, 0x0, 0x0, 0x33,
    0x0, 0x0, 0x12, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xd2, 0x0, 0x0, 0x8c, 0x21, 0x9c, 0x0, 0x0,
    0x21, 0x0, 0x3, 0x0,

    /* U+45F "џ" */
    0x0, 0x3, 0xf4, 0x0, 0x0, 0x0, 0x3f, 0x40,
    0x0, 0x0, 0x3, 0xf4, 0x0, 0xa, 0xff, 0xff,
    0xff, 0xfb, 0xaf, 0x88, 0x88, 0x8f, 0xba, 0xf1,
    0x0, 0x0, 0xfb, 0xaf, 0x10, 0x0, 0xf, 0xba,
    0xf1, 0x0, 0x0, 0xfb, 0xaf, 0x10, 0x0, 0xf,
    0xba, 0xf1, 0x0, 0x0, 0xfb, 0xaf, 0x10, 0x0,
    0xf, 0xba, 0xf1, 0x0, 0x0, 0xfb, 0xaf, 0x10,
    0x0, 0xf, 0xb2, 0x40, 0x0, 0x0, 0x42,

    /* U+2211 "∑" */
    0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x2c, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0xbf, 0xc4, 0x44,
    0x44, 0x44, 0x44, 0x21, 0xef, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x80, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x6, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x75, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x83,

    /* U+221E "∞" */
    0x0, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0, 0x64,
    0x0, 0x1c, 0xee, 0xa0, 0x1e, 0xba, 0xd3, 0xca,
    0x0, 0xd8, 0x6b, 0x0, 0x6f, 0xc0, 0x0, 0x6c,
    0x6a, 0x0, 0x6f, 0xc0, 0x0, 0x5b, 0x1d, 0x89,
    0xf4, 0xca, 0x0, 0xc8, 0x0, 0x66, 0x20, 0x1d,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x31, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_h = 0, .box_w = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 89, .box_h = 0, .box_w = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 89, .box_h = 15, .box_w = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 23, .adv_w = 114, .box_h = 6, .box_w = 7, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 44, .adv_w = 178, .box_h = 16, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 132, .adv_w = 178, .box_h = 18, .box_w = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 231, .adv_w = 285, .box_h = 16, .box_w = 16, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 359, .adv_w = 213, .box_h = 16, .box_w = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 463, .adv_w = 61, .box_h = 6, .box_w = 2, .ofs_x = 1, .ofs_y = 9},
    {.bitmap_index = 469, .adv_w = 107, .box_h = 20, .box_w = 5, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 519, .adv_w = 107, .box_h = 20, .box_w = 5, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 569, .adv_w = 125, .box_h = 7, .box_w = 8, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 597, .adv_w = 187, .box_h = 10, .box_w = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 647, .adv_w = 89, .box_h = 5, .box_w = 3, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 655, .adv_w = 107, .box_h = 3, .box_w = 7, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 666, .adv_w = 89, .box_h = 2, .box_w = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 669, .adv_w = 89, .box_h = 16, .box_w = 6, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 717, .adv_w = 178, .box_h = 16, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 805, .adv_w = 178, .box_h = 15, .box_w = 6, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 850, .adv_w = 178, .box_h = 15, .box_w = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 933, .adv_w = 178, .box_h = 16, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1021, .adv_w = 178, .box_h = 15, .box_w = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1104, .adv_w = 178, .box_h = 15, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1187, .adv_w = 178, .box_h = 16, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1275, .adv_w = 178, .box_h = 15, .box_w = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1358, .adv_w = 178, .box_h = 16, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1446, .adv_w = 178, .box_h = 16, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1534, .adv_w = 89, .box_h = 11, .box_w = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1551, .adv_w = 89, .box_h = 14, .box_w = 3, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 1572, .adv_w = 187, .box_h = 10, .box_w = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1622, .adv_w = 187, .box_h = 6, .box_w = 10, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 1652, .adv_w = 187, .box_h = 10, .box_w = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1702, .adv_w = 178, .box_h = 15, .box_w = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1785, .adv_w = 325, .box_h = 20, .box_w = 19, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 1975, .adv_w = 213, .box_h = 15, .box_w = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2080, .adv_w = 213, .box_h = 15, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2170, .adv_w = 231, .box_h = 16, .box_w = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 2274, .adv_w = 231, .box_h = 15, .box_w = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2372, .adv_w = 213, .box_h = 15, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2462, .adv_w = 195, .box_h = 15, .box_w = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2545, .adv_w = 249, .box_h = 16, .box_w = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 2657, .adv_w = 231, .box_h = 15, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2747, .adv_w = 89, .box_h = 15, .box_w = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2770, .adv_w = 160, .box_h = 16, .box_w = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2842, .adv_w = 213, .box_h = 15, .box_w = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2940, .adv_w = 178, .box_h = 15, .box_w = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3015, .adv_w = 267, .box_h = 15, .box_w = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3128, .adv_w = 231, .box_h = 15, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3218, .adv_w = 249, .box_h = 16, .box_w = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3338, .adv_w = 213, .box_h = 15, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3428, .adv_w = 249, .box_h = 16, .box_w = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3548, .adv_w = 231, .box_h = 15, .box_w = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3653, .adv_w = 213, .box_h = 16, .box_w = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3757, .adv_w = 195, .box_h = 15, .box_w = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3847, .adv_w = 231, .box_h = 16, .box_w = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 3943, .adv_w = 213, .box_h = 15, .box_w = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4048, .adv_w = 302, .box_h = 15, .box_w = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4191, .adv_w = 213, .box_h = 15, .box_w = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4296, .adv_w = 213, .box_h = 15, .box_w = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4401, .adv_w = 195, .box_h = 15, .box_w = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4491, .adv_w = 89, .box_h = 19, .box_w = 5, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 4539, .adv_w = 89, .box_h = 16, .box_w = 6, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4587, .adv_w = 89, .box_h = 19, .box_w = 5, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4635, .adv_w = 150, .box_h = 9, .box_w = 9, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 4676, .adv_w = 178, .box_h = 2, .box_w = 13, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 4689, .adv_w = 107, .box_h = 4, .box_w = 4, .ofs_x = 1, .ofs_y = 11},
    {.bitmap_index = 4697, .adv_w = 178, .box_h = 12, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4763, .adv_w = 178, .box_h = 16, .box_w = 10, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4843, .adv_w = 160, .box_h = 12, .box_w = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4903, .adv_w = 178, .box_h = 16, .box_w = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4983, .adv_w = 178, .box_h = 12, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5049, .adv_w = 89, .box_h = 15, .box_w = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5102, .adv_w = 178, .box_h = 16, .box_w = 10, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 5182, .adv_w = 178, .box_h = 15, .box_w = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5250, .adv_w = 71, .box_h = 15, .box_w = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5273, .adv_w = 71, .box_h = 20, .box_w = 5, .ofs_x = -1, .ofs_y = -5},
    {.bitmap_index = 5323, .adv_w = 160, .box_h = 15, .box_w = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5391, .adv_w = 71, .box_h = 15, .box_w = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5414, .adv_w = 267, .box_h = 11, .box_w = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5497, .adv_w = 178, .box_h = 11, .box_w = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5547, .adv_w = 178, .box_h = 12, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5613, .adv_w = 178, .box_h = 15, .box_w = 10, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 5688, .adv_w = 178, .box_h = 15, .box_w = 10, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5763, .adv_w = 107, .box_h = 11, .box_w = 6, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5796, .adv_w = 160, .box_h = 12, .box_w = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5856, .adv_w = 89, .box_h = 15, .box_w = 6, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5901, .adv_w = 178, .box_h = 12, .box_w = 9, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5955, .adv_w = 160, .box_h = 11, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6010, .adv_w = 231, .box_h = 11, .box_w = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6093, .adv_w = 160, .box_h = 11, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6148, .adv_w = 160, .box_h = 16, .box_w = 10, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 6228, .adv_w = 160, .box_h = 11, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6283, .adv_w = 107, .box_h = 20, .box_w = 7, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 6353, .adv_w = 83, .box_h = 20, .box_w = 3, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 6383, .adv_w = 107, .box_h = 20, .box_w = 7, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 6453, .adv_w = 187, .box_h = 4, .box_w = 11, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 6475, .adv_w = 214, .box_h = 18, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6583, .adv_w = 277, .box_h = 16, .box_w = 17, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6719, .adv_w = 173, .box_h = 18, .box_w = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6809, .adv_w = 230, .box_h = 16, .box_w = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6913, .adv_w = 213, .box_h = 16, .box_w = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7017, .adv_w = 89, .box_h = 15, .box_w = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7040, .adv_w = 89, .box_h = 18, .box_w = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7094, .adv_w = 160, .box_h = 16, .box_w = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7166, .adv_w = 338, .box_h = 16, .box_w = 21, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7334, .adv_w = 323, .box_h = 15, .box_w = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7477, .adv_w = 273, .box_h = 15, .box_w = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7605, .adv_w = 186, .box_h = 18, .box_w = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7704, .adv_w = 203, .box_h = 19, .box_w = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7828, .adv_w = 230, .box_h = 19, .box_w = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 7942, .adv_w = 213, .box_h = 15, .box_w = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8047, .adv_w = 210, .box_h = 15, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8137, .adv_w = 213, .box_h = 15, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8227, .adv_w = 173, .box_h = 15, .box_w = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8302, .adv_w = 217, .box_h = 19, .box_w = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 8426, .adv_w = 213, .box_h = 15, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8516, .adv_w = 295, .box_h = 15, .box_w = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8659, .adv_w = 193, .box_h = 16, .box_w = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8755, .adv_w = 230, .box_h = 15, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8845, .adv_w = 230, .box_h = 18, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8953, .adv_w = 186, .box_h = 15, .box_w = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9036, .adv_w = 210, .box_h = 16, .box_w = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9132, .adv_w = 267, .box_h = 15, .box_w = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9245, .adv_w = 231, .box_h = 15, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9335, .adv_w = 249, .box_h = 16, .box_w = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9455, .adv_w = 230, .box_h = 15, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9545, .adv_w = 213, .box_h = 15, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9635, .adv_w = 231, .box_h = 16, .box_w = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9739, .adv_w = 195, .box_h = 15, .box_w = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9829, .adv_w = 203, .box_h = 16, .box_w = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9933, .adv_w = 243, .box_h = 15, .box_w = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10046, .adv_w = 213, .box_h = 15, .box_w = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10151, .adv_w = 237, .box_h = 19, .box_w = 14, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 10284, .adv_w = 213, .box_h = 15, .box_w = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10374, .adv_w = 293, .box_h = 15, .box_w = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10494, .adv_w = 300, .box_h = 19, .box_w = 18, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 10665, .adv_w = 253, .box_h = 15, .box_w = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10785, .adv_w = 283, .box_h = 15, .box_w = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10905, .adv_w = 210, .box_h = 15, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10995, .adv_w = 230, .box_h = 16, .box_w = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11107, .adv_w = 323, .box_h = 16, .box_w = 19, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11259, .adv_w = 231, .box_h = 15, .box_w = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11357, .adv_w = 178, .box_h = 12, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11423, .adv_w = 183, .box_h = 16, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11511, .adv_w = 170, .box_h = 11, .box_w = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11561, .adv_w = 117, .box_h = 11, .box_w = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11600, .adv_w = 187, .box_h = 14, .box_w = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11684, .adv_w = 178, .box_h = 12, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11750, .adv_w = 214, .box_h = 11, .box_w = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11827, .adv_w = 147, .box_h = 12, .box_w = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11881, .adv_w = 179, .box_h = 11, .box_w = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11931, .adv_w = 179, .box_h = 15, .box_w = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11999, .adv_w = 140, .box_h = 11, .box_w = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12043, .adv_w = 187, .box_h = 11, .box_w = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12104, .adv_w = 220, .box_h = 11, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12170, .adv_w = 177, .box_h = 11, .box_w = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12220, .adv_w = 178, .box_h = 12, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 12286, .adv_w = 173, .box_h = 11, .box_w = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12336, .adv_w = 178, .box_h = 15, .box_w = 10, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 12411, .adv_w = 160, .box_h = 12, .box_w = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 12471, .adv_w = 147, .box_h = 11, .box_w = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12521, .adv_w = 160, .box_h = 16, .box_w = 10, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 12601, .adv_w = 263, .box_h = 19, .box_w = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12753, .adv_w = 160, .box_h = 11, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12808, .adv_w = 183, .box_h = 14, .box_w = 10, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 12878, .adv_w = 167, .box_h = 11, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12933, .adv_w = 257, .box_h = 11, .box_w = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13010, .adv_w = 263, .box_h = 14, .box_w = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 13115, .adv_w = 200, .box_h = 11, .box_w = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13181, .adv_w = 230, .box_h = 11, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13247, .adv_w = 167, .box_h = 11, .box_w = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13297, .adv_w = 163, .box_h = 12, .box_w = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 13357, .adv_w = 240, .box_h = 12, .box_w = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 13441, .adv_w = 173, .box_h = 11, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13496, .adv_w = 178, .box_h = 16, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 13584, .adv_w = 178, .box_h = 20, .box_w = 10, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 13684, .adv_w = 117, .box_h = 15, .box_w = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13737, .adv_w = 163, .box_h = 12, .box_w = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 13797, .adv_w = 160, .box_h = 12, .box_w = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 13857, .adv_w = 71, .box_h = 15, .box_w = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13880, .adv_w = 89, .box_h = 15, .box_w = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13925, .adv_w = 71, .box_h = 20, .box_w = 5, .ofs_x = -1, .ofs_y = -5},
    {.bitmap_index = 13975, .adv_w = 290, .box_h = 11, .box_w = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14074, .adv_w = 260, .box_h = 11, .box_w = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14157, .adv_w = 178, .box_h = 15, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14232, .adv_w = 140, .box_h = 15, .box_w = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14292, .adv_w = 160, .box_h = 20, .box_w = 10, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 14392, .adv_w = 177, .box_h = 14, .box_w = 9, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 14455, .adv_w = 228, .box_h = 20, .box_w = 13, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 14585, .adv_w = 228, .box_h = 8, .box_w = 12, .ofs_x = 1, .ofs_y = 3}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static uint16_t unicode_list_4[] = {
    0x0, 0x1, 0x1db3, 0x1dc0
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY,
        .glyph_id_start = 1, .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0
    },
    {
        .range_start = 1025, .range_length = 12, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY,
        .glyph_id_start = 96, .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0
    },
    {
        .range_start = 1038, .range_length = 66, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY,
        .glyph_id_start = 108, .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0
    },
    {
        .range_start = 1105, .range_length = 12, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY,
        .glyph_id_start = 174, .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0
    },
    {
        .range_start = 1118, .range_length = 7617, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY,
        .glyph_id_start = 186, .unicode_list = unicode_list_4, .glyph_id_ofs_list = NULL, .list_length = 4
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Pair left and right glyphs for kerning*/
static const uint8_t kern_pair_glyph_ids[] =
{
    1, 34,
    1, 53,
    1, 58,
    18, 18,
    34, 1,
    34, 53,
    34, 55,
    34, 56,
    34, 58,
    34, 87,
    34, 88,
    34, 90,
    39, 13,
    39, 15,
    39, 34,
    45, 1,
    45, 53,
    45, 55,
    45, 56,
    45, 58,
    45, 90,
    49, 1,
    49, 13,
    49, 15,
    49, 34,
    51, 53,
    51, 55,
    51, 56,
    51, 58,
    53, 1,
    53, 13,
    53, 14,
    53, 15,
    53, 27,
    53, 28,
    53, 34,
    53, 48,
    53, 66,
    53, 68,
    53, 70,
    53, 74,
    53, 80,
    53, 83,
    53, 84,
    53, 86,
    53, 88,
    53, 90,
    55, 13,
    55, 14,
    55, 15,
    55, 27,
    55, 28,
    55, 34,
    55, 66,
    55, 70,
    55, 74,
    55, 80,
    55, 83,
    55, 86,
    55, 90,
    56, 13,
    56, 14,
    56, 15,
    56, 27,
    56, 28,
    56, 34,
    56, 66,
    56, 70,
    56, 80,
    56, 83,
    56, 86,
    56, 90,
    58, 1,
    58, 13,
    58, 14,
    58, 15,
    58, 27,
    58, 28,
    58, 34,
    58, 66,
    58, 70,
    58, 74,
    58, 80,
    58, 81,
    58, 82,
    58, 86,
    58, 87,
    71, 71,
    83, 13,
    83, 15,
    87, 13,
    87, 15,
    88, 13,
    88, 15,
    90, 13,
    90, 15,
    98, 13,
    98, 15,
    110, 114,
    110, 117,
    110, 121,
    110, 124,
    110, 125,
    110, 127,
    110, 128,
    110, 129,
    110, 130,
    110, 133,
    110, 139,
    110, 142,
    110, 160,
    110, 161,
    110, 162,
    110, 171,
    111, 110,
    111, 117,
    111, 124,
    111, 127,
    111, 128,
    111, 129,
    111, 130,
    111, 131,
    111, 133,
    111, 136,
    111, 139,
    111, 141,
    111, 153,
    111, 161,
    112, 110,
    112, 114,
    112, 116,
    112, 117,
    112, 121,
    112, 124,
    112, 127,
    112, 128,
    112, 129,
    112, 130,
    112, 131,
    112, 133,
    112, 136,
    112, 141,
    112, 146,
    112, 154,
    112, 160,
    112, 161,
    112, 163,
    112, 165,
    112, 173,
    113, 13,
    113, 15,
    113, 110,
    113, 114,
    113, 117,
    113, 121,
    113, 122,
    113, 124,
    113, 127,
    113, 141,
    113, 142,
    113, 144,
    113, 146,
    113, 147,
    113, 150,
    113, 153,
    113, 154,
    113, 155,
    113, 156,
    113, 158,
    113, 161,
    113, 169,
    113, 170,
    113, 172,
    113, 173,
    114, 129,
    114, 130,
    114, 133,
    114, 149,
    114, 156,
    114, 161,
    115, 117,
    115, 159,
    116, 117,
    116, 124,
    116, 127,
    116, 128,
    116, 129,
    116, 136,
    116, 142,
    116, 147,
    116, 156,
    116, 161,
    117, 121,
    117, 124,
    117, 127,
    117, 128,
    117, 129,
    117, 130,
    117, 133,
    117, 141,
    120, 117,
    120, 124,
    120, 127,
    120, 129,
    120, 130,
    121, 130,
    121, 143,
    121, 161,
    122, 130,
    122, 133,
    122, 142,
    122, 147,
    122, 156,
    122, 159,
    122, 161,
    122, 165,
    122, 171,
    124, 110,
    124, 114,
    124, 116,
    124, 121,
    124, 129,
    124, 131,
    124, 133,
    124, 141,
    124, 146,
    124, 153,
    124, 163,
    126, 13,
    126, 15,
    126, 27,
    126, 28,
    126, 110,
    126, 114,
    126, 116,
    126, 117,
    126, 121,
    126, 122,
    126, 124,
    126, 127,
    126, 128,
    126, 129,
    126, 130,
    126, 131,
    126, 141,
    126, 142,
    126, 146,
    126, 147,
    126, 156,
    126, 171,
    126, 173,
    127, 110,
    127, 114,
    127, 117,
    127, 121,
    127, 122,
    127, 124,
    127, 128,
    127, 129,
    127, 131,
    127, 133,
    127, 136,
    127, 139,
    127, 142,
    127, 148,
    127, 165,
    128, 13,
    128, 15,
    128, 110,
    128, 114,
    128, 116,
    128, 117,
    128, 121,
    128, 124,
    128, 130,
    128, 141,
    128, 142,
    128, 144,
    128, 147,
    128, 150,
    128, 152,
    128, 153,
    128, 154,
    128, 156,
    128, 157,
    128, 158,
    128, 159,
    128, 161,
    128, 163,
    128, 167,
    128, 169,
    128, 170,
    128, 172,
    128, 173,
    129, 13,
    129, 15,
    129, 27,
    129, 28,
    129, 110,
    129, 114,
    129, 117,
    129, 121,
    129, 124,
    129, 130,
    129, 139,
    129, 141,
    129, 143,
    129, 144,
    129, 145,
    129, 146,
    129, 147,
    129, 148,
    129, 149,
    129, 150,
    129, 151,
    129, 152,
    129, 153,
    129, 154,
    129, 155,
    129, 156,
    129, 157,
    129, 158,
    129, 159,
    129, 163,
    129, 164,
    129, 166,
    129, 167,
    129, 172,
    129, 173,
    130, 110,
    130, 114,
    130, 121,
    130, 128,
    130, 129,
    130, 133,
    130, 141,
    130, 153,
    131, 117,
    131, 124,
    131, 127,
    131, 130,
    131, 139,
    131, 156,
    131, 161,
    132, 124,
    132, 142,
    135, 142,
    135, 161,
    136, 141,
    138, 110,
    138, 114,
    138, 116,
    138, 117,
    138, 121,
    138, 122,
    138, 124,
    138, 127,
    138, 128,
    138, 131,
    138, 133,
    138, 139,
    138, 141,
    139, 114,
    139, 116,
    139, 117,
    139, 121,
    139, 131,
    139, 141,
    139, 146,
    139, 148,
    139, 153,
    139, 154,
    139, 173,
    140, 110,
    140, 114,
    140, 116,
    140, 121,
    140, 124,
    140, 127,
    140, 128,
    140, 131,
    140, 133,
    140, 146,
    140, 153,
    140, 154,
    142, 149,
    142, 160,
    142, 161,
    142, 165,
    143, 142,
    143, 146,
    143, 147,
    143, 148,
    143, 149,
    143, 153,
    143, 154,
    143, 159,
    143, 161,
    143, 162,
    143, 163,
    143, 165,
    143, 168,
    143, 171,
    143, 173,
    144, 142,
    144, 143,
    144, 146,
    144, 147,
    144, 148,
    144, 149,
    144, 153,
    144, 154,
    144, 156,
    144, 159,
    144, 160,
    144, 161,
    144, 162,
    144, 165,
    144, 168,
    144, 173,
    145, 13,
    145, 15,
    145, 142,
    145, 146,
    145, 147,
    145, 149,
    145, 153,
    145, 156,
    145, 159,
    145, 173,
    146, 168,
    146, 171,
    147, 143,
    147, 146,
    147, 148,
    147, 149,
    147, 153,
    147, 160,
    147, 161,
    147, 163,
    147, 165,
    148, 143,
    148, 161,
    148, 165,
    148, 168,
    149, 143,
    149, 146,
    149, 147,
    149, 149,
    149, 153,
    149, 156,
    149, 159,
    149, 161,
    149, 162,
    149, 165,
    149, 168,
    152, 142,
    152, 143,
    152, 147,
    152, 149,
    152, 153,
    152, 156,
    152, 159,
    152, 160,
    152, 161,
    152, 171,
    153, 156,
    153, 165,
    154, 143,
    154, 149,
    154, 161,
    156, 146,
    156, 148,
    156, 149,
    156, 153,
    156, 160,
    156, 161,
    156, 163,
    156, 165,
    158, 146,
    158, 149,
    158, 153,
    158, 160,
    158, 161,
    158, 163,
    158, 165,
    158, 173,
    159, 148,
    159, 156,
    159, 165,
    159, 171,
    160, 13,
    160, 15,
    160, 142,
    160, 146,
    160, 147,
    160, 148,
    160, 153,
    160, 156,
    160, 159,
    160, 161,
    161, 13,
    161, 15,
    161, 142,
    161, 143,
    161, 146,
    161, 147,
    161, 148,
    161, 153,
    161, 154,
    161, 156,
    161, 158,
    161, 159,
    161, 162,
    161, 171,
    161, 173,
    162, 143,
    162, 146,
    162, 153,
    162, 160,
    162, 161,
    162, 165,
    162, 173,
    163, 142,
    163, 143,
    163, 147,
    163, 149,
    163, 156,
    163, 159,
    163, 160,
    163, 162,
    163, 165,
    164, 147,
    164, 149,
    164, 156,
    164, 159,
    167, 147,
    167, 156,
    167, 161,
    170, 160,
    170, 165,
    171, 146,
    171, 147,
    171, 149,
    171, 153,
    171, 156,
    171, 160,
    171, 163,
    171, 173,
    172, 146,
    172, 148,
    172, 153,
    172, 154,
    172, 160,
    172, 163,
    172, 165,
    186, 13,
    186, 15
};

/* Kerning between the respective left and right glyphs
 * 4.4 format which needs to scaled with `kern_scale`*/
static int8_t kern_pair_values[] =
{
    -18, -6, -6, -24, -18, -24, -24, -12,
    -24, -6, -6, -6, -35, -35, -18, -12,
    -24, -24, -24, -24, -12, -6, -41, -41,
    -24, -6, -6, -6, -6, -6, -35, -18,
    -35, -35, -35, -24, -6, -35, -35, -35,
    -12, -35, -12, -35, -12, -18, -18, -29,
    -18, -29, -12, -12, -24, -24, -18, -6,
    -18, -12, -12, -12, -18, -6, -18, -6,
    -6, -12, -12, -6, -6, -6, -6, -3,
    -6, -41, -29, -41, -18, -21, -24, -24,
    -29, -12, -29, -24, -29, -18, -18, -6,
    -18, -18, -24, -24, -18, -18, -24, -24,
    -39, -39, 11, -4, 7, -7, -4, -7,
    -25, -14, -11, -25, -7, 4, -7, -4,
    4, 7, -7, -4, -4, -4, -14, -7,
    -4, -7, -14, -11, -4, -4, -4, -7,
    -11, -7, -7, -11, -4, -11, -11, -21,
    -11, -11, -14, -14, -18, -11, -4, -4,
    -11, -4, -4, -11, -4, -39, -39, -21,
    -21, -7, -18, -7, -18, -14, -11, -18,
    -18, -21, -21, -18, -18, -18, -18, -21,
    -18, -21, -18, -18, -18, -21, 4, -7,
    -11, 11, 4, 7, -7, -4, -4, -7,
    -4, 4, 7, 7, 4, -4, -4, -4,
    -4, -4, -4, -7, -4, -4, -7, -4,
    -4, -4, -4, 4, -11, -4, 4, 4,
    -4, -4, 4, 4, 4, 4, 4, -4,
    4, -7, -7, -7, -4, -7, -14, -7,
    -7, -7, -4, -4, -60, -60, -7, -7,
    -21, -21, -4, -7, -18, -4, -7, -4,
    -14, -7, -4, -14, -7, -11, -25, -14,
    -14, -7, -11, -7, -7, -4, -11, -4,
    -7, -11, -11, -18, -11, -11, -4, 4,
    7, -4, -35, -35, -11, -11, 4, -4,
    -7, -14, -11, -7, -14, -14, -18, -14,
    -14, -14, -14, -25, -14, -18, -18, -18,
    -14, -14, -14, -14, -14, -18, -42, -42,
    -7, -7, -21, -14, -7, -11, -11, -11,
    -7, -7, -7, -18, -14, -25, -21, -11,
    -18, -14, -11, -14, -21, -14, -14, -21,
    -14, -14, -21, -14, -14, -14, -14, -14,
    -21, -7, -11, -11, -18, -14, -7, -11,
    -11, -7, -11, -11, -11, -11, -4, -7,
    -7, 7, 4, 7, -11, -7, -7, -11,
    -4, -11, -7, -7, -7, -32, -14, -25,
    -4, -14, -11, -4, -4, -11, -11, -7,
    -11, 4, -11, -4, -4, -11, -14, -7,
    -14, -4, -4, -18, -14, -11, -14, -14,
    -4, -4, -7, -4, -7, -7, -14, -4,
    -4, -7, -14, -7, -4, -7, -4, -11,
    -11, -11, -4, -7, -4, -4, -4, -4,
    -4, -4, -7, -4, -4, -4, -7, -7,
    -4, -14, -11, -4, -39, -39, -7, -14,
    -7, -4, -7, -7, -7, -4, -7, 4,
    -4, -7, -4, -7, -11, -11, -4, -7,
    -11, 4, 4, -4, 7, -4, -7, -4,
    -4, -4, -4, -4, -4, -4, -11, -7,
    7, 7, 4, 4, 4, 4, 4, 4,
    4, 4, 4, -7, -4, -4, 4, -7,
    -4, -4, -7, -7, -4, -4, -7, -7,
    -4, -11, -7, -4, -4, -7, -4, 4,
    4, -4, 4, -35, -35, -4, -11, -4,
    11, -7, -4, -4, 4, -32, -32, -4,
    4, -11, -4, 4, -7, -4, -4, -4,
    -4, -4, -4, -4, -4, -7, -7, -7,
    -4, -7, -4, -4, -4, -4, -4, -4,
    -4, -4, -4, -7, -4, -4, -4, -4,
    -4, -4, 4, -25, -21, -7, 4, -4,
    -7, 4, -7, -4, -4, -7, -4, -7,
    -4, -7, -4, -7, -32, -32
};

/*Collect the kern pair's data in one place*/
static lv_font_fmt_txt_kern_pair_t kern_pairs =
{
    .glyph_ids = kern_pair_glyph_ids,
    .values = kern_pair_values,
    .pair_cnt = 558,
    .glyph_ids_size = 0
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .cmap_num = 5,
    .bpp = 4,

    .kern_scale = 16,
    .kern_dsc = &kern_pairs,
    .kern_classes = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t arial_20 = {
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .line_height = 22,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
};

#endif /*#if ARIAL_20*/

