#include "dev/nullradio.h"
#include "string.h"
/*---------------------------------------------------------------------------*/
/*
 * The maximum number of bytes this driver can accept from the MAC layer for
 * "transmission".
 */
#define MAX_PAYLOAD_LEN ((unsigned short) - 1)
/*---------------------------------------------------------------------------*/
static int
init(void)
{
    return 1;
}
/*---------------------------------------------------------------------------*/
static int
prepare(const void *payload, unsigned short payload_len)
{
    return 0;
}
/*---------------------------------------------------------------------------*/
static int
transmit(unsigned short transmit_len)
{
    return RADIO_TX_OK;
}
/*---------------------------------------------------------------------------*/
static int
send(const void *payload, unsigned short payload_len)
{
    prepare(payload, payload_len);
    return transmit(payload_len);
}
/*---------------------------------------------------------------------------*/
static int
radio_read(void *buf, unsigned short buf_len)
{
    memset(buf, 0, buf_len);
    return buf_len;
}
/*---------------------------------------------------------------------------*/
static int
channel_clear(void)
{
    
    return 1;
}
/*---------------------------------------------------------------------------*/
static int
receiving_packet(void)
{
    return 0;
}
/*---------------------------------------------------------------------------*/
static int
pending_packet(void)
{
    return 0;
}
/*---------------------------------------------------------------------------*/
static int
on(void)
{
    return 1;
}
/*---------------------------------------------------------------------------*/
static int
off(void)
{
    return 1;
}
/*---------------------------------------------------------------------------*/
static radio_result_t
get_value(radio_param_t param, radio_value_t *value)
{
    if (!value) {
        return RADIO_RESULT_INVALID_VALUE;
    }

    switch (param) {
        case RADIO_CONST_MAX_PAYLOAD_LEN:
            *value = (radio_value_t)MAX_PAYLOAD_LEN;
            return RADIO_RESULT_OK;
        default:
            return RADIO_RESULT_NOT_SUPPORTED;
    }
}
/*---------------------------------------------------------------------------*/
static radio_result_t
set_value(radio_param_t param, radio_value_t value)
{
    return RADIO_RESULT_OK;
}
/*---------------------------------------------------------------------------*/
static radio_result_t
get_object(radio_param_t param, void *dest, size_t size)
{
    return RADIO_RESULT_NOT_SUPPORTED;
}
/*---------------------------------------------------------------------------*/
static radio_result_t
set_object(radio_param_t param, const void *src, size_t size)
{
    return RADIO_RESULT_NOT_SUPPORTED;
}
/*---------------------------------------------------------------------------*/
const struct radio_driver nullradio_driver = {
    init,
    prepare,
    transmit,
    send,
    radio_read,
    channel_clear,
    receiving_packet,
    pending_packet,
    on,
    off,
    get_value,
    set_value,
    get_object,
    set_object
};
/*---------------------------------------------------------------------------*/
