# nrf52840: Nordic Semiconductor nRF52840 (nRF5 SDK)

This guide's aim is to help you with using Contiki-NG for 
Nordic Semiconductor's nRF52840 SoC. 

This port supports the PCA10056 (nRF52840-DK) and PCA10059 (nRF52840-DONGLE) boards.

## Port Features

The following features have been implemented:
* Support for the 802.15.4 mode of the radio, including IPv6 using 6LoWPAN
* Support for both TSCH and CSMA
* No dependency on the SoftDevice
* Contiki-NG system clock and rtimers
* UART driver
* Watchdog driver
* RNG driver seeded from the hardware RNG
* Temperature sensor driver
* DK/Dongle LED and Button driver
* Bootloader and DFU upload support
* Real Time Transfer (RTT) I/O support
* Native USB support

Note that this port does not support BLE.

The port is organized as follows:
* nRF52840 CPU drivers are located in the `arch/cpu/nrf52840` folder.
* The nRF52 SDK is located in the `arch/cpu/nrf52840/lib/nrf52-sdk` folder. This will be installed automatically as a git submodule.
* nRF52 DK and Dongle drivers are located in the `arch/platform/nrf52840` folder.

## Prerequisites and Setup

In order to compile for the nRF52840 platforms you'll need:

* An ARM compatible toolchain

The toolchain used to build Contiki-NG is arm-gcc, also used by other arm-based Contiki-NG ports.

If you use the docker image or the vagrant image, this will be pre-installed for you. Otherwise, depending on your system, please follow the respective installation instructions ([native Linux](/doc/getting-started/Toolchain-installation-on-Linux) / [native mac OS](/doc/getting-started/Toolchain-installation-on-macOS)).

* GNU make

* nrfjprog for programming the nRF52840 DK

nrfjprog is supplied as part of the nRF Command Line Tools and can be downloaded from the following link: <br>
https://www.nordicsemi.com/Software-and-tools/Development-Tools/nRF-Command-Line-Tools

* nrfutil for programming the nRF52840 Dongle

nrfutil is available on PyPy: https://pypi.org/project/nrfutil/ <br>
A typical way to install this would be using pip: `pip install nrfutil` or `pip3 install nrfutil`

## Getting Started

Once all tools are installed it is recommended to start by compiling 
and flashing `examples/hello-world` application. This allows to verify 
that toolchain setup is correct.

To compile the example, go to `examples/hello-world` and execute:

    make TARGET=nrf52840

If the compilation is completed without errors flash the board:

    make TARGET=nrf52840 hello-world.upload

## Examples

This target supports all the common IPv6 examples available under the `examples/` folder.

## Compilation Options

The Contiki-NG TARGET name for this port is `nrf52840`, so in order to compile 
an application you need to invoke GNU make as follows:

    make TARGET=nrf52840

In addition to this port supports the following variables which can be
set on the compilation command line:

* `NRF52840_USE_RTT={0|1}`  
  Enables RealTime Terminal I/O. See VCOM and RTT for details.  
  By default, RTT is disabled and IO is done using Virtual COM port.

* `NRF52840_NATIVE_USB={0|1}`  
  Enables the native USB port of the nRF52840 SoC.  
  This will redirect I/O and SLIP to the native USB port (labelled nRF USB on the DK).  
  Using the native USB port provides a performance increase when acting as a border router.  
  By default, this is disabled for `BOARD=dk` and enabled for `BOARD=dongle`.

* `NRF52840_USB_DFU_TRIGGER={0|1}`  
  Enables the Nordic DFU trigger interface to allow for automatic reboot by `nrfutil` to the dongle's bootloader when programming.  
  Only available and enabled by default for `BOARD=dongle`.

* `NRF52_UPLOAD_SN=<serial number>`  
  Allows to choose a particular DK by its serial number (printed on the label).  
  This is useful if you have more than one DK connected to your
  PC and wish to flash a particular device using the `.upload` target. 

* `BOARD={dk|dongle}`  
  Allows to specify if the nRF52840 DK or Dongle is used.  
  Dongle images are built with a bootloader-specific linker file and should be flashed using the `.dfu-upload` target.

## Compilation Targets

Invoking make solely with the `TARGET` variable set will build all
applications in a given folder. A particular application can be built
by invoking make with its name as a compilation target:

    make TARGET=nrf52840 hello-world 

In order to flash the application binary to a single nRF52840 DK board use `<application>.upload`
as make target, e.g.: 

    make TARGET=nrf52840 hello-world.upload

In order to flash the application binary to all attached nRF52840 DK boards use `<application>.upload-all`
as make target, e.g.: 

    make TARGET=nrf52840 hello-world.upload-all

In order to flash the application binary to a single nRF52840 Dongle use `<application>.dfu-upload`
as make target, e.g.: 

    make TARGET=nrf52840 BOARD=dongle hello-world.dfu-upload PORT=/dev/ttyACM0

Where `PORT` is the name of the USB CDC-ACM port that the dongle is on.  
If `NRF52840_USB_DFU_TRIGGER` has not been disabled, the dongle will reboot to bootloader automatically.  
Otherwise the bootloader can be activated by pressing the RESET button once, until the red LED begins to pulse.

Notes when using the nRF dongle: 
* If `NRF52840_NATIVE_USB` is disabled, the serial output from the dongle can be accessed by attaching a USB to Serial converter to pins 0.29 (TX ->) and 0.31 (RX <-).
* If `nrfutil` returns an error such as `LIBUSB_ERROR_ACCESS` when attempting to perform a DFU trigger the following udev rules might be required:
```
## Set /dev/bus/usb/*/* as read-write for all users (0666) for Nordic Semiconductor devices
SUBSYSTEM=="usb", ATTRS{idVendor}=="1915", MODE="0666"
``` 

To remove all build results invoke:

    make TARGET=nrf52840 clean

## Virtual COM and Real Time Transfer

By default, the nRF52840 port uses a Virtual COM port to output logs. Once
the DK is plugged in a `/ttyACM<n>` or `/ttyUSB<n>` device should appear in
your filesystem. A terminal emulator, such as picocom or minicom, can be 
used to connect to the device. Default serial port speed is 115200 bps. 

When using the Virtual COM port, 
USB Mass Storage support must be disabled on the on-board J-Link debugger as it causes issues with serial communication ([#1365](https://github.com/contiki-ng/contiki-ng/issues/1365#issuecomment-1042915533)):

```
$ JLinkExe
J-Link>MSDDisable
J-Link>exit
```

To connect to serial port using picocom invoke:

    picocom -fh -b 115200 --imap lfcrlf /dev/ttyACM0 

In addition to Virtual COM the port supports SEGGER's Real Time Transfer
for low overhead I/O support. This allows for outputting debugging information
at much higher rate with significantly lower overhead than regular I/O.

To compile an application with RTT rather that VCOM set `NRF52840_USE_RTT` to 1 on
the compilation command line:

    make TARGET=nrf52840 NRF52840_USE_RTT=1 hello-world

You can then connect to the device terminal using `JLinkRTTClient`. Note that
a JLlink gdb or commander must be connected to the target for the RTT to work.

More details regarding RTT can be found at https://www.segger.com/jlink-rtt.html

## Support

For bug reports or/and suggestions please open a github issue.

## License

All files in the port are under BSD license. The nRF52 SDK is licensed on a separate terms.

## Resources

* nRF52 Datasheet and SDK documentation (http://infocenter.nordicsemi.com)
* nRF52 SDK Downloads (https://developer.nordicsemi.com/)
* JLink Tools (https://www.segger.com/)
