/*
 * Copyright (c) 2022, sakumisu
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#ifndef USBH_HID_H
#define USBH_HID_H

#include "usb_hid.h"

struct usbh_hid {
    struct usbh_hubport *hport;

    uint8_t report_desc[128];
    uint8_t intf; /* interface number */
    uint8_t minor;
    usbh_pipe_t intin;  /* INTR IN endpoint */
    usbh_pipe_t intout; /* INTR OUT endpoint */
};

#ifdef __cplusplus
extern "C" {
#endif

int usbh_hid_set_idle(struct usbh_hid *hid_class, uint8_t report_id, uint8_t duration);
int usbh_hid_get_idle(struct usbh_hid *hid_class, uint8_t *buffer);

void usbh_hid_run(struct usbh_hid *hid_class);
void usbh_hid_stop(struct usbh_hid *hid_class);

#ifdef __cplusplus
}
#endif

#endif /* USBH_HID_H */
