/**
  **************************************************************************************
  * @file    usbulpi.h
  * @brief   Header file for ULPI access functions.
  * @data    12/21/2018
  * @author  Eastsoft AE Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __ULPI_H__
#define __ULPI_H__

#define ULPI_CFG_HS             0x00000000
#define ULPI_CFG_FS             0x00000001
#define ULPI_CFG_LS             0x00000002
#define ULPI_CFG_AUTORESUME     0x00001000
#define ULPI_CFG_INVVBUSIND     0x00002000
#define ULPI_CFG_PASSTHRUIND    0x00004000
#define ULPI_CFG_EXTVBUSDRV     0x00400000
#define ULPI_CFG_EXTVBUSIND     0x00800000

extern void ulpi_config_set(uint32_t ui32Config);
extern void ulpi_power_transceiver(bool bEnable);

#endif

/******************* (C) COPYRIGHT Eastsoft Microelectronics Co., Ltd. *** END OF FILE ****/
