/**
  **************************************************************************************
  * @file    usbhscsi.h
  * @brief   Definitions for the USB host SCSI layer.
  * @data    11/9/2018
  * @author  Eastsoft AE Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __USBHSCSI_H__
#define __USBHSCSI_H__

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

/** @addtogroup usblib_host_class
  * @{
  */

//*****************************************************************************
//
// Prototypes for the APIs exported by the USB SCSI layer.
//
//*****************************************************************************
extern uint32_t usbhscsi_inquiry(uint32_t ui32InPipe, uint32_t ui32OutPipe,
                                 uint8_t *pui8Buffer, uint32_t *pui32Size);
extern uint32_t usbhscsi_read_capacity(uint32_t ui32InPipe, uint32_t ui32OutPipe,
                                       uint8_t *pui8Data, uint32_t *pui32Size);
extern uint32_t usbhscsi_read_capacities(uint32_t ui32InPipe,
    uint32_t ui32OutPipe, uint8_t *pui8Data,
    uint32_t *pui32Size);
extern uint32_t usbhscsi_mode_sense6(uint32_t ui32InPipe, uint32_t ui32OutPipe,
                                     uint32_t ui32Flags, uint8_t *pui8Data,
                                     uint32_t *pui32Size);
extern uint32_t usbhscsi_test_unit_ready(uint32_t ui32InPipe,
    uint32_t ui32OutPipe);
extern uint32_t usbhscsi_request_sense(uint32_t ui32InPipe, uint32_t ui32OutPipe,
                                       uint8_t *pui8Data, uint32_t *pui32Size);
extern uint32_t usbhscsi_read10(uint32_t ui32InPipe, uint32_t ui32OutPipe,
                                uint32_t ui32LBA, uint8_t *pui8Data,
                                uint32_t *pui32Size, uint32_t ui32NumBlocks);
extern uint32_t usbhscsi_write10(uint32_t ui32InPipe, uint32_t ui32OutPipe,
                                 uint32_t ui32LBA, uint8_t *pui8Data,
                                 uint32_t *pui32Size, uint32_t ui32NumBlocks);

/**
  * @} usblib_host_class
  */

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif

/******************* (C) COPYRIGHT Eastsoft Microelectronics Co., Ltd. *** END OF FILE ****/
