/**
  **************************************************************************************
  * @file    usbhmsc.h
  * @brief   Definitions for the USB MSC host driver.
  * @data    11/9/2018
  * @author  Eastsoft AE Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __USBHMSC_H__
#define __USBHMSC_H__

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

/** @addtogroup usblib_host_class
  * @{
  */

typedef struct tUSBHMSCInstance tUSBHMSCInstance;

//*****************************************************************************
//
// These defines are the the events that will be passed in the \e ui32Event
// parameter of the callback from the driver.
//
//*****************************************************************************
#define MSC_EVENT_OPEN          1
#define MSC_EVENT_CLOSE         2

//*****************************************************************************
//
// The prototype for the USB MSC host driver callback function.
//
//*****************************************************************************
typedef void (*tUSBHMSCCallback)(tUSBHMSCInstance *psMSCInstance,
                                 uint32_t ui32Event,
                                 void *pvEventData);

//*****************************************************************************
//
// Prototypes for the USB MSC host driver APIs.
//
//*****************************************************************************
extern tUSBHMSCInstance *usbhmsc_drive_open(uint32_t ui32Drive,
    tUSBHMSCCallback pfnCallback);
extern void usbhmsc_drive_close(tUSBHMSCInstance *psMSCInstance);
extern int32_t usbhmsc_drive_ready(tUSBHMSCInstance *psMSCInstance);
extern int32_t usbhmsc_block_read(tUSBHMSCInstance *psMSCInstance,
                                  uint32_t ui32LBA, uint8_t *pui8Data,
                                  uint32_t ui32NumBlocks);
extern int32_t usbhmsc_block_write(tUSBHMSCInstance *psMSCInstance,
                                   uint32_t ui32LBA, uint8_t *pui8Data,
                                   uint32_t ui32NumBlocks);
extern uint32_t usbhmsclpm_sleep(tUSBHMSCInstance *psMSCInstance);
extern uint32_t usbhmsclpm_status(tUSBHMSCInstance *psMSCInstance);

/**
  * @} usblib_host_class
  */

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif

/******************* (C) COPYRIGHT Eastsoft Microelectronics Co., Ltd. *** END OF FILE ****/
