/**
  **************************************************************************************
  * @file    usbhhidmouse.h
  * @brief   This file holds the application interfaces for USB mouse devices.
  * @data    11/9/2018
  * @author  Eastsoft AE Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __USBHHIDMOUSE_H__
#define __USBHHIDMOUSE_H__

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

/** @addtogroup usblib_host_class
  * @{
  */

typedef struct tUSBHMouse tUSBHMouse;

//*****************************************************************************
//
// The prototype for the host USB mouse driver callback function.
//
//*****************************************************************************
typedef void (*tUSBHIDMouseCallback)(tUSBHMouse *psMsInstance,
                                     uint32_t ui32Event,
                                     uint32_t ui32MsgParam,
                                     void *pvMsgData);

extern tUSBHMouse *usbh_mouse_open(tUSBHIDMouseCallback pfnCallback,
                                   uint8_t *pui8Buffer, uint32_t ui32Size);
extern uint32_t usbh_mouse_close(tUSBHMouse *psMsInstance);
extern uint32_t usbh_mouse_init(tUSBHMouse *psMsInstance);
extern uint32_t usbh_mouse_lpm_sleep(tUSBHMouse *psMsInstance);
extern uint32_t usbh_mouse_lpm_status(tUSBHMouse *psMsInstance);

/**
  * @} usblib_host_class
  */

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif
