/**
  **************************************************************************************
  * @file    usbhhidkeyboard.h
  * @brief   This file holds the application interfaces for USB keyboard devices.
  * @data    11/9/2018
  * @author  Eastsoft AE Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __USBHHIDKEYBOARD_H__
#define __USBHHIDKEYBOARD_H__

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

/** @addtogroup usblib_host_class
  * @{
  */

typedef struct tUSBHKeyboard tUSBHKeyboard;

//*****************************************************************************
//
// The prototype for the host USB Keyboard driver callback function.
//
//*****************************************************************************
typedef void (*tUSBHIDKeyboardCallback)(tUSBHKeyboard *psKbInstance,
                                        uint32_t ui32Event,
                                        uint32_t ui32MsgParam,
                                        void *pvMsgData);

extern tUSBHKeyboard *usbh_keyboard_open(tUSBHIDKeyboardCallback pfnCallback,
    uint8_t *pui8Buffer,
    uint32_t ui32BufferSize);
extern uint32_t usbh_keyboard_close(tUSBHKeyboard *psKbInstance);
extern uint32_t usbh_keyboard_init(tUSBHKeyboard *psKbInstance);
extern uint32_t usbh_keyboard_modifier_set(tUSBHKeyboard *psKbInstance,
    uint32_t ui32Modifiers);
extern uint32_t usbh_keyboard_poll_rate_set(tUSBHKeyboard *psKbInstance,
    uint32_t ui32PollRate);
extern uint32_t usbh_keyboard_lpm_sleep(tUSBHKeyboard *psKbInstance);
extern uint32_t usbh_keyboard_lpm_status(tUSBHKeyboard *psKbInstance);
extern uint32_t usbh_keyboard_usage_to_char(tUSBHKeyboard *psKbInstance,
    const tHIDKeyboardUsageTable *psTable,
    uint8_t ui8UsageID);

/**
  * @} usblib_host_class
  */

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif

/******************* (C) COPYRIGHT Eastsoft Microelectronics Co., Ltd. *** END OF FILE ****/
