/**
  **************************************************************************************
  * @file    usbhandler.c
  * @brief   General USB handling routines.
  * @data    3/12/2018
  * @author  Eastsoft AE Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

/* Incudes -------------------------------------------------------------------*/
#include <stdbool.h>
#include <stdint.h>
#include "usblib/drivers/usb_lowlayer_api.h"
#include "usblib/drivers/debug.h"
#include "usblib/drivers/type.h"
#include "usblib/usblib.h"
#include "usblib/usblibpriv.h"
#include "usblib/usbulpi.h"
#include "usblib/host/usbhost.h"
#include "usblib/host/usbhostpriv.h"
#include "usblib/host/usbhhub.h"


/** @addtogroup usblib_hcd
  * @{
  */

/* Public functions -----------------------------------------------------------*/

/**
 * @brief  The USB host mode interrupt handler for controller index 0.
 *
 *         This the main USB interrupt handler entry point.  This handler will branch
 *         the interrupt off to the appropriate handlers depending on the current
 *         status of the USB controller.   This function must be placed in the
 *         interrupt table in order for the USB Library host stack to function.
 *
 * @param  None.
 * @retval None.
 */
void
usb_host_int_handler(void)
{
  uint32_t ui32Status;

  //
  // Get the control interrupt status.
  //
  ui32Status = md_usb_hosdev_int_status();

  //
  // Call the internal handler to process the interrupts.
  //
  usb_host_int_handler_internal(0, ui32Status);
}

/**
  * @} usblib_hcd
  */

/******************* (C) COPYRIGHT Eastsoft Microelectronics ***** END OF FILE ****/
