/**
  **************************************************************************************
  * @file    debug.h
  * @brief   Macros for assisting debug of the driver library.
  * @data    12/21/2018
  * @author  Eastsoft AE Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __DRIVERLIB_DEBUG_H__
#define __DRIVERLIB_DEBUG_H__

#include "stdint.h"

//*****************************************************************************
//
// Prototype for the function that is called when an invalid argument is passed
// to an API.  This is only used when doing a DEBUG build.
//
//*****************************************************************************
extern void __error__(char *pcFilename, uint32_t ui32Line);

//*****************************************************************************
//
// The ASSERT macro, which does the actual assertion checking.  Typically, this
// will be for procedure arguments.
//
//*****************************************************************************
#ifdef DEBUG
#define ASSERT(expr) do                                                       \
  {                                                        \
    if(!(expr))                                          \
    {                                                    \
      __error__(__FILE__, __LINE__);                   \
    }                                                    \
  }                                                        \
  while(0)
#else
#define ASSERT(expr)
#endif

#endif

/******************* (C) COPYRIGHT Eastsoft Microelectronics Co., Ltd. *** END OF FILE ****/
