/**
  **************************************************************************************
  * @file    usbhandler.c
  * @brief   General USB handling routines.
  * @data    12/03/2018
  * @author  Eastsoft AE Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

/* Incudes -------------------------------------------------------------------*/
#include <stdbool.h>
#include <stdint.h>
#include "usblib/drivers/usb_lowlayer_api.h"
#include "usblib/drivers/debug.h"
#include "usblib/drivers/type.h"
#include "usblib/usblib.h"
#include "usblib/usblibpriv.h"
#include "usblib/device/usbdevice.h"
#include "usblib/device/usbdevicepriv.h"
#include "usblib/usblibpriv.h"


/** @addtogroup Device_Api
  * @{
  */

/* Public functions -----------------------------------------------------------*/

/**
 * @brief  The USB device interrupt handler.
 *
 *         This the main USB interrupt handler entry point for use in USB device
 *         applications.  This top-level handler will branch the interrupt off to the
 *         appropriate application or stack handlers depending on the current status
 *         of the USB controller.
 *
 *         Applications which operate purely as USB devices (rather than dual mode
 *         applications which can operate in either device or host mode at different
 *         times) must ensure that a pointer to this function is installed in the
 *         interrupt vector table entry for the USB0 interrupt.  For dual mode
 *         operation, the vector should be set to point to \e usb0_dual_mode_int_handler()
 *         instead.
 *
 * @param  None.
 * @retval None.
 */
void
usb_device_int_handler(void)
{
  uint32_t ui32Status;

  //
  // Get the controller interrupt status.
  //
  ui32Status = md_usb_hosdev_int_status();

  //
  // Call the internal handler.
  //
  usb_device_int_handler_internal(0, ui32Status);
}

/**
  * @} Device_Api
  */

/******************* (C) COPYRIGHT Eastsoft Microelectronics Co., Ltd. *** END OF FILE ****/
