#include "es32f0271.h"
#include "md_tick.h"
#include "md_usb.h"
#include "usbcore.h"
#include "usbenum.h"
#include "usbenum_host.h"
#include "usbmsc.h"
#include "mscbldr_host.h"
#include "iap_update.h"
#include "msdhost_fs.h"
//#include "MacRepDef.h"
//#include "GloVarExtDef.h"
#include <stdio.h>

#pragma pack(1)

#define	MSCMSG	1

#define	MSCBULKEP	USBEP1
#define	ESMSCTAG	0x455330CC

extern	_USB_STANDARD_REQUEST	USBRequest;

static	_pMSC_COMMAND_BLOCK				pMSC_CBW;
static	_pMSC_COMMAND_STATUS			pMSC_CSW;

static	uint8_t		u8CBWData[USBH_BULK_PKTSZ];
static	uint8_t		u8CSWData[USBH_BULK_PKTSZ];
static	uint8_t		u8MSCData[USBH_BULK_PKTSZ];
static	uint32_t	u32LBAData[MSC_BLOCK_SZ/4];

static	uint32_t	u32MSCTag=ESMSCTAG;
static	uint8_t		u8MSCMaxLun;

static	uint8_t		u8MSCInEP,u8MSCOutEP;

static	uint32_t	u32IAPAddr,u32IAPSize;

static	uint16_t	u16UpdateName[]=
{
//	'E','S','3','2','F','0','2','7','1','_','v','0','2','0','2','0','1',0,
	'F','I','R','M','W','A','R','E',0,
};
static	uint8_t		u8UpdateExt[]="BIN";

//*****************************************************************************
//!\Brief		Get MAX LUN
//!\Param		pu8MaxLUN	:	Pointer to Max LUN
//!\RetVal	0x0 : No error, 0x1 : Error
//*****************************************************************************
uint8_t	msc_get_max_lun(uint8_t *pu8MaxLUN)			//A1 FE 00 00 XX 00 01 00
{
#if	USBMSG
	printf("GetMaxLUN\r\n");
#endif

	USBRequest.bmRequestType=0xa1;		//Class Specified
	USBRequest.bRequest=MSC_REQ_GET_MAX_LUN;	//GETMAXLUN
	USBRequest.wValue=0;				//wValue
	USBRequest.wIndex=0;				//wIndex
	USBRequest.wLength=1;				//wLength
	
	if (usbh_request_transaction((uint8_t *)&USBRequest,pu8MaxLUN))
		return(1);
	return(0);
}
//*****************************************************************************
//!\Brief	Issue MSC CBW Out
//!\Param	pCBWData	:	Pointer to Command Block Structure
//!\RetVal	0x0 : No error, 0x1 : Error
//*****************************************************************************
uint8_t	msc_issue_cbw_out(_pMSC_COMMAND_BLOCK pCBWData)
{
#if	MSCMSG
	printf("CBW Out-");
#endif
	pCBWData->dSignature=CBW_SIGNATURE;	//Signature
	pCBWData->dTag=u32MSCTag++;						//Tag
	pMSC_CBW->bmFlags=0x80;
	pMSC_CBW->bLUN=0;
	if (usbh_issue_epx_out(MSCBULKEP, sizeof(_MSC_COMMAND_BLOCK), (uint8_t *)pCBWData))
	{
#if	MSCMSG
		printf("Error-\r\n");
#endif
		return(1);
	}
#if	MSCMSG
//	printf("Done\r\n");
#endif
	return(0);
}
//*****************************************************************************
//!\Brief		Issue MSC CSW In
//!\Param		pCSWData	:	Pointer to Command Block Status
//!\RetVal	0x0 : No error, 0x1 : Error
//*****************************************************************************
uint8_t	msc_issue_csw_in(_pMSC_COMMAND_STATUS pCSWData)
{
#if	MSCMSG
	printf("CSW In-");
#endif
	if (usbh_issue_epx_in(MSCBULKEP, sizeof(_MSC_COMMAND_STATUS), (uint8_t *)pCSWData))
	{
#if	MSCMSG
		printf("Error\r\n");
#endif
		return(1);
	}
	if (pCSWData->dSignature!=CSW_SIGNATURE)
	{
#if	MSCMSG
		printf("Error\r\n");
#endif
		return(1);
	}
#if	MSCMSG
//	printf("Done\r\n");
#endif
	return(0);
}
//*****************************************************************************
//!\Brief		Issue MSC Data In
//!\Param		u16BCnt	:	Byte Count for In Transaction
//!\Param		pu8Buf	:	Pointer to uint8_t Data Buffer
//!\RetVal	0x0 : No error, 0x1 : Error
//*****************************************************************************
uint8_t	msc_issue_data_in(uint16_t u16BCnt, uint8_t *pu8Buf)
{
#if	MSCMSG
	printf("Data In-");
#endif
	if (usbh_issue_epx_in(MSCBULKEP, u16BCnt, pu8Buf))
	{
		md_usb_set_index_eptidx(USBEP1);					//Endpoint 1
		if (md_usb_is_active_rxcsrl_stalled())		//STALL
		{
#if	MSCMSG
			printf("Stalled-");
#endif
			usbh_clear_feature(USB_FEATURE_EP_HALT, (u8MSCInEP|0x80));		//clearerr EPHalt for In Endpoint
			md_usb_clear_rxcsrl_stalled();
			return(0);
		}
		else
		{
#if	MSCMSG
			printf("Data Error\r\n");
#endif
			return(1);
		}
	}
#if	MSCMSG
//	printf("Done\r\n");
#endif
	return(0);
}
//*****************************************************************************
//!\Brief		Issue MSC RequestSense
//!\Param		*pu8CBWData	:	CBW Command Data
//!\Param		*pu8CSWData	:	CSW Status Data
//!\Param		*pu8MSCData	:	RequestSense Data In Buffer
//!\RetVal	0x0 : No error, 0x1 : Error
//*****************************************************************************
uint8_t	msc_request_sense_transaction(uint8_t *pu8CBWData, uint8_t *pu8CSWData, uint8_t *pu8MSCData)
{
_pSCSI_REQUEST_SENSE_COMMAND	pSCSIRequestSenseCommand;
_pSCSI_REQUEST_SENSE_DATA			pSCSIRequestSenseData;
uint8_t	ii;
	
#if	MSCMSG
	printf("RequestSense...");
#endif
	pMSC_CBW=(_pMSC_COMMAND_BLOCK)pu8CBWData;
	pMSC_CBW->sDataTransferLength=sizeof(_SCSI_REQUEST_SENSE_DATA);
	pMSC_CBW->bCBLength=sizeof(_SCSI_REQUEST_SENSE_COMMAND);
	for (ii=0;ii<sizeof(pMSC_CBW->CB);ii++)
		pMSC_CBW->CB[ii]=0;
	pSCSIRequestSenseCommand=(_pSCSI_REQUEST_SENSE_COMMAND)pMSC_CBW->CB;
	pSCSIRequestSenseCommand->OPCode=SCSI_REQUEST_SENSE;
	pSCSIRequestSenseCommand->LUN=0;
	pSCSIRequestSenseCommand->AllocationLength=sizeof(_SCSI_REQUEST_SENSE_DATA);
	if (msc_issue_cbw_out(pMSC_CBW))
		return(1);
	if (msc_issue_data_in(sizeof(_SCSI_REQUEST_SENSE_DATA), (uint8_t *)pu8MSCData))
	{
#if	MSCMSG
			printf("Data Error\r\n");
#endif
			return(1);
	}
	pMSC_CSW=(_pMSC_COMMAND_STATUS)pu8CSWData;
	if (msc_issue_csw_in(pMSC_CSW))
		return(1);
#if	MSCMSG
	printf("Done\r\n");
#endif
	return(0);
}
//*****************************************************************************
//!\Brief		Issue MSC TestUnitReady
//!\Param		*pu8CBWData	:	CBW Command Data
//!\Param		*pu8CSWData	:	CSW Status Data
//!\Param		*pu8MSCData	:	Inquiry Data In Buffer
//!\RetVal	0x0 : No error, 0x1 : Error
//*****************************************************************************
uint8_t	msc_test_unit_ready_transaction(uint8_t *pu8CBWData, uint8_t *pu8CSWData, uint8_t *pu8MSCData)
{
_pSCSI_TEST_UNIT_READY_COMMAND	pSCSITestUnitReadyCommand;
uint8_t	ii;
	
#if	MSCMSG
	printf("Inquiry...");
#endif
	pMSC_CBW=(_pMSC_COMMAND_BLOCK)pu8CBWData;
	pMSC_CBW->sDataTransferLength=0;
	pMSC_CBW->bCBLength=sizeof(_SCSI_TEST_UNIT_READY_COMMAND);
	for (ii=0;ii<sizeof(pMSC_CBW->CB);ii++)
		pMSC_CBW->CB[ii]=0;
	pSCSITestUnitReadyCommand=(_pSCSI_TEST_UNIT_READY_COMMAND)pMSC_CBW->CB;
	pSCSITestUnitReadyCommand->OPCode=SCSI_TEST_UNIT_READY;
	pSCSITestUnitReadyCommand->LUN=0;
	if (msc_issue_cbw_out(pMSC_CBW))
	{
#if	MSCMSG
		printf("CBW Error\r\n");
#endif
		return(1);
	}
	pMSC_CSW=(_pMSC_COMMAND_STATUS)pu8CSWData;
	if (msc_issue_csw_in(pMSC_CSW))
	{
#if	MSCMSG
		printf("CSW Error\r\n");
#endif
		return(1);
	}
	if (pMSC_CSW->bStatus!=CSW_STATUS_SUCCESS)
	{
		if (msc_request_sense_transaction(pu8CBWData, pu8CSWData, pu8MSCData))
			return(1);
	}
#if	MSCMSG
	printf("Done\r\n");
#endif
	return(0);
}
//*****************************************************************************
//!\Brief		Issue MSC Inquiry
//!\Param		*pu8CBWData	:	CBW Command Data
//!\Param		*pu8CSWData	:	CSW Status Data
//!\Param		*pu8MSCData	:	Inquiry Data In Buffer
//!\RetVal	0x0 : No error, 0x1 : Error
//*****************************************************************************
uint8_t	msc_inquiry_transaction(uint8_t *pu8CBWData, uint8_t *pu8CSWData, uint8_t *pu8MSCData)
{
_pSCSI_INQUIRY_COMMAND	pSCSIInquiryCommand;
_pSCSI_INQUIRY_DATA			pSCSIInquiryData;
uint8_t	ii;
	
#if	MSCMSG
	printf("Inquiry...");
#endif
	pMSC_CBW=(_pMSC_COMMAND_BLOCK)pu8CBWData;
	pMSC_CBW->sDataTransferLength=sizeof(_SCSI_INQUIRY_DATA);
	pMSC_CBW->bCBLength=sizeof(_SCSI_INQUIRY_COMMAND);
	for (ii=0;ii<sizeof(pMSC_CBW->CB);ii++)
		pMSC_CBW->CB[ii]=0;
	pSCSIInquiryCommand=(_pSCSI_INQUIRY_COMMAND)pMSC_CBW->CB;
	pSCSIInquiryCommand->OPCode=SCSI_INQUIRY;
	pSCSIInquiryCommand->LUN_EVPD=0;
	pSCSIInquiryCommand->Res0=0;
	pSCSIInquiryCommand->AllocationLength=sizeof(_SCSI_INQUIRY_DATA);
	if (msc_issue_cbw_out(pMSC_CBW))
	{
#if	MSCMSG
		printf("CBW Error\r\n");
#endif
		return(1);
	}
	if (msc_issue_data_in(sizeof(_SCSI_INQUIRY_DATA), (uint8_t *)pu8MSCData))
	{
#if	MSCMSG
		printf("Data Error\r\n");
#endif
		return(1);
	}
	pSCSIInquiryData=(_pSCSI_INQUIRY_DATA)pu8MSCData;
	pMSC_CSW=(_pMSC_COMMAND_STATUS)pu8CSWData;
	if (msc_issue_csw_in(pMSC_CSW))
	{
#if	MSCMSG
		printf("CSW Error\r\n");
#endif
		return(1);
	}
	if (pMSC_CSW->bStatus!=CSW_STATUS_SUCCESS)
	{
		if (msc_request_sense_transaction(pu8CBWData, pu8CSWData, pu8MSCData))
			return(1);
	}
#if	MSCMSG
	printf("Done\r\n");
#endif
	return(0);
}
//*****************************************************************************
//!\Brief		Issue MSC ReadFormatCapacities
//!\Param		*pu8CBWData	:	CBW Command Data
//!\Param		*pu8CSWData	:	CSW Status Data
//!\Param		*pu8MSCData	:	ReadFormatCapacities Data In Buffer
//!\RetVal	0x0 : No error, 0x1 : Error
//*****************************************************************************
uint8_t	msc_read_format_capacities_transaction(uint8_t *pu8CBWData, uint8_t *pu8CSWData, uint8_t *pu8MSCData)
{
_pSCSI_READ_FORMAT_CAPACITIES_COMMAND	pSCSIReadFormatCapacitiesCommand;
//_pSCSIREADFORMATCAPACITIESDATA			pSCSIReadFormatCapacitiesData;
uint8_t	ii;
	
#if	MSCMSG
	printf("ReadFormatCapacities...");
#endif
	pMSC_CBW=(_pMSC_COMMAND_BLOCK)pu8CBWData;
	pMSC_CBW->sDataTransferLength=sizeof(_SCSI_CAPACITY_LIST_HEADER)+sizeof(_SCSI_CAPACITY_DESCRIPTOR);
	pMSC_CBW->bCBLength=sizeof(_SCSI_READ_FORMAT_CAPACITIES_COMMAND);
	for (ii=0;ii<sizeof(pMSC_CBW->CB);ii++)
		pMSC_CBW->CB[ii]=0;
	pSCSIReadFormatCapacitiesCommand=(_pSCSI_READ_FORMAT_CAPACITIES_COMMAND)pMSC_CBW->CB;
	pSCSIReadFormatCapacitiesCommand->OPCode=SCSI_READ_FORMAT_CAPACITIES;
	pSCSIReadFormatCapacitiesCommand->LUN=0;
	pSCSIReadFormatCapacitiesCommand->AllocationLength1=(pMSC_CBW->sDataTransferLength>>8)&0xff;
	pSCSIReadFormatCapacitiesCommand->AllocationLength0=(pMSC_CBW->sDataTransferLength>>0)&0xff;
	if (msc_issue_cbw_out(pMSC_CBW))
		return(1);
	if (msc_issue_data_in(sizeof(_SCSI_CAPACITY_LIST_HEADER)+sizeof(_SCSI_CAPACITY_DESCRIPTOR), (uint8_t *)pu8MSCData))
	{
#if	MSCMSG
			printf("Data Error\r\n");
#endif
			return(1);
	}
	pMSC_CSW=(_pMSC_COMMAND_STATUS)pu8CSWData;
	if (msc_issue_csw_in(pMSC_CSW))
		return(1);
	if (pMSC_CSW->bStatus!=CSW_STATUS_SUCCESS)
	{
		if (msc_request_sense_transaction(pu8CBWData, pu8CSWData, pu8MSCData))
			return(1);
	}
#if	MSCMSG
	printf("Done\r\n");
#endif
	return(0);
}
//*****************************************************************************
//!\Brief		Issue MSC ReadCapacity
//!\Param		*pu8CBWData	:	CBW Command Data
//!\Param		*pu8CSWData	:	CSW Status Data
//!\Param		*pu8MSCData	:	ReadCapacity Data In Buffer
//!\RetVal	0x0 : No error, 0x1 : Error
//*****************************************************************************
uint8_t	msc_read_capacity_transaction(uint8_t *pu8CBWData, uint8_t *pu8CSWData, uint8_t *pu8MSCData)
{
_pSCSI_READ_CAPACITY_COMMAND	pSCSIReadCapacityCommand;
_pSCSI_READ_CAPACITY_DATA			pSCSIReadCapacityData;
uint8_t	ii;
	
#if	MSCMSG
	printf("ReadCapacity...");
#endif
	pMSC_CBW=(_pMSC_COMMAND_BLOCK)pu8CBWData;
	pMSC_CBW->sDataTransferLength=sizeof(_SCSI_READ_CAPACITY_DATA);
	pMSC_CBW->bCBLength=sizeof(_SCSI_READ_CAPACITY_COMMAND);
	for (ii=0;ii<sizeof(pMSC_CBW->CB);ii++)
		pMSC_CBW->CB[ii]=0;
	pSCSIReadCapacityCommand=(_pSCSI_READ_CAPACITY_COMMAND)pMSC_CBW->CB;
	pSCSIReadCapacityCommand->OPCode=SCSI_READ_CAPACITY;
	pSCSIReadCapacityCommand->LUN_RelAdr=0;
	pSCSIReadCapacityCommand->LBA3=0;
	pSCSIReadCapacityCommand->LBA2=0;
	pSCSIReadCapacityCommand->LBA1=0;
	pSCSIReadCapacityCommand->LBA0=0;
	pSCSIReadCapacityCommand->PMI=0;
	if (msc_issue_cbw_out(pMSC_CBW))
		return(1);
	if (msc_issue_data_in(sizeof(_SCSI_READ_CAPACITY_DATA), (uint8_t *)pu8MSCData))
	{
#if	MSCMSG
			printf("Data Error\r\n");
#endif
			return(1);
	}
	pMSC_CSW=(_pMSC_COMMAND_STATUS)pu8CSWData;
	if (msc_issue_csw_in(pMSC_CSW))
		return(1);
	if (pMSC_CSW->bStatus!=CSW_STATUS_SUCCESS)
	{
		if (msc_request_sense_transaction(pu8CBWData, pu8CSWData, pu8MSCData))
			return(1);
	}
#if	MSCMSG
	printf("Done\r\n");
#endif
	return(0);
}
//*****************************************************************************
//!\Brief		Issue MSC ModeSense6
//!\Param		*pu8CBWData	:	CBW Command Data
//!\Param		*pu8CSWData	:	CSW Status Data
//!\Param		*pu8MSCData	:	ModeSense6 Data In Buffer
//!\RetVal	0x0 : No error, 0x1 : Error
//*****************************************************************************
uint8_t	msc_mode_sense_6_transaction(uint8_t *pu8CBWData, uint8_t *pu8CSWData, uint8_t *pu8MSCData)
{
_pSCSI_MODE_SENSE_6_COMMAND		pSCSIModeSense6Command;
_pSCSI_MODE_SENSE_6_DATA			pSCSIModeSense6Data;
uint8_t	ii;
	
#if	MSCMSG
	printf("ModeSense6...");
#endif
	pMSC_CBW=(_pMSC_COMMAND_BLOCK)pu8CBWData;
	pMSC_CBW->sDataTransferLength=0xc0;
	pMSC_CBW->bCBLength=sizeof(_SCSI_MODE_SENSE_6_COMMAND);
	for (ii=0;ii<sizeof(pMSC_CBW->CB);ii++)
		pMSC_CBW->CB[ii]=0;
	pSCSIModeSense6Command=(_pSCSI_MODE_SENSE_6_COMMAND)pMSC_CBW->CB;
	pSCSIModeSense6Command->OPCode=SCSI_MODE_SENSE_6;
	pSCSIModeSense6Command->LUN_DBD=0;
	pSCSIModeSense6Command->PC_PageCode=0x1c;
	pSCSIModeSense6Command->AllocationLength=0x1c;
	if (msc_issue_cbw_out(pMSC_CBW))
		return(1);
	if (msc_issue_data_in(sizeof(_SCSI_MODE_SENSE_6_DATA), (uint8_t *)pu8MSCData))
	{
#if	MSCMSG
			printf("Data Error\r\n");
#endif
			return(1);
	}
	pMSC_CSW=(_pMSC_COMMAND_STATUS)pu8CSWData;
	if (msc_issue_csw_in(pMSC_CSW))
		return(1);
	if (pMSC_CSW->bStatus!=CSW_STATUS_SUCCESS)
	{
		if (msc_request_sense_transaction(pu8CBWData, pu8CSWData, pu8MSCData))
			return(1);
	}
#if	MSCMSG
	printf("Done\r\n");
#endif
	return(0);
}
//*****************************************************************************
//!\Brief		Issue MSC Read10
//!\Param		*pu8CBWData	:	CBW Command Data
//!\Param		*pu8CSWData	:	CSW Status Data
//!\Param		*pu8MSCData	:	Read10 Data In Buffer
//!\RetVal	0x0 : No error, 0x1 : Error
//*****************************************************************************
uint8_t	msc_read_10_transaction(uint8_t *pu8CBWData, uint8_t *pu8CSWData, uint8_t *pu8MSCData)
{
_pSCSI_READ_10_COMMAND	pSCSIRead10Command;
uint8_t	ii;
	
#if	MSCMSG
	printf("Read10...");
#endif
	pMSC_CBW=(_pMSC_COMMAND_BLOCK)pu8CBWData;
	pMSC_CBW->sDataTransferLength=0x200;
	pMSC_CBW->bCBLength=sizeof(_SCSI_READ_10_COMMAND);
	for (ii=0;ii<sizeof(pMSC_CBW->CB);ii++)
		pMSC_CBW->CB[ii]=0;
	pSCSIRead10Command=(_pSCSI_READ_10_COMMAND)pMSC_CBW->CB;
	pSCSIRead10Command->OPCode=SCSI_READ_10;
	if (msc_issue_cbw_out(pMSC_CBW))
		return(1);
	pMSC_CSW=(_pMSC_COMMAND_STATUS)pu8CSWData;
	if (msc_issue_csw_in(pMSC_CSW))
		return(1);
	if (pMSC_CSW->bStatus!=CSW_STATUS_SUCCESS)
	{
		if (msc_request_sense_transaction(pu8CBWData, pu8CSWData, pu8MSCData))
			return(1);
	}
#if	MSCMSG
	printf("Done\r\n");
#endif
	return(0);
}
//*****************************************************************************
//!\Brief		MSC Read Bulk
//!\Param		u32LBAIndex	:	LBA Index
//!\Param		u8LBACnt		:	Count of LBA
//!\Param		*pu8LBABuf	:	Data Buffer to Read
//!\RetVal	0x0 : No error, 0x1 : Error
//*****************************************************************************
uint8_t	msc_read_lba(uint32_t u32LBAIndex, uint8_t u8LBACnt, uint8_t *pu8LBABuf)
{
_pSCSI_READ_10_COMMAND	pSCSIRead10Command;
uint8_t	ii;
	
#if	MSCMSG
	printf("LBA=0x%x, Count=1\r\n",u32LBAIndex);
#endif
	pMSC_CBW=(_pMSC_COMMAND_BLOCK)u8CBWData;
	pMSC_CBW->sDataTransferLength=MSC_BLOCK_SZ;
	pMSC_CBW->bCBLength=sizeof(_SCSI_READ_10_COMMAND);
	for (ii=0;ii<sizeof(pMSC_CBW->CB);ii++)
		pMSC_CBW->CB[ii]=0;
	pSCSIRead10Command=(_pSCSI_READ_10_COMMAND)pMSC_CBW->CB;
	pSCSIRead10Command->OPCode=SCSI_READ_10;
	pSCSIRead10Command->LUN_RelAdr=0;
	pSCSIRead10Command->LBA3=(u32LBAIndex>>24)&0xff;
	pSCSIRead10Command->LBA2=(u32LBAIndex>>16)&0xff;
	pSCSIRead10Command->LBA1=(u32LBAIndex>>8)&0xff;
	pSCSIRead10Command->LBA0=(u32LBAIndex>>0)&0xff;
	pSCSIRead10Command->TransferLength0=u8LBACnt;
	if (msc_issue_cbw_out(pMSC_CBW))
		return(1);
	pMSC_CSW=(_pMSC_COMMAND_STATUS)u8CSWData;
	if (msc_issue_data_in(MSC_BLOCK_SZ, pu8LBABuf))
	{
#if	MSCMSG
		printf("Data Error\r\n");
#endif
		return(1);
	}
	if (msc_issue_csw_in(pMSC_CSW))
		return(1);
	if (pMSC_CSW->bStatus!=CSW_STATUS_SUCCESS)
	{
		if (msc_request_sense_transaction(u8CBWData, u8CSWData, u8MSCData))
			return(1);
	}
#if	MSCMSG
	printf("Done\r\n");
#endif
	return(0);
}
//*****************************************************************************
//!\Brief	USB Host Configuration
//!\Param	None
//!\RetVal	None
//*****************************************************************************
void	msc_host_ep_config()
{
//Configure EP1 Rx
	md_usb_set_index_eptidx(USBEP1);				//Endpoint 1
	md_usb_set_rxtype_protocol(MD_USB_TYPE_PROTOCOL_BULK);	//Bulk In, Mapping to EP0
	md_usb_set_rxmaxp_maxsize(USBH_BULK_PKTSZ/8);		//64 Bytes
	md_usb_set_rxfifo1_addrl(0x08);	//Start Address=0x08
	md_usb_set_rxfifo2_maxpktsize(MD_USB_FIFO2_MAXPKTSIZE_64);	 //Size=64, No Double-Packet Buffering
	md_usb_enable_rxcsrl_flush();	//Flush FIFO
//Configure EP1 Tx
	md_usb_set_index_eptidx(USBEP1);				//Endpoint 1
	md_usb_set_txtype_protocol(MD_USB_TYPE_PROTOCOL_BULK);	//Bulk Out, Mapping to EP0
	md_usb_set_txmaxp_maxsize(USBH_BULK_PKTSZ/8);		//64 Bytes
	md_usb_set_txfifo1_addrl(0x10);			//Start Address=0x10
	md_usb_set_txfifo2_maxpktsize(MD_USB_FIFO2_MAXPKTSIZE_64);	 //Size=64, No Double-Packet Buffering
	md_usb_enable_txcsrl_flush();	//Flush FIFO

//Initial MUSB
	md_usb_enable_txier_ep0ie();	//Interrupt Enable for EP0 Control
	md_usb_enable_txier_ep1ie();	//Interrupt Enable for EP1 Tx
	md_usb_enable_txier_ep1ie();		//Interrupt Enable for EP1 Rx
	md_usb_enable_ier_conie();			//Interrupt Enable for Connect
	md_usb_enable_ier_disconie();		//Interrupt Enable for Disconnect
					  
#if	USBMSG
	printf("MSC Config Done\r\n");
#endif
}
//*****************************************************************************
//!\Brief		MSC Enumeration
//!\Param		*pu8EnumBuf	:	Data Buffer for Enumeration
//!\RetVal	0x0 : No error, 0x1 : Error
//*****************************************************************************
uint8_t	msc_host_enum(uint8_t *pu8EnumBuf)
{
_pUSB_CONFIGURATION_DESC	pConfigurationDesc;
_pUSB_INTERFACE_DESC			pInterfaceDesc;
_pUSB_ENDPOINT_DESC				pEndpointDesc;
uint16_t	u16TotalConfigLen;
uint8_t		u8Config;

#if	MSCMSG
	printf("MSC Enumeration...\r\n");
#endif
	u8MSCInEP=0;
	u8MSCOutEP=0;
	pu8EnumBuf+=sizeof(_USB_DEVICE_DESC);		//Skip Device Descriptor
	pConfigurationDesc=(_pUSB_CONFIGURATION_DESC)pu8EnumBuf;
	u8Config=pConfigurationDesc->bConfigurationValue;
	u16TotalConfigLen=pConfigurationDesc->wTotalLength;
	u16TotalConfigLen-=*pu8EnumBuf;
	while (u16TotalConfigLen)
	{
		pu8EnumBuf+=*pu8EnumBuf;		//Skip bLength
		u16TotalConfigLen-=*pu8EnumBuf;
		if (*(pu8EnumBuf+1)==USB_DTYPE_INTERFACE)	//Interface Descriptor
    {
      pInterfaceDesc=(_pUSB_INTERFACE_DESC)pu8EnumBuf;
			continue;
    }
		if (*(pu8EnumBuf+1)!=USB_DTYPE_ENDPOINT)	//Not Endpoint Descriptor
			continue;
		pEndpointDesc=(_pUSB_ENDPOINT_DESC)pu8EnumBuf;
		if (pEndpointDesc->bmAttribute!=USB_EP_ATTR_BULK)		//Not Bulk Endpoint
			continue;
		if (pEndpointDesc->bEndpointAddress&0x80)	//In EP
		{
			printf("Bulk In EP=0x%x\r\n",pEndpointDesc->bEndpointAddress);
      u8MSCInEP=(pEndpointDesc->bEndpointAddress&0x7f);	//Endpoint x
		}
		else																			//Out EP
		{
			printf("Bulk Out EP=0x%x\r\n",pEndpointDesc->bEndpointAddress);
      u8MSCOutEP=(pEndpointDesc->bEndpointAddress);	//Endpoint x
		}
	}
  if (pInterfaceDesc->bInterfaceClass!=USB_CLASS_MSD)
	{
		printf("Not MSD Device\r\n");
		return(1);
	}
	if (u8MSCInEP==0)
	{
		printf("Can't Find Bulk In Endpoint\r\n");
		return(1);
	}
	if (u8MSCOutEP==0)
	{
		printf("Can't Find Bulk Out Endpoint\r\n");
		return(1);
	}
	md_usb_set_index_eptidx(USBEP1);			//Endpoint x
	md_usb_set_rxtype_tepn(u8MSCInEP);		//Mapping to BULKInEP
  md_usb_set_txtype_tepn(u8MSCOutEP);		//Mapping to BulkOutEP
	usbh_set_configuration(u8Config);
	if (msc_get_max_lun(&u8MSCMaxLun))
		return(1);
	if (msc_request_sense_transaction(u8CBWData, u8CSWData, u8MSCData))
		return(1);
	if (msc_inquiry_transaction(u8CBWData, u8CSWData, u8MSCData))
		return(1);
//	if (msc_read_format_capacities_transaction(u8CBWData, u8CSWData, u8MSCData))
//		return(1);
	if (msc_read_capacity_transaction(u8CBWData, u8CSWData, u8MSCData))
		return(1);
//	if (msc_mode_sense_6_transaction(u8CBWData, u8CSWData, u8MSCData))
//		return(1);
//	if (msc_request_sense_transaction(u8CBWData, u8CSWData, u8MSCData))
//		return(1);
	if (msc_test_unit_ready_transaction(u8CBWData, u8CSWData, u8MSCData))
		return(1);
#if	MSCMSG
	printf("MSC Enumeration Done\r\n");
#endif
	return(0);
}
//*****************************************************************************
//!\Brief		MSC Progam Application
//!\Param		None
//!\RetVal	0:No error, 1:Error
//*****************************************************************************
uint8_t	msc_host_app_programn()
{
uint32_t	u32Cluster,u32Sector;
uint32_t	u32APPStart,u32FileSize;
uint8_t		u8Index;
	
	if (fshost_enumeration())
	{
#if	MSCMSG
		printf("FAT Enumeration Fail\r\n");
#endif
		return(1);		
	}
	if (fshost_app_identify(u16UpdateName,u8UpdateExt))
	{
#if	MSCMSG
		printf("Filename Mismatch\r\n");
#endif
		return(1);		
	}
	iap_flash_info(&u32IAPAddr,&u32IAPSize);
	if (fshost_app_info(&u32Cluster,&u32FileSize))
	{
#if	MSCMSG
		printf("App Info Error\r\n");
#endif
		return(1);		
	}
	if (u32FileSize>u32IAPSize)
	{
#if	MSCMSG
		printf("App Size Error\r\n");
#endif
		return(1);		
	}
	u32APPStart=u32IAPAddr;
	u32IAPSize=u32FileSize;
#if	MSCMSG
	printf("Start updating!!!Don't remove U-Disk\r\n");
	printf("E-0x%x-0x%x\r\n",u32APPStart,u32IAPSize);
#endif
	iap_flash_erase(u32IAPAddr,u32IAPSize);
	u8Index=0;
	while (u32FileSize)
	{
		if ((u32Sector=fshost_app_sector(&u32Cluster,&u8Index))==0)
		{
#if	MSCMSG
			printf("App Get Sector Error\r\n");
#endif
			return(1);
		}
		if (msc_read_lba(u32Sector,1,(uint8_t *)u32LBAData))
			return(1);
#if	MSCMSG
		printf("S-0x%x-",u32Sector);
		printf("P-0x%x-",u32APPStart);
#endif
		if (u32FileSize>=MSC_BLOCK_SZ)
		{
			if (iap_flash_program(u32APPStart,MSC_BLOCK_SZ,u32LBAData))
				return(1);
#if	MSCMSG
			printf("0x%x\r\n",u32FileSize);
#endif
			u32APPStart+=MSC_BLOCK_SZ;
			u32FileSize-=MSC_BLOCK_SZ;
		}
		else
		{
			if (iap_flash_program(u32APPStart,u32FileSize,u32LBAData))
				return(1);
#if	MSCMSG
			printf("0x%x\r\n",u32FileSize);
#endif
			u32FileSize=0;
		}
	}
#if	MSCMSG
	printf("Update Complete\r\n");
#endif
	return(0);
}
