#ifndef	_USBENUM_DEV_H
#define	_USBENUM_DEV_H

#pragma pack(1)

//IP reg constants.This offset is actual register address.

typedef	struct	_CUSTOM_DESCRIPTOR_PARA_
{
	uint8_t		*pu8CtrlBurstData;
	uint16_t	u16CtrlBurstLeng;
}_CUSTOM_DESCRIPTOR_PARA, *_pCUSTOM_DESCRIPTOR_PARA;


//Event Task
typedef	enum
{
	USBD_EVENT_IDLE 	=0x0,
	USBD_EVENT_SETUP,
	USBD_EVENT_CTRLIN,
	USBD_EVENT_CTRLOUT,
	USBD_EVENT_STATUS,
	USBD_EVENT_STALL	=0x8,
	USBD_EVENT_EP1IN	=0x11,
	USBD_EVENT_EP1OUT,
	USBD_EVENT_EP2IN,
	USBD_EVENT_EP2OUT,
	USBD_EVENT_EP3IN,
	USBD_EVENT_EP3OUT,
	USBD_EVENT_EP4IN,
	USBD_EVENT_EP4OUT,
	USBD_EVENT_EP5IN,
	USBD_EVENT_EP5OUT,
	USBD_EVENT_EP6IN,
	USBD_EVENT_EP6OUT,
	USBD_EVENT_RESET	=0x31,
	USBD_EVENT_SUSPEND,
	USBD_EVENT_RESUME,
	USBD_EVENT_VENDOR	=0x80,
}eUSBDEvent;

//Functional Declaration
eUSBDEvent	usbd_event_handler(eUSBDEvent);
eUSBDEvent	usbd_handle_ctrl_in(void);
eUSBDEvent	usbd_handle_ctrl_out(uint16_t *, uint8_t *);
eUSBDEvent	usbd_handle_epx_in(uint8_t, uint16_t, uint8_t *);
eUSBDEvent	usbd_handle_epx_out(uint8_t, uint16_t *, uint8_t *);

#endif	//_USBENUM_DEV_H
