#include "es32f0271.h"
#include "md_usb.h"
#include "usbcore.h"
#include "usbenum.h"
#include "usbenum_dev.h"
#include <stdio.h>

#pragma pack(1)
#define	ENUMMSG	1

#define	pUSBEPFIFO(x)	((uint8_t *)&USBD->EP0FIFO+(x*4))

extern	_USB_STANDARD_REQUEST	USBRequest;
extern	uint8_t		*custom_descriptor_para(uint16_t,_pCUSTOM_DESCRIPTOR_PARA);
extern	uint32_t	u32IntrStatus;

static	_CUSTOM_DESCRIPTOR_PARA	CustomDescPara;
static	uint8_t		bDev_Config=0,bEP_Idle=0,bEP_Halt=0,bDev_RWake=0;

uint8_t	(*pCustomGetDescriptor)(uint16_t, _pCUSTOM_DESCRIPTOR_PARA);

//*****************************************************************************
//!\Brief	USB Endpoint In
//!\Param	u8EPx		:	Endpoint Index
//!\Param	u16BCnt	:	Byte Count to Send
//!\Param	*pu8Buf	:	Data Buffer to Write
//!\RetVal	Idle State
//*****************************************************************************
eUSBDEvent	usbd_handle_epx_in(uint8_t u8EPx, uint16_t u16BCnt, uint8_t *pu8Buf)
{
	md_usb_set_index_eptidx(u8EPx);			//Endpoint x
	while (md_usb_is_enabled_txcsrl_txrdy());	//Wait TXPKTRDY=0
	while (u16BCnt--)
		*pUSBEPFIFO(u8EPx)=*pu8Buf++;
	md_usb_set_index_eptidx(u8EPx);			//Endpoint x
	md_usb_enable_txcsrl_txrdy();		//TXRDY
	return(USBD_EVENT_IDLE);
}
//*****************************************************************************
//!\Brief	USB Endpoint Out
//!\Param	u8EPx		:	Endpoint Index
//!\Param	*pu16BCnt	:	Pointer to Rx Byte Count
//!\Param	*pu8Buf	:	Data Buffer to Write
//!\RetVal	Idle State
//*****************************************************************************
eUSBDEvent	usbd_handle_epx_out(uint8_t u8EPx, uint16_t *pu16BCnt, uint8_t *pu8Buf)
{
	md_usb_set_index_eptidx(u8EPx);			//Endpoint x
	*pu16BCnt=md_usb_get_count0_rx1();
	while (md_usb_get_count0_rx1())
		*pu8Buf++=*pUSBEPFIFO(u8EPx);
	md_usb_set_index_eptidx(u8EPx);			//Endpoint x
	md_usb_clear_rxcsrl_rxrdy();				//Clear RXRDY
	return(USBD_EVENT_IDLE);
}
//*****************************************************************************
//!\Brief	USB Device Control Out
//!\Param	*pu16BCnt	:	Pointer of Byte Count to Receive
//!\Param	*pu8Buf	:	Data Buffer to Receive Data
//!\RetVal	Idle State
//*****************************************************************************
eUSBDEvent	usbd_handle_ctrl_out(uint16_t *pu16BCnt, uint8_t *pu8Buf)
{
	md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
	*pu16BCnt=md_usb_get_count0_count();
	while (md_usb_get_count0_count())		//Rx Length
		*pu8Buf++=md_usb_get_ep0fifo();
	if (*pu16BCnt>USBD_CTRL_PKTSZ)			//More Packets to Receive
		md_usb_enable_csr0l_rxrdyc();			//Serviced RxPktRdy
	else
		md_usb_set_csr0l_txcsrl(USB_CSR0L_DATAEND_MSK|USB_CSR0L_RXRDYC_MSK);	//Serviced RxPktRdy, DataEnd
	return(USBD_EVENT_IDLE);
}
//*****************************************************************************
//!\Brief	USB Device Control In
//!\Param	BCnt	:	None
//!\RetVal	Control In State if There are More Packets, Idle State if There is No Packets
//*****************************************************************************
eUSBDEvent	usbd_handle_ctrl_in()
{
uint8_t	u8Dlen;
	
	if (CustomDescPara.u16CtrlBurstLeng>=USBD_CTRL_PKTSZ)	//More Packets to Be Transferred
	{
		md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
		while (md_usb_is_enabled_csr0l_txrdy());	//Wait TXPKTRDY=0
		u8Dlen=USBD_CTRL_PKTSZ;
		while (u8Dlen--)
			md_usb_set_ep0fifo(*CustomDescPara.pu8CtrlBurstData++);
		md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
		md_usb_enable_csr0l_txrdy();	//TXPKTRDY
		return(USBD_EVENT_CTRLIN);
	}
	else	//The Last Data Packet or Zero Data Packet
	{
		md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
		while (md_usb_is_enabled_csr0l_txrdy());	//Wait TXPKTRDY=0
		u8Dlen=CustomDescPara.u16CtrlBurstLeng;
		while (u8Dlen--)
			md_usb_set_ep0fifo(*CustomDescPara.pu8CtrlBurstData++);
		md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
		md_usb_set_csr0l_txcsrl(USB_CSR0L_DATAEND_MSK|USB_CSR0L_TXRDY_MSK);		//DATAEND & TXRDY
		return(USBD_EVENT_IDLE);
	}
}
//Stand Device Request
//Clear Feature
eUSBDEvent	usbd_req_clear_feature(_pUSB_STANDARD_REQUEST	pUSBRequest)		//[00 01 02] 01 XX 00 XX 00 00 00
{
#if	ENUMMSG
	printf("ClearFeature\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB_CSR0L_RXRDYC_MSK|USB_CSR0L_DATAEND_MSK);	//Serviced RxPktRdy & Dataend
	switch (pUSBRequest->bmRequestType)
	{
		case 2:		//Endpoint
			if (pUSBRequest->wValue==USB_FEATURE_EP_HALT)
				bEP_Halt=0;
			break;
		case 0:		//Device
			if (pUSBRequest->wValue==USB_FEATURE_REMOTE_WAKE)
				bDev_RWake=0;
		case 1:		//Interface
		default:
			break;
	}
	return(USBD_EVENT_IDLE);
}
//Get Configuration
eUSBDEvent	usbd_req_get_configuration(_pUSB_STANDARD_REQUEST	pUSBRequest)	//80 08 00 00 00 00 01 00
{
#if	ENUMMSG
	printf("GetConfiguration\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);		//Endpoint 0
	md_usb_enable_csr0l_rxrdyc();				//Serviced RxPktRdy
	md_usb_set_ep0fifo(bDev_Config);	//Config Value
	md_usb_set_csr0l_txcsrl(USB_CSR0L_DATAEND_MSK|USB_CSR0L_TXRDY_MSK);		//DATAEND & TXRDY
	return(USBD_EVENT_IDLE);
}
//Get Descriptor
eUSBDEvent	usbd_req_get_descriptor(_pUSB_STANDARD_REQUEST	pUSBRequest)		//80 06 XX XX 00 00 XX XX
{
eUSBDEvent	u8Event;

#if	ENUMMSG
	printf("GetDescriptor 0x%x\r\n",pUSBRequest->wValue);
#endif
//	if (custom_descriptor_para(pUSBRequest->wValue,&CustomDescPara))
	if ((*pCustomGetDescriptor)(pUSBRequest->wValue,&CustomDescPara))
	{
		md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
		md_usb_set_csr0l_txcsrl(USB_CSR0L_RXRDYC_MSK|USB_CSR0L_STALL_MSK);	//Serviced RxPktRdy & stall
		return(USBD_EVENT_IDLE);
	}
	if (CustomDescPara.u16CtrlBurstLeng>pUSBRequest->wLength)
		CustomDescPara.u16CtrlBurstLeng=pUSBRequest->wLength;
	md_usb_set_index_eptidx(USBEP0);		//Endpoint 0
	md_usb_enable_csr0l_rxrdyc();				//Serviced RxPktRdy
	u8Event=usbd_handle_ctrl_in();
	return(u8Event);
}
//Get Interface
eUSBDEvent	usbd_req_get_interface(_pUSB_STANDARD_REQUEST	pUSBRequest)		//81 0A 00 00 XX 00 01 00
{
#if	ENUMMSG
	printf("GetInterface\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);		//Endpoint 0
	md_usb_enable_csr0l_rxrdyc();				//Serviced RxPktRdy
	md_usb_set_ep0fifo(0);	//Interface Number
	md_usb_set_csr0l_txcsrl(USB_CSR0L_DATAEND_MSK|USB_CSR0L_TXRDY_MSK);		//DATAEND & TXRDY
	return(USBD_EVENT_IDLE);
}
//Get Status
eUSBDEvent	usbd_req_get_status(_pUSB_STANDARD_REQUEST	pUSBRequest)			//[80 81 82] 00 00 00 XX 00 02 00
{	
#if	ENUMMSG
	printf("GetStatus\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);		//Endpoint 0
	md_usb_enable_csr0l_rxrdyc();				//Serviced RxPktRdy
	switch (pUSBRequest->bmRequestType)
	{
		case 0x82:		//Endpoint
			if (pUSBRequest->wValue==USB_FEATURE_EP_HALT)
				md_usb_set_ep0fifo(bEP_Halt);	//
			else
				md_usb_set_ep0fifo(0);	//
			break;
		case 0x80:		//Device
			if (pUSBRequest->wValue==USB_FEATURE_REMOTE_WAKE)
				bDev_RWake=0;
			else
				md_usb_set_ep0fifo(0);	//
			break;
		case 0x81:		//Interface
		default:
			md_usb_set_ep0fifo(0);	//
			break;
	}
	md_usb_set_ep0fifo(0);	//
	md_usb_set_csr0l_txcsrl(USB_CSR0L_DATAEND_MSK|USB_CSR0L_TXRDY_MSK);		//DATAEND & TXRDY
	return(USBD_EVENT_IDLE);
}
//Set Address
eUSBDEvent	usbd_req_set_address(_pUSB_STANDARD_REQUEST	pUSBRequest)		//00 05 XX 00 00 00 00 00
{
#if	ENUMMSG
	printf("SetAddress\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB_CSR0L_RXRDYC_MSK|USB_CSR0L_DATAEND_MSK);	//Serviced RxPktRdy & Dataend
	while (!(u32IntrStatus&USB_INTR_EP0));
	u32IntrStatus&=~USB_INTR_EP0;
	md_usb_set_faddr_addr(pUSBRequest->wValue);	//Device Address	
#if	ENUMMSG
	printf("DevAddr	: %d\r\n",pUSBRequest->wValue);
#endif
	return(USBD_EVENT_IDLE);
}
//Set Configuration
eUSBDEvent	usbd_req_set_configuration(_pUSB_STANDARD_REQUEST	pUSBRequest)	//00 09 XX 00 00 00 00 00
{
#if	ENUMMSG
	printf("SetConfiguration\r\n");
#endif
	bDev_Config=pUSBRequest->wValue&0xff;	//Config Value
	md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB_CSR0L_RXRDYC_MSK|USB_CSR0L_DATAEND_MSK);	//Serviced RxPktRdy & Dataend
	return(USBD_EVENT_IDLE);
}
//Set Descriptor
eUSBDEvent	usbd_req_set_descriptor(_pUSB_STANDARD_REQUEST	pUSBRequest)		//00 07 00 XX 00 00 XX XX
{
#if	ENUMMSG
	printf("SetDescriptor\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB_CSR0L_RXRDYC_MSK|USB_CSR0L_STALL_MSK);	//Serviced RxPktRdy & stall
	return(USBD_EVENT_IDLE);
}
//Set Feature
eUSBDEvent	usbd_req_set_feature(_pUSB_STANDARD_REQUEST	pUSBRequest)		//[00 01 02] 03 XX 00 XX 00 00 00
{
#if	ENUMMSG
	printf("SetFeature\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB_CSR0L_RXRDYC_MSK|USB_CSR0L_DATAEND_MSK);	//Serviced RxPktRdy & Dataend
	switch (pUSBRequest->bmRequestType)
	{
		case 2:		//Endpoint
			if (pUSBRequest->wValue==USB_FEATURE_EP_HALT)
				bEP_Halt=1;
			break;
		case 0:		//Device
			if (pUSBRequest->wValue==USB_FEATURE_REMOTE_WAKE)
				bDev_RWake=1;
			break;
		case 1:		//Interface
		default:
			break;
	}
	return(USBD_EVENT_IDLE);
}
//Set Interface
eUSBDEvent	usbd_req_set_interface(_pUSB_STANDARD_REQUEST	pUSBRequest)		//01 0B XX 00 XX 00 00 00
{
#if	ENUMMSG
	printf("SetInterface\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB_CSR0L_RXRDYC_MSK|USB_CSR0L_DATAEND_MSK);	//Serviced RxPktRdy & Dataend
	return(USBD_EVENT_IDLE);
}
//Sync Frame
eUSBDEvent	usbd_req_sync_frame(_pUSB_STANDARD_REQUEST	pUSBRequest)			//82 0C 00 00 XX 00 02 00
{
#if	ENUMMSG
	printf("SyncFrame\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB_CSR0L_RXRDYC_MSK|USB_CSR0L_STALL_MSK);	//Serviced RxPktRdy & stall
	return(USBD_EVENT_IDLE);
}
//Reserved
eUSBDEvent	usbd_req_reserved(_pUSB_STANDARD_REQUEST	pUSBRequest)
{
#if	ENUMMSG
	printf("Reserved\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB_CSR0L_RXRDYC_MSK|USB_CSR0L_DATAEND_MSK);	//Serviced RxPktRdy & Dataend
	return(USBD_EVENT_IDLE);
}

eUSBDEvent	(*pUSBDStandardRequest[])(_pUSB_STANDARD_REQUEST)=		//Standard Device Request
{
	usbd_req_get_status,
	usbd_req_clear_feature,
	usbd_req_reserved,
	usbd_req_set_feature,
	usbd_req_reserved,
	usbd_req_set_address,
	usbd_req_get_descriptor,
	usbd_req_set_descriptor,
	usbd_req_get_configuration,
	usbd_req_set_configuration,
	usbd_req_get_interface,
	usbd_req_set_interface,
	usbd_req_sync_frame,
};

eUSBDEvent	usbd_event_handler(eUSBDEvent u8Event)
{
uint8_t	ii;

	if (!u32IntrStatus)
		return(u8Event);
	if (u32IntrStatus&USB_INTR_RESET)	//USB Reset
	{
		u32IntrStatus&=~USB_INTR_RESET;
		return(USBD_EVENT_RESET);
	}
	if (u32IntrStatus&USB_INTR_RESUME)	//USB Resume
	{
		u32IntrStatus&=~USB_INTR_RESUME;
		return(USBD_EVENT_RESUME);
	}
	if (u32IntrStatus&USB_INTR_SUSPEND)	//USB Suspend
	{
		u32IntrStatus&=~USB_INTR_SUSPEND;
		return(USBD_EVENT_SUSPEND);
	}
	if (u32IntrStatus&USB_INTR_EP0)	//EP0, Setup or Ctrl In/Out
	{
		u32IntrStatus&=~USB_INTR_EP0;
		md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
		if (md_usb_is_active_csr0l_rxrdy())	//Setup or Ctrl Out
		{
			switch (u8Event)
			{
				case USBD_EVENT_IDLE:
#if	ENUMMSG
					printf("Setup\r\n");
#endif
					u8Event=USBD_EVENT_SETUP;
					for (ii=0;ii<sizeof(_USB_STANDARD_REQUEST);ii++)
					{
						*((uint8_t *)&USBRequest+ii)=md_usb_get_ep0fifo();
#if	ENUMMSG
						printf("0x%02x ",*((uint8_t *)&USBRequest+ii));
#endif
					}
#if	ENUMMSG
					printf("\r\n");
#endif
					if ((USBRequest.bmRequestType&0x60)==0)		//bmRequestType=Standard
						u8Event=(*pUSBDStandardRequest[USBRequest.bRequest])(&USBRequest);
					else
						u8Event=USBD_EVENT_SETUP;
					return(u8Event);
				case USBD_EVENT_SETUP:
				case USBD_EVENT_CTRLOUT:
#if	ENUMMSG
//					printf("CtrlOut\r\n");
#endif
					return(USBD_EVENT_CTRLOUT);
				default:
					return(USBD_EVENT_IDLE);
			}
		}
		else
		{
			switch (u8Event)
			{
				case USBD_EVENT_CTRLIN:	
#if	ENUMMSG
					printf("CtrlIn\r\n");
#endif
					u8Event=usbd_handle_ctrl_in();
					return(u8Event);
//					return(USBD_EVENT_CTRLIN);
				default:
					return(USBD_EVENT_IDLE);
			}
		}
		return(u8Event);
	}
	if (u32IntrStatus&USB_INTR_EP1TX)	//EP1 TX
	{
#if	ENUMMSG
//		printf("EP1TX\r\n");
#endif
		u32IntrStatus&=~USB_INTR_EP1TX;
		return(USBD_EVENT_EP1IN);
	}
	if (u32IntrStatus&USB_INTR_EP1RX)	//EP1 RX
	{
#if	ENUMMSG
//		printf("EP1RX\r\n");
#endif
		u32IntrStatus&=~USB_INTR_EP1RX;
		return(USBD_EVENT_EP1OUT);
	}
	if (u32IntrStatus&USB_INTR_EP2TX)	//EP2 TX
	{
#if	ENUMMSG
//		printf("EP2TX\r\n");
#endif
		u32IntrStatus&=~USB_INTR_EP2TX;
		return(USBD_EVENT_EP2IN);
	}
	if (u32IntrStatus&USB_INTR_EP2RX)	//EP2 RX
	{
#if	ENUMMSG
//		printf("EP2RX\r\n");
#endif
		u32IntrStatus&=~USB_INTR_EP2RX;
		return(USBD_EVENT_EP2OUT);
	}
	if (u32IntrStatus&USB_INTR_EP3TX)	//EP3 TX
	{
#if	ENUMMSG
//		printf("EP3TX\r\n");
#endif
		u32IntrStatus&=~USB_INTR_EP3TX;
		return(USBD_EVENT_EP3IN);
	}
	if (u32IntrStatus&USB_INTR_EP3RX)	//EP3 RX
	{
#if	ENUMMSG
//		printf("EP3RX\r\n");
#endif
		u32IntrStatus&=~USB_INTR_EP3RX;
		return(USBD_EVENT_EP3OUT);
	}
	if (u32IntrStatus&USB_INTR_EP4TX)	//EP4 TX
	{
#if	ENUMMSG
//		printf("EP4TX\r\n");
#endif
		u32IntrStatus&=~USB_INTR_EP4TX;
	}
	if (u32IntrStatus&USB_INTR_EP4RX)	//EP4 RX
	{
#if	ENUMMSG
//		printf("EP4RX\r\n");
#endif
		u32IntrStatus&=~USB_INTR_EP4RX;
		return(USBD_EVENT_EP4OUT);
	}
	if (u32IntrStatus&USB_INTR_EP5TX)	//EP5 TX
	{
#if	ENUMMSG
//		printf("EP5TX\r\n");
#endif
		u32IntrStatus&=~USB_INTR_EP5TX;
		return(USBD_EVENT_EP5IN);
	}
	if (u32IntrStatus&USB_INTR_EP5RX)	//EP5 RX
	{
#if	ENUMMSG
//		printf("EP5RX\r\n");
#endif
		u32IntrStatus&=~USB_INTR_EP5RX;
		return(USBD_EVENT_EP5OUT);
	}
	if (u32IntrStatus&USB_INTR_EP6TX)	//EP6 TX
	{
#if	ENUMMSG
//		printf("EP6TX\r\n");
#endif
		u32IntrStatus&=~USB_INTR_EP6TX;
		return(USBD_EVENT_EP6IN);
	}
	if (u32IntrStatus&USB_INTR_EP6RX)	//EP6 RX
	{
#if	ENUMMSG
//		printf("EP6RX\r\n");
#endif
		u32IntrStatus&=~USB_INTR_EP6RX;
		return(USBD_EVENT_EP6OUT);
	}
	return(USBD_EVENT_IDLE);
}

