#include "es32f0271.h"
#include "md_usb.h"
#include "usbcore.h"
#include "usbenum.h"
#include "usbenum_dev.h"
#include "usbmsc.h"
#include "msddev_fs.h"
#include "mscbldr_desc.h"
#include "iap_update.h"
#include "mscbldr_dev.h"
#include <stdio.h>

#pragma pack(1)
#define	MSCMSG	1

#define	pUSBEPFIFO(x)	((uint8_t *)&USBD->EP0FIFO+(x*4))

extern	_USB_STANDARD_REQUEST	USBRequest;

extern	uint8_t	(*pUSBDStandardRequest[])(_pUSB_STANDARD_REQUEST);
extern	uint8_t	(*pCustomGetDescriptor)(uint16_t, _pCUSTOM_DESCRIPTOR_PARA);
extern	uint32_t	u32MSCIAPStart;
extern	uint8_t		u8MSCIAPDone;

uint8_t		u8MSCCBWData[sizeof(_MSC_COMMAND_BLOCK)],u8MSCCSWData[sizeof(_MSC_COMMAND_STATUS)];
uint32_t	u32LBAData[MSC_BLOCK_SZ/4];

const	_SCSI_INQUIRY_DATA	SCSIInquiryData=
{
	0x00,		//PeripheralDeviceType, 0x00=Direct-Access Device
	0x80,		//RMB, 0x80=Removable Media
//	0x00,		//RMB, 0x00=Non Removable Media
	0x00,		//Version
	0x00,		//ResponseDataFormat
	0x1f,		//AdditionalLength=0x1f
	0x00,0x00,0x00,		//Res0[3]
	'E','S','S','E','M','I',' ',' ',		//VendorID
	'U','S','B',' ','M','S','D',' ','F','A','T','1','6',' ',' ',' ',	//ProductID
	'1','.','0','0',	//Product Revison
};


_SCSI_CAPACITY_LIST_DATA	SCSICapacityListData=
{
//Header
	0x00,0x00,0x00,		//Res0[3]
	sizeof(_SCSI_CAPACITY_DESCRIPTOR),	//CapacityListLength
//Descriptor
	BYTE3(NUMBER_OF_BLOCKS),	//NumberofBlocks3
	BYTE2(NUMBER_OF_BLOCKS),	//NumberofBlocks2
	BYTE1(NUMBER_OF_BLOCKS),	//NumberofBlocks1
	BYTE0(NUMBER_OF_BLOCKS),	//NumberofBlocks0
	0x02,											//DescriptorCode, 0x2=Formatted Media
	BYTE2(MSC_BLOCK_SZ),			//BlockLength2
	BYTE1(MSC_BLOCK_SZ),			//BlockLength1
	BYTE0(MSC_BLOCK_SZ),			//BlockLength0
};

_SCSI_READ_CAPACITY_DATA	SCSIReadCapacityData=
{
	BYTE3(NUMBER_OF_BLOCKS-1),	//LastLBA3
	BYTE2(NUMBER_OF_BLOCKS-1),	//LastLBA2
	BYTE1(NUMBER_OF_BLOCKS-1),	//LastLBA1
	BYTE0(NUMBER_OF_BLOCKS-1),	//LastLBA0
	BYTE3(MSC_BLOCK_SZ),				//BlockLength3
	BYTE2(MSC_BLOCK_SZ),				//BlockLength2
	BYTE1(MSC_BLOCK_SZ),				//BlockLength1
	BYTE0(MSC_BLOCK_SZ),				//BlockLength0
};

const	_SCSI_MODE_SENSE_6_DATA	SCSIModeSense6Data=
{
	(sizeof(_SCSI_MODE_SENSE_6_DATA)-1),		//ModeDataLength;
	0x00,		//MediumType;
	0x00,		//DeviceSpecificParameter;
	0x00,		//BlockDescriptorLength;
};

const	_SCSI_REQUEST_SENSE_DATA	SCSIRequestSenseData=
{
	SCSI_RS_CUR_ERRORS,					//ResponseCode
	0,													//Reserved
	SCSI_RS_KEY_NO_SENSE,				//SenseKey;
	0,0,0,0,										//Information[4];
	10,													//AdditionalSenseLength;
	0,0,0,0,										//CommandSpecificInfo[4];
	0,													//AdditionalSenseCode;
	0,													//AdditionalSenseCodeQualifier;
	0,													//FieldReplaceableUnitCode;
	0,0,0,											//SenseKeySpecific[3];
};

eUSBDEvent	msc_handle_bulk_in(uint16_t u16BCnt, uint8_t *pu8Buf)
{
	while (u16BCnt)
	{
		md_usb_set_index_eptidx(USBEP1);	//Endpoint 1
		while (md_usb_is_enabled_txcsrl_txrdy());	//Wait TXPKTRDY=0
		if (u16BCnt>USBD_BULK_PKTSZ)
		{
			usbd_handle_epx_in(USBEP1,USBD_BULK_PKTSZ,pu8Buf);
			pu8Buf+=USBD_BULK_PKTSZ;
			u16BCnt-=USBD_BULK_PKTSZ;
		}
		else
		{
			usbd_handle_epx_in(USBEP1,u16BCnt,pu8Buf);
			u16BCnt=0;
		}
	}
	return(USBD_EVENT_IDLE);
}

eUSBDEvent	msc_handle_bulk_out(uint16_t u16BCnt, uint8_t *pu8Buf)
{
eUSBDEvent	u8Event;
uint16_t	u16DLen;
	
	u8Event=USBD_EVENT_IDLE;
	while (u16BCnt)
	{
		u8Event=usbd_event_handler(u8Event);
		if (u8Event==USBD_EVENT_EP1OUT)		//MSD Bulk Out
		{
			usbd_handle_epx_out(USBEP1,&u16DLen,pu8Buf);
			pu8Buf+=u16DLen;
			u16BCnt-=u16DLen;
		}
	}
	return(USBD_EVENT_IDLE);
}

eUSBDEvent	msc_error_handler(_pMSC_COMMAND_BLOCK pCBWData, _pMSC_COMMAND_STATUS pCSWData)
{
	return(USBD_EVENT_IDLE);
}
//*****************************************************************************
//
// This function is used to parser the CBW command when it is received from the host.
//
//*****************************************************************************
eUSBDEvent	msc_cbw_parser(_pMSC_COMMAND_BLOCK pCBWData, _pMSC_COMMAND_STATUS pCSWData)
{
_pSCSI_READ_10_COMMAND	pSCSIRead10;
_pSCSI_WRITE_10_COMMAND	pSCSIWrite10;
uint32_t	u32TransLen,u32DataResidue;
uint32_t	u32LBA;
uint16_t	u16LBACnt;	

	if (pCBWData->dSignature!=CBW_SIGNATURE)
		return(USBD_EVENT_IDLE);
	u32TransLen=pCBWData->sDataTransferLength;
	switch (pCBWData->CB[0])
	{
		case SCSI_TEST_UNIT_READY:		
#if	MSCMSG
			printf("Test Unit Ready\r\n");
#endif
			u32DataResidue=0;
			break;
		case SCSI_INQUIRY:
#if	MSCMSG
			printf("Inquery\r\n");
#endif
			usbd_handle_epx_in(USBEP1,sizeof(_SCSI_INQUIRY_DATA),(uint8_t *)&SCSIInquiryData);
			u32DataResidue=0;
			break;
		case SCSI_READ_FORMAT_CAPACITIES:
#if	MSCMSG
			printf("Read Format Capacities\r\n");
#endif
			usbd_handle_epx_in(USBEP1,sizeof(_SCSI_CAPACITY_LIST_DATA),(uint8_t *)&SCSICapacityListData);
			u32DataResidue=0;
			break;
		case SCSI_READ_CAPACITY:
#if	MSCMSG
			printf("Read Capacity\r\n");
#endif
			usbd_handle_epx_in(USBEP1,sizeof(_SCSI_READ_CAPACITY_DATA),(uint8_t *)&SCSIReadCapacityData);
			u32DataResidue=0;
			break;
		case SCSI_MODE_SENSE_6:
#if	MSCMSG
			printf("Mode Sense 6\r\n");
#endif
			usbd_handle_epx_in(USBEP1,sizeof(_SCSI_MODE_SENSE_6_DATA),(uint8_t *)&SCSIModeSense6Data);
			u32DataResidue=0;
			break;
		case SCSI_REQUEST_SENSE:
			usbd_handle_epx_in(USBEP1,sizeof(_SCSI_REQUEST_SENSE_DATA),(uint8_t *)&SCSIRequestSenseData);
#if	MSCMSG
			printf("Request Sense\r\n");
#endif
			break;
		case SCSI_READ_10:
#if	MSCMSG
			printf("Read 10-");
#endif
			pSCSIRead10=(_pSCSI_READ_10_COMMAND)((uint8_t *)pCBWData+sizeof(_MSC_COMMAND_BLOCK)-sizeof(pCBWData->CB));
			u32LBA=DATA32(pSCSIRead10->LBA3,pSCSIRead10->LBA2,pSCSIRead10->LBA1,pSCSIRead10->LBA0);
			u16LBACnt=DATA16(pSCSIRead10->TransferLength1,pSCSIRead10->TransferLength0);
#if	MSCMSG
			printf("LBA=0x%x-Count=0x%x\r\n", u32LBA, u16LBACnt);
#endif
			while (u16LBACnt--)
			{
				fsdev_read_lba(u32LBA++,u32LBAData);
				msc_handle_bulk_in(MSC_BLOCK_SZ,(uint8_t *)u32LBAData);
				u32TransLen-=MSC_BLOCK_SZ;
			}
			u32DataResidue=u32TransLen;
			break;
		case SCSI_WRITE_10:
#if	MSCMSG
			printf("Write 10-");
#endif
			pSCSIWrite10=(_pSCSI_WRITE_10_COMMAND)((uint8_t *)pCBWData+sizeof(_MSC_COMMAND_BLOCK)-sizeof(pCBWData->CB));
			u32LBA=DATA32(pSCSIWrite10->LBA3,pSCSIWrite10->LBA2,pSCSIWrite10->LBA1,pSCSIWrite10->LBA0);
			u16LBACnt=DATA16(pSCSIWrite10->TransferLength1,pSCSIWrite10->TransferLength0);
#if	MSCMSG
			printf("LBA=0x%x-Count=0x%x\r\n", u32LBA, u16LBACnt);
#endif
			while (u16LBACnt--)
			{
				msc_handle_bulk_out(MSC_BLOCK_SZ,(uint8_t *)u32LBAData);
				fsdev_write_lba(u32LBA++,u32LBAData);
				u32TransLen-=MSC_BLOCK_SZ;
			}
			u32DataResidue=u32TransLen;
			break;
		default:
			break;
	}
	pCSWData->dSignature=CSW_SIGNATURE;
	pCSWData->dTag=pCBWData->dTag;
	pCSWData->sDataResidue=u32DataResidue;
	pCSWData->bStatus=CSW_STATUS_SUCCESS;
	
//	md_usb_set_index_eptidx(USBEP1);	//Endpoint 1
//	while (md_usb_is_enabled_txcsrl_txrdy());	//Wait TXPKTRDY=0
	usbd_handle_epx_in(USBEP1,sizeof(_MSC_COMMAND_STATUS),(uint8_t *)pCSWData);
#if	MSCMSG
//	printf("CSW\r\n");
#endif
	if (u8MSCIAPDone)
	{
#if	MSCMSG
		printf("Remap-0x%x\r\n",u32MSCIAPStart);
#endif
		md_usb_set_index_eptidx(USBEP1);	//Endpoint 1
		while (md_usb_is_enabled_txcsrl_txrdy());	//Wait TXPKTRDY=0
		usb_dev_disconnect();
		iap_check_and_run(u32MSCIAPStart);
	}
	return(USBD_EVENT_IDLE);
}

//MSC Request
eUSBDEvent	msc_req_get_max_lun(_pUSB_STANDARD_REQUEST	pUSBRequest)			//A1 FE 00 00 XX 00 01 00
{
#if	MSCMSG
	printf("Get Max LUN\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
	md_usb_enable_csr0l_rxrdyc();		//Clear RxRdy
	md_usb_set_ep0fifo(0x0);				//Max LUN
	md_usb_set_csr0l_txcsrl(USB_CSR0L_DATAEND_MSK|USB_CSR0L_TXRDY_MSK);	//TXPKTRDY & DataEnd
	return(USBD_EVENT_IDLE);
}
eUSBDEvent	msc_req_storage_reset(_pUSB_STANDARD_REQUEST	pUSBRequest)		//21 FF 00 00 XX 00 00 00
{
#if	MSCMSG
	printf("Storage Reset\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB_CSR0L_RXRDYC_MSK|USB_CSR0L_DATAEND_MSK);	//Clear RxRdy & Dataend
	return(USBD_EVENT_IDLE);
}
eUSBDEvent	msc_req_reserved(_pUSB_STANDARD_REQUEST	pUSBRequest)
{
#if	MSCMSG
	printf("Reserved\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB_CSR0L_RXRDYC_MSK|USB_CSR0L_DATAEND_MSK);	//Clear RxRdy & Dataend
	return(USBD_EVENT_IDLE);
}

eUSBDEvent	(*pMSCVendorRequest[])(_pUSB_STANDARD_REQUEST)=		//MSD Device Request
{
	msc_req_get_max_lun,
	msc_req_storage_reset,
};

uint8_t	mscbldr_custom_descriptor_para(uint16_t wValue, _pCUSTOM_DESCRIPTOR_PARA pCustomDescPara)
{
uint8_t	u8ValueH, u8ValueL;

	u8ValueL=wValue&0xff;	
	u8ValueH=wValue>>8;	
	switch (u8ValueH)	//wValueH
	{
		case USB_DTYPE_DEVICE:	//Device
			pCustomDescPara->pu8CtrlBurstData=(uint8_t *)&MSCDeviceDesc;	//Device Descriptor
			pCustomDescPara->u16CtrlBurstLeng=sizeof(_USB_DEVICE_DESC);		//bLength
			break;
		case USB_DTYPE_CONFIGURATION:	//Configuration
			pCustomDescPara->pu8CtrlBurstData=(uint8_t *)&MSCConfigurationDesc;		//Configuration Descriptor
			pCustomDescPara->u16CtrlBurstLeng=sizeof(_MSC_CONFIGURATION_DESC);		//wTotalLength
			break;
		case USB_DTYPE_STRING:	//String
			switch (u8ValueL)	
			{
				case 0:
					pCustomDescPara->pu8CtrlBurstData=(uint8_t *)&MSCString0Desc;		//String 0 Descriptor
					pCustomDescPara->u16CtrlBurstLeng=sizeof(_USB_STRING_0_DESC);		//bLength
					break;
				case 1:
					pCustomDescPara->pu8CtrlBurstData=(uint8_t *)&MSCString1Desc;		//String 1 Descriptor
					pCustomDescPara->u16CtrlBurstLeng=sizeof(_USB_STRING_1_DESC);		//bLength
					break;
				case 2:
					pCustomDescPara->pu8CtrlBurstData=(uint8_t *)&MSCString2Desc;		//String 2 Descriptor
					pCustomDescPara->u16CtrlBurstLeng=sizeof(_USB_STRING_2_DESC);		//bLength
					break;
				default:		//Not Supported
					return(1);
			}
			break;
		case USB_DTYPE_QUALIFIER:		//Qualifier
			pCustomDescPara->pu8CtrlBurstData=NULL;
			pCustomDescPara->u16CtrlBurstLeng=0;
			break;
		default:		//Not Supported
			return(1);
	}
	return(0);
}

void	msc_dev_init()
{
//Configure EP0
	md_usb_set_index_eptidx(USBEP0);							//Endpoint 0
	md_usb_set_txmaxp_maxsize(USBD_CTRL_PKTSZ/8);	//64 bytes
	md_usb_set_txfifo1_addrl(0x0);							//Start Address=0x0
	md_usb_set_txfifo2_maxpktsize(MD_USB_FIFO2_MAXPKTSIZE_64);	//Size=64
	md_usb_set_rxmaxp_maxsize(USBD_CTRL_PKTSZ/8);	//64 bytes
	md_usb_set_rxfifo1_addrl(0x0);							//Start Address=0x0
	md_usb_set_rxfifo2_maxpktsize(MD_USB_FIFO2_MAXPKTSIZE_64);	//Size=64
	
	pCustomGetDescriptor=mscbldr_custom_descriptor_para;
}

void	msc_dev_ep_config()
{
//Configure EP1 In
	md_usb_set_index_eptidx(USBEP1);	//Endpoint 1
	md_usb_enable_txcsrh_bulk();			//Bulk
	md_usb_enable_txcsrh_txmode();		//TX
	md_usb_set_txmaxp_maxsize(USBD_BULK_PKTSZ/8);	//64 bytes
	md_usb_set_txfifo1_addrl(0x8);		//Start Address=0x8
	md_usb_set_txfifo2_maxpktsize(MD_USB_FIFO2_MAXPKTSIZE_64);	//size=64
	md_usb_enable_txfifo2_dpb();			//Double-Packet Buffering
	md_usb_enable_txcsrl_flush();			//Flush FIFO
//Configure EP1 Out
	md_usb_set_index_eptidx(USBEP1);	//Endpoint 1
	md_usb_enable_txcsrh_bulk();			//Bulk
	md_usb_enable_txcsrh_rxmode();		//RX
	md_usb_set_rxmaxp_maxsize(USBD_BULK_PKTSZ/8);	//64 Bytes
	md_usb_set_rxfifo1_addrl(0x18);		//Start Address=0x18
	md_usb_set_rxfifo2_maxpktsize(MD_USB_FIFO2_MAXPKTSIZE_64);	//Size=64
	md_usb_enable_rxfifo2_dpb();			//Double-Packet Buffering
	md_usb_enable_rxcsrl_flush();			//Flush FIFO

//Initial MUSB
	md_usb_enable_txier_ep0ie();	//Tx Interrupt Enable for EP0
	md_usb_enable_txier_ep1ie();	//Tx Interrupt Enable for EP1
	md_usb_enable_rxier_ep1ie();	//Rx Interrupt Enable for EP1

	md_usb_set_faddr_addr(0);			//Default Address	

#if	MSCMSG
	printf("MSC EP Config Done\r\n");
#endif
}

eUSBDEvent	msc_dev_enumeration(eUSBDEvent u8Event)
{
uint8_t	u8DescType;
	
	u8Event=usbd_event_handler(u8Event);
	switch (u8Event)
	{
		case USBD_EVENT_IDLE:
			return(USBD_EVENT_IDLE);
		case USBD_EVENT_RESET:			//Reset
#if	MSCMSG
			printf("Reset\r\n");
#endif
			msc_dev_ep_config();
			return(USBD_EVENT_IDLE);
		case USBD_EVENT_RESUME:			//Resume
#if	MSCMSG
			printf("Resume\r\n");
#endif
			return(USBD_EVENT_IDLE);
		case USBD_EVENT_SUSPEND:		//Suspend
#if	MSCMSG
			printf("Suspend\r\n");
#endif
			return(USBD_EVENT_IDLE);
		case USBD_EVENT_SETUP:			//Setup
			if ((USBRequest.bmRequestType&0x60)==0x20)		//bmRequestType=Class
				u8Event=(*pMSCVendorRequest[USBRequest.bRequest-0xfe])(&USBRequest);
			return(u8Event);
		case USBD_EVENT_CTRLOUT:		//Ctrl Out
#if	MSCMSG
//			printf("CtrlOut\r\n");
#endif
			return(USBD_EVENT_CTRLOUT);
		case USBD_EVENT_CTRLIN:			//Ctrl In
#if	MSCMSG
//			printf("CtrlIn\r\n");
#endif
//			u8Event=usbd_handle_ctrl_in();
//			return(u8Event);
			return(USBD_EVENT_CTRLIN);
		case USBD_EVENT_EP1IN:			//EP1, Bulk In
			return(USBD_EVENT_IDLE);
		case USBD_EVENT_EP1OUT:			//EP1, Bulk Out
#if	MSCMSG
//			printf("EP1Out\r\n");
#endif
			return(USBD_EVENT_EP1OUT);
		default:
			return(USBD_EVENT_IDLE);
	}
	return(USBD_EVENT_IDLE);
}
eUSBDEvent	msc_dev_transaction(eUSBDEvent u8Event)
{
uint16_t	u16DLen;
	
	if (u8Event!=USBD_EVENT_EP1OUT)
		return(USBD_EVENT_IDLE);
	usbd_handle_epx_out(USBEP1,&u16DLen,u8MSCCBWData);
	if (u16DLen!=sizeof(_MSC_COMMAND_BLOCK))		//Not Valid CBW
	{
		printf("CBW Error\r\n");
		msc_error_handler((_pMSC_COMMAND_BLOCK)u8MSCCBWData, (_pMSC_COMMAND_STATUS)u8MSCCSWData);
		return(USBD_EVENT_IDLE);
	}
	msc_cbw_parser((_pMSC_COMMAND_BLOCK)u8MSCCBWData, (_pMSC_COMMAND_STATUS)u8MSCCSWData);
	return(USBD_EVENT_IDLE);
}
