#ifndef	_MSCBLDR_DESC_H
#define	_MSCBLDR_DESC_H

#define	VID_ESSEMI	0x30CC
#define	PID_MSD			0xFF06

//*****************************************************************************
//
//! This structure describes the USB string descriptor for all string indexes
//! other than 0 as defined in USB 2.0 specification section 9.6.7.
//
//*****************************************************************************
typedef struct _USB_STRING_1_DESC_
{
  //
  //! The length of this descriptor in bytes.  This value will be 2 greater
  //! than the number of bytes comprising the UNICODE string that the
  //! descriptor contains.
  //
  uint8_t		bLength;

  //
  //! The type of the descriptor.  For a string descriptor, this will be
  //! USB_DTYPE_STRING (3).
  //
  uint8_t		bDescriptorType;

  //
  //! The first byte of the UNICODE string.  This string is not NULL
  //! terminated.  Its length (in bytes) can be computed by subtracting 2
  //! from the value in the bLength field.
  //
  uint16_t		bString[8];
}_USB_STRING_1_DESC, *_pUSB_STRING_1_DESC;

//*****************************************************************************
//
//! This structure describes the USB string descriptor for all string indexes
//! other than 0 as defined in USB 2.0 specification section 9.6.7.
//
//*****************************************************************************
typedef struct _USB_STRING_2_DESC_
{
  //
  //! The length of this descriptor in bytes.  This value will be 2 greater
  //! than the number of bytes comprising the UNICODE string that the
  //! descriptor contains.
  //
  uint8_t		bLength;

  //
  //! The type of the descriptor.  For a string descriptor, this will be
  //! USB_DTYPE_STRING (3).
  //
  uint8_t		bDescriptorType;

  //
  //! The first byte of the UNICODE string.  This string is not NULL
  //! terminated.  Its length (in bytes) can be computed by subtracting 2
  //! from the value in the bLength field.
  //
  uint16_t		bString[9];
}_USB_STRING_2_DESC, *_pUSB_STRING_2_DESC;

typedef	struct	_MSC_CONFIGURATION_DESC_		//MSC Configuration
{
	_USB_CONFIGURATION_DESC	ConfigDesc;
	_USB_INTERFACE_DESC		MSDInterfaceDesc;
	_USB_ENDPOINT_DESC		MSDEPIn1Desc;
	_USB_ENDPOINT_DESC		MSDEPOut1Desc;
} _MSC_CONFIGURATION_DESC, *_pMSC_CONFIGURATION_DESC;

//Device Descriptor
const	_USB_DEVICE_DESC	MSCDeviceDesc=
{
	sizeof(_USB_DEVICE_DESC),	//Length=0x12
	USB_DTYPE_DEVICE,	//Type=1
	0x0200,						//USB 2.00
	0x0,							//Class=0x00
	0x0,							//Subclass=0x00
	0x0,							//Protocol=0x00
	USBD_CTRL_PKTSZ,	//CTRL packet size=64
	VID_ESSEMI,				//VID=0x30cc
	PID_MSD,					//PID=0xff06, 
	0x100,						//Release number=1.00
	0x1,							//iManufactor
	0x2,							//iProduct=String1
	0x0,							//iSerialNumber
	0x1,							//Number of Configurations=0x1
};

const	_MSC_CONFIGURATION_DESC	MSCConfigurationDesc=
{
//Configuration Descriptor
	sizeof(_USB_CONFIGURATION_DESC),	//Length=9
	USB_DTYPE_CONFIGURATION,	//Type=2
	sizeof(_MSC_CONFIGURATION_DESC),	//Total Length
	0x1,							//Number of Interface=0x1
	0x1,							//Value for SetConfiguration
	0x0,							//String Index
	0x80,							//Bus Power, no Remote Wakeup
	0x32,							//Maxpower=100mA
//MSD Interface
	sizeof(_USB_INTERFACE_DESC),	//Length=9
	USB_DTYPE_INTERFACE,	//Type=4
	0x0,							//Interface Number
	0x0,							//Alternate Setting
	0x2,							//Number of Endpoints
	USB_CLASS_MSD,		//MSD Class
	MSC_SUBCLASS_SCSI,	//Subclass=0x6, SCSI
	0x50,							//Protocol=0x50, Bulk Only
	0x0,							//String Index
//MSD EP1 In
	sizeof(_USB_ENDPOINT_DESC),	//Length=7
	USB_DTYPE_ENDPOINT,	//Type=5
	0x81,							//EP1, In
	USB_EP_ATTR_BULK,	//Bulk
	USBD_BULK_PKTSZ,	//Max Packet Size=64
	0x0,							//Interval
//MSD EP1 Out
	sizeof(_USB_ENDPOINT_DESC),	//Length=7
	USB_DTYPE_ENDPOINT,	//Type=5
	0x1,							//EP1, Out
	USB_EP_ATTR_BULK,	//Bulk
	USBD_BULK_PKTSZ,	//Max Packet Size=64
	0x0,							//Interval
};

//String 0 Descriptor
const	_USB_STRING_0_DESC  MSCString0Desc=
{
	sizeof(_USB_STRING_0_DESC),	//length=4
	USB_DTYPE_STRING,	//Type=3
	0x0409,						//Language ID
};
//String 1 Descriptor
const	_USB_STRING_1_DESC  MSCString1Desc=
{
	sizeof(_USB_STRING_1_DESC),	//length
	USB_DTYPE_STRING,		//type=3
	{
	'E','a','s','t','S','o','f','t',
	},								//string data
};
//String 2 Descriptor
const	_USB_STRING_2_DESC  MSCString2Desc=
{
	sizeof(_USB_STRING_2_DESC),	//length
	USB_DTYPE_STRING,		//type=3
	{
	'M','S','D',' ','F','A','T','1','6',
	},								//string data
};

#endif	//_MSCBLDR_DESC_H
