#include "es32f0271.h"
#include "md_usb.h"
#include "usbcore.h"
#include "usbenum.h"
#include "usbenum_dev.h"
#include "usbhid.h"
#include "hidbldr_desc.h"
#include "eslab_parser.h"
#include "iap_update.h"
#include "hidbldr_dev.h"
#include <stdio.h>

#pragma pack(1)
#define	HIDMSG	1

extern	_USB_STANDARD_REQUEST	USBRequest;

extern	uint8_t	(*pUSBDStandardRequest[])(_pUSB_STANDARD_REQUEST);
extern	uint8_t	(*pCustomGetDescriptor)(uint16_t, _pCUSTOM_DESCRIPTOR_PARA);
extern	uint32_t	u32IntrStatus;
extern	uint32_t	u32IAPStart;
extern	uint8_t		u8HIDIAPDone;

static	uint8_t		BLDRRequestBuf[USBD_INT_PKTSZ],BLDRResponseBuf[USBD_CTRL_PKTSZ];
static	uint8_t		bEP_Idle=0;

eUSBDEvent	hid_handle_int_in(uint16_t u16BCnt, uint8_t *pu8Buf)
{
	while (u16BCnt)
	{
		md_usb_set_index_eptidx(USBEP1);	//Endpoint 1
		while (md_usb_is_enabled_txcsrl_txrdy());	//Wait TXPKTRDY=0
		if (u16BCnt>USBD_INT_PKTSZ)
		{
			usbd_handle_epx_in(USBEP1,USBD_INT_PKTSZ,pu8Buf);
			pu8Buf+=USBD_INT_PKTSZ;
			u16BCnt-=USBD_INT_PKTSZ;
		}
		else
		{
			usbd_handle_epx_in(USBEP1,u16BCnt,pu8Buf);
			u16BCnt=0;
		}
	}
	return(USBD_EVENT_IDLE);
}

eUSBDEvent	hid_handle_int_out(uint16_t u16BCnt, uint8_t *pu8Buf)
{
eUSBDEvent	u8Event;
uint16_t	u16DLen;
	
	u8Event=USBD_EVENT_IDLE;
	while (u16BCnt)
	{
		u8Event=usbd_event_handler(u8Event);
		if (u8Event==USBD_EVENT_EP1OUT)		//MSD Bulk Out
		{
			usbd_handle_epx_out(USBEP1,&u16DLen,pu8Buf);
			pu8Buf+=u16DLen;
			u16BCnt-=u16DLen;
		}
	}
	return(USBD_EVENT_IDLE);
}
//HID Request
eUSBDEvent	hid_req_get_report(_pUSB_STANDARD_REQUEST	pUSBRequest)
{
#if	HIDMSG
	printf("HIDGetReport\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);		//Endpoint 0
	md_usb_enable_csr0l_rxrdyc();		//Serviced RxPktRdy
	md_usb_set_csr0l_txcsrl(USB_CSR0L_DATAEND_MSK|USB_CSR0L_TXRDY_MSK);	//TXPKTRDY & DataEnd
	return(USBD_EVENT_IDLE);
}

eUSBDEvent	hid_req_get_idle(_pUSB_STANDARD_REQUEST	pUSBRequest)
{
#if	HIDMSG
	printf("HIDGetIdle\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);		//Endpoint 0
	md_usb_enable_csr0l_rxrdyc();		//Serviced RxPktRdy
	md_usb_set_ep0fifo(bEP_Idle);		//Idle Rate
	md_usb_set_csr0l_txcsrl(USB_CSR0L_DATAEND_MSK|USB_CSR0L_TXRDY_MSK);	//TXPKTRDY & DataEnd
	return(USBD_EVENT_IDLE);
}

eUSBDEvent	hid_req_get_protocol(_pUSB_STANDARD_REQUEST	pUSBRequest)
{
#if	HIDMSG
	printf("HIDGetProtocol\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);		//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB_CSR0L_DATAEND_MSK|USB_CSR0L_TXRDY_MSK);	//TXPKTRDY & DataEnd
	return(USBD_EVENT_IDLE);
}

eUSBDEvent	hid_req_set_report(_pUSB_STANDARD_REQUEST	pUSBRequest)
{
#if	HIDMSG
	printf("HIDSetReport\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);		//Endpoint 0
	md_usb_enable_csr0l_rxrdyc();	//Serviced RxPktRdy
	while (!(u32IntrStatus&USB_INTR_EP0));	//Wait for CtrlOut interrupt
	u32IntrStatus&=~USB_INTR_EP0;
	return(USBD_EVENT_CTRLOUT);
}

eUSBDEvent	hid_req_set_idle(_pUSB_STANDARD_REQUEST	pUSBRequest)
{
#if	HIDMSG
	printf("HIDSetIdle\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);		//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB_CSR0L_DATAEND_MSK|USB_CSR0L_TXRDY_MSK);	//TXPKTRDY & DataEnd
	bEP_Idle=pUSBRequest->wValue>>8;
	return(USBD_EVENT_IDLE);
}

eUSBDEvent	hid_req_set_protocol(_pUSB_STANDARD_REQUEST	pUSBRequest)
{
#if	HIDMSG
	printf("HIDGetProtocol\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);		//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB_CSR0L_DATAEND_MSK|USB_CSR0L_TXRDY_MSK);	//TXPKTRDY & DataEnd
	return(USBD_EVENT_IDLE);
}

eUSBDEvent	hid_req_reserved(_pUSB_STANDARD_REQUEST	pUSBRequest)
{
#if	HIDMSG
	printf("Reserved\r\n");
#endif
	md_usb_set_index_eptidx(USBEP0);		//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB_CSR0L_DATAEND_MSK|USB_CSR0L_TXRDY_MSK);	//TXPKTRDY & DataEnd
	return(USBD_EVENT_IDLE);
}

eUSBDEvent	(*pHIDVendorRequest[])(_pUSB_STANDARD_REQUEST)=		//MSD Device Request
{
	hid_req_reserved,
	hid_req_get_report,
	hid_req_get_idle,
	hid_req_get_protocol,
	hid_req_reserved,
	hid_req_reserved,
	hid_req_reserved,
	hid_req_reserved,
	hid_req_reserved,
	hid_req_set_report,
	hid_req_set_idle,
	hid_req_set_protocol,
};

uint8_t	hidbldr_custom_descriptor_para(uint16_t wValue, _pCUSTOM_DESCRIPTOR_PARA pCustomDescPara)
{
uint8_t	u8ValueH, u8ValueL;

	u8ValueL=wValue&0xff;	
	u8ValueH=wValue>>8;	
	switch (u8ValueH)	//wValueH
	{
		case USB_DTYPE_DEVICE:	//Device
			pCustomDescPara->pu8CtrlBurstData=(uint8_t *)&BLDRDeviceDesc;		//Device Descriptor
			pCustomDescPara->u16CtrlBurstLeng=sizeof(_USB_DEVICE_DESC);			//bLength
			break;
		case USB_DTYPE_CONFIGURATION:	//Configuration
			pCustomDescPara->pu8CtrlBurstData=(uint8_t *)&BLDRConfigurationDesc;		//Configuration Descriptor
			pCustomDescPara->u16CtrlBurstLeng=sizeof(_HID_CONFIGURATION_DESC);			//wTotalLength
			break;
		case USB_DTYPE_STRING:	//String
			switch (u8ValueL)	
			{
				case 0:
					pCustomDescPara->pu8CtrlBurstData=(uint8_t *)&BLDRString0Desc;		//String 0 Descriptor
					pCustomDescPara->u16CtrlBurstLeng=sizeof(_USB_STRING_0_DESC);			//bLength
					break;
				case 1:
					pCustomDescPara->pu8CtrlBurstData=(uint8_t *)&BLDRString1Desc;		//String 1 Descriptor
					pCustomDescPara->u16CtrlBurstLeng=sizeof(_USB_STRING_1_DESC);			//bLength
					break;
				case 2:
					pCustomDescPara->pu8CtrlBurstData=(uint8_t *)&BLDRString2Desc;		//String 2 Descriptor
					pCustomDescPara->u16CtrlBurstLeng=sizeof(BLDRString2Desc);				//bLength
					break;
				default:		//Not Supported
					return(1);
			}
			break;
		case USB_DTYPE_QUALIFIER:		//Qualifier
			pCustomDescPara->pu8CtrlBurstData=NULL;
			pCustomDescPara->u16CtrlBurstLeng=0;
			break;
		case HID_DTYPE_HID:			//HID
			pCustomDescPara->pu8CtrlBurstData=(uint8_t *)&BLDRConfigurationDesc.HIDDesc;		//HID Descriptor
			pCustomDescPara->u16CtrlBurstLeng=sizeof(_HID_HID_DESC);								//bLength
			break;
		case HID_DTYPE_REPORT:		//Report
			pCustomDescPara->pu8CtrlBurstData=(uint8_t *)BLDRReportDesc;						//Report Descriptor
			pCustomDescPara->u16CtrlBurstLeng=sizeof(BLDRReportDesc);								//bLength
			break;
		default:		//Not Supported
			return(1);
	}
	return(0);
}

void	hid_dev_init()
{
//Configure EP0
	md_usb_set_index_eptidx(USBEP0);							//Endpoint 0
	md_usb_set_txmaxp_maxsize(USBD_CTRL_PKTSZ/8);	//64 bytes
	md_usb_set_txfifo1_addrl(0x0);							//Start Address=0x0
	md_usb_set_txfifo2_maxpktsize(MD_USB_FIFO2_MAXPKTSIZE_64);	//Size=64
	md_usb_set_rxmaxp_maxsize(USBD_CTRL_PKTSZ/8);	//64 bytes
	md_usb_set_rxfifo1_addrl(0x0);							//Start Address=0x0
	md_usb_set_rxfifo2_maxpktsize(MD_USB_FIFO2_MAXPKTSIZE_64);	//Size=64
	
	pCustomGetDescriptor=hidbldr_custom_descriptor_para;
}

void	hid_dev_ep_config()
{
//Configure EP1 In
	md_usb_set_index_eptidx(USBEP1);	//Endpoint 1
	md_usb_enable_txcsrh_int();				//Int
	md_usb_enable_txcsrh_txmode();		//TX
	md_usb_set_txmaxp_maxsize(USBD_INT_PKTSZ/8);	//64 bytes
	md_usb_set_txfifo1_addrl(0x8);		//Start Address=0x8
	md_usb_set_txfifo2_maxpktsize(MD_USB_FIFO2_MAXPKTSIZE_64);	//size=64, No Double-Packet Buffering
	md_usb_enable_txcsrl_flush();			//Flush FIFO
//Configure EP1 Out
	md_usb_set_index_eptidx(USBEP1);	//Endpoint 1
	md_usb_enable_txcsrh_int();				//Int
	md_usb_enable_txcsrh_rxmode();		//RX
	md_usb_set_rxmaxp_maxsize(USBD_INT_PKTSZ/8);	//64 Bytes
	md_usb_set_rxfifo1_addrl(0x10);		//Start Address=0x10
	md_usb_set_rxfifo2_maxpktsize(MD_USB_FIFO2_MAXPKTSIZE_64);	//Size=64, No Double-Packet Buffering
	md_usb_enable_rxcsrl_flush();			//Flush FIFO

//Initial MUSB
	md_usb_enable_txier_ep0ie();	//Tx Interrupt Enable for EP0
	md_usb_enable_txier_ep1ie();	//Tx Interrupt Enable for EP1
	md_usb_enable_rxier_ep1ie();	//Rx Interrupt Enable for EP1

	md_usb_set_faddr_addr(0);			//Default Address	

#if	HIDMSG
	printf("HID EP Config Done\r\n");
#endif
}

uint8_t	hid_dev_enumeration(eUSBDEvent u8Event)
{
	u8Event=usbd_event_handler(u8Event);
	switch (u8Event)
	{
		case USBD_EVENT_IDLE:
			return(USBD_EVENT_IDLE);
		case USBD_EVENT_RESET:			//Reset
#if	HIDMSG
			printf("Reset\r\n");
#endif
			hid_dev_ep_config();
			return(USBD_EVENT_IDLE);
		case USBD_EVENT_RESUME:			//Resume
#if	HIDMSG
			printf("Resume\r\n");
#endif
			return(USBD_EVENT_IDLE);
		case USBD_EVENT_SUSPEND:		//Suspend
#if	HIDMSG
			printf("Suspend\r\n");
#endif
			return(USBD_EVENT_IDLE);
		case USBD_EVENT_SETUP:			//Setup
			if ((USBRequest.bmRequestType&0x60)==0x20)		//bmRequestType=Class
				u8Event=(*pHIDVendorRequest[USBRequest.bRequest])(&USBRequest);
			return(u8Event);
		case USBD_EVENT_CTRLOUT:		//Ctrl Out
			return(USBD_EVENT_CTRLOUT);
		case USBD_EVENT_CTRLIN:			//Ctrl In
//			u8Event=usbd_handle_ctrl_in();
//			return(u8Event);
			return(USBD_EVENT_CTRLIN);
		case USBD_EVENT_EP1IN:			//EP1, Bulk In
			return(USBD_EVENT_IDLE);
		case USBD_EVENT_EP1OUT:			//EP1, Bulk Out
			return(USBD_EVENT_EP1OUT);
		default:
			return(USBD_EVENT_IDLE);
	}
	return(USBD_EVENT_IDLE);
}
uint8_t	bldr_dev_transaction(eUSBDEvent u8Event)
{
uint16_t	u16DLen;
	
#if	HIDMSG
//	printf("Transaction\r\n");
#endif
	if (u8Event!=USBD_EVENT_CTRLOUT)
		return(USBD_EVENT_IDLE);
#if	HIDMSG
//	printf("Command\r\n");
#endif
	usbd_handle_ctrl_out(&u16DLen, BLDRRequestBuf);
	eslab_command_parser(BLDRRequestBuf,BLDRResponseBuf);
	usbd_handle_epx_in(USBEP1, USBD_INT_PKTSZ, BLDRResponseBuf);
	if (u8HIDIAPDone)
	{
#if	HIDMSG
		printf("Remap-0x%x\r\n",u32IAPStart);
#endif
		md_usb_set_index_eptidx(USBEP1);	//Endpoint 1
		while (md_usb_is_enabled_txcsrl_txrdy());	//Wait TXPKTRDY=0
		usb_dev_disconnect();
		iap_check_and_run(u32IAPStart);
	}
	return(USBD_EVENT_IDLE);
}
