#ifndef	_HIDBLDR_DESC_H
#define	_HIDBLDR_DESC_H

#define	VID_ESSEMI	0x30CC
#define	PID_HIDBLDR	0xFFF8


//*****************************************************************************
//
//! This structure describes the USB string descriptor for all string indexes
//! other than 0 as defined in USB 2.0 specification section 9.6.7.
//
//*****************************************************************************
typedef struct _USB_STRING_1_DESC_
{
  //
  //! The length of this descriptor in bytes.  This value will be 2 greater
  //! than the number of bytes comprising the UNICODE string that the
  //! descriptor contains.
  //
  uint8_t		bLength;

  //
  //! The type of the descriptor.  For a string descriptor, this will be
  //! USB_DTYPE_STRING (3).
  //
  uint8_t		bDescriptorType;

  //
  //! The first byte of the UNICODE string.  This string is not NULL
  //! terminated.  Its length (in bytes) can be computed by subtracting 2
  //! from the value in the bLength field.
  //
  uint16_t		bString[8];
}_USB_STRING_1_DESC, *_pUSB_STRING_1_DESC;

//*****************************************************************************
//
//! This structure describes the USB string descriptor for all string indexes
//! other than 0 as defined in USB 2.0 specification section 9.6.7.
//
//*****************************************************************************
typedef struct _USB_STRING_2_DESC_
{
  //
  //! The length of this descriptor in bytes.  This value will be 2 greater
  //! than the number of bytes comprising the UNICODE string that the
  //! descriptor contains.
  //
  uint8_t		bLength;

  //
  //! The type of the descriptor.  For a string descriptor, this will be
  //! USB_DTYPE_STRING (3).
  //
  uint8_t		bDescriptorType;

  //
  //! The first byte of the UNICODE string.  This string is not NULL
  //! terminated.  Its length (in bytes) can be computed by subtracting 2
  //! from the value in the bLength field.
  //
  uint16_t		bString[8];
}_USB_STRING_2_DESC, *_pUSB_STRING_2_DESC;

typedef	struct	_HID_CONFIGURATION_DESC_		//HID Configuration
{
	_USB_CONFIGURATION_DESC	ConfigutationDesc;
	_USB_INTERFACE_DESC			InterfaceDesc;
	_HID_HID_DESC						HIDDesc;
	_USB_ENDPOINT_DESC			EP1InDesc;
}_HID_CONFIGURATION_DESC, *_pHID_CONFIGURATION_DESC;

//endpoint define
#define	EP_CTRLIN		0
#define	EP_CTRLOUT	0
#define	EP_INTIN		1
#define	EP_INTOUT		1

const	uint8_t	BLDRReportDesc[]=
{
//EBD Control
	0x06, 0xf8, 0xff,		//Usage Page (Vendor)
	0x09, 0x80,					//	Usage (ISP_Control)
	0xa1, 0x01,					//Collection (Application)

	0x15, 0x00,					//	Logical Minimum (0)
	0x26, 0xff, 0x00,		//	Logical Maximum (255)
	0x75, 0x08,					//	Report Size (8)
	0x95, 0x40,					//	Report Count (64)

	0x09, 0x02,					//	Usage (2)
	0x91, 0x02,					//	Output (Absolute, Variable, Data)
//BLDR Read Bulk
	0x09, 0x03,					//	Usage (3)
	0x81, 0x02,					//	Input (Absolute, Variable, Data)

	0xc0,      					//End Collection (Application)
};

//device descriptor
const	_USB_DEVICE_DESC	BLDRDeviceDesc=
{
	sizeof(_USB_DEVICE_DESC),	//length=0x12
	USB_DTYPE_DEVICE,	//type=1
	0x0200,						//USB 2.00
	0,								//class
	0,								//sub class
	0,								//protocol
	USBD_CTRL_PKTSZ,	//EP0 packet size=64
	VID_ESSEMI,				//VID=0x30cc
	PID_HIDBLDR,			//PID=0xfff8, 
	0x100,						//release number=1.00
	0x1,							//iManufactor
	0x2,							//iProduct=string1
	0,								//iSerialNumber
	0x1,							//number of configurations
};

const	_HID_CONFIGURATION_DESC	BLDRConfigurationDesc=
{
//configuration descriptor
	sizeof(_USB_CONFIGURATION_DESC),	//length=9
	USB_DTYPE_CONFIGURATION,					//type=2
	sizeof(_HID_CONFIGURATION_DESC),	//total length
	0x1,					//number of interface
	0x1,					//value for SetConfiguration
	0,						//string index
	0x80,					//bus power, no remote wakeup
	0x32,					//maxpower=100mA
//interface descriptor
	sizeof(_USB_INTERFACE_DESC),	//length=9
	USB_DTYPE_INTERFACE,		//type=4
	0,						//interface number
	0,						//alternate setting
	0x1,					//number of endpoints
	USB_CLASS_HID,			//HID class
	0,						//sub class
	0,						//protocol
	0x0,					//string index
//HID descriptor
	sizeof(_HID_HID_DESC),	//length=9
	HID_DTYPE_HID,			//type=0x21
	0x0111,					//bcdHID
	0x00,						//bCountryCode
	0x01,						//Number of HID class descriptors
	{
		HID_DTYPE_REPORT,		//Report descriptor type.
		sizeof(BLDRReportDesc),		//Total length of Report descriptor.
	},
//endpoint1 in descriptor
	sizeof(_USB_ENDPOINT_DESC),	//length=7
	USB_DTYPE_ENDPOINT,		//type=5
	0x81,					//EP1, in
	USB_EP_ATTR_INT,		//interrupt
	USBD_INT_PKTSZ,				//max packet size=64
	0x20,					//interval=32ms
};

//string0 descriptor
const	_USB_STRING_0_DESC  BLDRString0Desc=
{
	sizeof(_USB_STRING_0_DESC),	//length=4
	USB_DTYPE_STRING,			//type=3
	0x0409,					//language ID
};
//String 1 Descriptor
const	_USB_STRING_1_DESC  BLDRString1Desc=
{
	sizeof(_USB_STRING_1_DESC),	//length
	USB_DTYPE_STRING,		//type=3
	{
	'E','a','s','t','S','o','f','t',
	},								//string data
};
//String 2 Descriptor
const	_USB_STRING_2_DESC  BLDRString2Desc=
{
	sizeof(_USB_STRING_2_DESC),	//length
	USB_DTYPE_STRING,			//type=3
	{
	'H','I','D',' ','B','L','D','R',
	},						//string data
};

#endif	//_HIDBLDR_DESC_H
