#include "es32f0271.h"
#include "iap_update.h"
#include "eslab_parser.h"
#include <stdio.h>

#pragma pack(1)

static	uint32_t	u32IAPAddr,u32IAPSize;
uint32_t	u32IAPStart;
static	const	uint8_t	*u8BLDRResponseStr[]=
{
	"OK\r\n",
	"CMD_INVALID\r\n",
	"PARAM_ERROR\r\n",
	"COUNT_ERROR\r\n",
	"ADDR_ERROR\r\n",
	"BUSY\r\n",
	"*\r\n",
	"CHECK_ERROR\r\n",
	"ERASE_FAILED\r\n",
	"PROG_FAILED\r\n",
};

uint8_t	u8HIDIAPDone=0;

/**
  * @brief Calculate the checksum of the app flash
  * @param u32Addr is the flash address
  * @param u32Size is the flash size
  * @retval checksum
  */
static uint32_t eslab_flash_checksum(uint32_t u32Addr, uint32_t u32Size)
{
  uint32_t u32CKSum, *pu32Addr;

//	printf("A-0x%x-S-0x%x-",u32Addr,u32Size);
	u32CKSum=0;
	pu32Addr=(uint32_t *)u32Addr;
	u32Size=(u32Size+sizeof(uint32_t)-1)/sizeof(uint32_t);
	while (u32Size--)
    u32CKSum += *pu32Addr++;
//	printf("C-0x%x\t",u32CKSum);

  return(u32CKSum);
}

/**
  * @brief The end position of request string. (index of "\r\n" + 2)
  * @param pRequest is point to the request data .
	* @retval index if "\r\n" found, 0 if "\r\n" not found
  */
static	uint8_t	eslab_request_end(uint8_t *pRequest)
{
uint8_t	u8index;
	
	u8index=0;
	while (*pRequest++!=ESLAB_CMD_CR)
	{
		u8index++;
		if (u8index==0)		//"\r\n" not found
			return(u8index);
	}
	if (*pRequest!=ESLAB_CMD_LF)
		return(0);
	return(u8index+2);
}
/**
  * @brief The string is converted to the hex data
  * @param pu8Str is point to the string .
  * @param pu32Data is point to the data.
	* @retval 0:done, 1:error
  */
static	uint8_t	str2hex(uint8_t *pu8Str, uint32_t *pu32Data)
{
	*pu32Data=0;
	while (*pu8Str!=' ')
	{
		if ((*pu8Str=='x')||(*pu8Str=='X'))
		{
			*pu32Data=0;
			pu8Str++;
			continue;
		}
		if ((*pu8Str>='0')&&(*pu8Str<='9'))		//Digial 0~9
		{
			*pu32Data=((*pu32Data<<4)|(*pu8Str-'0'));
			pu8Str++;
			continue;
		}
		if ((*pu8Str>='A')&&(*pu8Str<='F'))		//Digial A~F
		{
			*pu32Data=((*pu32Data<<4)|(*pu8Str-'A')+10);
			pu8Str++;
			continue;
		}
		if ((*pu8Str>='a')&&(*pu8Str<='f'))		//Digial a~f
		{
			*pu32Data=((*pu32Data<<4)|(*pu8Str-'a')+10);
			pu8Str++;
			continue;
		}
		return(1);			//Invalid
	}
	return(0);
}
/**
  * @brief Parse the command parameter
  * @param pRequest is point to the request data.
  * @param pParameter is point to the u32 parameter data.
  * @param u8nParam is the number of parameter.
	* @retval 0:Done, 1:Error
  */
static	uint8_t	eslab_parameter_parser(uint8_t *pRequest, uint32_t *pParameter, uint8_t u8nParam)
{
uint8_t		ii;

	for (ii=0;ii<u8nParam;ii++)
	{
		while (*pRequest==ESLAB_CMD_SPACE)
			pRequest++;
		if (str2hex(pRequest,pParameter++))
			return(1);
		while (*pRequest!=ESLAB_CMD_SPACE)
		{
			if ((*pRequest==ESLAB_CMD_CR)||((*pRequest==ESLAB_CMD_LF)))
				return(1);
			pRequest++;
		}
	}
	while (*pRequest==ESLAB_CMD_SPACE)
		pRequest++;
	if (*pRequest++==ESLAB_CMD_CR)
	{
		if (*pRequest++==ESLAB_CMD_LF)
			return(0);
		else
			return(1);
	}
	else
		return(1);
	return(0);
}
/**
  * @brief Parse the request command and execute function
  * @param pRequest is point to the request data .
  * @param pResponse is point to the response data.
	* @retval Response code
  */
uint8_t	eslab_command_parser(uint8_t *pRequest, uint8_t *pResponse)
{
eESLAB_ResponseCode	ResponseCode;
uint32_t	u32Param[2],u32CKSum,u32Data[64/4];
uint8_t		ii;
	
	if (*pRequest++ != ESLAB_CMD_REQUEST)
	{
		ResponseCode=ESLAB_ACK_CMD_INVALID;
		ii=0;
		while (u8BLDRResponseStr[ResponseCode][ii]!=ESLAB_CMD_END)
		{
			printf("%c",u8BLDRResponseStr[ResponseCode][ii]);
			*pResponse++ = u8BLDRResponseStr[ResponseCode][ii++];
		}
		*pResponse=ESLAB_CMD_END;
		return(ResponseCode);
	}
	switch (*pRequest++)
	{
		case ESLAB_CMD_WRITE:
			printf("W-");
			if (eslab_parameter_parser(pRequest,u32Param,2))
			{
				printf("0x%x-0x%x-",u32Param[0],u32Param[1]);
				ResponseCode=ESLAB_ACK_PARAM_ERROR;
				break;
			}
			printf("0x%x-0x%x\r\n",u32Param[0],u32Param[1]);
			iap_flash_info(&u32IAPStart,&u32IAPSize);
      if ((u32Param[0]>=(u32IAPStart + u32IAPSize))||(u32Param[0]<u32IAPStart))
      {
				ResponseCode=ESLAB_ACK_PARAM_ERROR;
        break;
      }
      if (u32Param[1]>u32IAPSize)
      {
				ResponseCode=ESLAB_ACK_PARAM_ERROR;
        break;
      }
			if (iap_flash_erase(u32Param[0],u32Param[1]))
			{
				ResponseCode=ESLAB_ACK_ERASE_FAILED;
				break;
			}
			u32IAPStart=u32Param[0];
			u32IAPAddr=u32Param[0];
			u32IAPSize=u32Param[1];
			u8HIDIAPDone=0;
			ResponseCode=ESLAB_ACK_OK;
			break;
		case ESLAB_CMD_SEND:
			printf("D-");
			if (eslab_parameter_parser(pRequest,u32Param,2))
			{
				printf("0x%x-0x%x-",u32IAPAddr,u32Param[1]);
				ResponseCode=ESLAB_ACK_PARAM_ERROR;
				printf("Error\r\n");
				break;
			}
			printf("0x%x-0x%x\t",u32IAPAddr,u32Param[1]);
			pRequest+=eslab_request_end(pRequest);
			if (u32Param[1]==0x00)		//Program
			{
			}
			else if (u32Param[1]==0xff)		//Checksum
			{
				u32CKSum=((pRequest[3]<<24)|(pRequest[2]<<16)|(pRequest[1]<<8)|pRequest[0]);
				printf("C-0x%x-0x%x-0x%x\t",u32IAPStart,u32IAPSize,u32CKSum);
				if (u32CKSum!=eslab_flash_checksum(u32IAPStart,u32IAPSize))
				{
#if	0
					printf("\r\n");
					u32CKSum=eslab_flash_checksum(u32IAPStart,u32IAPSize);
					printf("E-0x%x\t",u32CKSum);
#endif					
					iap_flash_erase(u32IAPAddr,u32IAPSize);
					ResponseCode=ESLAB_ACK_CHECK_ERROR;
				}
				u8HIDIAPDone=1;
			}
			else
			{
				printf("P-0x%x\t",u32IAPAddr);
				for (ii=0;ii<u32Param[1];ii++)
				{
					*((uint8_t *)u32Data+ii)=*(pRequest+ii);
				}
				if (iap_flash_program(u32IAPAddr,u32Param[1],(uint32_t *)u32Data))
				{
					ResponseCode=ESLAB_ACK_PROG_FAILED;
					break;
				}
				u32IAPAddr+=u32Param[1];
			}
			ResponseCode=ESLAB_ACK_OK;
			break;
		default:
			printf("Invalid\r\n");
			ResponseCode=ESLAB_ACK_CMD_INVALID;
			break;
	}
	ii=0;
	while (u8BLDRResponseStr[ResponseCode][ii]!=ESLAB_CMD_END)
	{
		printf("%c",u8BLDRResponseStr[ResponseCode][ii]);
		*pResponse++ = u8BLDRResponseStr[ResponseCode][ii++];
	}
	*pResponse=ESLAB_CMD_END;
	return(ResponseCode);
}
