#include "es32f0271.h"
#include "md_usb.h"
#include "usbcore.h"
#include <stdio.h>

#define	COREMSG	0

_USB_STANDARD_REQUEST	USBRequest;
uint32_t	u32IntrStatus=0;

//*****************************************************************************
//!\Brief	USB IRQ Handler
//!\Param	None
//!\RetVal	None
//*****************************************************************************
void USB_IRQHandler(void)
{
	u32IntrStatus|=(md_usb_get_rif()<<16);
	u32IntrStatus|=(md_usb_get_txrif()<<8);
	u32IntrStatus|=md_usb_get_rxrif();
	md_usb_set_icr(md_usb_get_rif());
	md_usb_set_txicr(md_usb_get_txrif());
	md_usb_set_rxicr(md_usb_get_rxrif());
	
}
/**
  * @brief Allows dual mode application to switch between USB device and host modes
  *        and provides a method to force the controller into the desired mode.
  * @param iUSBMode indicates the mode that the application wishes to operate
  *        in.  Valid values are \b eUSBModeDevice to operate as a USB device and
  *        \b eUSBModeHost to operate as a USB host.
  * @retval None.
  */
void	usb_core_mode_set(tUSBMode iUSBMode)
{
	//
	// If going to unconfigured mode
	//
	if (iUSBMode == eUSBModeNone)
	{
	}
	//
	// If going to device mode
	//
	if (iUSBMode == eUSBModeDevice)
	{
	}
	//
	// If going to host mode
	//
	if (iUSBMode == eUSBModeHost)
	{
	}
	//
	// If going to otg mode
	//
	if (iUSBMode == eUSBModeOTG)
	{
	}
	//
	// If going to force device mode
	//
	if (iUSBMode == eUSBModeForceDevice)
	{
		md_usb_set_dpdmcon((MD_USB_DPDMCON_DPPUD_PULLUP<<USB_DPDMCON_DPPUD_POSS)|(MD_USB_DPDMCON_DPPUD_PULLDOWN<<USB_DPDMCON_DMPUD_POSS));
									//DP=pull up, DM=Pull Down
		md_usb_enable_dpdmcon_phypwen();	//USB Phy Enable
		md_usb_enable_swcid_device();			//CID=1 (Device)
		md_usb_enable_swcid_cidctrl();		//Enable SW CID
	}
	//
	// If going to force host mode
	//
	if (iUSBMode == eUSBModeForceHost)
	{
		md_usb_set_devcon(0);
		md_usb_set_dpdmcon((MD_USB_DPDMCON_DPPUD_PULLDOWN<<USB_DPDMCON_DPPUD_POSS)|(MD_USB_DPDMCON_DPPUD_PULLDOWN<<USB_DPDMCON_DMPUD_POSS));
									//DP,DM=Pull Down
		md_usb_enable_dpdmcon_phypwen();	//USB Phy Enable
		md_usb_enable_swcid_host();				//CID=0 (Host)
		md_usb_enable_swcid_cidctrl();		//Enable SW CID

		md_usb_set_devcon(USB_DEVCON_HOSTREQ_MSK|USB_DEVCON_SESSION_MSK);
		while (!md_usb_is_active_devcon_host());
		md_usb_enable_swvbus_sigctrl();				  
	}
}
/**
  * @brief  USB soft connect.
  * @param  None.
  * @retval None.
  */
void	usb_dev_connect()
{
	md_usb_set_dpdmcon_dppud(MD_USB_DPDMCON_DPPUD_PULLUP);	//DP=Pull up
	md_usb_enable_dpdmcon_phypwen();	//USB Phy Enable
	md_usb_enable_swcid_device();			//CID=1 (Device)
	md_usb_enable_swcid_cidctrl();		//Enable SW CID
}
/**
  * @brief  USB soft disconnect.
  * @param  None.
  * @retval None.
  */
void	usb_dev_disconnect()
{
	md_usb_set_dpdmcon_dppud(MD_USB_DPDMCON_DPPUD_FLOATING);	//DP=Floating
	md_usb_disable_swcid_cidctrl();		//Disable SW CID
}


