//-------------------------------------------------------//
//----------------------   DRIVER    --------------------//
//-------------------------------------------------------//  
#include "es32f0271.h"
#include "msdfat.h"
#include "mscbldr_host.h"
#include "msdhost_fs.h"
#include <stdio.h>

#define	FAT16_CLUSTER		4085
#define	FAT32_CLUSTER		65525

#define	LFN_SEGMENT			13
#define	LFN_CHAR_MAX		255

#define	Cluster2LBA(x)	(((x-2)*pLUNEntry->u8SectorsPerCluster)+pLUNEntry->u32FirstDataLBA)

static	uint8_t				u8DIRData[FAT_SECTOR_SZ],u8FATData[FAT_SECTOR_SZ];
static	uint32_t			u32LBAData[FAT_SECTOR_SZ/4];
static	_pLUN_ENTRY 	pLUNEntry;
static	_pSHORT_FILENAME	pSFN;
static	_pLONG_FILENAME		pLFN;
static	_LUN_ENTRY	LUNEntry;

static	uint32_t	u32FATCurrent=0;
static	uint16_t	u16LFNData[LFN_CHAR_MAX];

void	fshost_dump_lba(uint8_t *pu8Buf)
{
uint16_t	ii;

	for (ii=0;ii<FAT_SECTOR_SZ;ii++)
	{
		if ((ii&0xf)==0)
			printf("0x%04x : ",ii);
		printf("%02x ",*pu8Buf++);
		if ((ii&0xf)==0xf)
			printf("\r\n");
	}
}

uint8_t	fshost_read_lba(uint32_t u32LBAIndex, uint8_t *pu8LBABuf)
{
	if (msc_read_lba(u32LBAIndex,1,pu8LBABuf))
		return(1);
//	fshost_dump_lba(pu8LBABuf);
	return(0);
}

uint8_t	fshost_read_cluster(uint32_t u32Cluster, uint8_t *pu8LBABuf)
{
uint32_t	u32LBA;
	
	u32LBA=Cluster2LBA(u32Cluster);
	if (msc_read_lba(u32LBA,pLUNEntry->u8SectorsPerCluster,pu8LBABuf))
		return(1);
	return(0);
}

uint32_t	fshost_next_cluster(uint32_t u32Cluster)
{
uint32_t	u32NextCluster;
uint32_t	u32FATEntry,u32FATIndex;
	
	u32FATEntry=pLUNEntry->u32FAT0Entry;
	if (pLUNEntry->u8FATMedia==MEDIA_FAT16)
	{
		u32Cluster<<=1;
		u32FATEntry=u32FATEntry+(u32Cluster/FAT_SECTOR_SZ);
		if (u32FATEntry!=u32FATCurrent)
		{
			u32FATCurrent=u32FATEntry;
			if (fshost_read_lba(u32FATEntry,u8FATData))
				return(ENDOFCHAIN16);		//ENDOFCHAIN
		}
		u32FATIndex=(u32Cluster&(FAT_SECTOR_SZ-1));
		u32NextCluster=DATA16(u8FATData[u32FATIndex+1],u8FATData[u32FATIndex]);
	}
	if (pLUNEntry->u8FATMedia==MEDIA_FAT32)
	{
		u32Cluster<<=2;
		u32FATEntry=u32FATEntry+(u32Cluster/FAT_SECTOR_SZ);
		if (u32FATEntry!=u32FATCurrent)
		{
			u32FATCurrent=u32FATEntry;
			if (fshost_read_lba(u32FATEntry,u8FATData))
				return(ENDOFCHAIN32);		//ENDOFCHAIN
		}
		u32FATIndex=(u32Cluster&(FAT_SECTOR_SZ-1));
		u32NextCluster=DATA32(u8FATData[u32FATIndex+3],u8FATData[u32FATIndex+2],u8FATData[u32FATIndex+1],u8FATData[u32FATIndex]);
	}
	return(u32NextCluster);
}

void	fshost_dump_file(uint32_t u32Cluster)
{
	printf("Cluster:\r\n");
	if (pLUNEntry->u8FATMedia==MEDIA_FAT16)
	{
		while (u32Cluster<ENDOFCHAIN16)
		{
			printf("0x%04x-",u32Cluster);
			u32Cluster=fshost_next_cluster(u32Cluster);
		}
		printf("0x%04x\r\n",u32Cluster);
	}
	if (pLUNEntry->u8FATMedia==MEDIA_FAT32)
	{
		while (u32Cluster<ENDOFCHAIN32)
		{
			printf("0x%08x-",u32Cluster);
			u32Cluster=fshost_next_cluster(u32Cluster);
		}
		printf("0x%08x\r\n",u32Cluster);
	}
}

uint8_t	fshost_enumeration(void)
{
_pMBR_ENTRY		pMBREntry;
_pBPB_ENTRY		pBPBEntry;
uint32_t	u32TotalCluster,u32TotalSectors;
uint32_t	u32Root16Sectors,u32SectorsPerFAT;

	pLUNEntry=(_pLUN_ENTRY)&LUNEntry;
	pLUNEntry->u32BPBEntry=0;	//BPB=LBA0
//Load MBR Entry
	printf("Read LBA : 0x%x\r\n",pLUNEntry->u32BPBEntry);
	if (fshost_read_lba(pLUNEntry->u32BPBEntry,(uint8_t *)u32LBAData))
		return(1);
	pBPBEntry=(_pBPB_ENTRY)u32LBAData;
	if (pBPBEntry->u16Signature!=SIGNATUREID)
	{
		printf("Invalid Signature\r\n");
		return(1);
	}
	if (pBPBEntry->u16BytesPerSector!=FAT_SECTOR_SZ)
	{
		printf("is MBR\r\n");
		pLUNEntry->u32MBREntry=0;	//MBR=LBA0
		pMBREntry=(_pMBR_ENTRY)u32LBAData;
//Load BPB Entry
		pLUNEntry->u32BPBEntry=pMBREntry->Partition0.u32FirstLBA;
		printf("Read BPB : 0x%x\r\n",pLUNEntry->u32BPBEntry);
		if (fshost_read_lba(pLUNEntry->u32BPBEntry,(uint8_t *)u32LBAData))
			return(1);
		if (pBPBEntry->u16Signature!=SIGNATUREID)
		{
			printf("Invalid Signature\r\n");
			return(1);
		}
		pBPBEntry=(_pBPB_ENTRY)u32LBAData;
	}
	else
		printf("is BPB\r\n");
//FAT Determination
//Load FAT Entry
	printf("ReservedSectors=0x%x\r\n",pBPBEntry->u16ReservedSectors);
	pLUNEntry->u32FAT0Entry=(pLUNEntry->u32BPBEntry+(pBPBEntry->u16ReservedSectors));
	printf("FAT0Entry=0x%x\r\n",pLUNEntry->u32FAT0Entry);
	pLUNEntry->u8SectorsPerCluster=pBPBEntry->u8SectorsPerCluster;
	printf("SectorsPerCluster=0x%x\r\n",pLUNEntry->u8SectorsPerCluster);
//Total Sectors
	u32Root16Sectors=(pBPBEntry->u16RootEntry16*sizeof(_SHORT_FILENAME)/pBPBEntry->u16BytesPerSector);	//Bytes of Root Entries
	printf("Root16Sectors=0x%x\r\n",u32Root16Sectors);
	u32SectorsPerFAT=pBPBEntry->u16SectorsPreFAT16;
	printf("SectorsPerFAT=0x%x\r\n",u32SectorsPerFAT);
	if (u32SectorsPerFAT==0)
		u32SectorsPerFAT=pBPBEntry->Ext.Ext32.u32SectorsPreFAT32;
	printf("SectorsPerFAT=0x%x\r\n",u32SectorsPerFAT);
	pLUNEntry->u32FAT1Entry=(pLUNEntry->u32FAT0Entry+u32SectorsPerFAT);
	printf("FAT1Entry=0x%x\r\n",pLUNEntry->u32FAT1Entry);
	pLUNEntry->u32FirstDataLBA=(pLUNEntry->u32FAT1Entry+u32SectorsPerFAT);
	printf("FirstDataLBA=0x%x\r\n",pLUNEntry->u32FirstDataLBA);
	u32TotalSectors=pBPBEntry->u16TotalSectors16;
	if (u32TotalSectors==0)
		u32TotalSectors=pBPBEntry->u32TotalSectors32;
	printf("TotalSectors=0x%x\r\n",u32TotalSectors);
//Total Clusters
	u32TotalCluster=(u32TotalSectors-u32Root16Sectors)/pBPBEntry->u8SectorsPerCluster;		//TotalCluster Clusters
	if (u32TotalCluster<FAT16_CLUSTER)
	{
		pLUNEntry->u8FATMedia=MEDIA_FAT12;
		printf("FAT12\r\n");
		return(1);
	}
	if (u32TotalCluster<FAT32_CLUSTER)
	{
		printf("FAT16\r\n");
		pLUNEntry->u8FATMedia=MEDIA_FAT16;
		pLUNEntry->u32FirstDataLBA+=u32Root16Sectors;
		pLUNEntry->u32RootCluster=0;
		pLUNEntry->u16RootLBA=(pLUNEntry->u32FAT1Entry+u32SectorsPerFAT);
	}
	else
	{
		printf("FAT32\r\n");
		pLUNEntry->u8FATMedia=MEDIA_FAT32;
		pLUNEntry->u32RootCluster=pBPBEntry->Ext.Ext32.u32RootCluster;
		pLUNEntry->u16RootLBA=Cluster2LBA(pLUNEntry->u32RootCluster);
	}
	
	printf("FAT0Entry : 0x%x\r\n",pLUNEntry->u32FAT0Entry);
	printf("FAT1Entry : 0x%x\r\n",pLUNEntry->u32FAT1Entry);
	printf("Cluster2 : 0x%x\r\n",pLUNEntry->u32FirstDataLBA);
	printf("SectorsPerCluster : 0x%x\r\n",pLUNEntry->u8SectorsPerCluster);
	printf("RootCluster : 0x%x\r\n",pLUNEntry->u32RootCluster);
	
	return(0);
}

void	fshost_dump_lfn(uint16_t *pu16LFNData)
{
	while (*pu16LFNData)
	{
		if (*pu16LFNData>>8)
			printf("%c%c",(*pu16LFNData>>8),(*pu16LFNData&0xff));
		else
			printf("%c",(*pu16LFNData&0xff));
		pu16LFNData++;
	}
	printf("\t<LFN>\r\n");
}

uint8_t	fshost_root_dir(void)
{
uint32_t	u32RootLBA,u32RootCluster;
uint8_t		ii,u8DIRIndex,u8SectorOrder;

	u32RootLBA=pLUNEntry->u16RootLBA;
	u32RootCluster=pLUNEntry->u32RootCluster;
	printf("RootLBA=0x%x\r\n",u32RootLBA);
	fshost_read_lba(u32RootLBA,u8DIRData);
	pSFN=(_pSHORT_FILENAME)u8DIRData;
	u8DIRIndex=0;
	u8SectorOrder=0;
	while (pSFN->u8Name[0]!=SFN_EMPTY)
	{
		if (pSFN->u8Attribute==SFN_ATTR_LFN)
		{
			pLFN=(_pLONG_FILENAME)pSFN;
			if (pLFN->u8Ordinal&0x40)		//The Last Field
			{
				pLFN->u8Ordinal&=0x3f;
				u16LFNData[pLFN->u8Ordinal*LFN_SEGMENT]=0;
			}
			pLFN->u8Ordinal--;		//Order-1
			for (ii=0;ii<5;ii++)			//UniCode 0~4
				u16LFNData[pLFN->u8Ordinal*LFN_SEGMENT+ii]=pLFN->u16UniCode0[ii];
			for (;ii<11;ii++)					//UniCode 5~10
				u16LFNData[pLFN->u8Ordinal*LFN_SEGMENT+ii]=pLFN->u16UniCode1[ii-5];
			for (;ii<13;ii++)					//UniCode 11~12
				u16LFNData[pLFN->u8Ordinal*LFN_SEGMENT+ii]=pLFN->u16UniCode2[ii-11];
			if (pLFN->u8Ordinal==0)
				fshost_dump_lfn(u16LFNData);
		}
		else
		{
			if (pSFN->u8Name[0]==SFN_ERASE)		//Erased
				printf("?");
			else
				if (pSFN->u8Name[0]==SFN_E5)		//0xE5
					printf("%c",0xe5);
				else
					printf("%c",pSFN->u8Name[0]);
			for (ii=1;ii<8;ii++)
				printf("%c",pSFN->u8Name[ii]);
			if (!(pSFN->u8Attribute&SFN_ATTR_VOLUME))
				printf(".");
			for (ii=0;ii<3;ii++)
				printf("%c",pSFN->u8Extension[ii]);
			if (pSFN->u8Attribute&SFN_ATTR_VOLUME)
			{
				printf("\t<Volnme>\r\n");
			}
			if (pSFN->u8Attribute&SFN_ATTR_SUBDIR)
			{
				printf("\t<DIR>\r\n");
			}
			if (pSFN->u8Attribute&SFN_ATTR_ARCHIVE)
			{
				printf("\t<Archive>\r\n");
			}
		}
		pSFN++;
		u8DIRIndex++;
		if (u8DIRIndex==(FAT_SECTOR_SZ/sizeof(_SHORT_FILENAME)))
		{
			if (pLUNEntry->u8FATMedia==MEDIA_FAT16)
				u32RootLBA++;
			if (pLUNEntry->u8FATMedia==MEDIA_FAT32)
			{
				u32RootLBA++;
				u8SectorOrder++;
				if (u8SectorOrder==pLUNEntry->u8SectorsPerCluster)
				{
					u32RootCluster=fshost_next_cluster(u32RootCluster);
					u32RootLBA=Cluster2LBA(u32RootCluster);
					u8SectorOrder=0;
				}
			}
			printf("RootLBA=0x%x\r\n",u32RootLBA);
			fshost_read_lba(u32RootLBA,u8DIRData);
			pSFN=(_pSHORT_FILENAME)u8DIRData;
			u8DIRIndex=0;
		}
	}
	return(0);
}

uint8_t	fshost_identify_name(uint8_t u8Size, uint8_t *u8DirName, uint8_t *u8UserName)
{
uint8_t	ii;
	
	while ((*u8DirName)&&(*u8UserName))
	{
		for (ii=0;ii<u8Size;ii++)
		{
			if ((*u8DirName++)!=(*u8UserName++))
				return(1);
		}
	}
	if (*u8UserName)
		return(1);
	return(0);
}

uint8_t	fshost_app_identify(uint16_t *u16LFName, uint8_t *u8Ext)
{
uint32_t	u32RootLBA,u32RootCluster;
uint8_t		ii,u8DIRIndex,u8SectorOrder;

	u32RootLBA=pLUNEntry->u16RootLBA;
	u32RootCluster=pLUNEntry->u32RootCluster;
	printf("RootLBA=0x%x\r\n",u32RootLBA);
	fshost_read_lba(u32RootLBA,u8DIRData);
	pSFN=(_pSHORT_FILENAME)u8DIRData;
	u8DIRIndex=0;
	u8SectorOrder=0;
	while (pSFN->u8Name[0]!=SFN_EMPTY)
	{
		if (pSFN->u8Attribute==SFN_ATTR_LFN)
		{
			pLFN=(_pLONG_FILENAME)pSFN;
			if (pLFN->u8Ordinal&0x40)		//The Last Field
			{
				pLFN->u8Ordinal&=0x3f;
				u16LFNData[pLFN->u8Ordinal*LFN_SEGMENT]=0;
			}
			pLFN->u8Ordinal--;		//Order-1
			for (ii=0;ii<5;ii++)			//UniCode 0~4
				u16LFNData[pLFN->u8Ordinal*LFN_SEGMENT+ii]=pLFN->u16UniCode0[ii];
			for (;ii<11;ii++)					//UniCode 5~10
				u16LFNData[pLFN->u8Ordinal*LFN_SEGMENT+ii]=pLFN->u16UniCode1[ii-5];
			for (;ii<13;ii++)					//UniCode 11~12
				u16LFNData[pLFN->u8Ordinal*LFN_SEGMENT+ii]=pLFN->u16UniCode2[ii-11];
//			if (pLFN->u8Ordinal==0)
//				fshost_dump_lfn(u16LFNData);
		}
		else
		{
			if (pSFN->u8Name[0]==SFN_ERASE)		//Erased
				printf("?");
			else
				if (pSFN->u8Name[0]==SFN_E5)		//0xE5
					printf("%c",0xe5);
				else
					printf("%c",pSFN->u8Name[0]);
			for (ii=1;ii<8;ii++)
				printf("%c",pSFN->u8Name[ii]);
			if (!(pSFN->u8Attribute&SFN_ATTR_VOLUME))
				printf(".");
			for (ii=0;ii<3;ii++)
				printf("%c",pSFN->u8Extension[ii]);
			if (pSFN->u8Attribute&SFN_ATTR_VOLUME)
			{
				printf("\t<Volnme>\r\n");
			}
			if (pSFN->u8Attribute&SFN_ATTR_SUBDIR)
			{
				printf("\t<DIR>\r\n");
			}
			if (pSFN->u8Attribute&SFN_ATTR_ARCHIVE)
			{
				printf("\t<Archive>\r\n");
				if (!fshost_identify_name(sizeof(uint8_t),pSFN->u8Extension,u8Ext))
				{
					if (!fshost_identify_name(sizeof(uint16_t),(uint8_t *)u16LFNData,(uint8_t *)u16LFName))
					{
						fshost_dump_lfn(u16LFNData);
						fshost_dump_file((pSFN->u16FirstCluster32<<16)|pSFN->u16FirstCluster16);
						return(0);
					}
				}
			}
		}
		pSFN++;
		u8DIRIndex++;
		if (u8DIRIndex==(FAT_SECTOR_SZ/sizeof(_SHORT_FILENAME)))
		{
			if (pLUNEntry->u8FATMedia==MEDIA_FAT16)
				u32RootLBA++;
			if (pLUNEntry->u8FATMedia==MEDIA_FAT32)
			{
				u32RootLBA++;
				u8SectorOrder++;
				if (u8SectorOrder==pLUNEntry->u8SectorsPerCluster)
				{
					u32RootCluster=fshost_next_cluster(u32RootCluster);
					u32RootLBA=Cluster2LBA(u32RootCluster);
					u8SectorOrder=0;
				}
			}
			fshost_read_lba(u32RootLBA,u8DIRData);
			pSFN=(_pSHORT_FILENAME)u8DIRData;
			u8DIRIndex=0;
		}
	}
	printf("No matched bin file found\r\n");
	return(1);
}

uint8_t		fshost_app_info(uint32_t *pu32StartClus, uint32_t *pu32FileSize)
{
	
	*pu32StartClus=((pSFN->u16FirstCluster32<<16)|pSFN->u16FirstCluster16);
	*pu32FileSize=pSFN->u32Size;
	return(0);
}

uint32_t	fshost_app_sector(uint32_t *pu32Cluster, uint8_t *pu8Index)
{
uint32_t	u32Sector;
	
	u32Sector=Cluster2LBA(*pu32Cluster)+*pu8Index;
	(*pu8Index)++;
	if (*pu8Index==pLUNEntry->u8SectorsPerCluster)
	{
		*pu8Index=0;
		*pu32Cluster=fshost_next_cluster(*pu32Cluster);
		if (pLUNEntry->u8FATMedia==MEDIA_FAT16)
		{
			if (*pu32Cluster<ENDOFCHAIN16)
				return(u32Sector);
			else
				return(0);
		}
		if (pLUNEntry->u8FATMedia==MEDIA_FAT32)
		{
			if (*pu32Cluster<ENDOFCHAIN32)
				return(u32Sector);
			else
				return(0);
		}
	}
	return(u32Sector);
}

