//-------------------------------------------------------//
//----------------------   DRIVER    --------------------//
//-------------------------------------------------------//  
#include "es32f0271.h"
#include "msdfat.h"
#include "fat16data.h"
#include "msddev_fs.h"
#include "iap_update.h"
#include <stdio.h>

#define	LFN_SEGMENT		13
#define	MAX_FILENAME	30

static	msd_boot_state_t eBootState = BOOT_STATE_READY;  
static	uint16_t	u16UpdateName[MAX_FILENAME];
static	uint32_t	u32UpdateLBA;
static	uint32_t	u32IAPAddr,u32IAPSize;

uint32_t	u32MSCIAPStart;
uint8_t		u8MSCIAPDone=0;

uint8_t	fsdev_read_lba(uint32_t u32LBA, uint32_t *pu32Buf)
{
uint32_t	u32EFAddr;
uint16_t	ii;
uint8_t		*pu8Buf;

	pu8Buf=(uint8_t *)pu32Buf;
	switch (u32LBA)
	{	
    /* Boot Sector */
    case DBR_SECTOR:
			for (ii=0;ii<sizeof(_BPB_ENTRY);ii++)
				*pu8Buf++=*((uint8_t *)&FAT16_BPBEntry+ii);
      break;

    /* FAT Table Sector */
    case FAT16_FAT0_SECTOR:
    case FAT16_FAT1_SECTOR:
			for (ii=0;ii<sizeof(FAT16_FATHeader);ii++)
				*pu8Buf++=FAT16_FATHeader[ii];
			for (;ii<FAT_SECTOR_SZ;ii++)
				*pu8Buf++=0;
      break;

    /* Root Directory Sector */
    case FAT16_ROOT_SECTOR:
			for (ii=0;ii<sizeof(_SHORT_FILENAME);ii++)
				*pu8Buf++=*((uint8_t *)&SFN_MSDVolume+ii);
      switch (eBootState)
      {
        case BOOT_STATE_READY:
					for (ii=0;ii<sizeof(FAT16_ReadyFileName);ii++)
						*pu8Buf++=FAT16_ReadyFileName[ii];
          break;
        case BOOT_STATE_FLASH_ERROR:
					for (ii=0;ii<sizeof(FAT16_FailFileName);ii++)
						*pu8Buf++=FAT16_FailFileName[ii];
          break;
        case BOOT_STATE_SUCCESS:
					for (ii=0;ii<sizeof(FAT16_SuccessFileName);ii++)
						*pu8Buf++=FAT16_SuccessFileName[ii];
          break;
        case BOOT_STATE_START:
					for (ii=0;ii<sizeof(FAT16_StartedFileName);ii++)
						*pu8Buf++=FAT16_StartedFileName[ii];
          break;
      }
			for (;ii<sizeof(_SHORT_FILENAME);ii++)
				*pu8Buf++=*((uint8_t *)&SFN_VirtualFile+ii);
			for (;ii<FAT_SECTOR_SZ;ii++)
				*pu8Buf++=0;		
      break;

    /* All other sectors empty */
    default:
#if	0			
			if (u32LBA>=FAT16_DATA_SECTOR)
			{
				iap_flash_info(&u32MSCIAPStart, &u32IAPSize);
				u32EFAddr=(u32LBA-FAT16_DATA_SECTOR)*FAT_SECTOR_SZ;
				u32EFAddr+=u32MSCIAPStart;
				iap_flash_read(u32EFAddr, FAT_SECTOR_SZ, pu32Buf);
			}
			else
			{
				for (ii=0;ii<FAT_SECTOR_SZ;ii++)
					*pu8Buf++=0;
			}
#else			
			for (ii=0;ii<FAT_SECTOR_SZ;ii++)
				*pu8Buf++=0;
#endif
      break;
	}
	return(0);
}

void	fsdev_dump_lfn(uint16_t *pu16LFNData)
{
	while (*pu16LFNData)
	{
		if (*pu16LFNData>>8)
			printf("%c%c",(*pu16LFNData>>8),(*pu16LFNData&0xff));
		else
			printf("%c",(*pu16LFNData&0xff));
		pu16LFNData++;
	}
	printf("\t<LFN>\r\n");
}

uint8_t	fsdev_write_lba(uint32_t u32LBA, uint32_t *pu32Buf)
{
_pSHORT_FILENAME	pSFN;
_pLONG_FILENAME		pLFN;
uint32_t	u32EFAddr;
uint8_t		ii;
	
	if (u32LBA==FAT16_ROOT_SECTOR)		//Parser File Name
	{
		pSFN=(_pSHORT_FILENAME)pu32Buf;
		while (pSFN->u8Name[0]!=SFN_EMPTY)
		{
			if (pSFN->u8Attribute==SFN_ATTR_LFN)
			{
				pLFN=(_pLONG_FILENAME)pSFN;
				if (pLFN->u8Ordinal&0x40)		//The Last Field
				{
					pLFN->u8Ordinal&=0x3f;
					u16UpdateName[pLFN->u8Ordinal*LFN_SEGMENT]=0;
				}
				pLFN->u8Ordinal--;		//Order-1
				for (ii=0;ii<5;ii++)			//UniCode 0~4
					u16UpdateName[pLFN->u8Ordinal*LFN_SEGMENT+ii]=pLFN->u16UniCode0[ii];
				for (;ii<11;ii++)					//UniCode 5~10
					u16UpdateName[pLFN->u8Ordinal*LFN_SEGMENT+ii]=pLFN->u16UniCode1[ii-5];
				for (;ii<13;ii++)					//UniCode 11~12
					u16UpdateName[pLFN->u8Ordinal*LFN_SEGMENT+ii]=pLFN->u16UniCode2[ii-11];
				if (pLFN->u8Ordinal==0)
				{
//					if (!fsdev_bin_check(u16UpdateName))
						eBootState=BOOT_STATE_IDENTIFY;
				}
			}
			if (pSFN->u8Attribute==SFN_ATTR_ARCHIVE)
			{
				if (eBootState!=BOOT_STATE_IDENTIFY)
				{
					printf("Identify Error\r\n");
					eBootState=BOOT_STATE_READY;
					pSFN++;
					continue;
				}
				if ((pSFN->u8Extension[0]!='B')||(pSFN->u8Extension[1]!='I')||(pSFN->u8Extension[2]!='N'))
				{
					printf("Ext Error\r\n");
					eBootState=BOOT_STATE_READY;
					pSFN++;
					continue;
				}
				iap_flash_info(&u32MSCIAPStart, &u32IAPSize);
				if (pSFN->u32Size>u32IAPSize)
				{
					printf("Size Error\r\n");
					eBootState=BOOT_STATE_READY;
					pSFN++;
					continue;
				}
				u32IAPSize=pSFN->u32Size;
				eBootState=BOOT_STATE_START;
				u32UpdateLBA=((pSFN->u16FirstCluster16-2)*BPB_SECTORS_PER_CLUSTER+FAT16_DATA_SECTOR);
				fsdev_dump_lfn(u16UpdateName);
				printf("FileSize=%d\r\n",u32IAPSize);
				printf("Cluster=0x%x\tLBA=0x%x\r\n",pSFN->u16FirstCluster16,u32UpdateLBA);
			}
			pSFN++;
		}
	}
	if (u32LBA>=u32UpdateLBA)		//Parser File Name
	{
		if (eBootState!=BOOT_STATE_START)
			return(0);
		u32EFAddr=(u32LBA-u32UpdateLBA)*FAT_SECTOR_SZ;
		u32EFAddr+=IAP_FLASH_START;
		if ((u32EFAddr&FAT_SECTOR_SZ)==0)		//Page Boundary
		{
			iap_flash_erase(u32EFAddr,IAP_FLASH_PAGE_SIZE);
			printf("PErase 0x%x\r\n",u32EFAddr);
		}
		iap_flash_program(u32EFAddr, FAT_SECTOR_SZ, pu32Buf);
		printf("Program 0x%x\r\n",u32EFAddr);
		if ((u32LBA-u32UpdateLBA)==((u32IAPSize-1)/FAT_SECTOR_SZ))
		{
			printf("Success\r\n");
			eBootState=BOOT_STATE_SUCCESS;
			u8MSCIAPDone=1;
		}
	}
	return(0);
}

uint8_t	fsdev_read_cluster(uint32_t u32Cluster, uint32_t *pu32Buf)
{
	return(0);
}

