#ifndef	_FAT16DATA_H
#define	_FAT16DATA_H

/* Public Macros --------------------------------------------------------------*/
#define BPB_BYTES_PER_SECTOR					(512)
#define BPB_NUMBER_OF_SECTORS					(64*1024*1024/BPB_BYTES_PER_SECTOR)
#define BPB_SECTORS_PER_CLUSTER				(2)
#define BPB_RESERVED_SECTORS					(2)
#define BPB_NUMBER_OF_FAT							(2)
#define BPB_SECTORS_PER_FAT						(255) 
#define BPB_NUMBER_OF_ROOT_ENTRY			(512)

#define DBR_SECTOR										(0)
#define FAT16_FAT0_SECTOR							(DBR_SECTOR + BPB_RESERVED_SECTORS)
#define FAT16_FAT1_SECTOR							(FAT16_FAT0_SECTOR + BPB_SECTORS_PER_FAT)
#define FAT16_ROOT_SECTOR							(FAT16_FAT1_SECTOR + BPB_SECTORS_PER_FAT)
#define FAT16_DATA_SECTOR							(FAT16_ROOT_SECTOR + (BPB_NUMBER_OF_ROOT_ENTRY/16))

static	const	_BPB_ENTRY	FAT16_BPBEntry=
{
	0xeb,0x3c,0x90,						//Jump Code
	{'M','S','D','O','S','5','.','0',},	//OEM Name
	BPB_BYTES_PER_SECTOR,			//Bytes Per Sector
	BPB_SECTORS_PER_CLUSTER,	//Sectors Per Cluster
	BPB_RESERVED_SECTORS,			//Reserved Sectors
  BPB_NUMBER_OF_FAT,				//Number of FAT
  BPB_NUMBER_OF_ROOT_ENTRY,	//Maxinum Number of FAT12/16 Root Entries
  0x00,											//FAT16 Total Logical Sectors
  0xf8,											//Media ID
  BPB_SECTORS_PER_FAT,			//Logical Sectors Per FAT16
  0x3f,											//Sectors Per Track
  0xff,											//Number of Heads
  0,												//Number of Hidden Sectors
  BPB_NUMBER_OF_SECTORS,		//Number of Sectors
//Ext16	
  0x80,											//Logical Drive Number of Partition
  0x00,											//Reserved
  0x29,											//Extended Sugnature
  0x1e6fd2bb,								//Serial Number of Partition
  {'N','O',' ','N','A','M','E',' ',' ',' ',' ',},	//Volume Name of Partition
  {'F','A','T','1','6',' ',' ',' ',},		//FAT32 Name
  {0x00},										//Executable Code
  SIGNATUREID,							//Signature 
};

static	const	_SHORT_FILENAME	SFN_MSDVolume=
{
	'M','S','D',' ','B','L','D','R',	//File Name
	' ',' ',' ',			//Extension Name
	SFN_ATTR_VOLUME,	//Attribute
	0x00,					//Reserved for NT
	0x00,					//Create Time, mS
	0x0000,				//Create Time
	0x0000,				//Create Date
	0x0000,				//Last Access Date
	0x0000,				//First Cluster 3~2
	0x8e41,				//Last Modified Time
	0x32bb,				//Last Modified Date
	0x0000,				//First Cluster 1~0
	0x00000000		//File Size
};

static	const	_SHORT_FILENAME	SFN_VirtualFile=
{
	' ',' ',' ',' ',' ',' ',' ',' ',	//File Name
	' ', ' ', ' ',			//Extension Name
	SFN_ATTR_READONLY,	//Attribute
	0x00,					//Reserved for NT
	0x00,					//Create Time, mS
	0x0000,				//Create Time
	0x4876,				//Create Date
	0x4876,				//Last Access Date
	0x0000,				//First Cluster 3~2
	0x83dc,				//Last Modified Time
	0x4ea6,				//Last Modified Date
	0x0000,				//First Cluster 1~0
	0x00000000		//File Size
};

const uint8_t FAT16_ReadyFileName[] =
{
  'R','E','A','D','Y',' ',' ',' ',		/*00-07 - Short File Name */
};

const uint8_t FAT16_SuccessFileName[] =
{
  'S','U','C','C','E','S','S',' ', 	/*00-07 - Short File Name */
};

const uint8_t FAT16_FailFileName[] =
{
  'F','A','I','L','E','D',' ',' ',		/*00-07 - Short File Name */
};

const uint8_t FAT16_StartedFileName[] =
{
  'S','T','A','R','T','E','D',' ',		/*00-07 - Short File Name */
};

const	uint8_t	FAT16_FATHeader[]=
{
  0xf8,0xff,0xff,0xff,
};

#endif	//_FAT16DATA_H
