/**
  **************************************************************************************
  * @file    iap_update.h
  * @brief   iap update head file.
  * @data    5/17/2019
  * @author  Eastsoft AE Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __IAP_UPDATE_H__
#define __IAP_UPDATE_H__  
/* Includes -------------------------------------------------------------------*/ 
/* Public Functions -----------------------------------------------------------*/
/* Public Typedef -------------------------------------------------------------*/
/* Public Macros --------------------------------------------------------------*/
#define	EF_FALSH_TOTAL					(0x10000)
#define IAP_FLASH_PAGE_SIZE			(0x00000400U)
#define IAP_FLASH_START					(0x00004000U)
#define IAP_FLASH_SIZE					(EF_FALSH_TOTAL-IAP_FLASH_START)

/* Public Constants -----------------------------------------------------------*/
/* Public Variables -----------------------------------------------------------*/
/* Private Macros -------------------------------------------------------------*/
/* Private Constants-----------------------------------------------------------*/
/* Private Functions ----------------------------------------------------------*/
uint8_t iap_check_and_run(uint32_t);
uint8_t iap_flash_erase(uint32_t, uint32_t);
uint8_t iap_flash_program(uint32_t, uint32_t, uint32_t *);
uint8_t iap_flash_read(uint32_t, uint32_t, uint32_t *);
void iap_flash_info(uint32_t *, uint32_t *);
#endif		//__IAP_UPDATE_H__
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/

