#ifndef _FCLIB_H
#define _FCLIB_H

/* Private Macros ------------------------------------------------------------*/
/* Library Base Address-------------------------------------------------------*/
#define	LIBRARY_BASE	(0x10000000)

/* FC Base Address------------------------------------------------------------*/
#define	FCLIB_BASE	(LIBRARY_BASE+0x0040)
	#define	FCLIB_MERASE_BASE				(FCLIB_BASE+0x000)		//LIBRARY_BASE+0x0040
	#define	FCLIB_PERASE_BASE				(FCLIB_BASE+0x008)		//LIBRARY_BASE+0x0048
	#define	FCLIB_READ_BASE					(FCLIB_BASE+0x010)		//LIBRARY_BASE+0x0050
	#define	FCLIB_PROGRAM_BASE			(FCLIB_BASE+0x018)		//LIBRARY_BASE+0x0058
	#define	FCLIB_UPDPL1OPT_BASE		(FCLIB_BASE+0x020)		//LIBRARY_BASE+0x0060
	#define	FCLIB_UPDPL2OPT_BASE		(FCLIB_BASE+0x028)		//LIBRARY_BASE+0x0068
	#define	FCLIB_UPDREMAPOPT_BASE	(FCLIB_BASE+0x030)		//LIBRARY_BASE+0x0070

/* Private function prototypes -----------------------------------------------*/
//*****************************************************************************
//!\Brief	FC Main Erase
//!\Param	MEraseID:	Key for Main Erase, Must be 0xA5A5AA55
//!\RetVal	None
//*****************************************************************************
typedef	void	(*fclib_merase_func)(uint32_t);
#define	fclib_merase	(*(fclib_merase_func)((uint32_t *)(FCLIB_MERASE_BASE|0x01)))	//FCLIB_MErase
//*****************************************************************************
//!\Brief	FC Page Erase
//!\Param	Addr	:	EFlash Address
//!\Param	AddrC	:	Complement of EFlash Address
//!\RetVal	None
//*****************************************************************************
typedef	void	(*fclib_perase_func)(uint32_t, uint32_t);
#define	fclib_perase	(*(fclib_perase_func)((uint32_t *)(FCLIB_PERASE_BASE|0x01)))	//FCLIB_PErase
//*****************************************************************************
//!\Brief	FC Page Read
//!\Param	Addr	:	EFlash Address
//!\Param	BCnt	:	Byte Count to Read
//!\Param	*pu32Buf:	Data Buffer to be Read
//!\RetVal	None
//*****************************************************************************
typedef	void	(*fclib_read_func)(uint32_t, uint16_t, uint32_t *);
#define	fclib_read		(*(fclib_read_func)((uint32_t *)(FCLIB_READ_BASE|0x01)))			//FCLIB_Read
//*****************************************************************************
//!\Brief	FC Page Program
//!\Param	Addr	:	EFlash Address
//!\Param	AddrC	:	Complement of EFlash Address
//!\Param	BCnt	:	Byte Count to Program
//!\Param	*pU32Buf:	Data Buffer to Program
//!\RetVal	None
//*****************************************************************************
typedef	void	(*fclib_program_func)(uint32_t, uint32_t, uint16_t, uint32_t *);
#define	fclib_program	(*(fclib_program_func)((uint32_t *)(FCLIB_PROGRAM_BASE|0x01)))	//FCLIB_Program
//*****************************************************************************
//!\Brief	FC Update Protect Level 1 Option
//!\Param	UpdateL1L	:	New Level 1 Bit Mapping Low Byte (0=Protect, 1=Unprotect)
//!\Param	UpdateL1H	:	New Level 1 Bit Mapping High Byte (0=Protect, 1=Unprotect)
//!\Param	ClearL1L	:	Erase EFlash Bit Mapping Low Byte (0=Reserve, 1=Erase)
//!\Param	ClearL1H	:	Erase EFlash Bit Mapping Low Byte (0=Reserve, 1=Erase)
//!\RetVal	None
//*****************************************************************************
typedef	void	(*fclib_update_protect_l1_func)(uint32_t, uint32_t, uint32_t, uint32_t);
#define	fclib_update_protect_l1	(*(fclib_update_protect_l1_func)((uint32_t *)(FCLIB_UPDPL1OPT_BASE|0x01)))	//FCLIB_UpdPL1Opt
//*****************************************************************************
//!\Brief	FC Update Protect Level 2 Option
//!\Param	UpdateL2L	:	New Level 2 Bit Mapping Low Byte (0=Protect, 1=Unprotect)
//!\Param	UpdateL2H	:	New Level 2 Bit Mapping High Byte (0=Protect, 1=Unprotect)
//!\Param	ClearL2L	:	Erase EFlash Bit Mapping Low Byte (0=Reserve, 1=Erase)
//!\Param	ClearL2H	:	Erase EFlash Bit Mapping Low Byte (0=Reserve, 1=Erase)
//!\RetVal	None
//*****************************************************************************
typedef	void	(*fclib_update_protect_l2_func)(uint32_t, uint32_t, uint32_t, uint32_t);
#define	fclib_update_protect_l2	(*(fclib_update_protect_l2_func)((uint32_t *)(FCLIB_UPDPL2OPT_BASE|0x01)))	//FCLIB_UpdPL2Opt
//*****************************************************************************
//!\Brief	FC Update Remap Option
//!\Param	UpdRemap	:	New Remap Setting (0~F=EFlash (4K Base), 0x10=BootLoader)
//!\RetVal	None
//*****************************************************************************
typedef	void	(*fclib_update_remap_func)(uint8_t);
#define	fclib_update_remap	(*(fclib_update_remap_func)((uint32_t *)(FCLIB_UPDREMAPOPT_BASE|0x01)))	//FCLIB_UpdRemap

#endif	//_FCLIB_H
