#ifndef	_USBENUM_H
#define	_USBENUM_H

#pragma pack(1)

//Constant Definition
//Define EP Constant
#define	USBEP0		0
#define	USBEP1		1
#define	USBEP2		2
#define	USBEP3		3
#define	USBEP4		4
#define	USBEP5		5
#define	USBEP6		6

//Endpoint Packet Size
#define	USBH_CTRL_PKTSZ		64
#define	USBH_BULK_PKTSZ		64
#define	USBH_INT_PKTSZ		64
#define	USBH_ISO_PKTSZ		256

//Endpoint Packet Size
#define	USBD_CTRL_PKTSZ		64
#define	USBD_BULK_PKTSZ		64
#define	USBD_INT_PKTSZ		64
#define	USBD_ISO_PKTSZ		256

#if	0
//POWER
#define	USB_POWER_ISOUPD		(1<<7)		//Device
//#define	USB_POWER_VBUSVAL		(1<<6)
//#define	USB_POWER_VBUSSESS	(1<<5)
//#define	USB_POWER_VBUSLO		(1<<4)
#define	USB_POWER_RESET	  	(1<<3)		//Host/Device
#define	USB_POWER_RESUME		(1<<2)		//Host/Device
#define	USB_POWER_SUSPEND		(1<<1)		//Host/Device
#define	USB_POWER_SUSPENDEN	(1<<0)		//Device
//DPDMCON
#define	USB_DPDMCON_DPPD			(2<<3)
#define	USB_DPDMCON_DPPU			(1<<3)
#define	USB_DPDMCON_DPFLOAT		(0<<3)
#define	USB_DPDMCON_DMPD			(2<<1)
#define	USB_DPDMCON_DMPU			(1<<1)
#define	USB_DPDMCON_DMFLOAT		(0<<1)
#define	USB_DPDMCON_PHYPWREN	(1<<0)
//SWCID
#define	USB_SWCID_DEVICE	(1<<1)
#define	USB_SWCID_HOST		(0<<1)
#define	USB_SWCID_CIDCTRL	(1<<0)
//SWVBUS
#define	USB_SWVBUS_VALTH		(1<<3)
#define	USB_SWVBUS_SESVALTH	(1<<2)
#define	USB_SWVBUS_SESENDTH	(1<<1)
#define	USB_SWVBUS_SIGCTRL	(1<<0)
//TXIER
#define	USB_TXIE_EP7			(1<<7)
#define	USB_TXIE_EP6			(1<<6)
#define	USB_TXIE_EP5			(1<<5)
#define	USB_TXIE_EP4			(1<<4)
#define	USB_TXIE_EP3			(1<<3)
#define	USB_TXIE_EP2			(1<<2)
#define	USB_TXIE_EP1			(1<<1)
#define	USB_TXIE_EP0			(1<<0)
//RXIER
#define	USB_RXIE_EP7			(1<<7)
#define	USB_RXIE_EP6			(1<<6)
#define	USB_RXIE_EP5			(1<<5)
#define	USB_RXIE_EP4			(1<<4)
#define	USB_RXIE_EP3			(1<<3)
#define	USB_RXIE_EP2			(1<<2)
#define	USB_RXIE_EP1			(1<<1)
//USBIER
#define	USB_USBIE_VBUSERR		(1<<7)
#define	USB_USBIE_SESSREQ		(1<<6)
#define	USB_USBIE_DISCON		(1<<5)
#define	USB_USBIE_CONN			(1<<4)
#define	USB_USBIE_SOF				(1<<3)
#define	USB_USBIE_BABBLE		(1<<2)
#define	USB_USBIE_RESUME		(1<<1)
#define	USB_USBIE_SUSPEND		(1<<0)
//TXIFR
#define	USB_TXIF_EP7			(1<<7)
#define	USB_TXIF_EP6			(1<<6)
#define	USB_TXIF_EP5			(1<<5)
#define	USB_TXIF_EP4			(1<<4)
#define	USB_TXIF_EP3			(1<<3)
#define	USB_TXIF_EP2			(1<<2)
#define	USB_TXIF_EP1			(1<<1)
#define	USB_TXIF_EP0			(1<<0)
//RXIFR
#define	USB_RXIF_EP7			(1<<7)
#define	USB_RXIF_EP6			(1<<6)
#define	USB_RXIF_EP5			(1<<5)
#define	USB_RXIF_EP4			(1<<4)
#define	USB_RXIF_EP3			(1<<3)
#define	USB_RXIF_EP2			(1<<2)
#define	USB_RXIF_EP1			(1<<1)
//USBIFR
#define	USB_USBIF_VBUSERR		(1<<7)
#define	USB_USBIF_SESSREQ		(1<<6)
#define	USB_USBIF_DISCON		(1<<5)
#define	USB_USBIF_CONN			(1<<4)
#define	USB_USBIF_SOF				(1<<3)
#define	USB_USBIF_BABBLE		(1<<2)
#define	USB_USBIF_RESUME		(1<<1)
#define	USB_USBIF_SUSPEND		(1<<0)
//DEVCON
//#define	USB_DEVCON_CID		  (1<<7)
#define	USB_DEVCON_FSDEV		(1<<6)
#define	USB_DEVCON_LSDEV		(1<<5)
//#define	USB_DEVCON_PUCON		(1<<4)
//#define	USB_DEVCON_PDCON		(1<<3)
#define	USB_DEVCON_HOST			(1<<2)
#define	USB_DEVCON_HOSTREQ	(1<<1)
#define	USB_DEVCON_SESSION	(1<<0)	
//CSR0L
#define	USB_CSR0L_NAKTO			(1<<7)		//Host
#define	USB_CSR0L_SETENDC		(1<<7)		//Device
#define	USB_CSR0L_STATUSPKT	(1<<6)		//Host
#define	USB_CSR0L_RXRDYC		(1<<6)		//Device
#define	USB_CSR0L_REQPKT		(1<<5)		//Host
#define	USB_CSR0L_STALL			(1<<5)		//Device
#define	USB_CSR0L_ERROR			(1<<4)		//Host
#define	USB_CSR0L_SETEND		(1<<4)		//Device
#define	USB_CSR0L_SETUPPKT	(1<<3)		//Host
#define	USB_CSR0L_DATAEND		(1<<3)		//Device
#define	USB_CSR0L_STALLED		(1<<2)		//Host/Device
#define	USB_CSR0L_TXRDY			(1<<1)		//Host/Device
#define	USB_CSR0L_RXRDY			(1<<0)		//Host/Device
//TXCSRL
#define	USB_TXCSRL_NAKTO		(1<<7)		//Host
#define	USB_TXCSRL_CLRDT		(1<<6)		//Host/Device
#define	USB_TXCSRL_STALLED	(1<<5)		//Host/Device
#define	USB_TXCSRL_STALL		(1<<4)		//Device
#define	USB_TXCSRL_FLUSH		(1<<3)		//Host/Device
#define	USB_TXCSRL_ERROR		(1<<2)		//Host
#define	USB_TXCSRL_UNDRUN		(1<<2)		//Device
#define	USB_TXCSRL_FIFONE		(1<<1)		//Host/Device
#define	USB_TXCSRL_TXRDY		(1<<0)		//Host/Device
//CSR0H
#define	USB_CSR0H_FLUSHFIFO	(1<<7)
//TXCSRH
#define	USB_TXCSRH_AUTOSET	(1<<7)
#define	USB_TXCSRH_ISO			(1<<6)
#define	USB_TXCSRH_BULK			(0<<6)
#define	USB_TXCSRH_TXMODE		(1<<5)
#define	USB_TXCSRH_RXMODE		(0<<5)
//#define	USB_TXCSRH_DMAEN	(1<<4)
#define	USB_TXCSRH_FDT			(1<<3)
//#define	USB_TXCSRH_DMAMODE	(1<<2)
//RXCSRL
#define	USB_RXCSRL_CLRDT			(1<<7)
#define	USB_RXCSRL_STALLED		(1<<6)
#define	USB_RXCSRL_REQPKT			(1<<5)
#define	USB_RXCSRL_FLUSH			(1<<4)
#define	USB_RXCSRL_DATAERROR	(1<<3)
#define	USB_RXCSRL_NAKTO			(1<<3)
#define	USB_RXCSRL_ERROR			(1<<2)
#define	USB_RXCSRL_FIFOFULL		(1<<1)
#define	USB_RXCSRL_RXRDY			(1<<0)
//RXCSRH
#define	USB_RXCSRH_AUTOCL			(1<<7)	//auto clear
#define	USB_RXCSRH_AUTOREQ		(1<<6)	//auto request
//Endpoint Type
#define	USB_PROTOCOL_INT			0x3
#define	USB_PROTOCOL_BULK			0x2
#define	USB_PROTOCOL_ISO			0x1
#endif

//Iterrupt Status
#define	USB_INTR_VBUSERR		((1<<7)<<16)		//Host/Device
#define	USB_INTR_SESSREQ		((1<<6)<<16)		//Host/Device
#define	USB_INTR_DISCON			((1<<5)<<16)		//Host/Device
#define	USB_INTR_CONN				((1<<4)<<16)		//Host/Device
#define	USB_INTR_SOF				((1<<3)<<16)		//Host/Device
#define	USB_INTR_BABBLE			((1<<2)<<16)		//Host
#define	USB_INTR_RESET			((1<<2)<<16)		//Device
#define	USB_INTR_RESUME			((1<<1)<<16)		//Host/Device
#define	USB_INTR_SUSPEND		((1<<0)<<16)		//Host/Device
#define	USB_INTR_EP7TX			((1<<7)<<8)
#define	USB_INTR_EP6TX			((1<<6)<<8)
#define	USB_INTR_EP5TX			((1<<5)<<8)
#define	USB_INTR_EP4TX			((1<<4)<<8)
#define	USB_INTR_EP3TX			((1<<3)<<8)
#define	USB_INTR_EP2TX			((1<<2)<<8)
#define	USB_INTR_EP1TX			((1<<1)<<8)
#define	USB_INTR_EP0				((1<<0)<<8)
#define	USB_INTR_EP7RX			((1<<7)<<0)
#define	USB_INTR_EP6RX			((1<<6)<<0)
#define	USB_INTR_EP5RX			((1<<5)<<0)
#define	USB_INTR_EP4RX			((1<<4)<<0)
#define	USB_INTR_EP3RX			((1<<3)<<0)
#define	USB_INTR_EP2RX			((1<<2)<<0)
#define	USB_INTR_EP1RX			((1<<1)<<0)

#endif	//_USBENUM_H
