#ifndef	_USBENUM_HOST_H
#define	_USBENUM_HOST_H

#pragma pack(1)

#define	pUSBEPFIFO(x)	((uint8_t *)&USBD->EP0FIFO + (x * 4))

#define	DEFAULT_ADDRESS	0
#define	HUB_ADDRESS		1
#define	DEVICE_ADDRESS	2

#define	DEFAULT_CONFIGURATION	0

//Endpoint Packet Size
#define	USBH_CTRL_PKTSZ		64
#define	USBH_BULK_PKTSZ		64
#define	USBH_INT_PKTSZ		64
#define	USBH_ISO_PKTSZ		256

//Structure Declaration
typedef	struct	_USB_FS_HOST_
{
	uint8_t		DevAddr;			//Device Address
	uint8_t		ConfigValue;		//Device Configuration
	uint8_t		DevConnected;		//Device Connected
	uint8_t		MaxCtrlPacketSize;	//Maximum Control Packet Size
	uint8_t		*pCtrlBurstData;	//Control transfer data pointer
	uint16_t	CtrlBurstRemain;	//Control transfer remain size
}_USB_FS_HOST, *_pUSB_FS_HOST;

//Transaction Result
typedef	enum
{
	USBH_RESULT_PASS		= 0x0,
	USBH_RESULT_FAIL,
}eUSBHResult;

//Functional Declaration
eUSBHResult	usbh_dev_connect(_pUSB_FS_HOST);
eUSBHResult	usbh_issue_reset(_pUSB_FS_HOST);
eUSBHResult	usbh_issue_request(_pUSB_FS_HOST, _pUSB_SETUP_REQUEST, uint8_t *);
eUSBHResult	usbh_enumeration(_pUSB_FS_HOST, uint8_t *);
eUSBHResult	usbh_issue_epx_out(_pUSB_FS_HOST, uint8_t, uint16_t, uint8_t *);
eUSBHResult	usbh_issue_epx_in(_pUSB_FS_HOST, uint8_t, uint16_t, uint8_t *);
eUSBHResult	usbh_clear_feature(_pUSB_FS_HOST, uint8_t, uint8_t);
eUSBHResult	usbh_set_configuration(_pUSB_FS_HOST, uint8_t);
eUSBHResult	usbh_set_interface(_pUSB_FS_HOST, uint8_t, uint8_t);
eUSBHResult	usbh_get_interface(_pUSB_FS_HOST, uint8_t, uint8_t *);
eUSBHResult	usbh_get_configuration(_pUSB_FS_HOST, uint8_t *);

#endif	//_USBENUM_HOST_H
