/**********************************************************************************
 *
 * @file    usb_enum.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef  _USB_ENUM_H
#define  _USB_ENUM_H

#pragma pack(1)

//Constant Definition
//Define EP Constant
#define  USBEP0    0
#define  USBEP1    1
#define  USBEP2    2
#define  USBEP3    3
#define  USBEP4    4
#define  USBEP5    5
#define  USBEP6    6

//Iterrupt Status
#define  USB_INTR_VBUSERR    ((1 << 7) << 16)    //Host/Device
#define  USB_INTR_SESSREQ    ((1 << 6) << 16)    //Host/Device
#define  USB_INTR_DISCON      ((1 << 5) << 16)    //Host/Device
#define  USB_INTR_CONN      ((1 << 4) << 16)    //Host/Device
#define  USB_INTR_SOF      ((1 << 3) << 16)    //Host/Device
#define  USB_INTR_BABBLE      ((1 << 2) << 16)    //Host
#define  USB_INTR_RESET      ((1 << 2) << 16)    //Device
#define  USB_INTR_RESUME      ((1 << 1) << 16)    //Host/Device
#define  USB_INTR_SUSPEND    ((1 << 0) << 16)    //Host/Device
#define  USB_INTR_EP7TX      ((1 << 7) << 8)
#define  USB_INTR_EP6TX      ((1 << 6) << 8)
#define  USB_INTR_EP5TX      ((1 << 5) << 8)
#define  USB_INTR_EP4TX      ((1 << 4) << 8)
#define  USB_INTR_EP3TX      ((1 << 3) << 8)
#define  USB_INTR_EP2TX      ((1 << 2) << 8)
#define  USB_INTR_EP1TX      ((1 << 1) << 8)
#define  USB_INTR_EP0      ((1 << 0) << 8)
#define  USB_INTR_EP7RX      ((1 << 7) << 0)
#define  USB_INTR_EP6RX      ((1 << 6) << 0)
#define  USB_INTR_EP5RX      ((1 << 5) << 0)
#define  USB_INTR_EP4RX      ((1 << 4) << 0)
#define  USB_INTR_EP3RX      ((1 << 3) << 0)
#define  USB_INTR_EP2RX      ((1 << 2) << 0)
#define  USB_INTR_EP1RX      ((1 << 1) << 0)

extern  void    (*cb_app_usb_handler)(void);
extern  uint32_t  USBIntrEvent;
extern  _USB_SETUP_REQUEST  SetupReq;

#endif  //_USB_ENUM_H

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/

