/**********************************************************************************
 *
 * @file    usb_dev_enum.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef  _USBENUM_DEV_H
#define  _USBENUM_DEV_H

#pragma pack(1)

#define  pUSBEPFIFO(x)  ((uint8_t *)&USBD->EP0FIFO + (x * 4))

//Endpoint Packet Size
#define  USBD_CTRL_PKTSZ    64
//#define  USBD_BULK_PKTSZ    64
//#define  USBD_INT_PKTSZ    64
//#define  USBD_ISO_PKTSZ    256

//IP reg constants.This offset is actual register address.

//Event Task
typedef  enum
{
  USBD_STATE_IDLE    = 0x0,
  USBD_STATE_SETUP,
  USBD_STATE_CTRLIN,
  USBD_STATE_CTRLOUT,
  USBD_STATE_STATUS,
  USBD_STATE_STALL  = 0x8,
  USBD_STATE_EP1IN  = 0x11,
  USBD_STATE_EP1OUT,
  USBD_STATE_EP2IN,
  USBD_STATE_EP2OUT,
  USBD_STATE_EP3IN,
  USBD_STATE_EP3OUT,
  USBD_STATE_EP4IN,
  USBD_STATE_EP4OUT,
  USBD_STATE_EP5IN,
  USBD_STATE_EP5OUT,
  USBD_STATE_EP6IN,
  USBD_STATE_EP6OUT,
  USBD_STATE_RESET  = 0x31,
  USBD_STATE_SUSPEND,
  USBD_STATE_RESUME,
  USBD_STATE_SOF,
  USBD_STATE_VENDOR  = 0x80,
}eUSBDState;

//Structure Declaration
typedef  struct  _USB_FS_DEVICE_
{
  uint8_t    DevAddr;      //Device Address
  uint8_t    ConfigValue;    //Device Configuration
  uint8_t    *pCtrlBurstData;  //Control transfer data pointer
  uint16_t  CtrlBurstRemain;  //Control transfer remain size
  void    *cb_app_dev_request;  //Callback for user specific request
}_USB_FS_DEVICE, *_pUSB_FS_DEVICE;

typedef  struct  _CB_APP_DEV_REQUEST_
{
  eUSBDState  (*cb_app_dev_enum)(_pUSB_FS_DEVICE, _pUSB_SETUP_REQUEST);    //Enumeration callback for Standard Request
  eUSBDState  (*cb_app_dev_class)(_pUSB_FS_DEVICE, _pUSB_SETUP_REQUEST);    //Enumeration callback for Class Request
}_CB_APP_DEV_REQUEST, *_pCB_APP_DEV_REQUEST;

//Functional Declaration
eUSBDState  usbd_dev_enum(_pUSB_FS_DEVICE, _pUSB_SETUP_REQUEST, eUSBDState);
uint16_t  usbd_epx_out_available(_pUSB_FS_DEVICE, uint8_t);
eUSBDState  usbd_handle_ctrl_in(_pUSB_FS_DEVICE);
eUSBDState  usbd_handle_ctrl_out(_pUSB_FS_DEVICE);
eUSBDState  usbd_handle_epx_in(_pUSB_FS_DEVICE, uint8_t, uint16_t, uint8_t *);
eUSBDState  usbd_handle_epx_out(_pUSB_FS_DEVICE, uint8_t, uint16_t, uint8_t *);

#endif  //_USBENUM_DEV_H

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/

