/**********************************************************************************
 *
 * @file    usbprinter.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef	_USBPRINTER_H
#define	_USBPRINTER_H

#pragma pack(1)


//*****************************************************************************
//
// The subclass for the printer class.
//
//*****************************************************************************
#define	PRINTER_SUBCLASS_RESERVED		0x00	//Reserved
#define	PRINTER_SUBCLASS_PRINTER		0x01	//Printer
#define	PRINTER_SUBCLASS_VENDOR			0xFF	//Vendor specific

//*****************************************************************************
//
// The protocol for the printer class.
//
//*****************************************************************************
#define	PRINTER_PROTOCOL_RESERVED		0x00	//Reserved
#define	PRINTER_PROTOCOL_UNIDIRECTIONAL	0x01	//UniDirectional
#define	PRINTER_PROTOCOL_BIDIRECTIONAL	0x02	//BiDirectional
#define	PRINTER_PROTOCOL_IEEE1284		0x03	//BiDirectional for IEEE1284
#define	PRINTER_PROTOCOL_VENDOR			0xFF	//Vendor specific

//*****************************************************************************
//
// The request for the printer class-specific.
//
//*****************************************************************************
#define	PRINTER_REQ_GET_DEVICE_ID		0x00
#define PRINTER_REQ_GET_PORT_STATUS		0x01
#define PRINTER_REQ_SOFT_RESET			0x02

//*****************************************************************************
//
// The constant for the get report status request.
//
//*****************************************************************************
#define	PRINTER_STATUS_PAPER_EMPTY	(1 << 5)
#define	PRINTER_STATUS_PAPER_NOT_EMPTY	(0 << 5)
#define	PRINTER_STATUS_SELECTED		(1 << 4)
#define	PRINTER_STATUS_NOT_SELECTED	(0 << 4)
#define	PRINTER_STATUS_ERROR		(1 << 3)
#define	PRINTER_STATUS_NO_ERROR		(0 << 3)

#endif	//_USBPRINTER_H

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
