/**********************************************************************************
 *
 * @file    usbcdc.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef  _USBCDC_H
#define  _USBCDC_H

#pragma pack(1)

//*****************************************************************************
//
// USB CDC device class code.  Used in device descriptor, bDeviceClass
//
//*****************************************************************************
#define CDC_CLASS_DEVICE_CODE        0x02

//*****************************************************************************
//
// USB CDC interface class code.  Used in interface descriptor, bInterfaceClass
//
//*****************************************************************************
#define CDC_CLASS_INTERFACE_CODE      0x02

//*****************************************************************************
//
// USB CDC subclass codes.  Used in interface descriptor, bInterfaceSubClass
//
//*****************************************************************************
#define CDC_SUBCLASS_RESERVED            0x00
#define CDC_SUBCLASS_DIRECT_LINE_CONTROL      0x01
#define CDC_SUBCLASS_ABSTRACT_CONTROL        0x02
#define CDC_SUBCLASS_TELEPHONE_CONTROL        0x03
#define CDC_SUBCLASS_MULTI_CHANNEL_CONTROL      0x04
#define CDC_SUBCLASS_CAPI_CONTROL          0x05
#define CDC_SUBCLASS_ETHERNET_NETWORKING_CONTROL  0x06
#define CDC_SUBCLASS_ATM_NETWORKING_CONTROL      0x07
#define CDC_SUBCLASS_WIRELESS_HANDSET_CONTROL    0x08
#define CDC_SUBCLASS_DEVICE_MANAGEMENT        0x09
#define CDC_SUBCLASS_MOBILE_DIRECT_LINE        0x0A
#define CDC_SUBCLASS_OBEX              0x0B
#define CDC_SUBCLASS_ETHERNET_EMULATION        0x0C
#define CDC_SUBCLASS_NETWORK_CONTROL        0x0D

//*****************************************************************************
//
// USB CDC communication interface protocols.  Used in communication interface descriptor,
// bInterfaceProtocol
//
//*****************************************************************************
#define CDC_CI_PROTOCOL_NONE         0x00
#define CDC_CI_PROTOCOL_ITU_T_V250     0x01
#define CDC_CI_PROTOCOL_PCCA_101     0x02
#define CDC_CI_PROTOCOL_PCCA_ANNEX_O   0x03
#define CDC_CI_PROTOCOL_GSM_707       0x04
#define CDC_CI_PROTOCOL_3GPP_2707     0x05
#define CDC_CI_PROTOCOL_C_S0017_0     0x06
#define CDC_CI_PROTOCOL_USB_EEM       0x07
#define CDC_CI_PROTOCOL_EXTERNAL    0xFE
#define CDC_CI_PROTOCOL_VENDOR       0xFF

//*****************************************************************************
//
// USB CDC data interface code.  Used in data interface descriptor, bInterfaceClass
//
//*****************************************************************************
#define CDC_DATA_INTERFACE_CODE      0x0A

//*****************************************************************************
//
// USB CDC data interface protocols.  Used in data interface descriptor,
// bInterfaceProtocol
//
//*****************************************************************************
#define CDC_DI_PROTOCOL_NONE        0x00
#define CDC_DI_PROTOCOL_USBNCM_1_0      0x01
#define CDC_DI_PROTOCOL_I430        0x30
#define CDC_DI_PROTOCOL_ISO_3309_1993    0x31
#define CDC_DI_PROTOCOL_TRANSPARENT      0x32
#define CDC_DI_PROTOCOL_Q921M        0x50
#define CDC_DI_PROTOCOL_Q921        0x51
#define CDC_DI_PROTOCOL_Q921TM        0x52
#define CDC_DI_PROTOCOL_V42BIS        0x90
#define CDC_DI_PROTOCOL_Q931EURO      0x91
#define CDC_DI_PROTOCOL_V120        0x92
#define CDC_DI_PROTOCOL_CAPI20        0x93
#define CDC_DI_PROTOCOL_HOST_DRIVER      0xFD
#define CDC_DI_PROTOCOL_CDC_SPEC      0xFE
#define CDC_DI_PROTOCOL_VENDOR        0xFF

//*************************************************************
//
// Functional descriptor definitions
//
//*****************************************************************************

//*****************************************************************************
//
// Functional descriptor types
//
//*****************************************************************************
#define  CDC_CS_INTERAFCE    0x24
#define  CDC_CS_ENDPOINT      0x25

//*****************************************************************************
//
// Functional descriptor subtypes
//
//*****************************************************************************
#define CDC_FD_SUBTYPE_HEADER        0x00
#define CDC_FD_SUBTYPE_CALL_MGMT      0x01
#define CDC_FD_SUBTYPE_ABSTRACT_CTRL_MGMT  0x02
#define CDC_FD_SUBTYPE_DIRECT_LINE_MGMT    0x03
#define CDC_FD_SUBTYPE_TELEPHONE_RINGER    0x04
#define CDC_FD_SUBTYPE_LINE_STATE_REPORTT  0x05
#define CDC_FD_SUBTYPE_UNION        0x06
#define CDC_FD_SUBTYPE_COUNTRY_SELECTION  0x07
#define CDC_FD_SUBTYPE_TELEPHONE_MODES    0x08
#define CDC_FD_SUBTYPE_USB_TERMINAL      0x09
#define CDC_FD_SUBTYPE_NETWORK_TERMINAL    0x0A
#define CDC_FD_SUBTYPE_PROTOCOL_UNIT    0x0B
#define CDC_FD_SUBTYPE_EXTENSION_UNIT    0x0C
#define CDC_FD_SUBTYPE_MULTI_CHANNEL_MGMT  0x0D
#define CDC_FD_SUBTYPE_CAPI_CTRL_MGMT    0x0E
#define CDC_FD_SUBTYPE_ETHERNET_NETWORKING  0x0F
#define CDC_FD_SUBTYPE_ATM          0x10
#define CDC_FD_SUBTYPE_WIRELESS_HANDSET    0x11
#define CDC_FD_SUBTYPE_MOBILE_DIRECT_LINE  0x12
#define CDC_FD_SUBTYPE_MOBILE_MDLM_DETAIL  0x13
#define CDC_FD_SUBTYPE_DEVICE_MGMT_MODEL  0x14
#define CDC_FD_SUBTYPE_OBEX          0x15
#define CDC_FD_SUBTYPE_COMMAND_SET      0x16
#define CDC_FD_SUBTYPE_COMMAND_SET_DETAIL  0x17
#define CDC_FD_SUBTYPE_TELEPHONE_CTRL_MODEL  0x18
#define CDC_FD_SUBTYPE_OBEX_SERVICE      0x19
#define CDC_FD_SUBTYPE_NCM          0x1A
#define CDC_FD_SUBTYPE_VENDOR        0xFE

//*****************************************************************************
//
// CDC_FD_SUBTYPE_CALL_MGMT, Header functional descriptor, bmCapabilities
//
//*****************************************************************************
#define CDC_CALL_MGMT_VIA_DATA        0x02
#define CDC_CALL_MGMT_HANDLED        0x01

//*****************************************************************************
//
// CDC_FD_SUBTYPE_ABSTRACT_CTL_MGMT, Abstract Control Management functional
// descriptor, bmCapabilities
//
//*****************************************************************************
#define CDC_ACM_SUPPORTS_NETWORK_CONNECTION  0x08
#define CDC_ACM_SUPPORTS_SEND_BREAK      0x04
#define CDC_ACM_SUPPORTS_LINE_PARAMS    0x02
#define CDC_ACM_SUPPORTS_COMM_FEATURE    0x01

//*****************************************************************************
//
// CDC_FD_SUBTYPE_DIRECT_LINE_MGMT, Direct Line Management functional
// descriptor, bmCapabilities
//
//*****************************************************************************
#define CDC_DLM_NEEDS_EXTRA_PULSE_SETUP    0x04
#define CDC_DLM_SUPPORTS_AUX        0x02
#define CDC_DLM_SUPPORTS_PULSE        0x01

//*****************************************************************************
//
// CDC_FD_SUBTYPE_TELEPHONE_MODES, Telephone Operational Modes functional
// descriptor, bmCapabilities
//
//*****************************************************************************
#define CDC_TELEPHONE_SUPPORTS_COMPUTER    0x04
#define CDC_TELEPHONE_SUPPORTS_STANDALONE  0x02
#define CDC_TELEPHONE_SUPPORTS_SIMPLE    0x01

//*****************************************************************************
//
// CDC_FD_SUBTYPE_LINE_STATE_CAPS, Telephone Call and Line State Reporting
// Capabilities descriptor
//
//*****************************************************************************
#define CDC_LINE_STATE_CHANGES_NOTIFIED    0x20
#define CDC_LINE_STATE_REPORTS_DTMF      0x10
#define CDC_LINE_STATE_REPORTS_DIST_RING  0x08
#define CDC_LINE_STATE_REPORTS_CALLERID    0x04
#define CDC_LINE_STATE_REPORTS_BUSY      0x02
#define CDC_LINE_STATE_REPORTS_INT_DIALTONE  0x01

//*****************************************************************************
//
// CDC_FD_SUBTYPE_USB_TERMINAL, USB Terminal functional descriptor,
// bmOptions
//
//*****************************************************************************
#define CDC_TERMINAL_NO_WRAPPER_USED    0x00
#define CDC_TERMINAL_WRAPPER_USED      0x01

//*****************************************************************************
//
// CDC_FD_SUBTYPE_MULTI_CHANNEL_MGMT, Multi-Channel Management functional
// descriptor, bmCapabilities
//
//*****************************************************************************
#define CDC_MCM_SUPPORTS_SET_UNIT_PARAM    0x04
#define CDC_MCM_SUPPORTS_CLEAR_UNIT_PARAM  0x02
#define CDC_MCM_UNIT_PARAMS_NON_VOLATILE  0x01

//*****************************************************************************
//
// CDC_FD_SUBTYPE_CAPI_MGMT, CAPI Control Management functional descriptor,
// bmCapabilities
//
//*****************************************************************************
#define CDC_CAPI_INTELLIGENT        0x01
#define CDC_CAPI_SIMPLE            0x00

//*****************************************************************************
//
// CDC_FD_SUBTYPE_ETHERNET, Ethernet Networking functional descriptor,
// bmEthernetStatistics
//
//*****************************************************************************
#define CDC_ETHERNET_XMIT_OK        0x01000000
#define CDC_ETHERNET_RCV_OK          0x02000000
#define CDC_ETHERNET_XMIT_ERROR        0x04000000
#define CDC_ETHERNET_RCV_ERROR        0x08000000
#define CDC_ETHERNET_RCV_NO_BUFFER      0x10000000
#define CDC_ETHERNET_DIRECTED_BYTES_XMIT  0x20000000
#define CDC_ETHERNET_DIRECTED_FRAMES_XMIT  0x40000000
#define CDC_ETHERNET_MULTICAST_BYTES_XMIT  0x80000000
#define CDC_ETHERNET_MULTICAST_FRAMES_XMIT  0x00010000
#define CDC_ETHERNET_BROADCAST_BYTES_XMIT  0x00020000
#define CDC_ETHERNET_BROADCAST_FRAMES_XMIT  0x00040000
#define CDC_ETHERNET_DIRECTED_BYTES_RCV    0x00080000
#define CDC_ETHERNET_DIRECTED_FRAMES_RCV  0x00100000
#define CDC_ETHERNET_MULTICAST_BYTES_RCV  0x00200000
#define CDC_ETHERNET_MULTICAST_FRAMES_RCV  0x00400000
#define CDC_ETHERNET_BROADCAST_BYTES_RCV  0x00800000
#define CDC_ETHERNET_BROADCAST_FRAMES_RCV  0x00000100
#define CDC_ETHERNET_RCV_CRC_ERROR      0x00000200
#define CDC_ETHERNET_TRANSMIT_QUEUE_LENGTH  0x00000400
#define CDC_ETHERNET_RCV_ERROR_ALIGNMENT  0x00000800
#define CDC_ETHERNET_XMIT_ONE_COLLISION    0x00001000
#define CDC_ETHERNET_XMIT_MORE_COLLISIONS  0x00002000
#define CDC_ETHERNET_XMIT_DEFERRED      0x00004000
#define CDC_ETHERNET_XMIT_MAX_COLLISIONS  0x00008000
#define CDC_ETHERNET_RCV_OVERRUN      0x00000001
#define CDC_ETHERNET_XMIT_UNDERRUN      0x00000002
#define CDC_ETHERNET_XMIT_HEARTBEAT_FAILURE  0x00000004
#define CDC_ETHERNET_XMIT_TIMES_CRS_LOST  0x00000010

//*****************************************************************************
//
// CDC_FD_SUBTYPE_ATM, ATM Networking functional descriptor,
// bmDataCapabilities
//
//*****************************************************************************
#define CDC_ATM_TYPE_3      0x08
#define CDC_ATM_TYPE_2      0x04
#define CDC_ATM_TYPE_1      0x02

//*****************************************************************************
//
// bmATMDeviceStatistics
//
//*****************************************************************************
#define CDC_ATM_VC_US_CELLS_SENT      0x10
#define CDC_ATM_VC_US_CELLS_RECEIVED    0x08
#define CDC_ATM_DS_CELLS_HEC_ERR_CORRECTED  0x04
#define CDC_ATM_US_CELLS_SENT        0x02
#define CDC_ATM_US_CELLS_RECEIVED      0x01

//*****************************************************************************
//
// Management Element Requests (provided in tUSBRequest.bRequest)
//
//*****************************************************************************
#define CDC_SEND_ENCAPSULATED_COMMAND    0x00
#define CDC_GET_ENCAPSULATED_RESPONSE    0x01
#define CDC_SET_COMM_FEATURE        0x02
#define CDC_GET_COMM_FEATURE        0x03
#define CDC_CLEAR_COMM_FEATURE        0x04
#define CDC_SET_AUX_LINE_STATE        0x10
#define CDC_SET_HOOK_STATE          0x11
#define CDC_PULSE_SETUP             0x12
#define CDC_SEND_PULSE              0x13
#define CDC_SET_PULSE_TIME          0x14
#define CDC_RING_AUX_JACK           0x15
#define CDC_SET_LINE_CODING         0x20
#define CDC_GET_LINE_CODING         0x21
#define CDC_SET_CONTROL_LINE_STATE      0x22
#define CDC_SEND_BREAK              0x23
#define CDC_SET_RINGER_PARMS        0x30
#define CDC_GET_RINGER_PARMS        0x31
#define CDC_SET_OPERATION_PARMS        0x32
#define CDC_GET_OPERATION_PARMS        0x33
#define CDC_SET_LINE_PARMS          0x34
#define CDC_GET_LINE_PARMS            0x35
#define CDC_DIAL_DIGITS             0x36
#define CDC_SET_UNIT_PARAMETER        0x37
#define CDC_GET_UNIT_PARAMETER        0x38
#define CDC_CLEAR_UNIT_PARAMETER      0x39
#define CDC_GET_PROFILE            0x3A
#define CDC_SET_ETHERNET_MULTICAST_FILTERS  0x40
#define CDC_SET_ETHERNET_POWER_MANAGEMENT_PATTERN_FILTER  0x41
#define CDC_GET_ETHERNET_POWER_MANAGEMENT_PATTERN_FILTER  0x42
#define CDC_SET_ETHERNET_PACKET_FILTER    0x43
#define CDC_GET_ETHERNET_STATISTIC      0x44
#define CDC_SET_ATM_DATA_FORMAT        0x50
#define CDC_GET_ATM_DEVICE_STATISTICS    0x51
#define CDC_SET_ATM_DEFAULT_VC        0x52
#define CDC_GET_ATM_VC_STATISTICS      0x53
#define CDC_GET_NTB_PARAMETERS        0x80
#define CDC_GET_NET_ADDRESS          0x81
#define CDC_SET_NET_ADDRESS          0x82
#define CDC_GET_NTB_FORMAT          0x83
#define CDC_SET_NTB_FORMAT          0x84
#define CDC_GET_NTB_INPUT_SIZE        0x85
#define CDC_SET_NTB_INPUT_SIZE        0x86
#define CDC_GET_MAX_DATAGRAM_SIZE      0x87
#define CDC_SET_MAX_DATAGRAM_SIZE      0x88
#define GET_CRC_MODE            0x89
#define GET_SRC_MODE            0x8A

//*****************************************************************************
//
// In cases where a request defined above results in the return of a fixed size
// data block, the following group of labels define the size of that block.  In
// each of these cases, an access macro is also provided to write the response
// data into an appropriately-sized array of 8-bit characters.
//
//*****************************************************************************
#define CDC_SIZE_COMM_FEATURE        2
#define CDC_SIZE_LINE_CODING        7
#define CDC_SIZE_RINGER_PARMS        4
#define CDC_SIZE_OPERATION_PARMS      2
#define CDC_SIZE_UNIT_PARAMETER        2
#define CDC_SIZE_PROFILE          64
#define CDC_SIZE_ETHERNET_POWER_MANAGEMENT_PATTERN_FILTER  2
#define CDC_SIZE_ETHERNET_STATISTIC      4
#define CDC_SIZE_ATM_DEVICE_STATISTICS    4
#define CDC_SIZE_ATM_VC_STATISTICS      4
#define CDC_SIZE_LINE_PARMS          10

//*****************************************************************************
//
// NB: CDC_SIZE_LINE_PARAMS assumes only a single call.  For multiple
// calls, add 4 bytes per additional call.
//
//*****************************************************************************

//*****************************************************************************
//
// CDC_GET_COMM_FEATURE & CDC_SET_COMM_FEATURE
//
//*****************************************************************************

//*****************************************************************************
//
// wValue (Feature Selector)
//
//*****************************************************************************
#define CDC_ABSTRACT_STATE  0x0001
#define CDC_COUNTRY_SETTING  0x0002

//*****************************************************************************
//
// Data when feature selector is USB_DCD_ABSTRACT_STATE
//
//*****************************************************************************
#define CDC_ABSTRACT_CALL_DATA_MULTIPLEXED  0x0002
#define CDC_ABSTRACT_ENDPOINTS_IDLE      0x0001

//*****************************************************************************
//
// CDC_SET_AUX_LINE_STATE, wValue
//
//*****************************************************************************
#define CDC_AUX_DISCONNECT  0x0000
#define CDC_AUX_CONNECT     0x0001

//*****************************************************************************
//
// CDC_SET_HOOK_STATE, wValue
//
//*****************************************************************************
#define CDC_ON_HOOK          0x0000
#define CDC_OFF_HOOK        0x0001
#define CDC_SNOOPING        0x0002

//*****************************************************************************
//
// CDC_GET_LINE_CODING
//
//*****************************************************************************
#define CDC_STOP_BITS_1    0x00
#define CDC_STOP_BITS_1_5   0x01
#define CDC_STOP_BITS_2     0x02

#define CDC_PARITY_NONE     0x00
#define CDC_PARITY_ODD      0x01
#define CDC_PARITY_EVEN     0x02
#define CDC_PARITY_MARK     0x03
#define CDC_PARITY_SPACE    0x04

//*****************************************************************************
//
// CDC_SET_CONTROL_LINE_STATE, wValue
//
//*****************************************************************************
#define CDC_DEACTIVATE_CARRIER  0x00
#define CDC_ACTIVATE_CARRIER  0x02
#define CDC_DTE_NOT_PRESENT    0x00
#define CDC_DTE_PRESENT      0x01

//*****************************************************************************
//
// CDC_SET_RINGER_PARMS, CDC_GET_RINGER_PARMS and
// CDC_GET_LINE_PARMS (ui32RingerBmp)
//
//*****************************************************************************
#define CDC_RINGER_EXISTS      0x80000000
#define CDC_RINGER_DOES_NOT_EXIST  0x00000000

//*****************************************************************************
//
// CDC_SET_OPERATION_PARMS, wValue
//
//*****************************************************************************
#define CDC_SIMPLE_MODE      0x0000
#define CDC_STANDALONE_MODE    0x0001
#define CDC_HOST_CENTRIC_MODE  0x0002

//*****************************************************************************
//
// CDC_SET_LINE_PARMS, wParam - Line State Change
//
//*****************************************************************************
#define CDC_DROP_ACTIVE_CALL  0x0000
#define CDC_START_NEW_CALL    0x0001
#define CDC_APPLY_RINGING    0x0002
#define CDC_REMOVE_RINGING    0x0003
#define CDC_SWITCH_CALL      0x0004

//*****************************************************************************
//
// Line state bitmap in CDC_GET_LINE_PARMS response
//
//*****************************************************************************
#define CDC_LINE_IS_ACTIVE    0x80000000
#define CDC_LINE_IS_IDLE    0x00000000
#define CDC_LINE_NO_ACTIVE_CALL  0x000000FF

#define CDC_CALL_ACTIVE      0x80000000

//*****************************************************************************
//
// Call state value definitions
//
//*****************************************************************************
#define CDC_CALL_IDLE        0x00000000
#define CDC_CALL_TYPICAL_DIALTONE  0x00000001
#define CDC_CALL_INTERRUPTED_DIALTONE  0x00000002
#define CDC_CALL_DIALING    0x00000003
#define CDC_CALL_RINGBACK    0x00000004
#define CDC_CALL_CONNECTED    0x00000005
#define CDC_CALL_INCOMING    0x00000006

//*****************************************************************************
//
// Call state change value definitions
//
//*****************************************************************************
#define CDC_CALL_STATE_IDLE      0x01
#define CDC_CALL_STATE_DIALING    0x02
#define CDC_CALL_STATE_RINGBACK    0x03
#define CDC_CALL_STATE_CONNECTED  0x04
#define CDC_CALL_STATE_INCOMING    0x05

//*****************************************************************************
//
// Extra byte of data describing the connection type for
// CDC_CALL_STATE_CONNECTED.
//
//*****************************************************************************
#define CDC_VOICE          0x00
#define CDC_ANSWERING_MACHINE    0x01
#define CDC_FAX            0x02
#define CDC_MODEM          0x03
#define CDC_UNKNOWN          0xFF

//*****************************************************************************
//
// Notification Element definitions
//
//*****************************************************************************
#define CDC_NOTIFY_NETWORK_CONNECTION    0x00
#define CDC_NOTIFY_RESPONSE_AVAILABLE    0x01
#define CDC_NOTIFY_AUX_JACK_HOOK_STATE    0x08
#define CDC_NOTIFY_RING_DETECT        0x09
#define CDC_NOTIFY_SERIAL_STATE        0x20
#define CDC_NOTIFY_CALL_STATE_CHANGE    0x28
#define CDC_NOTIFY_LINE_STATE_CHANGE    0x29
#define CDC_NOTIFY_CONNECTION_SPEED_CHANGE  0x2A

//*****************************************************************************
//
// CDC_NOTIFY_NETWORK_CONNECTION, wValue
//
//*****************************************************************************
#define CDC_NETWORK_DISCONNECTED  0x0000
#define CDC_NETWORK_CONNECTED    0x0001

//*****************************************************************************
//
// CDC_NOTIFY_AUX_JACK_HOOK_STATE, wValue
//
//*****************************************************************************
#define CDC_AUX_JACK_ON_HOOK      0x0000
#define CDC_AUX_JACK_OFF_HOOK      0x0001

//*****************************************************************************
//
// CDC_NOTIFY_SERIAL_STATE, Data
//
//*****************************************************************************

//*****************************************************************************
//
// Number of bytes of data returned alongside this notification.
//
//*****************************************************************************
#define CDC_NOTIFY_SERIAL_STATE_SIZE  2

#define CDC_SERIAL_STATE_OVERRUN    0x0040
#define CDC_SERIAL_STATE_PARITY      0x0020
#define CDC_SERIAL_STATE_FRAMING    0x0010
#define CDC_SERIAL_STATE_RING_SIGNAL  0x0008
#define CDC_SERIAL_STATE_BREAK      0x0004
#define CDC_SERIAL_STATE_TXCARRIER    0x0002
#define CDC_SERIAL_STATE_RXCARRIER    0x0001

//*****************************************************************************
//
// CDC_NOTIFY_LINE_STATE_CHANGE, wValue
//
// Note that the data returned alongside this notification are heavily
// dependent upon the call state being reported so no specific lengths or
// access macros are provided here.
//
//*****************************************************************************
#define CDC_LINE_STATE_IDLE     0x0000
#define CDC_LINE_STATE_HOLD     0x0001
#define CDC_LINE_STATE_OFF_HOOK    0x0002
#define CDC_LINE_STATE_ON_HOOK    0x0003

//*****************************************************************************
//
//  CDC Header Functional Descriptor Format
//
//*****************************************************************************
typedef  struct  _CDC_HEADER_DESC_
{
  uint8_t    bFunctionLength;
  uint8_t    bDescriptorType;
  uint8_t    bDescriptorSubType;
  uint16_t  bcbCDC;
}_CDC_HEADER_DESC, *_pCDC_HEADER_DESC;

//*****************************************************************************
//
//  CDC Union Functional Descriptor Format
//
//*****************************************************************************
typedef  struct  _CDC_UNION_DESC_
{
  uint8_t    bFunctionLength;
  uint8_t    bDescriptorType;
  uint8_t    bDescriptorSubType;
  uint8_t    bControlInterface;
  uint8_t    bSubordinateInterface0;
}_CDC_UNION_DESC, *_pCDC_UNION_DESC;

//*****************************************************************************
//
//  CDC Country Selection Descriptor Format
//
//*****************************************************************************
typedef  struct  _CDC_COUNTRY_SELECTION_DESC_
{
  uint8_t    bFunctionLength;
  uint8_t    bDescriptorType;
  uint8_t    bDescriptorSubType;
  uint8_t    iCountryCodeRelDate;
  uint16_t  wCountryCode0;
}_CDC_COUNTRY_SELECTION_DESC, *_pCDC_COUNTRY_SELECTION_DESC;

//*****************************************************************************
//
//  CDC Abstract Functional Descriptor Format
//
//*****************************************************************************
typedef  struct  _CDC_ABSTRACT_DESC_
{
  uint8_t    bFunctionLength;
  uint8_t    bDescriptorType;
  uint8_t    bDescriptorSubType;
  uint8_t    bmCapabilities;
}_CDC_ABSTRACT_DESC, *_pCDC_ABSTRACT_DESC;

//*****************************************************************************
//
//  CDC Call Management Functional Descriptor Format
//
//*****************************************************************************
typedef  struct  _CDC_CALL_MANAGEMENT_DESC_
{
  uint8_t    bFunctionLength;
  uint8_t    bDescriptorType;
  uint8_t    bDescriptorSubType;
  uint8_t    bmCapabilities;
  uint8_t    bDataInterafce;
}_CDC_CALL_MANAGEMENT_DESC, *_pCDC_CALL_MANAGEMENT_DESC;

//*****************************************************************************
//
//CDC Line Coding Structure
//
//*****************************************************************************
/*  Line Coding DTR  */
#define  CDC_LINE_CODING_DTR_1200  (uint32_t)(1200)
#define  CDC_LINE_CODING_DTR_2400  (uint32_t)(2400)
#define  CDC_LINE_CODING_DTR_4800  (uint32_t)(4800)
#define  CDC_LINE_CODING_DTR_9600  (uint32_t)(9600)
#define  CDC_LINE_CODING_DTR_19200  (uint32_t)(19200)
#define  CDC_LINE_CODING_DTR_38400  (uint32_t)(38400)
#define  CDC_LINE_CODING_DTR_57600  (uint32_t)(57600)
#define  CDC_LINE_CODING_DTR_115200  (uint32_t)(115200)
#define  CDC_LINE_CODING_DTR_128000  (uint32_t)(128000)
#define  CDC_LINE_CODING_DTR_230400  (uint32_t)(230400)
#define  CDC_LINE_CODING_DTR_256000  (uint32_t)(256000)
/*  Line Coding Stop  */
#define  CDC_LINE_CODING_STOP_1    (uint8_t)(0)
#define  CDC_LINE_CODING_STOP_1P5  (uint8_t)(1)
#define  CDC_LINE_CODING_STOP_2    (uint8_t)(2)
/*  Line Coding Parity  */
#define  CDC_LINE_CODING_PARITY_NONE  (uint8_t)(0)
#define  CDC_LINE_CODING_PARITY_ODD  (uint8_t)(1)
#define  CDC_LINE_CODING_PARITY_EVEN  (uint8_t)(2)
#define  CDC_LINE_CODING_PARITY_MARK  (uint8_t)(3)
#define  CDC_LINE_CODING_PARITY_SPACE  (uint8_t)(4)
/*  Line Coding Bits  */
#define  CDC_LINE_CODING_BITS_5    (uint8_t)(5)
#define  CDC_LINE_CODING_BITS_6    (uint8_t)(6)
#define  CDC_LINE_CODING_BITS_7    (uint8_t)(7)
#define  CDC_LINE_CODING_BITS_8    (uint8_t)(8)
#define  CDC_LINE_CODING_BITS_16    (uint8_t)(16)
typedef  struct  _CDC_LINE_CODING_DATA_
{
  uint32_t  dwDTERate;      //Data Terminal Rate
  uint8_t    bCharFormat;    //Stop Bits
  uint8_t    bParityType;    //Parity
  uint8_t    bDataBits;      //Data Bits
}_CDC_LINE_CODING_DATA, *_pCDC_LINE_CODING_DATA;

#endif  //_USBCDC_H

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/

