/**********************************************************************************
 *
 * @file    usb_host_msc.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef	_USB_HOST_MSC_H
#define	_USB_HOST_MSC_H

#pragma pack(1)

#define	MSC_BULK_IN_EP		USBEP1
#define	MSC_BULK_OUT_EP		USBEP1

#define	MSC_BLOCK_SZ		0x200

#define	ESMSCTAG			0x455330CC

//Structure Declaration

//Functional Declaration
eUSBHResult	msc_issue_get_max_lun(_pUSB_FS_HOST, uint8_t *);
eUSBHResult	msc_issue_request_sense(_pUSB_FS_HOST, uint8_t *, uint8_t *, uint8_t *);
eUSBHResult	msc_issue_test_unit_ready(_pUSB_FS_HOST, uint8_t *, uint8_t *, uint8_t *);
eUSBHResult	msc_issue_inquiry(_pUSB_FS_HOST, uint8_t *, uint8_t *, uint8_t *);
eUSBHResult	msc_issue_read_format_capacities(_pUSB_FS_HOST, uint8_t *, uint8_t *, uint8_t *);
eUSBHResult	msc_issue_read_capacity(_pUSB_FS_HOST, uint8_t *, uint8_t *, uint8_t *);
eUSBHResult	msc_issue_mode_sense_6(_pUSB_FS_HOST, uint8_t *, uint8_t *, uint8_t *);
eUSBHResult	msc_issue_read_10(_pUSB_FS_HOST, uint8_t *, uint8_t *, uint8_t *);
eUSBHResult	msc_read_lba(_pUSB_FS_HOST, uint32_t, uint8_t, uint8_t *);

#endif	//_USB_HOST_MSC_H
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
