/**********************************************************************************
 *
 * @file    usb_dev_uac1.h
 * @brief   Head File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef	_USB_DEV_UAC1_H
#define	_USB_DEV_UAC1_H

#pragma pack(1)

//Structure Declaration
typedef	struct	_UAC1_AUDIO_CONTROL_
{
	uint32_t	SampFreq;		//Sampling Frequency
	uint16_t	VolMin;			//Volume Minimum
	uint16_t	VolMax;			//Volume Maximum
	uint16_t	VolRes;			//Volume Resolution
	uint16_t	VolCurL;		//Volume Current Left
	uint16_t	VolCurR;		//Volume Current Right
	uint8_t		Mute;			//Mute
}_UAC1_AUDIO_CONTROL, *_pUAC1_AUDIO_CONTROL;

//Default Volume Min, Max, Res, Cur
#define UAC1_AC_VOL_MIN			0xE200
#define UAC1_AC_VOL_MAX			0x1400
#define UAC1_AC_VOL_RES			0x100
#define UAC1_AC_VOL_CUR			0x0000

#define UAC1_BCR_48K			192
#define UAC1_BCR_44K1			176

//Functional Declaration
extern	eUSBDState	(*pUAC1ClassRequest[])(_pUSB_FS_DEVICE, _pUSB_SETUP_REQUEST);

#endif	//_USB_DEV_UAC1_H

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
