/**********************************************************************************
 *
 * @file    usb_dev_uac1.c
 * @brief   c File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#include "es32f0283.h"
#include "md_usb.h"
#include "usb_core.h"
#include "usb_enum.h"
#include "usb_dev_enum.h"
#include "usbuac1.h"
#include "usbhid.h"
#include "usb_dev_uac1.h"
#include <stdio.h>

#pragma pack(1)

#define	DEV_UAC1_MSG	1

/****
	* @brief	USB UAC Request - Set Cur
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	uac1_request_set_cur(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)
{
#if	DEV_UAC1_MSG
	printf("UAC1SetCur-");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_clear_flag_device_ep0_rx_ready(USB);		//Clear RxRdy

	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
		(*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
	return(USBD_STATE_IDLE);
}
/****
	* @brief	USB UAC Request - Set Min
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	uac1_request_set_min(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)
{
#if	DEV_UAC1_MSG
	printf("UAC1SetMin\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_clear_flag_device_ep0_rx_ready(USB);		//Clear RxRdy

	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
		(*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
	return(USBD_STATE_IDLE);
}
/****
	* @brief	USB UAC Request - Set Max
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	uac1_request_set_max(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)
{
#if	DEV_UAC1_MSG
	printf("UAC1SetMax\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_clear_flag_device_ep0_rx_ready(USB);		//Clear RxRdy

	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
		(*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
	return(USBD_STATE_IDLE);
}
/****
	* @brief	USB UAC Request - Set Res
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	uac1_request_set_res(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)
{
#if	DEV_UAC1_MSG
	printf("UAC1SetRes\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_clear_flag_device_ep0_rx_ready(USB);		//Clear RxRdy

	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
		(*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
	return(USBD_STATE_IDLE);
}
/****
	* @brief	USB UAC Request - Set Mem
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	uac1_request_set_mem(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)
{
#if	DEV_UAC1_MSG
	printf("UAC1SetMem\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_clear_flag_device_ep0_rx_ready(USB);		//Clear RxRdy

	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
		(*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
	return(USBD_STATE_IDLE);
}
/****
	* @brief	USB UAC Request - Get Cur
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	uac1_request_get_cur(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)
{
#if	DEV_UAC1_MSG
	printf("UAC1GetCur\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_clear_flag_device_ep0_rx_ready(USB);		//Clear RxRdy
	
	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
		(*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
	return(USBD_STATE_IDLE);
}
/****
	* @brief	USB UAC Request - Get Min
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	uac1_request_get_min(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)
{
#if	DEV_UAC1_MSG
	printf("UAC1GetMin\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_clear_flag_device_ep0_rx_ready(USB);		//Clear RxRdy

	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
		(*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
	return(USBD_STATE_IDLE);
}
/****
	* @brief	USB UAC Request - Get Max
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	uac1_request_get_max(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)
{
#if	DEV_UAC1_MSG
	printf("UAC1GetMax\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_clear_flag_device_ep0_rx_ready(USB);		//Clear RxRdy

	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
		(*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
	return(USBD_STATE_IDLE);
}
/****
	* @brief	USB UAC Request - Get Res
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	uac1_request_get_res(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)
{
#if	DEV_UAC1_MSG
	printf("UAC1GetRes\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_clear_flag_device_ep0_rx_ready(USB);		//Clear RxRdy
	
	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
		(*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
	return(USBD_STATE_IDLE);
}
/****
	* @brief	USB UAC Request - Get Mem
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	uac1_request_get_mem(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)
{
#if	DEV_UAC1_MSG
	printf("UAC1GetMem\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_clear_flag_device_ep0_rx_ready(USB);		//Clear RxRdy

	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
		(*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
	return(USBD_STATE_IDLE);
}
/****
	* @brief	USB UAC Request - Reserved
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	uac1_request_reserved(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)
{
#if	DEV_UAC1_MSG
	printf("Reserved\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB, (USB_CSR0L_RXRDYC | USB_CSR0L_DATAEND));	//Clear RxRdy & Dataend
	return(USBD_STATE_IDLE);
}

eUSBDState	(*pUAC1ClassRequest[])(_pUSB_FS_DEVICE, _pUSB_SETUP_REQUEST) =		//UAC Device Request
{
	uac1_request_reserved,
	uac1_request_set_cur,		//0x1
	uac1_request_set_min,		//0x2
	uac1_request_set_max,		//0x3
	uac1_request_set_res,		//0x4
	uac1_request_set_mem,		//0x5
	uac1_request_reserved,
	uac1_request_reserved,
	uac1_request_reserved,
	uac1_request_get_cur,		//0x81
	uac1_request_get_min,		//0x82
	uac1_request_get_max,		//0x83
	uac1_request_get_res,		//0x84
	uac1_request_get_mem,		//0x85
};

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
