/**********************************************************************************
 *
 * @file    usb_dev_printer.c
 * @brief   c File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#include "es32f0283.h"
#include "md_usb.h"
#include "usb_core.h"
#include "usb_enum.h"
#include "usb_dev_enum.h"
#include "usbprinter.h"
#include "usb_dev_printer.h"
#include <stdio.h>

#pragma pack(1)
#define	DEV_PRINTER_MSG		1

static	uint8_t	DeviceID[]=
{
	0x00, 0x00, 
	'M', 'F', 'G', ':', 'E', 'a', 's', 't', 's', 'o', 'f', 't', ';', 
	'M', 'D', 'L', ':', 'G', 'e', 'n', 'e', 'e', 'r', 'i', 'c', ';', 
	'C', 'M', 'D', ':', '1', '2', '8', '4', '.', '4', ';', 
	'C', 'L', 'S', ':', 'P', 'r', 'i', 'n', 't', 'e', 'r', ';', 
	'D', 'E', 'S', ':', 'T', 'e', 'x', 't', '_', 'o', 'n', 'l', 'y', ';',
};


/****
	* @brief	Printer Class Request - SGet Device ID
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	printer_request_get_device_id(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)		//21 20 00 00 00 00 07 00
{
eUSBDState	USBState;
uint16_t	idLength;
	
#if	DEV_PRINTER_MSG
	printf("Printer GetDeviceID\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_clear_flag_device_ep0_rx_ready(USB);		//Clear RxRdy
	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
	{
		USBState = (*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
		if (USBState == USBD_STATE_STALL)
		{
			md_usb_set_epx_index(USB, USBEP0);		//Endpoint 0
			md_usb_set_csr0l_txcsrl(USB, (USB_CSR0L_RXRDYC | USB_CSR0L_STALL));	//Clear RxRdy & Stall
			return(USBState);
		}
	}
	else
	{
		idLength = sizeof(DeviceID);
		DeviceID[0] = (uint8_t)(idLength >> 8);
		DeviceID[1] = (uint8_t)(idLength & 0xff);
		if (idLength > pSetupReq->wLength)
			idLength = pSetupReq->wLength;
		pDev->pCtrlBurstData = (uint8_t *)&DeviceID;		//Device ID
		pDev->CtrlBurstRemain = idLength;					//bLength
		USBState = usbd_handle_ctrl_in(pDev);
//		md_usb_set_epx_index(USB, USBEP0);		//Endpoint 0
//		md_usb_set_csr0l_txcsrl(USB, (USB_CSR0L_TXRDY | USB_CSR0L_DATAEND));	//TxRdy & DataEnd
		return(USBState);
	}
	return(USBD_STATE_IDLE);
}
/****
	* @brief	Printer Class Request - Get Port Status
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	printer_request_get_port_status(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)		//A1 21 00 00 XX 00 07 00
{
eUSBDState	USBState;

#if	DEV_PRINTER_MSG
	printf("Printer GetPortStatus\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_clear_flag_device_ep0_rx_ready(USB);		//Clear RXRDY
	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
	{
		USBState = (*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
		if (USBState == USBD_STATE_STALL)
		{
			md_usb_set_epx_index(USB, USBEP0);		//Endpoint 0
			md_usb_set_csr0l_txcsrl(USB, (USB_CSR0L_RXRDYC | USB_CSR0L_STALL));	//Clear RxRdy & Stall
			return(USBState);
		}
	}
	else
	{	
		md_usb_set_ep0_fifo(USB, (uint8_t)PRINTER_STATUS_NO_ERROR);
		md_usb_set_epx_index(USB, USBEP0);		//Endpoint 0
		md_usb_set_csr0l_txcsrl(USB, (USB_CSR0L_TXRDY | USB_CSR0L_DATAEND));	//TxRdy & DataEnd
		USBState = USBD_STATE_IDLE;
	}
	return(USBState);
}
/****
	* @brief	Printer Class Request - Soft Reset
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	printer_request_soft_reset(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)	//21 22 00 00 XX 00 00 00
{
eUSBDState	USBState;

#if	DEV_PRINTER_MSG
	printf("Printer SoftReset\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB, (USB_CSR0L_RXRDYC | USB_CSR0L_DATAEND));	//Clear RxRdy & Dataend
	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
	{
		(*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
	}
	return(USBD_STATE_IDLE);
}
/****
	* @brief	Printer Class Request - Reserved
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	printer_request_reserved(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)
{
#if	DEV_PRINTER_MSG
	printf("Reserved\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB, (USB_CSR0L_RXRDYC | USB_CSR0L_DATAEND));		//Clear RxRdy, DataEnd
	return(USBD_STATE_IDLE);
}
/****
	* @brief	Functionality Array for Printer Class Request
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
****/
eUSBDState	(*pPrinterClassRequest[])(_pUSB_FS_DEVICE, _pUSB_SETUP_REQUEST) =		//Printer Class Request
{
	printer_request_get_device_id,				//0x00, SET_LINE_CODING
	printer_request_get_port_status,			//0x01, GET_LINE_CODING
	printer_request_soft_reset,					//0x02, SET_CONTROL_LINE_STATE
};

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
