/**********************************************************************************
 *
 * @file    usb_dev_msc.c
 * @brief   c File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#include "es32f0283.h"
#include "md_usb.h"
#include "usb_core.h"
#include "usb_enum.h"
#include "usb_dev_enum.h"
#include "usbmsc.h"
#include "usb_dev_msc.h"
#include <stdio.h>

#pragma pack(1)
#define	DEV_MSC_MSG	1

/****
	* @brief	MSC Class Request - Get Max Lun
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	msc_request_get_max_lun(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)			//A1 FE 00 00 XX 00 01 00
{
#if	DEV_MSC_MSG
	printf("Get Max LUN\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_clear_flag_device_ep0_rx_ready(USB);	//Clear RxRdy
	md_usb_set_ep0_fifo(USB, 0x0);			//Max LUN
	md_usb_set_csr0l_txcsrl(USB, (USB_CSR0L_TXRDY | USB_CSR0L_DATAEND));	//TxRdy & DataEnd
	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
		(*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
	return(USBD_STATE_IDLE);
}
/****
	* @brief	MSC Class Request - Storage Reset
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	msc_request_storage_reset(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)		//21 FF 00 00 XX 00 00 00
{
#if	DEV_MSC_MSG
	printf("Storage Reset\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB, (USB_CSR0L_RXRDYC | USB_CSR0L_DATAEND));	//Clear RxRdy & Dataend
	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
		(*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
	return(USBD_STATE_IDLE);
}
/****
	* @brief	MSC Class Request - Reserved
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	msc_request_reserved(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)
{
#if	DEV_MSC_MSG
	printf("Reserved\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB, (USB_CSR0L_RXRDYC | USB_CSR0L_DATAEND));	//Clear RxRdy & Dataend
	return(USBD_STATE_IDLE);
}
/****
	* @brief	Functionality Array for MSC Class Request
****/
eUSBDState	(*pMSCClassRequest[])(_pUSB_FS_DEVICE, _pUSB_SETUP_REQUEST) =		//MSC Class Request
{
	msc_request_get_max_lun,
	msc_request_storage_reset,
};

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/

