/**********************************************************************************
 *
 * @file    usb_dev_cdc.c
 * @brief   c File
 *
 * @date    5 May 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 May 2022      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#include "es32f0283.h"
#include "md_usb.h"
#include "usb_core.h"
#include "usb_enum.h"
#include "usb_dev_enum.h"
#include "usbcdc.h"
#include "usb_dev_cdc.h"
#include <stdio.h>

#pragma pack(1)
#define	DEV_CDC_MSG		1

_CDC_LINE_CODING_DATA	CDCLineCoding;

/****
	* @brief	CDC Class Request - Set Line Coding
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	cdc_request_set_line_coding(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)		//21 20 00 00 00 00 07 00
{
eUSBDState	USBState;

#if	DEV_CDC_MSG
	printf("CDC SetLineCoding\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_clear_flag_device_ep0_rx_ready(USB);		//Clear RxRdy
	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
	{
		USBState = (*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
		if (USBState == USBD_STATE_STALL)
		{
			md_usb_set_epx_index(USB, USBEP0);		//Endpoint 0
			md_usb_set_csr0l_txcsrl(USB, (USB_CSR0L_RXRDYC | USB_CSR0L_STALL));	//Clear RxRdy & Stall
			return(USBState);
		}
	}
	else
	{
		USBState = USBD_STATE_SETUP;
		while (USBState != USBD_STATE_CTRLOUT)
			USBState = usbd_dev_enum(pDev, pSetupReq, USBState);
		pDev->pCtrlBurstData = (uint8_t *)&CDCLineCoding;
		pDev->CtrlBurstRemain = usbd_epx_out_available(pDev, USBEP0);
		usbd_handle_ctrl_out(pDev);
		USBState = USBD_STATE_IDLE;
	}
	return(USBD_STATE_IDLE);
}
/****
	* @brief	CDC Class Request - Get Line Coding
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	cdc_request_get_line_coding(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)		//A1 21 00 00 XX 00 07 00
{
eUSBDState	USBState;

#if	DEV_CDC_MSG
	printf("CDC GetLineCoding\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_clear_flag_device_ep0_rx_ready(USB);		//Clear RXRDY
	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
	{
		USBState = (*(((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class))(pDev, pSetupReq);
		if (USBState == USBD_STATE_STALL)
		{
			md_usb_set_epx_index(USB, USBEP0);		//Endpoint 0
			md_usb_set_csr0l_txcsrl(USB, (USB_CSR0L_RXRDYC | USB_CSR0L_STALL));	//Clear RxRdy & Stall
			return(USBState);
		}
	}
	else
	{	
		pDev->pCtrlBurstData = (uint8_t *)&CDCLineCoding;
		pDev->CtrlBurstRemain = sizeof(_CDC_LINE_CODING_DATA);
		usbd_handle_ctrl_in(pDev);
		USBState = USBD_STATE_IDLE;
	}
	return(USBState);
}
/****
	* @brief	CDC Class Request - Set Control Line State
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	cdc_request_set_control_line_state(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)	//21 22 00 00 XX 00 00 00
{
eUSBDState	USBState;

#if	DEV_CDC_MSG
	printf("CDC SetControlLineState\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);		//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB, (USB_CSR0L_RXRDYC | USB_CSR0L_DATAEND));	//Clear RxRdy, DataEnd
	if (((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class != NULL)
		(*((_pCB_APP_DEV_REQUEST)pDev->cb_app_dev_request)->cb_app_dev_class)(pDev, pSetupReq);
	return(USBD_STATE_IDLE);
}
/****
	* @brief	CDC Class Request - Reserved
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
	* @retval	Idle State
****/
eUSBDState	cdc_request_reserved(_pUSB_FS_DEVICE pDev, _pUSB_SETUP_REQUEST pSetupReq)
{
#if	DEV_CDC_MSG
	printf("Reserved\r\n");
#endif
	md_usb_set_epx_index(USB, USBEP0);			//Endpoint 0
	md_usb_set_csr0l_txcsrl(USB, (USB_CSR0L_RXRDYC | USB_CSR0L_DATAEND));		//Clear RxRdy, DataEnd
	return(USBD_STATE_IDLE);
}
/****
	* @brief	Functionality Array for CDC Class Request
	* @param	pDev		: Device Instance
	* @param	pSetupReq	: Pointer to Standard Request Data
****/
eUSBDState	(*pCDCClassRequest[])(_pUSB_FS_DEVICE, _pUSB_SETUP_REQUEST) =		//CDC Class Request
{
	cdc_request_set_line_coding,			//0x20, SET_LINE_CODING
	cdc_request_get_line_coding,			//0x21, GET_LINE_CODING
	cdc_request_set_control_line_state,		//0x22, SET_CONTROL_LINE_STATE
};

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/

