/**
  *********************************************************************************
  *
  * @file    usb_msc.h
  * @brief   Header file for the USB MSC.
  *
  * @version V1.0
  * @date    30 Jul 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          30 Jul 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  * THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
  * NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
  * NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  * A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. EASTSOFT SHALL NOT, UNDER ANY
  * CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
  * DAMAGES, FOR ANY REASON WHATSOEVER.
  *
  *********************************************************************************
  */

#ifndef __USB_MSC_H__
#define __USB_MSC_H__

#ifdef __cplusplus
extern "C"
{
#endif

#include "usb_utils.h"


/** @addtogroup USB_LIBRARY
  * @{
  */

/** @addtogroup UTILS
  * @{
  */

/**
  * @defgroup MSC_Private_Macros MSC Private Macros
  * @{
  */
#define USBREQ_GET_MAX_LUN	0xfeU
#define USBREQ_BULK_ONLY_RESET	0xffU
#define CBW_SIGNATURE		0x43425355U
#define CSW_SIGNATURE		0x53425355U
#define CBWFLAGS_DIR_M		0x80U
#define CBWFLAGS_DIR_IN		0x80U
#define CBWFLAGS_DIR_OUT	0x00U
#define SCSI_CMD_STATUS_PASS	0x00U
#define SCSI_CMD_STATUS_FAIL	0x01U
#define SCSI_TEST_UNIT_READY	0x00U
#define SCSI_REQUEST_SENSE	0x03U
#define SCSI_INQUIRY_CMD	0x12U
#define SCSI_MODE_SENSE_6	0x1aU
#define SCSI_START_STOP_UNIT	0x1bU
#define SCSI_MEDIUM_REMOVAL	0x1eU
#define SCSI_READ_CAPACITIES	0x23U
#define SCSI_READ_CAPACITY	0x25U
#define SCSI_READ_10		0x28U
#define SCSI_WRITE_10		0x2aU
#define SCSI_INQUIRY_DATA_SZ	36U
#define SCSI_INQ_PQ_M		0xe0U
#define SCSI_INQ_PQ_CNCT	0x00U
#define SCSI_INQ_PQ_DISC	0x20U
#define SCSI_INQ_PDT_M		0x1fU
#define SCSI_INQ_PDT_SBC	0x00U
#define SCSI_INQ_RMB		0x80U
#define SCSI_READ_CAPACITY_SZ	0x08U
#define SCSI_MS_DBD		0x00000800U
#define SCSI_MS_PC_VENDOR	0x00000000U
#define SCSI_MS_PC_DISCO	0x00020000U
#define SCSI_MS_PC_CONTROL	0x000a0000U
#define SCSI_MS_PC_LUN		0x00180000U
#define SCSI_MS_PC_PORT		0x00190000U
#define SCSI_MS_PC_POWER	0x001a0000U
#define SCSI_MS_PC_INFORM	0x001c0000U
#define SCSI_MS_PC_ALL		0x003f0000U
#define SCSI_MS_PC_CURRENT	0x00000000U
#define SCSI_MS_PC_CHANGEABLE	0x00400000U
#define SCSI_MS_PC_DEFAULT	0x00800000U
#define SCSI_MS_PC_SAVED	0x00c00000U
#define SCSI_REQUEST_SENSE_SZ	18U
#define SCSI_RS_SKEY		2U
#define SCSI_RS_SKEY_AD_SKEY	12U
#define SCSI_RS_VALID		0x80U
#define SCSI_RS_CUR_ERRORS	0x70U
#define SCSI_RS_DEFER_ERRORS	0x71U
#define SCSI_RS_KEY_M		0x0fU
#define SCSI_RS_KEY_NO_SENSE	0x00U
#define SCSI_RS_KEY_RECOVRD_ERR	0x01U
#define SCSI_RS_KEY_NOT_READY	0x02U
#define SCSI_RS_KEY_MEDIUM_ERR	0x03U
#define SCSI_RS_KEY_HW_ERR	0x04U
#define SCSI_RS_KEY_ILGL_RQST	0x05U
#define SCSI_RS_KEY_UNIT_ATTN	0x06U
#define SCSI_RS_KEY_DATA_PROT	0x07U
#define SCSI_RS_KEY_BLANK_CHK	0x08U
#define SCSI_RS_KEY_ABORT	0x0bU
#define SCSI_RS_ILI		0x20U
#define SCSI_RS_EOM		0x40U
#define SCSI_RS_FILEMARK	0x80U
#define SCSI_RS_MED_NOT_PRSNT	0x003aU
#define SCSI_RS_MED_NOTRDY2RDY	0x0028U
#define SCSI_RS_PV_INVALID	0x0226U
#define SCSI_RS_KEY_NOTPRSNT	0x3AU
#define SCSI_PE_MEDRMV_M	0x03U
#define SCSI_PE_MEDRMV_ALLOW	0x00U
#define SCSI_PE_MEDRMV_PREVENT	0x01U
#define SCSI_SS_UNIT_IMMED	0x01U
#define SCSI_SS_UNIT_LUN_M	0xe0U
#define SCSI_SS_UNIT_START	0x01U
#define SCSI_SS_UNIT_LOEJ	0x02U
#define SCSI_SS_UNIT_PWR_M	0xf0U
#define SCSI_SS_UNIT_PWR_ACTIVE	0x10U
#define SCSI_SS_UNIT_PWR_IDLE	0x20U
#define SCSI_SS_UNIT_PWR_STDBY	0x30U
#define SCSI_SS_UNIT_PWR_DSLEEP	0x50U

#define CSWSTATUS_CMD_SUCCESS   0
#define CSWSTATUS_CMD_FAILED    1
#define CSWSTATUS_PHASE_ERROR   2

#define SCSI_IS_REMOVABLE(x)	(((uint8_t *)x)[1] & SCSI_INQ_RMB)
/**
  * @}
  */

/**
  * @defgroup MSC_Public_Types MSC Public Types
  * @{
  */
#ifdef __ICCARM__
#pragma pack(1)
#endif

/**
  * @brief Command Block Wrapper(CBW)
  */
typedef struct {
	uint32_t dCBWSignature;			/**< Identify this data packet as a CBW */
	uint32_t dCBWTag;			/**< Command Block Tag */
	uint32_t dCBWDataTransferLength;	/**< Number of bytes of data */
	uint8_t bmCBWFlags;			/**< Bit mapping */
	uint8_t bCBWLUN;			/**< Logical Unit Number (LUN) */
	uint8_t bCBWCBLength;			/**< Valid length of the CBWCB in bytes */
	uint8_t CBWCB[16];			/**< Command */
} PACKED msc_cbw_t;


/**
  * @brief Command Status Word(CSW)
  */
typedef struct {
	uint32_t dCSWSignature;		/**< Identifies this data packet as a CSW */
	uint32_t dCSWTag;		/**< Command Block Tag */
	uint32_t dCSWDataResidue;	/**< Difference */
	uint8_t bCSWStatus;		/**< Status */
} PACKED msc_csw_t;

#ifdef __ICCARM__
#pragma pack()
#endif
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
#ifdef __cplusplus
}
#endif

#endif
